<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Class that contains card information
	class cardinfo
	{
		//Variables needed for the class
		public $device_name = "";
		public $card_mode = "";
		public $pci_slot = "";
		public $pci_bus = "";
		public $port_num = "";
		public $firmware = "";
		public $echo = "";
		public $analog_port = "";
		public $num_te = "";
		public $num_nt = "";
		public $pci_int = "";
		public $fe_line = "";
		public $britype_array = "";

		//Use this function when parsing data from products that in the hwprobe dump don't have HWEC and Firmware Version shifted
		function class_create_no_shift($parse_results, $b)
		{
			//Locations of information required within the parse_results array
			$slot = $b + 2; 
			$bus = $b + 4;
			$HWEC = $b + 10;
			$firm = $b + 12;
			
			$this->device_name = $parse_results[$b];
			$this->pci_slot = $parse_results[$slot];
			$this->pci_bus = $parse_results[$bus];
			$this->echo = $parse_results[$HWEC];

			//Calculates the relative position of the PCI type
			if ($this->device_name == "AFT-B601-SH")
				$int = $b + 15;
			elseif ($this->device_name == "AFT-B600-SH")
				$int = $b + 24;

			$this->pci_int = $parse_results[$int];			
			$this->firmware = $parse_results[$firm];

			if ($parse_results[$b] == "AFT-B601-SH")
			{
				$this->analog_port = 1;
				$this->port_num = 2;				
			}
			if ($parse_results[$b] == "AFT-B600-SH")
				$this->port_num = 1;
		}

		//Use this function when parsing data from products that in the hwprobe dump have HWEC and Firmware Version shifted
		function class_create_shift($parse_results, $b)
		{
			//Locations of information required within the parse_results array
			$slot = $b + 2; 
			$bus = $b + 4;
			$HWEC = $b + 12;
			$firm = $b + 14;

			$this->device_name = $parse_results[$b];
			$this->pci_slot = $parse_results[$slot];
			$this->pci_bus = $parse_results[$bus];

			//echo "slot = " . $this->pci_slot . "\n";

			//Calculates the relative position of the PCI type
			if ($this->device_name == "AFT-A200-SH" || $parse_results[$b] == "AFT-A400-SH")
				$int = $b + 64;
			if ($this->device_name == "AFT-A101-SH" || $this->device_name == "AFT-A102-SH" || $this->device_name == "AFT-A104-SH" || $this->device_name == "AFT-A108-SH" || $this->device_name == "AFT-A116-SH")
				$int = $b + 17;
			
			$this->pci_int = $parse_results[$int];
			$this->echo = $parse_results[$HWEC];
			$this->firmware = $parse_results[$firm];

			if ($parse_results[$b] == "AFT-A200-SH" || $parse_results[$b] == "AFT-A400-SH")
				$this->analog_port = 1;

			$this->port_num++;
		}
		
		//Use for BRI cards (A500 and B700)
		function class_bri($parse_results, $b)
		{
			//Locations of information required within the parse_results array
			$slot = $b + 2; 
			$bus = $b + 4;
			$HWEC = $b + 10;
 			$firm = $b + 12;
			$mode = $b + 14;
			$interface = $b + 16;			
		
			$this->device_name = $parse_results[$b];
			$this->pci_slot = $parse_results[$slot];
			$this->pci_bus = $parse_results[$bus];
			$this->firmware = $parse_results[$firm];
			$this->echo = $parse_results[$HWEC];

			if ($this->device_name == "AFT-B700-SH")
			{
				if ($parse_results[$interface] == "FXO" || $parse_results[$interface] == "FXS")
				{
					$this->pci_int = $_SESSION['last_int'];
				}
				else
				{
					$this->pci_int = $parse_results[$interface];
					$_SESSION['last_int'] = $this->pci_int;
				}
			}
			elseif ($this->device_name == "AFT-A500-SH")
			{
				$this->pci_int = $parse_results[$interface];
			}

			//Calculates how many TE and NT ports are found on the BRI card
			//echo "mode = $parse_results[$mode]<br />"; 
			if ($parse_results[$mode] == "NT")
				$this->num_nt++;
			elseif ($parse_results[$mode] == "TE")
				$this->num_te++;

			$this->port_num++;
			
			if ($parse_results[$b] == "AFT-B700-SH")
				$this->analog_port = $this->port_num; 
		}
		
		//Creates the card object from the database
		function cached_info($data,$db,$count)
		{
			//echo $count . "<br />";
			$object_info = $data->select_statement($db,'card_present','*',"id = $count");
			
			$this->pci_bus = $object_info['pci_bus'];
			$this->pci_slot = $object_info['pci_slot'];
			$this->echo = $object_info['echo'];
			$this->firmware = $object_info['firmware'];
			$this->num_nt = $object_info['num_nt'];
			$this->num_te = $object_info['num_te'];
			$this->port_num = $object_info['num_ports'];
			$this->analog_port = $object_info['analog_location'];
			
			//Tokenize device name and remove the -$count
			//echo $object_info['dev_name'] . "<br />";
			$string = $object_info['dev_name'];
			$tok = strtok($string, "-");
	
			$count = 0;
			while ($tok !== false) 
			{
				$token[$count] = $tok;
			    $tok = strtok("-");
				$count++;
			}
		
			$this->device_name = $token[0] . "-" . $token[1] . "-" . $token[2];
		}
		
	}

	class wanrouter_hwprobe
	{
		//Function Tokenizes the results of "wanrouter hwprobe dump"
		function get_information($relay_name)
		{
			$count = 0;
			
			
			if ($relay_name == "")
			{
				//Standalone machine
				exec ('/usr/sbin/wanrouter hwprobe dump', $output);
			}
			elseif ($relay_name != "")
			{
				//include the ssh class to determine what command to run
				require_once 'SSH_Class.php';
				require_once 'database_classes.php';
			
				$data = new database_class;
				$ssh = new ssh_class;
		
				//Pull relay information from database
				//echo $relay_name . "<br />";
				$relay_info = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','ip_addr,ssh_port',"relay_name = \"$relay_name\"");			
				
				$pattern = "'\bMaster1\b'";
				//echo $relay_name;
				
				//var_dump (preg_match($pattern,$relay_name));
				if (preg_match($pattern,$relay_name))
					$type = "local";
				elseif (!preg_match($pattern,$relay_name))
					$type = "remote";
				
				//echo "type = $type";
				//echo "IP = " . $relay_info['ip_addr'] . "<br />";
				$output = $ssh->execute($type,'/usr/sbin/wanrouter hwprobe dump',$relay_info['ip_addr'],$relay_info['ssh_port']);
				/*foreach ($output as $key=>$value)
				{
					echo "$key = $value<br />";
				}*/
				
				unset($ssh);
				unset($data);	
				unset($type);

			}
			//echo $output[1] . "<br />";
			if ($output[0] != "DISABLED" && $output[0] != "INVALID KEY")
			{
				//exec ('/usr/sbin/wanrouter hwprobe dump', $output);	
				$counter = count($output);
				for ($a = 0; $a < $counter; $a ++)
				{
					if (preg_match('/(\d+)(.*):.*SLOT=(\d+).*BUS=(\d+).*CPU=(\w+).*PORT=(\w+).*/', $output[$a]) || preg_match('/(\d+).(\w+\w+).*SLOT=(\d+).*BUS=(\d+).*(\w+).*PORT=(\w+).*HWEC=(\d+)/', $output[$a]))
					{
						$tok = strtok($output[$a], "|");
				
						while ($tok !== false)
						{
							$token[$count] = $tok;
							$tok = strtok("|");
							$count++;
						}
					}
				}
				for ($b = 0; $b <= $count; $b ++)
				{
					$tok = strtok($token[$b], "=");
			
					while ($tok !== false)
					{
						$tokenize[$value] = $tok;
						$tok = strtok("=");
						
						//echo $tokenize[$value] . "<br />";
						
						$value++;
					}
				}
			}
			else
			{
				$tokenize[0] = "empty";
			}
			return $tokenize;	
		}	
	
		//Tokenizes the card name
		function tokenize_name($string)
		{
			$tok = strtok($string, "-");
	
			$count = 0;
			while ($tok !== false) 
			{
				$token[$count] = $tok;
			    $tok = strtok("-");
				$count++;
			}
		
			$token_value = $token[1] . "-" . $token[2];
	
			return $token_value;
		}
		
		function tokenize_wanpipe($string)
		{
			$tok = strtok($string, "-");
	
			$count = 0;
			while ($tok !== false) 
			{
				$token[$count] = $tok;
			    $tok = strtok("-");
				$count++;
			}
		
			return $token[1];
		}
		
		function token_name($string)
		{
			$tok = strtok($string, "-");
	
			$count = 0;
			while ($tok !== false) 
			{
				$token[$count] = $tok;
			    $tok = strtok("-");
				$count++;
			}
		
			return $token[0];
		}
	}
?>
