<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//$db_location = "sqlite:../sqlite/cardinfo.db";
	
	//Include Statements
	include '../database_classes.php';
	include 'ss7_linkset_view_profile_class.php';
	
	//PHP Class Constructors
	$data = new database_class;	
	$ss7_linkset_view = new ss7_linkset_view_profile_class;
	
	$ss7_linkset_view->proc_id = $_SESSION['proc_id'];
	//echo "Proc = " . $_SESSION['proc_id'] . "<br />";
	if ($ss7_linkset_view->proc_id == 1)
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";	
	}
	elseif ($ss7_linkset_view->proc_id > 1)
	{
		$db_location = "sqlite:../sqlite/cardinfo" . $ss7_linkset_view->proc_id . ".db";
	}		
	$db2 = "sqlite:../sqlite/cardinfo.db";
	
	//echo $db_location;
	unset ($_SESSION['error']);
			
	//Check if a linkset/route/isup interface exists.
	$table_name = "ss7_linkset_profile";
	$check = $data->check_for_table($db2, $table_name);
	//echo "check = $check <br/>";
	if ($check > 1)
	{
		//$where = "id = 1";
		$linkset_exist = $data->select_statement($db2, $table_name, "profile_name", $where);
	}

	$table_name = "ss7_route_profile";
	$check = $data->check_for_table($db2, $table_name);
	if ($check > 1)
	{
		//$where = "id = 1";
		$route_exist = $data->select_statement($db2, $table_name, "profile_name", $where);
	}
	
	$table_name = "ss7_isup_profile";
	$check = $data->check_for_table($db2, $table_name);
	if ($check > 1)
	{
		//$where = "id = 1";
		$isup_exist = $data->select_statement($db2, $table_name, "profile_name", $where);
	}

	//If there was a deleted route, isup or linkset
	if ($_SESSION['deleted_linkset'] == "yes" || $_SESSION['deleted_route'] == "yes")
	{
		$stay_on_page = "yes";
	}
	//echo $linkset_exist['profile_name'] . "<br />";
	//If there is no linkset, route or ISUP interface
	if ($linkset_exist['profile_name'] == "" && $route_exist['profile_name'] == "" && $isup_exist['profile_name'] == "" && $stay_on_page == "")
	{
		$_SESSION['skip_all'] = "yes";
		unset ($_SESSION['error']);		
		header( 'Location:create_ss7_linkset.php#top' );
	}
	//If route and ISUP don't exist
	elseif ($route_exist['profile_name'] == "" && $isup_exist['profile_name'] == "" && $stay_on_page == "")
	{
		$_SESSION['skip_route'] = "yes";
		unset ($_SESSION['skip_all']);
		unset ($_SESSION['skip_isup']);
		unset ($_SESSION['error']);		
	}
	//If ISUP doesn't exist
	elseif ($isup_exist['profile_name'] == "" && $stay_on_page == "")
	{
		unset ($_SESSION['skip_all']);
		unset ($_SESSION['skip_route']);
		unset ($_SESSION['error']);		
		$_SESSION['skip_isup'] = "yes";
	}
	//If a linkset doesn't exist
	elseif ($linkset_exist['profile_name'] == "" && $stay_on_page == "")
	{
		$_SESSION['skip_all'] = "yes";
		unset ($_SESSION['skip_all']);
		unset ($_SESSION['skip_route']);
		unset ($_SESSION['error']);		
		unset ($_SESSION['skip_isup']);		
		header( 'Location:create_ss7_linkset.php#top' );
	}
			
	//Holds the number of entries variable
	$num_entries = $_SESSION['num_entries'];
	
	$_SESSION['id_num'] = "";
	
	//Starts the Wizard
	if (!isset($_SESSION['linkset']) && !isset($_SESSION['route']) && !isset($_SESSION['isup']))
	{
		$_SESSION['linkset'] = "Start";
		unset ($_SESSION['error']);		
	}
	
	//If back to hardware information button is pressed
	if ($_REQUEST['back'] == "Cancel")
	{
		$ss7_linkset_view->unset_sessions();
		
		//Redirects to hardware probe
		header( 'Location:../wanrouterhwprobe.php#top' );
	}
	if ($_REQUEST['back-route'] == "<- Back")
	{
		$_SESSION['linkset'] = "Start";
		unset ($_SESSION['isup']);
		unset ($_SESSION['route']);
		unset ($_SESSION['error']);		
		header( 'Location:view_ss7_linkset.php#top' );		
	}
	if ($_REQUEST['back-isup'] == "<- Back")
	{
		$_SESSION['linkset'] = "Done";
		unset($_SESSION['route']);
		unset($_SESSION['skip_isup']);
		unset ($_SESSION['error']);
		header( 'Location:view_ss7_linkset.php#top' );				
	}
	
	//if the finish button is clicked on
	if ($_REQUEST['back-isup'] == "Finish")
	{
		if ($_SESSION['skip_isup'] != "")
		{
			//The finish button was clicked without creating an ISUP Interface
			$_SESSION['route'] = "Done";
			$_SESSION['error'] = "yes";
		}
		elseif ($_SESSION['route_finish'] == "yes")
		{
			//If you finished adding a route
			$ss7_linkset_view->unset_sessions();
			
			header( 'Location:create_ss7_ccspans.php#top' );		
		}
		elseif ($_SESSION['finish'] == "yes")
		{
			//If the finish button is clicked from the Linkset page
			$ss7_linkset_view->unset_sessions();
			
			header( 'Location:create_ss7_ccspans.php#top' );				
		}
		else
		{
			//If you are finishing the wizard from the ISUP Interface portion
			$ss7_linkset_view->unset_sessions();
			
			//header( 'Location:../wanrouterhwprobe.php' );				
			header( 'Location:create_ss7_ccspans.php#top' );		
		}
	}	
	//echo $_REQUEST['back-route2'] ;
	//If you need to continue to ISUP Interfaces from the route management page
	if ($_REQUEST['back-route2'] == "Next ->")
	{
		  $_SESSION['last_route'] = $x;
		  unset($_SESSION['linkset']);
		  $_SESSION['route'] = "Done";
		  unset($_SESSION['last_profile']);
		  unset ($_SESSION['skip_route']);
		  unset($_SESSION['next_route']);
		  
		  if ($_SESSION['skip_isup'] == "yes")
		  {
			  //echo "yes";
			  header( 'Location:create_ss7_isup.php#top' );
		  }	
	}	
	//If you click the next button from the linkset management page
	if ($_REQUEST['back-route'] == "Next ->")
	{
		  $_SESSION['linkset'] = "Done";
		  
		  unset($_SESSION['next']);
		  unset($_SESSION['last_route']);
		  unset($_SESSION['route']);
		  unset($_SESSION['last_profile']);
		  unset ($_SESSION['skip_route']);
		  
		  header( 'Location:view_ss7_linkset.php#top' );
	}		
	
	//If create profile clicked on
	if ($_REQUEST['create_linkset'] == "Create Linkset")
	{
		//Redirects to hardware probe
		header( 'Location:create_ss7_linkset.php#top' );
	}
	if ($_REQUEST['create_route'] == "Create Route")
	{
		//Redirects to hardware probe
		header( 'Location:create_ss7_route.php#top' );
	}
	if ($_REQUEST['create_isup'] == "Create ISUP Interface")
	{
		//Redirects to hardware probe
		header( 'Location:create_ss7_isup.php#top' );
	}
	unset($l);
	$relay_type = $data->select_statement('sqlite:../sqlite/relay_info.db', 'ss7_relay', "machine_type, relay_type", $where);
	if ($relay_type['machine_type'] == "standalone" || $relay_type['relay_type'] == "SLAVE")
	{
		$count_hosts['count(id)'] = 1;
	}
	else
	{
		$count_hosts = $data->select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','count(id)',"");
	}
	//echo $count_hosts['count(id)'];
	//Goes through the request variables and checks what was clicked on
	foreach ($_REQUEST as $key => $value)
	{	
		//echo "$key = $value<br />";;
		//Check to see if the Signalling table for that card exists
		$exists = $data->check_for_table ($db_location, $table_name);
		
		for ($x = 0; $x <= $num_entries+10; $x++)
		{		
			//$x = the ss7_profile line number			
			//Checks to see which Delete button was pressed
			//echo $l . "= " . $key . ", $value<br />";
			if ($key == "delete-linkset$x" && $value == "Delete Linkset")
			{
				$table_name = "ss7_linkset_profile";
				$proc_id = substr($key,0,1);
				//echo $proc_id;
				$db = "sqlite:../sqlite/cardinfo.db";
		
				$select = $data->select_statement($db, $table_name, "profile_name", "id = $x");
				
				//If the one you are deleting is the new linkset
				if ($_SESSION['last_profile']  == $select['profile_name'])
				{
					$_SESSION['new_linkset'] = "";
					$_SESSION['next'] = "";
				}
				
				//Remove the linkset deleted from the tables
				//$ss7_linkset_view->remove_linksets($select['profile_name']);
				//Remove entry from the used_linkset table as well as the ss7-link table
				
								
				$param = "id = $x";
				$data->delete_generic($db, $table_name, $param);
			}
			if ($key == "delete-route$x" && $value == "Delete Route")
			{
				$table_name = "ss7_route_profile";
				$proc_id = substr($key,0,1);
				//echo $proc_id;
				
				$db = "sqlite:../sqlite/cardinfo.db";
				
				$select = $data->select_statement($db, $table_name, "profile_name", "id = $x");
				
				//If the one you are deleting is the new route
				if ($_SESSION['last_profile']  == $select['profile_name'])
				{

					$_SESSION['new_route'] = "";
					$_SESSION['next_route'] = "";
				}
				
				$param = "id = $x";
				$data->delete_generic($db, $table_name, $param);
			}
			if ($key == "delete-isup$x" && $value == "Delete Interface")
			{
				$proc_id = substr($key,0,1);
				//echo $proc_id;
				
				$db = "sqlite:../sqlite/cardinfo.db";
				
				//Release route when deleting a isup interface
				$param = "profile_name";
				$where_param = "id = $x";
				$isup_int = $data->select_statement($db,'ss7_isup_profile',$param,$where_param);
				
				$table_name = "used_route";
				$param = "isup = \"" . $isup_int['profile_name'] . "\"";
				$data->delete_generic($db, $table_name, $param);
				
				//echo "i am here<br />";
				$table_name = "ss7_isup_profile";
				$param = "id = $x";
				$data->delete_generic($db, $table_name, $param);
				
				if ($x == 1)
				{
					unset($_SESSION['isup_created']);
				}
			}						
			if ($key == "config-linkset$x" && $value == "Edit Linkset")
			{
				//Takes the last value in the key to know the database ID number clicked
				$rest = substr($key, -1);
				
				//Sets the ID number into a session variable to go to the redirection and edit the profile
				$_SESSION['id_num'] = $rest;
			
				//$proc_id = substr($key,0,1);
				//echo $proc_id;
				//$_SESSION['selected_proc'] = $proc_id;
			
				//Redirects to the create profile page
				header( 'Location:create_ss7_linkset.php#top' ) ;
			}
			if ($key == "config-route$x" && $value == "Edit Route")
			{
				//Takes the last value in the key to know the database ID number clicked
				$rest = substr($key, -1);
				$proc_id = substr($key,0,1);
				//echo $proc_id;
				$_SESSION['selected_proc'] = $proc_id;
				
				//Sets the ID number into a session variable to go to the redirection and edit the profile
				$_SESSION['id_num'] = $rest;
			
				//Redirects to the create profile page
				header( 'Location:create_ss7_route.php' ) ;
			}
			if ($key == "config-isup$x" && $value == "Edit ISUP Interface")
			{
				//Takes the last value in the key to know the database ID number clicked
				$rest = substr($key, -1);
				
				//Sets the ID number into a session variable to go to the redirection and edit the profile
				$_SESSION['id_num'] = $rest;
				$proc_id = substr($key,0,1);
				//echo $proc_id;
				$_SESSION['selected_proc'] = $proc_id;
			
				//Redirects to the create profile page
				header( 'Location:create_ss7_isup.php' ) ;
			}
			//Clicked when user wants to use a Linkset Profile
			if ($key == "use-linkset$x" && $value == "Bind Linkset")
			{
				//Check if the link being bound has the same link type, switchtype and unique SLC value as all the other links attached to this linkset
				//If the linkset is not tied to any link, allow it
				//If it isn't then check to make sure all the attached links have the same values
				//class redirection
				//echo "database = $db_location<br />";
				$ss7_linkset_view->clicked_id = $x;
				$ss7_linkset_view->check_linksets();
				
				if ($ss7_linkset_view->error_linkset == "pass")
				{	
					$port = $_SESSION['port_num_clicked'];
					//Get linkset from proper db
					if ($ss7_linkset_view->proc_id == 1)
					{
						$db = "sqlite:../sqlite/cardinfo.db";
					}
					else
					{
						$db = "sqlite:../sqlite/cardinfo" . $ss7_linkset_view->proc_id . ".db";
					}
	
					$db2 = "sqlite:../sqlite/cardinfo.db";
	
					$param = "profile_name";
					$where_param = "id = " . $x;
					$values = $data->select_statement ($db2, "ss7_linkset_profile", $param, $where_param);
					
					$update_where = "port_id = $port";	
					$insert_param = "linkset";
					$update_param = "linkset = \"" . $values['profile_name'] . "\"";
					$insert_values = "\"" . $values['profile_name'] . "\"";													
				
				
					//Checks to see if the linkset is already found in the used table
					$card = $_SESSION['card_clicked'] . "-" . $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];
					$linkset_param = "card, name";
					$linkset_where_param = "card = \"" . $card . "\"";
					$linkset_found = $data->select_statement ($db, "used_linkset", $linkset_param, $linkset_where_param);	
					//echo $linkset_found['card'];
					if ($linkset_found['card'] == $card)
					{
						//update the existing entry for the new profile name
						$linkset_update_where = "card = \"$card\"";
						$linkset_update_param = "name = \"" . $values['profile_name'] . "\"";
						
						$data->update_table($db,"used_linkset", $linkset_update_param, $linkset_update_where);
						
					}
					elseif ($linkset_found['card'] == "")
					{
						//Entry was not found, insert it into the table
						$linkset_insert_param = "id, card, name";
						$linkset_insert_values = "$x, \"" . $card . "\" ,\"" . $values['profile_name'] . "\"";
						$data->insert_statement($db, "used_linkset", $linkset_insert_param, $linkset_insert_values);
					}		
						
					//Checks to see if the line exists
					$sig_param = "port_id = $port";
					
					$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
					$param = "port_id";
	
					$sig_info = $data->select_statement ($db_location, $table_name, $param, $sig_param);						
					//echo $sig_info['port_id'];
					if ($sig_info['port_id'] != "")
					{
						//Port ID found, please update that port
						$data->update_table($db,$table_name, $update_param, $update_where);
						
					}
					if ($sig_info['port_id'] == "")
					{
						//echo "I am here <br />";
						//Insert the line
						$data->insert_statement($db, $table_name, $insert_param, $insert_values);
					}						
					
					unset($_SESSION['last_profile']);
					$_SESSION['linkset'] = "Done";
					
					if ($_SESSION['skip_route'] == "yes")
					{
						//If this is your first run through, go directly to creating a route
						header( 'Location:create_ss7_route.php#top' );
					}
					elseif ($_SESSION['deleted_linkset'] == "yes")
					{
						//If all the linksets were deleted, go to the route page
						header( 'Location:view_ss7_linkset.php' );						
					}
					elseif ($_SESSION['ccspan'] == "yes")
					{
						$ss7_linkset_view->unset_sessions();
			
						header( 'Location:create_ss7_ccspans.php#top' );
					}
				}
			}
		}
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";			
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		$javascript = "
<script type=\"text/javascript\">
function delete($id) {
   var answer = confirm(\"Do you want to delete this Linkset?\")
   if (answer)
   {
      window.location = \"view_ss7_linkset.php?delete-linkset$id=\"Delete Linkset\"\";
   }
}
</script>";			
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("SS7 Configuration Wizard", "../../../style.css", $javascript);		
	}	

	//Display the SS7 Profiles
	$ss7_linkset_view->display_profiles();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{	
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}	
?>