<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class ss7_link_class
{
	
	//Class Variables
	public $data = "";					//Contains the database class
	public $line_type="";				//Type of Line configured
	public $link_name="";				//SS7 Link name
	public $span="";					//SS7 Link Span
	public $sig_channel="";				//SS7 Signalling Channel
	public $error_type="";				//SS7 Error Correction
	public $lssu="";					//SS7 LSSU
	public $priority="";				//SS7 Priority
	public $link_type="";				//SS7 Link Type
	public $switchtype="";				//SS7 Switchtype
	public $SSF="";						//SS7 SSF
	public $SLC="";						//SS7 SLC
	private $error = array();			//Holds the errors created in the form
	public $error_count = "";			//Error counter variable;
	public $untoken_card_name = "";		//Card Name
	public $card_name = "";				//Tokenized card_name
	public $total_ports = "";			//Contains the total number of ports for that particular card
	public $database=array();			//Stores the returned values from the database
	private $name = "";					//Stores the name from the card_present table
	public $db_location = "";			//Contains the database location for sqlite
	public $skip="";
	public $proc_id="";					//Contains the relay proc_id
	public $relay_type = "";			//Contains the relay type
	
	//Main Display Function
	function main()
	{		
		if ($this->link_name == "")
		{
			$a = $this->span;
			$this->link_name = "Link$a";
		}
		
		//Checks which values to place in the form
		$this->form_values();
		if ($_SESSION['embedded'] != "true" && $_REQUEST['embedded'] != "true")
		{
			echo "<h3>" . $_SESSION['card_clicked'] . " - Port " . $_SESSION['port_num_clicked'] . " - SS7 Link Configuration</h3>";
		/*?>
        <p>
        	The SS7 Link configuration is the first step in creating an SS7 setup. Here you select all the MTP link configuration parameters.<br />
            MTP information is only required on spans that are going to have signalling links on them.<br />
            Voice only spans do not require link configuration.
        </p>
        <?php*/
		echo "<hr style='width:700px;' align='left'/>";
		}
		?>
    	<form action="" method="post">
     		<br />
        	<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">ISUP Termination</th>
                <tr>
	                <td class="mytablesubheader" width='30%'>Does this port contain a signalling link?</td>
                    <td width='70%'>
                    
            <?php
			if ($this->relay_type == "SLAVE" && ($this->skip == "yes" || $_SESSION['skip'] == "yes"))
			{
				echo "<input type=\"submit\" name=\"sigandvoice\" value=\"YES\" disabled=\"disabled\" style=\"color:black; background-color: #999; font-weight:bold\"/>\n";
			?>
            <input type="submit" name="voice" value="NO" style="background-color: #CCC" disabled="disabled"/>
			
            <?php

				//echo "<input type=\"submit\" name=\"sigandvoice\" value=\"YES\" disabled=\"disabled\" style=\"background-color: #CCC\"/>\n";
			}
			elseif($this->relay_type == "SLAVE" && ($this->skip != "yes" || $_SESSION['skip'] != "yes"))
			{
				echo "<input type=\"submit\" name=\"sigandvoice\" value=\"YES\" disabled=\"disabled\" style=\"background-color: #CCC\"/>\n";
			?>
            <input type="submit" name="voice" value="NO" style="color:black; background-color: #999; font-weight:bold" disabled="disabled"/>
			
            <?php
			}
			else
			{
				if ($_REQUEST['sigandvoice'] == "YES" || $this->skip == "yes" || $_SESSION['skip'] == "yes")
				{
					echo "<input type=\"submit\" name=\"sigandvoice\" value=\"YES\" style=\"color:black; background-color: #999; font-weight:bold\"/>\n";
				}
				else
				{
					echo "<input type=\"submit\" name=\"sigandvoice\" value=\"YES\" style=\"background-color: #CCC\"/>\n";
				}
			
			?>
            <input type="submit" name="voice" value="NO" style="background-color: #CCC"/>
            </td>
			</tr>
            </table>
            <?php
			}
			//echo $_SESSION['skip'];
			if ($_REQUEST['sigandvoice'] == "YES" || $this->skip == "yes" || $_SESSION['skip'] == "yes")
			{
			?>
            <br />
			<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">ISUP Termination Profile</th>
            	<tr>
                	<td class="mytablesubheader" width='30%'>Link Name</td>
                    <?php
					if ($this->database['link_name'] == "") {
					?>
                    <td width='50%'><input type="text" name="link_name" value="<?php echo $this->link_name; ?>" align="right" style="text-align:left; width:100px" /></td>
                    <?php
					}
					else {
					?>
                    <td width='50%'><input type="text" name="link_name" value="<?php echo $this->link_name; ?>" align="right" style="text-align:left; width:100px" disabled='disabled'/></td>
                    <?php						
					}
					?>
                    <td width='20%'><font color="#FF0000"><?=$this->error['link_name']?></font></td>
                </tr>
            </table>
            <br />
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">MTP1 Information</th>
                <tr>
                	<td class="mytablesubheader" width='30%'>Span</td>
                    <td width='50%'><font color="#666666"><strong><?php echo $this->span; ?></strong></font></td>
                    <td width='20%'></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Line Media Type</td>
                    <td width='50%'><font color="#666666"><strong><?php echo $this->line_type; ?></strong></font></td>
                    <td width='20%'><font color="#FF0000"></font></td>
                </tr>                
                <tr>
                	<td class="mytablesubheader" width='30%'>Signalling Channel</td>
                    <td width='50%'><input type="text" name="sig_channel" value="<?php echo $this->sig_channel; ?>" style="text-align:left; width:30px" /></td>
                    <td width='20%'><font color="#FF0000"><?=$this->error['sig_channel']?></font></td>
                </tr>
            </table>
            <br />            
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">MTP2 Information</th>  
                <tr>
                	<td class="mytablesubheader" width='30%'>Errortype</td>
                    <td width='50%'>
                    	<select name="error_type">
                        	<option value="basic" <?php if ($this->pick['error_type_basic'] == "yes" ) { ?> selected="selected" <?php } ?> style="text-align:left">Basic</option>
                            <option value="pcr" <?php if ($this->pick['error_type_pcr'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left" >PCR</option>
                        </select>
                    </td>
                    <td width='20%'><font color="#FF0000"><?=$this->error['error_type']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>LSSU Length</td>
                    <td width='50%'>
                    	<select name="lssu">
                        	<option value="1" <?php if ($this->pick['lssu_1'] == "yes" ) { ?> selected="selected" <?php } ?> style="text-align:left">1</option>
                            <option value="2" <?php if ($this->pick['lssu_2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">2</option>
                        </select>
                    </td>
                    <td width='20%'><font color="#FF0000"><?=$this->error['lssu']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Link Type</td>
                    <td width='50%'>
                    	<select name="link_type">
                        	<option value="itu92" <?php if ($this->pick['link_type_itu92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU92</option>
                            <option value="itu88" <?php if ($this->pick['link_type_itu88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU88</option>
                            <option value="ansi96" <?php if ($this->pick['link_type_ansi96'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI96</option>
                            <option value="ansi92" <?php if ($this->pick['link_type_ansi92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI92</option>
                            <option value="ansi88" <?php if ($this->pick['link_type_ansi88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI88</option>
                            <option value="etsi" <?php if ($this->pick['link_type_etsi'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ETSI</option>
                        </select>
                    </td>
                    <td width='20%'><font color="red"><?=$this->error['link_type']?></font></td>
                </tr> 
           </table>
           <br />
           <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">MTP3 Information</th>               
                <tr>
                	<td class="mytablesubheader" width='30%'>Priority</td>
                    <td width='50%'><input type="text" name="priority" value="<?php if ($this->priority != "") { echo $this->priority; } else { echo 0; } ?>" style="text-align:left; width:30px" /></td>
                    <td width='20%'><font color="red"><?=$this->error['priority']?></font></td>               
                </tr>                               
                <tr>
                	<td class="mytablesubheader" width='30%'>Switch Type</td>
                    <td width='50%'>
                    	<select name="switchtype">
                        	<option value="itu00" <?php if ($this->pick['switchtype_itu00'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU00</option>
                            <option value="itu97" <?php if ($this->pick['switchtype_itu97'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU97</option>
                            <option value="itu88" <?php if ($this->pick['switchtype_itu88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU88</option>
                            <option value="itu92" <?php if ($this->pick['switchtype_itu92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ITU92</option>
                            <option value="etsiv2" <?php if ($this->pick['switchtype_etsi2'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ETSI v2</option>
                            <option value="etsiv3" <?php if ($this->pick['switchtype_etsi3'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ETSI v3</option>
                            <option value="uk" <?php if ($this->pick['switchtype_uk'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">UK</option>
                            <option value="russia" <?php if ($this->pick['switchtype_russia'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">RUSSIA</option>
                           <?php /* <option value="china" <?php if ($this->pick['switchtype_china'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">CHINA</option> */ ?>
                            <option value="india" <?php if ($this->pick['switchtype_india'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">INDIA</option>
                            <option value="ansi88" <?php if ($this->pick['switchtype_ansi88'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI88</option>
                            <option value="ansi92" <?php if ($this->pick['switchtype_ansi92'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI92</option>
                            <option value="ansi95" <?php if ($this->pick['switchtype_ansi95'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">ANSI95</option>
                        </select>
                    </td>
                   <td width='20%'><font color="red"><?=$this->error['switchtype']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Sub-Service Field (SSF)</td>
                    <td width='50%'>
                    	<select name="ssf">
                        	<option value="nat" <?php if ($this->pick['ssf_nat'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">National</option>
                            <option value="int" <?php if ($this->pick['ssf_int'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">International</option>
                            <option value="spare" <?php if ($this->pick['ssf_spare'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Spare</option>
                            <option value="res" <?php if ($this->pick['ssf_res'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Reserved</option>
                        </select>
                    </td>
                    <td width='20%'><font color="red"><?=$this->error['ssf']?></font></td>
                </tr>
                <tr>
					<td class="mytablesubheader" width='30%'>Signaling Link Selection Code (SLC)</td>
                    <td width='50%'><input type="text" name="slc" value="<?php if ($this->SLC == "") { echo 0; } elseif ($this->SLC != "") { echo $this->SLC; } else { echo $ss7_link->SLC; } ?>" style="text-align:left; width:30px" /></td>
                    <td width='20%'><font color="red"><?=$this->error['slc']?></font></td>
               	</tr>                 
            </table>
            <br />
        <?php
			}
			echo "<table width=\"100%\">\n";
			echo "<tr>\n";
			if ($this->relay_type == "SLAVE")
			{
		?>
            <td width="1%"><input type="submit" name="apply" value="Apply to Port" disabled="disabled" <?php echo $_SESSION['disabled_button_class']; ?>/></td>
        <?php
			}
			else
			{
			
            	if ($_REQUEST['sigandvoice'] == "YES" || $this->skip == "yes" || $_SESSION['skip'] == "yes")
				{			
		?>
            <td width="1%"><input type="submit" name="apply" value="Apply to Port" <?php echo $_SESSION['button_class']; ?>/></td>
        <?php
				}
			}
		?>
            <td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
            </tr>
            </table>
        </form>  			
        <?php
	}
	
	//Validates the information
	function validate()
	{
		$this->card_name = $_SESSION['card_clicked'];
		
		//Validate Link Name and make sure it doesn't exist
		//Must go through all SS7 link tables and extract the link names and compare them. If the link name exists, then will return an error
	
		$select = "SELECT id, dev_name FROM card_present;";

		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$values[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
		
		for ($b = 0; $b < $a; $b++)
		{
			//tokenize card_name
			$this->token_cards($values[$b]['dev_name']);
			$table = $this->name . "_" . $values[$b]['id'] . "_SS7_link";
			
			//Check the database. If the database exists, use that information to display
			$table_exists = $this->data->check_for_table ($this->db_location, $table_name);
			
			//Table exists
			if ($table_exists > 1)
			{
				$select = "SELECT link_name FROM " . $table . ";";
		
				try
				{
					//open the database
					$db = new PDO($this->db_location);
		
					$result = $db->query($select);
				
					foreach($result as $row)
					{
						$link_name[$c] = $row['link_name'];
						$c++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					//echo "hello <br />";
					print 'Exception : '.$e->getMessage();
				}
				
				for ($d = 0; $d < $c; $d++)
				{
					if ($this->link_name == $link_name[$d]['link_name'])
					{
						$this->error['link_name'] = "Link name <b>EXISTS</b>. Please use a <b>DIFFERENT</b> Link name";
						$this->error_count++;
					}
				}
			}
		}
		
		
		//Validation for the Signalling Channel
		if ($this->line_type == "T1")
		{
			if (!is_numeric($this->sig_channel))
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be a <b>NUMERIC</b> value";
				$this->error_count++;				
			}
			elseif ($this->sig_channel < 1 || $this->sig_channel > 24)
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be between Channel <b>1</b> and <b>24</b> for a <b>T1</b> Line";
				$this->error_count++;
			}
		}
		elseif ($this->line_type == "E1")
		{
			if (!is_numeric($this->sig_channel))
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be a <b>NUMERIC</b> value";
				$this->error_count++;				
			}
			elseif ($this->sig_channel < 1 || $this->sig_channel > 31)
			{
				$this->error['sig_channel'] = "Signalling Channel <b>MUST</b> be between Channel <b>1</b> and <b>31</b> for a <b>E1</b> Line";
				$this->error_count++;
			}
		}
		
		//Validation for link types && switchtypes
		/*if ($this->line_type == "T1")
		{
			if ($_REQUEST['link_type'] != "ansi95" && $_REQUEST['link_type'] != "ansi92" && $_REQUEST['link_type'] != "ansi88")
			{
				$this->error['link_type'] = "Cannot Use <b>ITU</b> or <b>ETSI</b> link types with a T1 Span";
				$this->error_count++;
			}
			
			if ($_REQUEST['switchtype'] != "ansi96" && $_REQUEST['switchtype'] != "ansi92" && $_REQUEST['switchtype'] != "ansi88")
			{
				$this->error['switchtype'] = "Cannot Use <b>ITU</b> or <b>ETSI</b> switchtypes with a T1 Span";
				$this->error_count++;
			}
		}
		elseif ($this->line_type == "E1")
		{
			if ($_REQUEST['link_type'] == "ansi95" || $_REQUEST['link_type'] == "ansi92" || $_REQUEST['link_type'] == "ansi88")
			{
				$this->error['link_type'] = "Cannot Use <b>ANSI</b> link types with an E1 Span";
				$this->error_count++;
			}
			
			if ($_REQUEST['switchtype'] == "ansi96" || $_REQUEST['switchtype'] == "ansi92" || $_REQUEST['switchtype'] == "ansi88")
			{
				$this->error['switchtype'] = "Cannot Use <b>ANSI</b> switchtypes with an E1 Span";
				$this->error_count++;
			}
		}*/
		
		if ((($_REQUEST['link_type'] == "ansi96" || $_REQUEST['link_type'] == "ansi92" || $_REQUEST['link_type'] == "ansi88") && ($_REQUEST['switchtype'] != "ansi95" && $_REQUEST['switchtype'] != "ansi92" && $_REQUEST['switchtype'] != "ansi88"))	|| ($_REQUEST['link_type'] != "ansi96" && $_REQUEST['link_type'] != "ansi92" && $_REQUEST['link_type'] != "ansi88") && ($_REQUEST['switchtype'] == "ansi95" || $_REQUEST['switchtype'] == "ansi92" || $_REQUEST['switchtype'] == "ansi88"))
		{
			$this->error['link_type'] = "The Link Type and the Switch Type chosen must be of the same <b>SS7 STANDARD</b>";
			$this->error_count++;
		}
		
		//Validation for the Priority
		if (!is_numeric($this->priority))
		{
			$this->error['priority'] = "Priority <b>MUST</b> be a <b>NUMERIC</b> value";
			$this->error_count++;
		}
		elseif (!ctype_digit($this->priority))
		{
			$this->error['priority'] = "Priority <b>MUST</b> be an <b>INTEGER</b>";
			$this->error_count++;
		}

		//Validation for the SLC
		if (!is_numeric($this->SLC))
		{
			$this->error['slc'] = "SLC <b>MUST</b> be a <b>NUMERIC</b> value";
			$this->error_count++;
		}
		elseif (!ctype_digit($this->SLC))
		{
			$this->error['slc'] = "SLC <b>MUST</b> be an <b>INTEGER</b> value";
			$this->error_count++;
		}
		elseif ( $this->SLC < 0 || $this->SLC > 15)
		{
			$this->error['slc'] = "SLC <b>MUST</b> be between <b>0</b> and <b>15</b>";
			$this->error_count++;
		}
			
	}
	
	//Tokenizes Card Name
	function tokenize()
	{
		$tok = strtok($this->untoken_card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->card_name = $token[1];		
	}
	
	//tokenizes the card names from the card_present table
	function token_cards($card_name)
	{
		$tok = strtok($card_name, "-");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		$this->name = $token[1];		
	}
	
	//Form Values
	function form_values()
	{
		if ($_REQUEST['error_type'] == "basic")
		{
			$this->pick['error_type_basic'] = "yes";
		}
		elseif ($_REQUEST['error_type'] == "pcr")
		{
			$this->pick['error_type_pcr'] = "yes";
		}
		elseif ($this->database['error_type'] == "basic")
		{
			$this->pick['error_type_basic'] = "yes";
		}
		elseif ($this->database['error_type'] == "pcr")
		{
			$this->pick['error_type_pcr'] = "yes";
		}
		
		if ($_REQUEST['lssu'] == "2")
		{
			$this->pick['lssu_2'] = "yes";
		}
		elseif ($_REQUEST['lssu'] == "1")
		{
			$this->pick['lssu_1'] = "yes";
		}
		elseif ($this->database['lssu'] == "2")
		{
			$this->pick['lssu_2'] = "yes";
		}
		elseif ($this->database['lssu'] == "1")
		{
			$this->pick['lssu_1'] = "yes";
		}
		
		if ($_REQUEST['link_type'] == "itu92")
		{
			$this->pick['link_type_itu92'] = "yes";
		}
		elseif ($_REQUEST['link_type'] == "itu88")
		{
			$this->pick['link_type_itu88'] = "yes";
		}
		elseif ($_REQUEST['link_type'] == "ansi96")
		{
			$this->pick['link_type_ansi96'] = "yes";
		}
		elseif ($_REQUEST['link_type'] == "ansi92")
		{
			$this->pick['link_type_ansi92'] = "yes";
		}
		elseif ($_REQUEST['link_type'] == "ansi88")
		{
			$this->pick['link_type_ansi88'] = "yes";
		}
		elseif ($_REQUEST['link_type'] == "etsi")
		{
			$this->pick['link_type_etsi'] = "yes";
		}
		elseif ($this->database['link_type'] == "itu92")
		{
			$this->pick['link_type_itu92'] = "yes";
		}
		elseif ($this->database['link_type'] == "itu88")
		{
			$this->pick['link_type_itu88'] = "yes";
		}
		elseif ($this->database['link_type'] == "ansi96")
		{
			$this->pick['link_type_ansi96'] = "yes";
		}
		elseif ($this->database['link_type'] == "ansi92")
		{
			$this->pick['link_type_ansi92'] = "yes";
		}
		elseif ($this->database['link_type'] == "ansi88")
		{
			$this->pick['link_type_ansi88'] = "yes";
		}
		elseif ($this->database['link_type'] == "etsi")
		{
			$this->pick['link_type_etsi'] = "yes";
		}		
		
		if ($_REQUEST['switchtype'] == "itu00")
		{
			$this->pick['switchtype_itu00'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "itu97")
		{
			$this->pick['switchtype_itu97'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "itu88")
		{
			$this->pick['switchtype_itu88'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "itu92")
		{
			$this->pick['switchtype_itu92'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "etsiv2")
		{
			$this->pick['switchtype_etsi2'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "etsiv3")
		{
			$this->pick['switchtype_etsi3'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "uk")
		{
			$this->pick['switchtype_uk'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "russia")
		{
			$this->pick['switchtype_russia'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "china")
		{
			$this->pick['switchtype_china'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "india")
		{
			$this->pick['switchtype_india'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "ansi88")
		{
			$this->pick['switchtype_ansi88'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "ansi92")
		{
			$this->pick['switchtype_ansi92'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "ansi95")
		{
			$this->pick['switchtype_ansi95'] = "yes";
		}
		elseif ($this->database['switchtype'] == "itu00")
		{
			$this->pick['switchtype_itu00'] = "yes";
		}
		elseif ($this->database['switchtype'] == "itu97")
		{
			$this->pick['switchtype_itu97'] = "yes";
		}
		elseif ($this->database['switchtype'] == "itu88")
		{
			$this->pick['switchtype_itu88'] = "yes";
		}
		elseif ($this->database['switchtype'] == "itu92")
		{
			$this->pick['switchtype_itu92'] = "yes";
		}
		elseif ($this->database['switchtype'] == "etsiv2")
		{
			$this->pick['switchtype_etsi2'] = "yes";
		}
		elseif ($this->database['switchtype'] == "etsiv3")
		{
			$this->pick['switchtype_etsi3'] = "yes";
		}
		elseif ($this->database['switchtype'] == "uk")
		{
			$this->pick['switchtype_uk'] = "yes";
		}
		elseif ($this->database['switchtype'] == "russia")
		{
			$this->pick['switchtype_russia'] = "yes";
		}
		elseif ($this->database['switchtype'] == "china")
		{
			$this->pick['switchtype_china'] = "yes";
		}		
		elseif ($this->database['switchtype'] == "india")
		{
			$this->pick['switchtype_india'] = "yes";
		}
		elseif ($this->database['switchtype'] == "ansi88")
		{
			$this->pick['switchtype_ansi88'] = "yes";
		}
		elseif ($this->database['switchtype'] == "ansi92")
		{
			$this->pick['switchtype_ansi92'] = "yes";
		}
		elseif ($this->database['switchtype'] == "ansi95")
		{
			$this->pick['switchtype_ansi95'] = "yes";
		}		
		
		if ($_REQUEST['ssf'] == "nat")
		{
			$this->pick['ssf_nat'] = "yes";
		}
		elseif ($_REQUEST['ssf'] == "int")
		{
			$this->pick['ssf_int'] = "yes";
		}
		elseif ($_REQUEST['ssf'] == "spare")
		{
			$this->pick['ssf_spare'] = "yes";
		}
		elseif ($_REQUEST['ssf'] == "res")
		{
			$this->pick['ssf_res'] = "yes";
		}
		elseif ($this->database['SSF'] == "nat")
		{
			$this->pick['ssf_nat'] = "yes";
		}
		elseif ($this->database['SSF'] == "int")
		{
			$this->pick['ssf_int'] = "yes";
		}
		elseif ($this->database['SSF'] == "spare")
		{
			$this->pick['ssf_spare'] = "yes";
		}
		elseif ($this->database['SSF'] == "res")
		{
			$this->pick['ssf_res'] = "yes";
		}		
		
	}
}
?>