<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Class Includes
	include "../../database_classes.php";
	include "mg_channels_class.php";
	
	//Class Constructors
	$mg_chan = new ss7_mg_channels_class;
	$data = new database_class;
	
	//echo $ss7_m2ua->proc_id . "<br />";
	
	//Database related variables
	if ($proc_id == 1 || $proc_id == "")
		$db_location = "sqlite:../../sqlite/cardinfo.db";	
	elseif ($proc_id > 1)
		$db_location = "sqlite:../../sqlite/cardinfo" . $ss7_m2ua->proc_id . ".db";
	
	$table_exist = $data->check_for_table('sqlite:../../sqlite/relay_info.db',"ss7_relay");
	
	if ($table_exist > 1)
	{
		$relay = $data->select_statement('sqlite:../../sqlite/relay_info.db',"ss7_relay","relay_type","id = 1");
		$relay_type = $relay['relay_type'];
	}

	//SQLite information
	$mg_chan->db_location = $db_location;
	$untoken_card_name = $_SESSION['card_clicked'];
	$proc_id = $_SESSION['proc_id'];
	$mg_chan->db_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_channels";	
	$m2ua_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";
	$mg_chan->span = $_SESSION['ss7_span'];
	$cardtable = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$where = "port_id = " . $_SESSION['port_num_clicked'];
	$cardlinetype = $data->select_statement ($mg_chan->db_location, $cardtable, "line_type", $where);
	
	if ($data->check_for_table($mg_chan->db_location,$m2ua_table) > 1) {
		$sig_channel=$data->select_statement($mg_chan->db_location,$m2ua_table,'*',$where);
	}
		
	$mg_chan->line_type = $cardlinetype['line_type'];
	$mg_chan->sig_channel = $sig_channel['sig_channel'];	
	$mg_chan->data = $data;	
	$ss7_span = $_SESSION['ss7_span'];

	if ($_REQUEST['cancel'])
		header('Location:../../wanrouterhwprobe.php');
	
	if ($_REQUEST['cancel_error'])
		header('Location:../../wanrouterhwprobe.php');
		
	if ($_REQUEST['apply'] == "Apply to Port")
	{
		$mg_chan->get_data_values($mg_chan->db_table,$_SESSION['port_num_clicked']);
		if ($mg_chan->validation())
		{
			$_SESSION['mg_base'] = $_REQUEST['base'];
			//save to db
			//check if table exists for that card
			if ($data->check_for_table($db_location,$mg_chan->db_table) > 1)
			{
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$check = $data->select_statement($db_location,$mg_chan->db_table,'profile_name',$where_param);
				
				if ( $check['profile_name'] != "")
				{
					//update
					$update_param = "mg_profile=\"" . $_REQUEST['mg_profile'] . "\",prefix=\"" . $_REQUEST['prefix'] . "\",base=\"" . $_REQUEST['base'] . "\",channel_map=\"" . $_REQUEST['channel_map'] . "\", ss7_span=" . $ss7_span;
					$data->update_table($db_location,$mg_chan->db_table,$update_param,$where_param);
				}
				else
				{
					//insert
					$insert_param = "port_id,profile_name,mg_profile,prefix,base,channel_map,ss7_span";
					$insert_values = $_SESSION['port_num_clicked'] . ",\"" . $_REQUEST['profile_name'] . "\",\"" . $_REQUEST['mg_profile'] . "\",\"" . $_REQUEST['prefix'] . "\",\"" . $_REQUEST['base'] . "\",\"" . $_REQUEST['channel_map'] . "\", " . $ss7_span;
					$data->insert_statement($db_location,$mg_chan->db_table,$insert_param,$insert_values);
				}
			}
			else
			{
				//create table
				$create_param = "port_id int, profile_name varchar(100), mg_profile varchar(100), prefix varchar(100), base varchar(100), channel_map varchar(100), ss7_span int";
				$data->create_table($db_location,$mg_chan->db_table,$create_param);
				
				//insert table
				$insert_param = "port_id,profile_name,mg_profile,prefix,base,channel_map,ss7_span";
				$insert_values = $_SESSION['port_num_clicked'] . ",\"" . $_REQUEST['profile_name'] . "\",\"" . $_REQUEST['mg_profile'] . "\",\"" . $_REQUEST['prefix'] . "\",\"" . $_REQUEST['base'] . "\",\"" . $_REQUEST['channel_map'] . "\", " . $ss7_span;
				$data->insert_statement($db_location,$mg_chan->db_table,$insert_param,$insert_values);
				
			}
			header('Location:../../wanrouterhwprobe.php');
		}
	}
	

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../../sqlite/database_creation.php';
		include '../../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Media Gateway Configuration", "../../../../style.css","");		
	}	

	//Display the page
	$mg_chan->display();

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		//ClearOS Integration
		$display_common->html_footer();	
}
else
{
	header( 'Location:../../index.php' ) ;
}
?>