<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	$untoken_card_name = $_SESSION['card_clicked'];
	$proc_id = $_SESSION['proc_id'];
	$db_m2ua_link_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";	
	$db_mg_chans_table = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels";	
	$port = $_SESSION['port_num_clicked'];
	
	//includes
	include '../../database_classes.php';
 	//@SLIBARIAN
	//Overide question as M2UA without voice has issues
	$_REQUEST['apply'] = "Apply";
	$_REQUEST['voice_chans'] = 'yes';
	
	$ask_chans = false;
	
	//class constructors
	$data = new database_class;
	
	if ($data->check_for_table('sqlite:../../sqlite/cardinfo.db',$db_m2ua_link_table) > 1) {
		if ($data->check_for_table('sqlite:../../sqlite/cardinfo.db',$db_mg_chans_table) > 1) 
			$chans = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$db_mg_chans_table,'*','port_id = ' . $port);
	
		$m2ua = $data->select_statement('sqlite:../../sqlite/cardinfo.db',$db_m2ua_link_table,'*','port_id='.$port);
		
		if ($chans['port_id'] != "" && $m2ua['voice_chans'] == "yes") 
			header ('Location: mg_channels.php');
		elseif ($m2ua['voice_chans'] == "no")
			header ('Location: ../../wanrouterhwprobe.php');
		else
			$ask_chans = true;
	}
	
	if ($_REQUEST['cancel'])
		header('Location:../../wanrouterhwprobe.php');
	
	if ($_REQUEST['apply']) {
		//validate form
		if (validate($error)) {
			//enter into m2ua table voice chan result
			$where = 'port_id = ' . $port;
			$param = 'voice_chans = "' . $_REQUEST['voice_chans'] . '"';
			
			if ($_REQUEST['voice_chans'] == "yes") {
				$data->update_table('sqlite:../../sqlite/cardinfo.db',$db_m2ua_link_table,$param,$where);
				header('Location:mg_channels.php');
			}
			elseif ($_REQUEST['voice_chans'] == "no") {
				$data->update_table('sqlite:../../sqlite/cardinfo.db',$db_m2ua_link_table,$param,$where);
				header('Location:../../wanrouterhwprobe.php');
			}
		}
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../../../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../../sqlite/database_creation.php';
		include '../../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Configuration Manager", "/style.css","");		
	}	

	if ($ask_chans)
		tdm_page($error);
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../../../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:index.php' ) ;
}

function tdm_page ($error) {
	?>
    	<form name='mg_chans'>
           <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Voice Channels</th>                
                <tr>
                    <td class="mytablesubheader" width='30%'>Will this link contain Voice Channels?</td>
                    <td>
                    	<input type='radio' name='voice_chans' value='yes' />YES<br />
                        <input type='radio' name='voice_chans' value='no' />NO                  
                    </td>
                    <td><?=$error['voice_chans']?></td>
                </tr>                                  
            </table>	
	        <br />	
			<table width="100%">
				<tr>
    		        <td width="1%"><input type="submit" name="apply" value="Apply" <?php echo $_SESSION['button_class']; ?>/></td>
            		<td align="right"><input type="submit" name="cancel" value="Cancel" <?php echo $_SESSION['button_class']; ?>/></td>
            	</tr>
            </table>
        </form>              
	<?php
}

function validate(&$error) {
	if ($_REQUEST['voice_chans'] == "") {
		$error['voice_chans'] = "<font color='red'>Please specifiy if this link will have voice channels</font>";
		$error_count++;
	}
	
	if ($error_count == 0)
		return true;
	else
		return false;
}
?>
