<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Class Includes
	include "ss7_m2ua_config_class.php";
	include "../../database_classes.php";
	
	//Class Constructors
	$ss7_m2ua= new ss7_m2ua_class;
	$ss7_m2ua->data = new database_class;
	
	//SQLite information
	$ss7_m2ua->untoken_card_name = $_SESSION['card_clicked'];
	$ss7_m2ua->proc_id = $_SESSION['proc_id'];
	$ss7_m2ua->db_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";
	//echo $ss7_m2ua->proc_id . "<br />";
	
	//Database related variables
	if ($ss7_m2ua->proc_id == 1)
		$ss7_m2ua->db_location = "sqlite:../../sqlite/cardinfo.db";	
	elseif ($ss7_m2ua->proc_id > 1)
		$ss7_m2ua->db_location = "sqlite:../../sqlite/cardinfo" . $ss7_m2ua->proc_id . ".db";
		
	$table_exist = $ss7_m2ua->data->check_for_table('sqlite:../../sqlite/relay_info.db',"ss7_relay");
	if ($table_exist > 1)
	{
		$relay = $ss7_m2ua->data->select_statement('sqlite:../../sqlite/relay_info.db',"ss7_relay","relay_type","id = 1");
		$ss7_m2ua->relay_type = $relay['relay_type'];
	}

	//Gets the number of ports for this card from the card_present table
	$where_param = "id = " . $_SESSION['card_num'];
	$return = $ss7_m2ua->data->select_statement ($ss7_m2ua->db_location, "card_present", "num_ports", $where_param);
	$ss7_m2ua->total_ports = $return[0];
	$ss7_m2ua->span = $_SESSION['ss7_span'];
	
	$cardtable = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$where = "port_id = " . $_SESSION['port_num_clicked'];
	$cardlinetype = $ss7_m2ua->data->select_statement ($ss7_m2ua->db_location, $cardtable, "line_type", $where);	
	$ss7_m2ua->line_type = $cardlinetype['line_type'];
	//$ss7_m2ua->line_type = $_SESSION['ss7_line'];
	
	//If the user clicks cancel
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		header( 'Location:../../wanrouterhwprobe.php#top' ) ;
	}
	
	if ($_REQUEST['apply'] == "Apply to Port")
	{
		//Validate inforamtion
		$ss7_m2ua->get_data_values($ss7_m2ua->db_table,$_SESSION['port_num_clicked']);
		if ($ss7_m2ua->validate())
		{
			//save to db
			//Check if db exists
			$table = $ss7_m2ua->data->check_for_table($ss7_m2ua->db_location,$ss7_m2ua->db_table);
			
			if ($table > 1)
			{
				//check if update required
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$check = $ss7_m2ua->data->select_statement_order_by($ss7_m2ua->db_location,$ss7_m2ua->db_table,'port_id',$where_param);
				
				if ($check['port_id'] != "") 
				{
					//update	
					$update_param = "span=" . $ss7_m2ua->span . ", sig_channel=\"" . $_REQUEST['sig_channel'] . "\", error_type=\"" . $_REQUEST['error_type'] . "\", lssu=" . $_REQUEST['lssu'] . ", link_type=\"" . $_REQUEST['link_type'] . "\", line_type=\"" . $ss7_m2ua->line_type . "\", interface_id = \"" . $_REQUEST['interface_id'] . "\"";
					$ss7_m2ua->data->update_table($ss7_m2ua->db_location,$ss7_m2ua->db_table,$update_param,$where_param);
				}
				else 
				{
					//insert
					$insert_param = "port_id ,link_name, span, sig_channel, error_type, lssu, link_type, line_type, interface_id";
					$insert_values = $_SESSION['port_num_clicked'] . ", \"" . $_REQUEST['link_name'] . "\", " . $ss7_m2ua->span . ", \"" . $_REQUEST['sig_channel'] . "\", \"" . $_REQUEST['error_type'] . "\", " . $_REQUEST['lssu'] . ", \"" . $_REQUEST['link_type'] . "\", \"" . $ss7_m2ua->line_type . "\", \"" . $_REQUEST['interface_id'] . "\"";
					$ss7_m2ua->data->insert_statement($ss7_m2ua->db_location,$ss7_m2ua->db_table,$insert_param,$insert_values);
				}

			}
			else
			{
				// create table and insert
				$create_param = "port_id int,link_name varchar(100), span int, sig_channel int, error_type varchar(100), lssu int, link_type varchar(30), line_type varchar(20), cluster varchar(30), voice_chans varchar(40), interface_id int";
				$ss7_m2ua->data->create_table($ss7_m2ua->db_location,$ss7_m2ua->db_table,$create_param);
				
					$insert_param = "port_id ,link_name, span, sig_channel, error_type, lssu, link_type, line_type, interface_id";
					$insert_values = $_SESSION['port_num_clicked'] . ", \"" . $_REQUEST['link_name'] . "\", " . $ss7_m2ua->span . ", \"" . $_REQUEST['sig_channel'] . "\", \"" . $_REQUEST['error_type'] . "\", " . $_REQUEST['lssu'] . ", \"" . $_REQUEST['link_type'] . "\", \"" . $ss7_m2ua->line_type . "\", \"" . $_REQUEST['interface_id'] . "\"";
					$ss7_m2ua->data->insert_statement($ss7_m2ua->db_location,$ss7_m2ua->db_table,$insert_param,$insert_values);
			}
			
			//redirect to mg_channels page
			header( 'Location:m2ua_clusters.php#top' ) ;
		}
		
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../../sqlite/database_creation.php';
		include '../../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("SS7 M2UA Configuration", "../../../../style.css","");		
	}	

	//SS7 Link configuration page
	$ss7_m2ua->main();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../../index.php' ) ;
}
?>
