<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/


class decide_ss7_link {
	
	public $line_type;			//Physical Line type chosen in physical configuration
	
	public function main($data,$error=NULL) {
		
		$protocol = $this->protocol_mix($data);

		require_once ('../display_class.php');
		$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
		if ($protocol == "ISUP") {
			//M2UA/MG disabled message
			$notif->add("Protocol","An ISUP span has been detected. Configuring for M2UA Signalling Gateway or Media Gateway has been disabled.");
			$disabled_mg = 'disabled="disabled"';
			$style_mg = '#3F5680';
			$style_isup='black';
		}
		if ($protocol == "M2UA" || $protocol == "MG" || $protocol == "M3UA") {
			//ISUP Disabled Message
			$notif->add("Protocol","A Media Gateway or M2UA Signalling Gateway span has been detected. Configuring for ISUP has been disabled.");
			$disabled_isup = 'disabled="disabled"';
			$style_isup = '#3F5680';
			$style_mg='black';
		}
		if ($protocol == "") {
			$style_isup='black';
			$style_mg='black';
		}
		$notif->display();
		unset($notif);
		?>
        <br />
		<form name="select_gw_type" method="post">
    	
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Select a link type</th>
        <?php
		if ($_SESSION['shortname'] == "NSG") {

	?>
                <tr>
                	<td class="mytablesubheader" width='30%'>Available Link types</td>
                    	<td width='40%'><input type='radio' name='link_type' value='isup_term' <?=$disabled_isup?> /><font color="<?=$style_isup?>">ISUP Termination</td>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>
                    <td width='40%'><input type='radio' name='link_type' value='sig_gw' <?=$disabled_mg?> /><font color="<?=$style_mg?>">Signalling Gateway (M2UA)</font></td>
                </tr>
        <?php
		}
	?>
                <tr>
		    <td class="mytablesubheader" width='30%'>
        <?php
		if ($_SESSION['shortname'] == "NVG")
			echo "Available Link types";
		?>                    
                    </td>
                    <td width='40%'><input type='radio' name='link_type' value='isdn' /><font color="black">ISDN Link (PRI)</font></td>
                </tr>  
		<?php
        if ($this->line_type == "E1") {
        ?>
                <tr>
                	<td class="mytablesubheader" width='30%'></td>
                    <td width='40%'><input type='radio' name='link_type' value='r2' /><font color="black">MFC/R2</font></td>
                    <td width='30%'><font color='red'><?=$error?></font></td>
                </tr>                                
        <?php
		}
		if ($_SESSION['shortname'] == "NSG") {
	?>                
                <tr>
                	<td class="mytablesubheader" width='30%'></td>
                    <td width='40%'><input type='radio' name='link_type' value='no_sig_link' /><font color="black">No Signalling Link</font></td>
                </tr>
        <?php
		}
	?>
                <tr>
                	<td class="mytablesubheader" width='30%'><br /></td>
                    <td width='40%'><br /></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'></td>
                    <td width='40%'><input type='submit' name='select_link_type' value="Next" <?php echo $_SESSION['button_class']; ?> /><input type='submit' name='cancel' value='Cancel' <?php echo $_SESSION['button_class']; ?> /></td>
                </tr>
            </table>
		</form>                      
        <?php
	}
	
	public function protocol_mix($data) {

		$boards = $data->array_select_statement('sqlite:../sqlite/cardinfo.db','card_present','id,dev_name,num_ports','');
		if (!empty($boards)) {
			foreach ($boards as $board) {
				$tmpBoard = explode('-',$board['dev_name']);
				$name = $tmpBoard[1];
				$number = $board['id'];

				//Check to see if all applicable tables are populated
				$physical_table = $name . '_' . $number;
				$r2_table = $name . '_' . $number.'_r2_signalling';
				$pri_table = $name . '_' . $number.'_signalling';
				$m2ua_link_table = $name . '_' . $number.'_m2ua_link';
				$mg_table = $name.'_'.$number.'_m2ua_channels';
				$ss7_link_table = $name.'_'.$number.'_SS7_link';
				$ss7_ccspans_table = $name.'_'.$number.'_SS7_ccspans';
		
				for ($a = 1; $a <= $board['num_ports']; $a++) {
					$insert=false;
					$port_type = "";
					$phys = array();
					$ss7_link = array();
					$ss7_ccspans = array();
					$m2ua_link = array();
					$mg_link = array();
					$r2_link = array();
					$pri_link = array();
		
					$phys = $data->select_statement('sqlite:../sqlite/cardinfo.db',$physical_table,'*','port_id='.$a);
					$ss7_link = $data->select_statement('sqlite:../sqlite/cardinfo.db',$ss7_link_table,'*','port_id='.$a);
					$ss7_ccspans = $data->select_statement('sqlite:../sqlite/cardinfo.db',$ss7_ccspans_table,'*','port_id='.$a);
					$m2ua_link = $data->select_statement('sqlite:../sqlite/cardinfo.db',$m2ua_link_table,'*','port_id='.$a);
					$mg_link = $data->select_statement('sqlite:../sqlite/cardinfo.db',$mg_table,'*','port_id='.$a);
					$r2_link = $data->select_statement('sqlite:../sqlite/cardinfo.db',$r2_table,'*','port_id='.$a);
					$pri_link = $data->select_statement('sqlite:../sqlite/cardinfo.db',$pri_table,'*','port_id='.$a);
		
					/*echo "physical<br />";
					print_r ($phys);
					echo "<br /> m2ua<br />";
					print_r ($m2ua_link);
					echo "<br />mg<br />";
					print_r ($mg_link);
					echo "<br />SS7 Link<br />";
					print_r ($ss7_link);	
					echo "<br />CCSPANS<br />";
					print_r ($ss7_ccspans);
					echo "<br />R2<br />";
					print_r ($r2_link);
					echo "<br />PRI<br />";
					print_r ($pri_link);														
					echo "<br />";*/
		
		
					//check if ss7 complete
					if ($ss7_link['link_name'] != "" && $ss7_ccspans['profile_name'] != "" && $phys['dev_name'] != "")
						$port_type = "ISUP";
					elseif ($phys['dev_name'] != "" && $m2ua_link['link_name'] != "" && $mg_link['profile_name'] != "")
						$port_type = "M2UA";
					elseif ($phys['dev_name'] != "" && $mg_link['profile_name'] != "")
						$port_type = "MG";
					/*elseif ($phys['dev_name'] != "" && $r2_link['r2_profile'] != "")
						$port_type="ISDN";
					elseif ($phys['dev_name'] != "" && $pri_link['dev_name'] != "") 
						$port_type="ISDN";*/

					if ($port_type != "")
						break(2);					

				}
			}
		}
		return $port_type;
	}
	
	
	public function no_sig_link($data) {
		$protocol = $this->protocol_mix($data);


                require_once ('../display_class.php');
                $notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
                if ($protocol == "ISUP") {
                        //M2UA/MG disabled message
                        $notif->add("Protocol","An ISUP span has been detected. Configuring for M2UA Signalling Gateway or Media Gateway has been disabled.");
			$disabled_mg = 'disabled="disabled"';
                        $style_isup = 'black';
                        $style_mg='#3F5680';
                }
                if ($protocol == "M2UA" || $protocol == "MG" || $protocol == "M3UA") {
                        //ISUP Disabled Message
                        $notif->add("Protocol","A Media Gateway or M2UA Signalling Gateway span has been detected. Configuring for ISUP has been disabled.");
			$disabled_isup = 'disabled="disabled"';
                        $style_isup = '#3F5680';
                        $style_mg='black';
                }
                $notif->display();
                unset($notif);

	?>
        <br />
		<form name="term_type" method="post">
    	
            <table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Media Gateway Termination Type</th>
                <tr>
               	    <td class="mytablesubheader" width='30%'>Available Link types</td>
                    <td width='70%'><input type='radio' name='term_type' value='ss7_term' <?=$disabled_isup?> /><font color="<?=$style_isup?>">ISUP Termination</font></td>
                </tr>
                <tr>
                    <td class="mytablesubheader" width='30%'></td>
                    <td width='70%'><input type='radio' name='term_type' value='media_gw' <?=$disabled_mg?> /><font color="<?=$style_mg?>">Media Gateway</font></td>
                </tr>
                <tr>
               	    <td class="mytablesubheader" width='30%'><br /></td>
                    <td width='70%'><br /></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'></td>
                    <td width='70%'>
                    <input type='submit' name='link_type_back' value='Back' <?php echo $_SESSION['button_class']; ?> />
                    <input type='submit' name='select_term_type' value="Next" <?php echo $_SESSION['button_class']; ?> />
                    <input type='submit' name='cancel' value='Cancel' <?php echo $_SESSION['button_class']; ?> /></td>
                </tr>
            </table>
		</form>                      
        <?php
	}
	
}

?>
