<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Starts PHP Session
	session_start();
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_ss7_linkset_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$ss7_linkset = new create_ss7_linkset_profile;
	$ss7_linkset->data = $data;
	$db_location = "sqlite:../sqlite/cardinfo.db";
	$ss7_linkset->db_location = $db_location;
	
	//If statement that controls the HTML Title & gets the information out of the database if you are performing editing.
	if ($_SESSION['id_num'] == "") 
	{ 
		$title = $_SESSION['line_type'] . " Profile Creation"; 
	} 
	else 
	{ 
		$title = "Edit Profile"; 
		//echo "id = " . $_SESSION['id_num'] . "<br />";
		$id = $_SESSION['id_num'];
		
		//Pull the information out of the database and save it in the class variable "edit"
		$ss7_linkset->edit = $data->select_statement($db_location, "ss7_linkset_profile", "*", "id = $id");
		$ss7_linkset->profile = $ss7_linkset->edit['profile_name'];
		$ss7_linkset->apc = $ss7_linkset->edit['apc'];
		$ss7_linkset->minactive = $ss7_linkset->edit['minactive'];
	}	

	
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		//Runs the validation script
		$ss7_linkset->validation($data);
		
		//If there are no errors, place in the database
		if ($ss7_linkset->error_counter == 0 || $ss7_linkset->error_counter == "")
		{
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			$_SESSION['profile_num_linkset'] = $_REQUEST['id_number'];
			
			//If a new profile was created, set a session variable for the ss7 configuration wizard
			if ($_REQUEST['create'] == "Create Profile")
			{
				$_SESSION['new_linkset'] = "yes";
			}
			else
			{
				unset($_SESSION['new_linkset']);
			}
			
			//Check if it is a the profile is in the database
			if ($_SESSION['id_num'] != "")
			{
				$exist = $data->select_statement($db_location, "ss7_linkset_profile", "profile_name", "id = $id");
			}
			//echo $db_location . "<br />";
			$id = $data->select_statement($db_location, "ss7_linkset_profile", "id", "");
			
			$id[0]++;
			
			if ($exist['profile_name'] == "")
			{
				//Line doesn't exist, insert it
				$insert_param = "id, profile_name, apc, minactive";
				$insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['apc'] . "\", \"" . $_REQUEST['minactive'] . "\"";
				
				$data->insert_statement($db_location, "ss7_linkset_profile", $insert_param, $insert_values);
			}
			elseif ($exist['profile_name'] != "")
			{
				//Line exists, update it
				$update_param = "apc = \"" . $_REQUEST['apc'] . "\", minactive = \"" . $_REQUEST['minactive'] . "\"";

				$where_param = "id = " . $_SESSION['id_num'];
				
				$data->update_table($db_location, "ss7_linkset_profile", $update_param, $where_param);
			}
			
			//If this is your first run through with the ss7 configuration
			if ($_SESSION['skip_all'] == "yes")
			{
				$proc_id = $_SESSION['proc_id'];
				//echo "proc = " . $proc_id . "<br />";
				if ($proc_id == 1)
				{
					$db = "sqlite:../sqlite/cardinfo.db";	
				}
				elseif ($proc_id > 1)
				{
					$db = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";
				}
				
				//echo $db . "<br />";
				//Checks to see if the linkset is already found in the used table
				$card = $_SESSION['card_clicked'] . "-" . $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];
				$linkset_param = "card, name";
				$linkset_where_param = "card = \"" . $card . "\"";
				$linkset_found = $data->select_statement ($db, "used_linkset", $linkset_param, $linkset_where_param);	
				
				if ($linkset_found['card'] == $card)
				{
					//update the existing entry for the new profile name
					$linkset_update_where = "card = \"$card\"";
					$linkset_update_param = "name = \"" . $_REQUEST['profile_name'] . "\"";
					
					$data->update_table($db,"used_linkset", $linkset_update_param, $linkset_update_where);
					
				}
				elseif ($linkset_found['card'] == "")
				{
					//Entry was not found, insert it into the table
					$linkset_insert_param = "id, card, name";
					$linkset_insert_values = "$id[0], \"" . $card . "\" ,\"" . $_REQUEST['profile_name'] . "\"";
					$data->insert_statement($db, "used_linkset", $linkset_insert_param, $linkset_insert_values);
				}	
									
				//$_SESSION['profile_num_linkset']--;
				
				$port = $_SESSION['port_num_clicked'];
	
				$update_where = "port_id = $port";	
				$insert_param = "linkset";
				$update_param = "linkset = \"" . $_REQUEST['profile_name'] . "\"";
				$insert_values = "\"" . $_REQUEST['profile_name'] . "\"";													
			
				//Checks to see if the line exists
				$sig_param = "port_id = $port";
				
				$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
				$param = "port_id";
	
				$sig_info = $data->select_statement ($db, $table_name, $param, $sig_param);						
				
				if ($sig_info['port_id'] != "")
				{
					//Port ID found, please update that port
					$data->update_table($db,$table_name, $update_param, $update_where);
				}
				if ($sig_info['port_id'] == "")
				{
					//echo "I am here <br />";
					//Insert the line
					$data->insert_statement($db, $table_name, $insert_param, $insert_values);
				}
								
				header( 'Location:create_ss7_route.php#top' ) ;
			}
			else
			{
				if ($_REQUEST['create'] == "Create Profile")
				{
					$_SESSION['new_linkset'] = "yes";
				}
				//Redirects to viewing all profiles page
				header( 'Location:view_ss7_linkset.php#top' ) ;			
			}			
		}
		else
		{
			$ss7_linkset->profile = $_REQUEST['profile_name'];
			$ss7_linkset->apc = $_REQUEST['apc'];
			$ss7_linkset->minactive = $_REQUEST['minactive'];			
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		unset($_SESSION['new_linkset']);
		
		//$_SESSION['profile_num_linkset'] = $_SESSION['profile_num_linkset'] - 2;
		
		if ($_SESSION['skip_all'] == "yes")
		{
			unset($_SESSION['skip_all']);
			header( 'Location:../wanrouterhwprobe.php#top' );				

		}
		else
		{
			//Redirects to viewing all profiles page
			header( 'Location:view_ss7_linkset.php#top' ) ;			
		}
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		if ($_SESSION['id_num'] == "") 
		{ 
			$title = "SS7 Linkset Profile Creation";		
		} 
		else 
		{ 
			$title = "SS7 Linkset Profile - Edit"; 
		} 	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css","");		
	}	
	
	//Displays the linkset creation page
	$ss7_linkset->display();	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}	
?>