<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_ss7_isup_profile
{
	
	private $error= "";				//Contains validation errors
	public $error_counter="";		//Contains the number of errors in the form
	public $edit="";				//Contains database returned values for editing
	public $profile_name = array();	//Contains the profile names within the database
	public $profile_counter = "";	//Contains the number of profiles in the database
	private $pick="";				//Contains the data for what was returned to the form
	public $ssf="";					//Contains the value of SSF
	public $spc;					//Contains the value of spc
	private $db_location="";		//Contains the database location
	private $table_name="";			//Contains the database table name
	public $profile="";				//Contains the profile name
	public $t6="";					//Contains the T.6 timer value
	public $t9="";					//Contains the T.9 timer value
	public $data;
	
	//Display function
	function display()
	{
		$this->db_location = "sqlite:../sqlite/cardinfo.db";

		if ($_SESSION['id_num'] == "") 
		{ 
			echo "<h3>SS7 ISUP Interface Creation</h3>";		
		} 
		else 
		{ 
			echo "<h3>SS7 ISUP Interface - Edit</h3>"; 
		} 
		
		$this->check_submit();
		
		$this->table_name = "ss7_route_profile";
		$this->get_profiles();
		
		?>
	<p>
    	The fourth step of the SS7 configuration is the creation of an ISUP Interface.<br />
        ISUP Stands for Integrated Services Digital Network User Part.<br /> 
        An ISUP Interface is used mainly for Call Control. It is used to manage voice and data calls over the PSTN (Public Switched Telephone Network).<br />
        An ISUP Interface can only use 1 SS7 Route for call control.
    </p>
	<form name="create_profile" method="post">
    	<input type="hidden" name="id_number" value="<?php echo $a; ?>" />
		<br />   		   
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">ISUP Interface Options</th>
			<tr>
				<td class="mytablesubheader" width='30%'>Profile Name</td>
				<?php
				if ($this->edit['profile_name'] == "") {
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" /></td>
                <?php
				}
				else
				{
				?>
				<td width='40%'><input type="text" name="profile_name" value="<?=$this->pick['profile_name']?>" style="text-align:left; width:150px" disabled="disabled" /></td>
                <?php
				}
				?>
				<td width='30%'><?php echo $this->error['profile_name']; ?></td>
			</tr>  
            
            <?php
				//Grab all the self point codes from the license file
				require_once ('../display_class.php');
				$disp = new Display_common;
				
				$file = $_SESSION['smg_root_path'] . '/conf/license.txt';
				$array = $disp->open_file($file);
				
				for ($a = 0; $a < count($array); $a++)
				{
					if (preg_match('/SPC/',$array[$a]))
					{
						$pos = strpos($array[$a],' ');
						$spc_temp = substr($array[$a],$pos);
						$spc = trim($spc_temp," ");
						//echo $spc . "<br />";
						$appliance = true;
						if ($spc != "ANY") {
							$appliance = false;
							if (strpos($spc,','))
							{
								$token = $disp->token_generic($spc);
							}
							else
							{
								$token[0] = $spc;
							}
						}
					}
				}
				$prod=NULL;	

            ?>      
            <tr>
            	<td class="mytablesubheader" width='30%'>Self Point Code</td>
                <td width='40%'>
            <?php
				if (!$appliance) {
					echo "<select name=\"spc\">";
				
					for ($l = 0; $l < count($token); $l++)
					{ 
						$hash = "spc-" . $token[$l];
						echo "<option value=\"" . $token[$l] . "\""; 
						if ($this->pick[$hash] == "yes") { 
							echo "selected=\"selected\""; 
						} 
						echo " style=\"text-align:left\" style=\"text-align:left\">" . $token[$l] . "</option>\n";
					}
					echo "</select>";
				}
				else
				{
					echo "<input type=\"text\" name=\"spc\" value=\"" .  $this->spc . "\" style=\"text-align:left; width:40px\" />";
				}
				
			?>
                
                </td>
                <td width='30%'><?php echo $this->error['spc']; ?></td>
            </tr>  
            <tr>
              	<td class="mytablesubheader" width='30%'>Sub-Service Field (SSF)</td>
                <td width='40%'>
                   	<select name="ssf">
            	       	<option value="nat" <?php if ($this->pick['ssf_nat'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">National</option>
                        <option value="int" <?php if ($this->pick['ssf_int'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">International</option>
                        <option value="spare" <?php if ($this->pick['ssf_spare'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Spare</option>
                        <option value="res" <?php if ($this->pick['ssf_res'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:left">Reserved</option>
                    </select>
               </td>
               <td width='30%'><font color="red"><?php echo $this->error['ssf']; ?></font></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>Route</td>
                <td width='40%'>
					<select name="route">
				<?php
				for ($a = 0; $a < $this->profile_counter; $a++)
				{ 
						$hash = "route-" . $this->profile_name[$a]['profile_name'];
						echo "<option value=\"" . $this->profile_name[$a]['profile_name'] . "\""; if ($this->pick[$hash] == "yes") { ?> selected="selected" <?php } echo " style=\"text-align:left\" >" . $this->profile_name[$a]['profile_name'] . "</option>\n";
				}
				?>
				   </select>
                </td>
                <td width='30%'></td>
            </tr>                       
       </table>
		<br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Advanced ISUP Interface Options</th>
            <tr>
            	<td class="mytablesubheader" width='30%'>T.6 Timer (in seconds)</td>
                <td><a href="http://wiki.sangoma.com/nsg-isup-timers" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'><input type="text" name="t6" value="<?php echo $this->t6; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['t6']; ?></td>
            </tr>
            <tr>
            	<td class="mytablesubheader" width='30%'>T.9 Timer (in seconds)</td>
                <td><a href="http://wiki.sangoma.com/nsg-isup-timers" target="_blank"><font color="blue"><b>?</b></font></a></td>
                <td width='40%'><input type="text" name="t9" value="<?php echo $this->t9; ?>" style="text-align:left; width:40px" /></td>
                <td width='30%'><?php echo $this->error['t9']; ?></td>
            </tr>
       </table>
		<br />
		<table width="100%">
        <tr>
		<td width="10%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>         
	<?php
	}	
	
	//Validates the Form
	function validation($data)
	{
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		$db = "sqlite:../sqlite/cardinfo.db";
		
		if ($_SESSION['id_num'] == 0 && $_REQUEST['create'] != "Save Profile")
		{	
			$this->table_name = "ss7_route_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
			
			$this->table_name = "ss7_linkset_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}	
			}
			
			$this->table_name = "ss7_isup_profile";
			$table = $data->check_for_table($db,$this->table_name);
			if ($table > 1)
			{
				$this->get_profiles();
				
				for ($z = 0; $z <= $this->profile_counter; $z++)
				{
					if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
					{
						$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
						$this->error_counter++;
					}
				}							
			}
		}
		
		require_once ('../display_class.php');
		$disp = new Display_common;
		
		$file = $_SESSION['smg_root_path'] . '/conf/license.txt';
		$array = $disp->open_file($file);
		
		for ($a = 0; $a < count($array); $a++)
		{
			if (preg_match('/SPC/',$array[$a]))
			{
				$pos = strpos($array[$a],' ');
				$spc_temp = substr($array[$a],$pos);
				$spc = trim($spc_temp," ");
				//echo $spc . "<br />";
				if (strpos($spc,','))
				{
					$token = $disp->token_generic($spc);
				}
			}
		}
		$prod=NULL;
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "" && $_REQUEST['create'] != "Save Profile")
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}		
		
		if ($_REQUEST['spc'] == "")
		{
			$this->error['spc'] = "<font color=\"red\">Please Enter a <b>Self Point Code</b></font>";
			$this->error_counter++;
		}
		elseif (!is_numeric($_REQUEST['spc']))
		{
			$this->error['spc'] = "<font color=\"red\">Please Enter a <b>NUMERIC</b> value for the <b>Self Point Code</b></font>";
			$this->error_counter++;
		}
		
		//T.6 Timer validation
		if (!is_numeric($_REQUEST['t6']))
		{
			$this->error['t6'] = "<font color='red'>Please Enter a <b>NUMERIC</b> value for the <b>T.6 timer</b></font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['t6'] < 60 || $_REQUEST['t6'] > 120)
		{
			$this->error['t6'] = "<font color='red'>The <b>T.6 timer</b> must be between 60 and 120 seconds</font>";
			$this->error_counter++;
		}
		
		//T.9 timer validation
		if (!is_numeric($_REQUEST['t9']))
		{
			$this->error['t9'] = "<font color='red'>Please Enter a <b>NUMERIC</b> value for the <b>T.9 timer</b></font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['t9'] < 90 || $_REQUEST['t9'] > 180)
		{
			$this->error['t9'] = "<font color='red'>The <b>T.9 timer</b> must be between 90 and 180 seconds</font>";
			$this->error_counter++;
		}

	}	
	
	
	//Retrieves all the SS7 route/linkset Profile Names
	function get_profiles()
	{
		$a = 0;
		$this->db_location = "sqlite:../sqlite/cardinfo.db";
		
		$select = "SELECT profile_name FROM " . $this->table_name . ";";

		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	

	//Function to return the proper values when entering the page
	function check_submit()
	{
		if ($_REQUEST['ssf'] == "nat")
			$this->pick['ssf_nat'] = "yes";
		elseif ($_REQUEST['ssf'] == "int")
			$this->pick['ssf_int'] = "yes";
		elseif ($_REQUEST['ssf'] == "spare")
			$this->pick['ssf_spare'] = "yes";
		elseif ($_REQUEST['ssf'] == "res")
			$this->pick['ssf_res'] = "yes";
		elseif ($this->edit['ssf'] == "nat")
			$this->pick['ssf_nat'] = "yes";
		elseif ($this->edit['ssf'] == "int")
			$this->pick['ssf_int'] = "yes";
		elseif ($this->edit['ssf'] == "spare")
			$this->pick['ssf_spare'] = "yes";
		elseif ($this->edit['ssf'] == "res")
			$this->pick['ssf_res'] = "yes";

		if ($_REQUEST['t6'] == "" && $this->edit['t6'] == "")
			$this->t6 = 60;
		
		if ($_REQUEST['t9'] == "" && $this->edit['t9'] == "")
			$this->t9 = 180;
		
		if ($_REQUEST['profile_name'] != "")
			$this->pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->pick['profile_name'] = $this->edit['profile_name'];
		else {
			$table = 'ss7_isup_profile';
			$id = $this->data->select_statement_order_by($this->db_location,$table,'id','','id','-1');
			$a = $id['id'] + 1;			
			$this->pick['profile_name'] = "ISUP" . $a;
		}



		//Populate the Dropdown with only what is inside the license file
		require_once ('../display_class.php');
		$disp = new Display_common;
		
		$file = $_SESSION['smg_root_path'] . '/conf/license.txt';
		$array = $disp->open_file($file);
		
		for ($a = 0; $a < count($array); $a++)
		{
			if (preg_match('/SPC/',$array[$a]))
			{
				$pos = strpos($array[$a],' ');
				$spc_temp = substr($array[$a],$pos);
				$spc = trim($spc_temp," ");
				//echo $spc . "<br />";
				if (strpos($spc,','))
				{
					$token = $disp->token_generic($spc);
				}
			}
		}
		$prod=NULL;	
			
		for ($a = 0; $a < count($token); $a++)
		{
			$hash = "spc-" . $token[$a];
			//echo $_REQUEST['route'] . " AND " . $this->profile_name[$a]['profile_name'] . "<br />";
			//echo "hash = $hash<br />";
			
			if ($_REQUEST['spc'] == $token[$a])
			{
				$this->pick[$hash] = "yes";
			}
			elseif ($this->edit['spc'] == $token[$a])
			{
				$this->pick[$hash] = "yes";
			}
			
			//echo "pick = " . $this->pick[$hash]  ."<br />";
		}



		$this->table_name = "ss7_route_profile";
		$this->get_profiles();

		for ($a = 0; $a < $this->profile_counter; $a++)
		{
			$hash = "route-" . $this->profile_name[$a]['profile_name'];
			//echo $_REQUEST['route'] . " AND " . $this->profile_name[$a]['profile_name'] . "<br />";
			//echo "hash = $hash<br />";
			
			if ($_REQUEST['route'] == $this->profile_name[$a]['profile_name'])
			{
				$this->pick[$hash] = "yes";
			}
			elseif ($this->edit['route'] == $this->profile_name[$a]['profile_name'])
			{
				$this->pick[$hash] = "yes";
			}
			
			//echo "pick = " . $this->pick[$hash]  ."<br />";
		}
	}
}