<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

//echo $_SESSION['cic'];

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_ss7_ccspans_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$ss7_ccspans = new create_ss7_ccspans;
	$ss7_ccspans->data = $data;
	$ss7_ccspans->proc_id = $_SESSION['proc_id'];
	$update=false;
		
	if ($ss7_ccspans->proc_id == 1)
		$db_location = "sqlite:../sqlite/cardinfo.db";
	elseif ($ss7_ccspans->proc_id > 1)
		$db_location = "sqlite:../sqlite/cardinfo" . $ss7_ccspans->proc_id . ".db";
	
	//echo $ss7_ccspans->proc_id . "<br />";	
		
	//$db_location = "sqlite:../sqlite/cardinfo.db";
	$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_ccspans";
	$table_exist = $data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay");
	if ($table_exist > 1)
	{
		$relay = $data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","relay_type","id = 1");
		$ss7_ccspans->relay_type = $relay['relay_type'];
	}
	
	$ss7_ccspans->card_num = $_SESSION['card_num'];
	$ss7_ccspans->get_link_info();
	
	//Check the database. If the database exists, use that information to display
	$table_exists = $data->check_for_table ($db_location, $table_name);

	if ($table_exists > 1)
	{
		//Check if the table needs to be upgraded
		/*$parameters = "port_id int primary key, profile_name varchar(60), isup varchar(30), cic varchar(30), channels varchar(30), min_digits int, clg_nadi int, cld_nadi int, rdnis_nadi int, obci_bita int, typeCntrl varchar(30), group_num int, lpa int, transparent_iam varchar(30), itx varchar(30), transparent_iam_timeout int, cpg_on_progress varchar(30), cpg_on_progress_media varchar(30), t10 int, t35 int";
		$old_insert_parameters = "port_id, profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media";
		$data->check_schema($db_location, $table_name, $parameters, "20", $old_insert_parameters);		*/	
	
	
		$param = "port_id, profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media,t10,t35";
		$where_param = "port_id = " . $_SESSION['port_num_clicked'];
		
		//Grab the information for that port
		$ss7_ccspans->edit = $data->select_statement ($db_location, $table_name, $param, $where_param);
		$update=true;
		$ss7_ccspans->profile = $ss7_ccspans->edit['profile_name'];
		$ss7_ccspans->cic = $ss7_ccspans->edit['cic'];
		$ss7_ccspans->isup = $ss7_ccspans->edit['isup'];
		$ss7_ccspans->channels = $ss7_ccspans->edit['channels'];
		$ss7_ccspans->min_digits = $ss7_ccspans->edit['min_digits'];
		$ss7_ccspans->clg_nadi = $ss7_ccspans->edit['clg_nadi'];
		$ss7_ccspans->cld_nadi = $ss7_ccspans->edit['cld_nadi'];
		$ss7_ccspans->rdnis_nadi = $ss7_ccspans->edit['rdnis_nadi'];
		$ss7_ccspans->obci_bita = $ss7_ccspans->edit['obci_bita'];
		$ss7_ccspans->typeCntrl = $ss7_ccspans->edit['typeCntrl'];
		$ss7_ccspans->group_num = $ss7_ccspans->edit['group_num'];
		$ss7_ccspans->lpa = $ss7_ccspans->edit['lpa'];
		$ss7_ccspans->itx = $ss7_ccspans->edit['itx'];
		$ss7_ccspans->transparent_iam = $ss7_ccspans->edit['transparent_iam'];	
		$ss7_ccspans->transparent_iam_timeout = $ss7_ccspans->edit['transparent_iam_timeout'];
		$ss7_ccspans->cpg_on_progress = $ss7_ccspans->edit['cpg_on_progress'];
		$ss7_ccspans->cpg_on_progress_media = $ss7_ccspans->edit['cpg_on_progress_media'];	
		$ss7_ccspans->t10 = $ss7_ccspans->edit['t10'];
		$ss7_ccspans->t35 = $ss7_ccspans->edit['t35'];
	}

	if ($ss7_ccspans->channels == "")
		$ss7_ccspans->channel_map_create();

	//CiC Information
	if ($ss7_ccspans->cic != "")
		$_SESSION['cic'] = $ss7_ccspans->cic;
	elseif ($_SESSION['cic'] == "")
		$ss7_ccspans->cic = 1;
	elseif ($_SESSION['cic'] >= 1)
	{
		if ($ss7_ccspans->media == "T1")
			$ss7_ccspans->cic = $_SESSION['cic'] + 24;
		elseif ($ss7_ccspans->media == "E1")
			$ss7_ccspans->cic = $_SESSION['cic'] + 32;
	}	

	if ($_REQUEST['create'] == "Create Channel Map" || $_REQUEST['create-all-voice'] == "Set all Unconfigured ports as Voice Spans")
	{
		$ss7_ccspans->cic = $_REQUEST['cic'];
		$ss7_ccspans->isup = $_REQUEST['isup'];
		$ss7_ccspans->channels = $_REQUEST['channels'];
		$ss7_ccspans->min_digits = $_REQUEST['min_digits'];
		$ss7_ccspans->clg_nadi = $_REQUEST['clg_nadi'];
		$ss7_ccspans->cld_nadi = $_REQUEST['cld_nadi'];
		$ss7_ccspans->rdnis_nadi = $_REQUEST['rdnis_nadi'];
		$ss7_ccspans->obci_bita = $_REQUEST['obci_bita'];
		$ss7_ccspans->typeCntrl = $_REQUEST['typeCntrl'];	
		$ss7_ccspans->group_num = $_REQUEST['group_num'];
		$ss7_ccspans->lpa = $_REQUEST['lpa'];
		$ss7_ccspans->itx = $_REQUEST['itx'];
		$ss7_ccspans->transparent_iam = $_REQUEST['transparent_iam'];	
		$ss7_ccspans->transparent_iam_timeout = $_REQUEST['transparent_iam_timeout'];
		$ss7_ccspans->cpg_on_progress = $_REQUEST['cpg_on_progress'];
		$ss7_ccspans->cpg_on_progress_media = $_REQUEST['cpg_on_progress_media'];	
		$ss7_ccspans->t10 = $_REQUEST['t10'];
		$ss7_ccspans->t35 = $_REQUEST['t35'];				
			
			
		//echo $_REQUEST['cpg_on_progress'];
		//echo 	$_REQUEST['cpg_on_progress_media'];		
			
		//Runs the validation script
		$ss7_ccspans->validation($update);
		
		//If there are no errors, place in the database
		if ($ss7_ccspans->error_counter == 0)
		{
			//Increment the counters
			$_SESSION['cic'] = $_REQUEST['cic'];
			$_SESSION['profile_num_ccspan'] = $_REQUEST['id_number'];			
			
			//Add the ISUP interface to the used_isup table so that no one will accidentally delete the entry
			$card = $_SESSION['card_clicked'] . "-" . $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];
			$isup_param = "card, name";
			$isup_where_param = "card = \"" . $card . "\"";
			$isup_found = $data->select_statement ($db_location, "used_isup", $isup_param, $isup_where_param);	
			
			if ($isup_found['card'] == $card)
			{
				//update the existing entry for the new profile name
				$isup_update_where = "card = \"$card\"";
				$isup_update_param = "name = \"" . $_REQUEST['isup'] . "\"";
				$data->update_table($db_location,"used_isup", $isup_update_param, $isup_update_where);
			}
			elseif ($isup_found['card'] == "")
			{
				//Entry was not found, insert it into the table
				$isup_insert_param = "id, card, name";
				$isup_insert_values = $_SESSION['port_num_clicked'] . ", \"" . $card . "\" ,\"" . $_REQUEST['isup'] . "\"";
				$data->insert_statement($db_location, "used_isup", $isup_insert_param, $isup_insert_values);
			}				
			
			//Single Port Configuration
			if ($_REQUEST['create'] == "Create Channel Map")
			{
				//Check if the table needs to be created		
				if ($table_exists < 2)
				{
		
					$param = "port_id int primary key, profile_name varchar(60), isup varchar(30), cic varchar(30), channels varchar(30), min_digits int, clg_nadi int, cld_nadi int, rdnis_nadi int, obci_bita int, typeCntrl varchar(30), group_num int, lpa int, transparent_iam varchar(30), itx varchar(30), transparent_iam_timeout int, cpg_on_progress varchar(30), cpg_on_progress_media varchar(30), t10 int, t35 int";
					$data->create_table($db_location, $table_name, $param);
	
					//Line doesn't exist, insert it
					$insert_param = "port_id, profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media, t10, t35";
					$insert_values = $_SESSION['port_num_clicked'] . ", \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['isup'] . "\", \"" . $_REQUEST['cic'] . "\", \"" . $_REQUEST['channels'] . "\", \"" . $_REQUEST['min_digits'] . "\", \"" . $_REQUEST['clg_nadi'] . "\", \"" . $_REQUEST['cld_nadi'] . "\", \"" . $_REQUEST['rdnis_nadi'] . "\", \"" . $_REQUEST['obci_bita'] . "\", \"" . $_REQUEST['typeCntrl'] . "\", \"" . $_REQUEST['group_num'] . "\", \"" . $_REQUEST['lpa'] . "\", \"" . $_REQUEST['transparent_iam'] . "\", \"" . $_REQUEST['itx'] . "\", \"" . $_REQUEST['transparent_iam_timeout'] . "\", \"" . $_REQUEST['cpg_on_progress'] . "\", \"" . $_REQUEST['cpg_on_progress_media'] . "\", " . $_REQUEST['t10'] . ", " . $_REQUEST['t35'];
				
					$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);				
				}
				elseif ($table_exists > 1)
				{
					//Check if the line exists
					$param = "port_id";
					$where_param = "port_id = " . $_SESSION['port_num_clicked'];
					$result = $data->select_statement ($db_location, $table_name, $param, $where_param);
					
					if ($result['port_id'] != "")
					{
						//Line exists, update it
						$update_param = "cic = \"" . $_REQUEST['cic'] . "\", isup = \"" . $_REQUEST['isup'] . "\", channels = \"" . $_REQUEST['channels'] . "\", min_digits = \"" . $_REQUEST['min_digits'] . "\", clg_nadi = \"" . $_REQUEST['clg_nadi'] . "\", cld_nadi = \"" . $_REQUEST['cld_nadi'] . "\", rdnis_nadi = \"" . $_REQUEST['rdnis_nadi'] . "\", obci_bita = \"" . $_REQUEST['obci_bita'] . "\", typeCntrl = \"" . $_REQUEST['typeCntrl'] . "\", group_num = \"" . $_REQUEST['group_num'] . "\", lpa = \"" . $_REQUEST['lpa'] . "\", itx = \"" . $_REQUEST['itx'] . "\", transparent_iam = \"" . $_REQUEST['transparent_iam'] . "\", transparent_iam_timeout = \"" . $_REQUEST['transparent_iam_timeout'] . "\", cpg_on_progress = \"" . $_REQUEST['cpg_on_progress'] . "\", cpg_on_progress_media = \"" . $_REQUEST['cpg_on_progress_media'] . "\", t10 = " . $_REQUEST['t10'] . ", t35 = " . $_REQUEST['t35'];
	
						$where_param = "port_id = " . $_SESSION['port_num_clicked'];
					
						$data->update_table($db_location, $table_name, $update_param, $where_param);
					}
					elseif ($result['port_id'] == "")
					{
						//Line doesn't exist, insert it
						$insert_param = "port_id, profile_name, isup, cic, channels, min_digits, clg_nadi, cld_nadi, rdnis_nadi, obci_bita, typeCntrl, group_num, lpa, transparent_iam, itx, transparent_iam_timeout, cpg_on_progress, cpg_on_progress_media, t10, t35";
						$insert_values = $_SESSION['port_num_clicked'] . ", \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['isup'] . "\", \"" . $_REQUEST['cic'] . "\", \"" . $_REQUEST['channels'] . "\", \"" . $_REQUEST['min_digits'] . "\", \"" . $_REQUEST['clg_nadi'] . "\", \"" . $_REQUEST['cld_nadi'] . "\", \"" . $_REQUEST['rdnis_nadi'] . "\", \"" . $_REQUEST['obci_bita'] . "\", \"" . $_REQUEST['typeCntrl'] . "\", \"" . $_REQUEST['group_num'] . "\", \"" . $_REQUEST['lpa'] . "\", \"" . $_REQUEST['transparent_iam'] . "\", \"" . $_REQUEST['itx'] . "\", \"" . $_REQUEST['transparent_iam_timeout'] . "\", \"" . $_REQUEST['cpg_on_progress'] . "\", \"" . $_REQUEST['cpg_on_progress_media'] . "\", " . $_REQUEST['t10'] . ", " . $_REQUEST['t35'];
					
						$data->insert_statement($db_location, $table_name, $insert_param, $insert_values);
					}
				}
			}
			elseif ($_REQUEST['create-all-voice'] == "Set all Unconfigured ports as Voice Spans")
			{
				//Find out which ports on a card are not configured or configured as voice ports. Set them up as voice only with ccspans filled.
				
				//Find out the number of ports on card
				$ss7_ccspans->find_total_ports($data);
				$_SESSION['new_ss7_span'] = $_SESSION['ss7_span'];
				$ss7_ccspans->first_port = "yes";
				
				//Check if the table needs to be created		
				if ($table_exists < 2)
				{
		
					$param = "port_id int primary key, profile_name varchar(60), isup varchar(30), cic varchar(30), channels varchar(30), min_digits int, clg_nadi int, cld_nadi int, rdnis_nadi int, obci_bita int, typeCntrl varchar(30), group_num int, lpa int, transparent_iam varchar(30), itx varchar(30), transparent_iam_timeout int, cpg_on_progress varchar(30), cpg_on_progress_media varchar(30), t10 int, t35 int";
					$data->create_table($db_location, $table_name, $param);
				}
			
				//echo "Number of ports = " . $ss7_ccspans->num_ports . "<br />";
			
				//Find out which ports are configured, and if configured, which ports are voice links
				for ($a = 1; $a <= $ss7_ccspans->num_ports; $a++)
				{
					//Figure out the span number
					//echo "port = $a <br />";
					$span = $ss7_ccspans->span_calc($a);
					
					//echo "on port $a, port number clicked on = " . $_SESSION['port_num_clicked'] . ", session span = " . $_SESSION['new_ss7_span'] . ",  span number = " . $span . "<br />";
					$no_mg_link = true;
					
					//Check if the link is being used for m2ua of mg
					$mg_chan = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_channels";
					$m2ua = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_m2ua_link";
					
					//echo "channels table = $mg_chan<br />";
					//echo "link table = $m2ua<br />";
					
					if ($data->check_for_table($db_location,$m2ua) > 1) {
						$where = 'port_id = ' . $a;
						$m2ua_link = $data->select_statement($db_location,$m2ua,'link_name',$where);
						
						if ($m2ua_link['link_name'] != "")
							$no_mg_link = false;
					}
					
					if ($data->check_for_table($db_location,$mg_chan) > 1) {
						$where = 'port_id = ' . $a;
						$chans = $data->select_statement($db_location,$mg_chan, 'profile_name',$where);

						if ($chans['profile_name'] != "")
							$no_mg_link = false; 						
					}
					
					/*echo "Chans<br />";
					print_r ($chans);
					echo "Link<br />";
					print_r ($m2ua_link);*/
										
					if ($no_mg_link) {
						//Check if physical Layer has been configured for the card
						$physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
						$where_param = "port_id = " . $a;
						$result = $data->select_statement ($db_location, $physical, "port_id", $where_param);
						
						//Configure Port with the exact same values as the port being used
						if ($result['port_id'] == "")
						{
							$where = "port_id = " . $_SESSION['port_num_clicked'];
							$current = $data->select_statement($db_location,$physical,"*",$where);
							
							$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, dtmf_removal, pre_buffer_size";	
							$insert_value = $a . ", \"" . $current['dev_name'] . "\", \"" . $current['line_type'] . "\", \"" .$current['coding'] . "\", \"" . $current['framing'] . "\", \"" . $current['clock'] . "\",\"" . $current['ref_clock'] . "\", \"" .$current['echo']. "\", \"" . $current['dtmf'] . "\", \"" . $current['fax'] . "\", \"" . $current['lbo'] . "\", \"" . $current['txtristate'] . "\", \"" . $current['sigmode'] . "\", \"" . $current['impedence'] . "\", \"" . $current['rx_level'] . "\", \"" . $current['rxgain'] . "\", \"" . $current['txgain'] . "\", \"" . $current['dtmf_removal'] . "\", \"" . $current['pre_buffer_size'] . "\"";	
							
							$data->insert_statement($db_location, $physical, $insert_parameters, $insert_value);	
						}
											
						//Check if link configured
						$ss7linktable = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
						$where_param = "port_id = " . $a;
						$result = $data->select_statement ($db_location, $ss7linktable, "port_id", $where_param);
						
						//echo $result['port_id'] . "<br />";
						if ($result['port_id'] != "")
						{
							//Configuring the clicked port
							//Only fill in the voice link information	
							$ss7_ccspans->database_insert($data, $a, $span);											
						}
						elseif ($result['port_id'] == "")
						{
							//Unconfigured Port
							//Fill in Link information into SS7_Link table
							$parameters = "port_id, link_name, span, line_type, voice";
							$values = $a . ", \"VL" . $span . "\", " . $span . ", \"" . $ss7_ccspans->media . "\", \"yes\"";		
							$data->insert_statement($db_location, $ss7linktable, $parameters, $values);	
							
							//Insert values in the database
							$ss7_ccspans->database_insert($data, $a, $span);
						}
					}
				}
			}

			//Redirects to viewing all profiles page
			header( 'Location:../wanrouterhwprobe.php' ) ;			
		}
		else
		{
			$ss7_ccspans->profile = $_REQUEST['profile_name'];
			$ss7_ccspans->cic = $_REQUEST['cic'];
			$ss7_ccspans->isup = $_REQUEST['isup'];
			$ss7_ccspans->channels = $_REQUEST['channels'];	
			$ss7_ccspans->min_digits = $_REQUEST['min_digits'];
			$ss7_ccspans->clg_nadi = $_REQUEST['clg_nadi'];
			$ss7_ccspans->cld_nadi = $_REQUEST['cld_nadi'];
			$ss7_ccspans->rdnis_nadi = $_REQUEST['rdnis_nadi'];
			$ss7_ccspans->obci_bita = $_REQUEST['obci_bita'];
			$ss7_ccspans->typeCntrl = $_REQUEST['typeCntrl'];
			$ss7_ccspans->lpa = $_REQUEST['lpa'];
			$ss7_ccspans->itx = $_REQUEST['itx'];
			$ss7_ccspans->transparent_iam = $_REQUEST['transparent_iam'];	
			$ss7_ccspans->transparent_iam_timeout = $_REQUEST['transparent_iam_timeout'];
			$ss7_ccspans->cpg_on_progress = $_REQUEST['cpg_on_progress'];
			$ss7_ccspans->cpg_on_progress_media = $_REQUEST['cpg_on_progress_media'];	
			$ss7_ccspans->t10 = $_REQUEST['t10'];
			$ss7_ccspans->t35 = $_REQUEST['t35'];	
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		$_SESSION['id_num'] = "";
		
		//$_SESSION['profile_num_isup'] = $_SESSION['profile_num_isup'] - 2;

		//Redirects to viewing all profiles page
		header( 'Location:../wanrouterhwprobe.php' ) ;		
		
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("SS7 Channel Configuration", "../../../style.css","");		
	}	
	
	$ss7_ccspans->display();	

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>