<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();

//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include '../check_referer.php';


$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		//include '../sqlite/database_creation.php';
		include '../database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Help", "../../../style.css","");		
	}	
	//echo $_SERVER['PHP_SELF'];
	?>
	<h2><?php echo $_SESSION['name']; ?> Help</h2>
	<p>This page will guide you on how to initially setup and configure your Sangoma Hardware, and to start <?php echo $_SESSION['name']; ?>.<br />
    The menu on the left hand side of the browser is how you would have to navigate throught the various areas of the <?php echo $_SESSION['name']; ?> Web interface.<br />
    The <?php echo $_SESSION['name']; ?> Web interface contains 
    <?php
    if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
        echo 5;
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		echo 4;
	}
	?>
    main areas:
    <ul>
    	<li><a href="#dashboard">Dashboard</a></li>
    	<li><a href="#configuration">Configuration</a></li>
        <li><a href="#Operation">Operation</a></li>
        <li><a href="#help">Help</a></li>
        <?php
        if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
        	echo "<li><a href=\"#Administration\">Administration</a></li>";
        }    
		?>
    </ul>
    For Initial Setup instructions, <a href="#setup">Click Here</a><br /></p>
    <br />
    <hr />
    <h4 id="dashboard">Dashboard</h4>
    <ol>
    	<li>
       		TDM Status<br />
            - Displays the status of each TDM interface<br />
            - Seperates each layer (Physical Layer, MTP-2, and MTP-3) and displays it's status (UP/DOWN)<br />
            - Displays each interface's channel status<br />
        </li>
    	<li>
        	SIP Status<br />
            - Displays all SIP related information present on the Gateway<br />
            - Displays information on all SIP endpoints currently registered with the gateway<br />
        </li>   
        <li>
        	Logs<br />
            - Displays the logs for the gateway, TDM driver and the media processing service<br />
            - Users can download the log information for troubleshooting purposes<br />
        </li>
    </ol>      
    <h4 id="configuration">Configuration</h4>
    <ol>
    	<li>
        	TDM<br />
            - Detects all Sangoma TDM hardware present in the system.<br />
            - Configures for SS7.<br />
            - Generates configuration required for <?php echo $_SESSION['name']; ?>'s Operation.<br />
        </li>
        <li>
        	Relay<br />
            - Configures <?php echo $_SESSION['name']; ?> in either standalone mode or relay mode<br />
            - Standalone mode is when only 1 system is being used for a SS7 Setup<br />
            - Relay mode is when more then 1 system are being used in a SS7 setup<br />
        </li>
        <li>
        	Media<br />
            - Configures media processing interfaces in order to change between different media codecs<br />
            - Allows the use of more then 1 media codec<br />
        </li>
		<li>
        	Global<br />
            - Displays <?php echo $_SESSION['name']; ?>'s global configuration file<br />
            - Allows the editing of the global configuration file<br />
        </li>
        <li>
        	Dialplan<br />
            - Displays <?php echo $_SESSION['name']; ?>'s dialplan<br />
            - Allows the editing of the dialplan<br />
        </li>
        <li>
        	File Editor<br />
            - Can open any file related to <?php echo $_SESSION['name']; ?><br />
            - Can be used to manually add/remove options from <?php echo $_SESSION['name']; ?> configuration files<br />
        </li>
        <?php
		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
		?>
        <li>
        	License<br />
            - Displays the license installed on the gateway<br />
        </li>
        <?php
		}
		?>        
    </ol>    
    <h4 id="Operation">Operation</h4>
    <ol>
    	<li>
        	Control Panel<br />
            - Used to control the Gateway<br />
            - Contains a visual representation of whether the Gateway and the Drivers are started/stopped<br />
            - When in relay mode and the system is configured for Master, it displays gateway information of the master and all the slaves configured<br />
        </li>
        <li>
        	Command Execution<br />
            - Gives the user the ability to run Linux Shell commands and <?php echo $_SESSION['name']; ?> commands directly from the <?php echo $_SESSION['name']; ?> Web Interface<br />
            - Provides example commands that can be run directly from the command execution page<br />
            - Can display a Shell Command and a <?php echo $_SESSION['name']; ?> Command simultaneously on the same page<br />
        </li>
        <li>
        	Self Test<br />
            - Runs a series of tests in order to determine the health of both TDM hardware and media processing hardware<br />
       	</li>
        <li>
        	Firmware Update
            - Displays the firmware versions of all hardware installed in the gateway<br />
            - Runs a firmware update on all hardware installed in the gateway<br />
        </li>
        <?php
		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
		?>
        <li>
        	Update<br />
            - Displays updates available for <?php echo $_SESSION['name']; ?>
        </li>
         <?php
		}
		?>
    </ol>
    </ol>
    <h4 id="help">Help</h4>
    <ol>
    	<li>
        	General<br />
            - Contains general help for this gateway
        </li>
        <li>
        	PBX Integration<br />
            - Displays how to configure your third party PBX in order for it to be able to communicate with <?php echo $_SESSION['name']; ?>
        </li>
        <?php
		if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
		?>
        <li>
        	About<br />
            - Contains <?php echo $_SESSION['name']; ?>'s version<br />
            - Each subproduct of the gateway is listed, as well as its version and GIT revision
        </li>
        <?php
		}
		?>
    </ol>
    <?php
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
	?>
    <h4 id="Administration">Administration</h4>
    <ol>
    	<li>
        	Menu Manager <br />
            - Manage the way the <?php echo $_SESSION['name']; ?> Web Interface menu looks<br />
            - SuperAdmin accounts can re-design the layout to their liking<br />
            - Limited to SuperUser accounts <b>ONLY</b>.
        </li>
    	<li>
        	User Manager<br />
            - Manage all the Users that can access the <?php echo $_SESSION['name']; ?> Web Interface<br />
            - Limited to Administrative Accounts <b>ONLY</b><br />
            - Admin accounts can create all levels of accounts other than SuperAdmin accounts<br />
            - Only SuperAdmin accounts can create SuperAdmin accounts<br />
        </li>
    </ol>
	<?php
	}
	?>
	<br />
    <hr />
   	<h4 id="setup">Initial Setup</h4>
    Follow the steps below in order to setup <?php echo $_SESSION['name']; ?> for the first time.
    
    <ol>
    	<li>Determine whether the gateway will be used for Relay.</li>
    	<li>Configure the TDM Devices using the TDM Configuration Link</li>
        <ul>
        	<li>This is where you will setup the physical spans and configure the grouping of each span</li>
            <li>Perform the steps below in order to generate TDM Configuration Files</li>
            <ol type="a">
            	<li>Detect Sangoma Hardware</li>
                <li>Configure each TDM Span for SS7</li>
                <li>Generate Configuration</li>
            </ol>
            <li><font color="red">NOTE: This step only generates configuration files. It does not start the Gateway</font></li>
        </ul>
        <li>Dialplan Configuration</li>
        <ul>
        	<li>Gateway Dialplan is already setup</li>
            <li>All incoming calls from the TDM interfaces will be passed to registered SIP endpoints</li>
            <li>All incoming calls from the SIP endpoints will be passed to the TDM spans based on the groups assigned during the TDM Configuration</li>
        </ul>
        <li>Use the PBX Integration in order to setup your third party PBX in order to communicate with <?php echo $_SESSION['name']; ?> via SIP</li>
        <ul>
        	<li>This page will explain how to setup Asterisk and FreeSWITCH for use with <?php echo $_SESSION['name']; ?></li>
        </ul>
        <li>Confirm the Gateway Operation</li>
        <ul>
        	<li>Use the Control Panel in order to start <?php echo $_SESSION['name']; ?></li>
       	</ul>
        <li>Check the Signalling Status</li>
        <ul>
        	<li>Go to the TDM Status page in order to confirm that all channels are up and ready to accept calls</li>
        </ul>
    </ol>

    <?php
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}