<?php
/*
	FusionPBX
	Version: MPL 1.1

	The contents of this file are subject to the Mozilla Public License Version
	1.1 (the "License"); you may not use this file except in compliance with
	the License. You may obtain a copy of the License at
	http://www.mozilla.org/MPL/

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.

	The Original Code is FusionPBX

	The Initial Developer of the Original Code is
	Mark J Crane <markjcrane@fusionpbx.com>
	Portions created by the Initial Developer are Copyright (C) 2008-2010
	the Initial Developer. All Rights Reserved.

	Contributor(s):
	Mark J Crane <markjcrane@fusionpbx.com>
	Shaunt Libarian <shaunt@sangoma.com>
*/
session_start();

include 'sangoma/display_class.php';
$display_common = new Display_common;
//Checks to make sure the user is logged into the WebUI
if ( $display_common->IsRenderingNonDynamicDiv( ) ) {
	if (empty($_POST))
		include 'sangoma/check_referer.php';
}

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include "root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
	header("Location: ".PROJECT_PATH."/install.php");
	exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
include "sangoma/database_classes.php";

	
// ************************************************************************************
// HEADER 
// ************************************************************************************
//print_r( $_SERVER );
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
	unset($_SESSION['embedded']);
	
	//FusionPBX Integration
	require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include 'sangoma/sqlite/database_creation.php';

	
	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:sangoma/sqlite/cardinfo.db");
	$display_common->html_header();
	$display_common->html_title("Overview", "../style.css","");		

}	

// Getting a POST request ?
if ( isset($_POST) && sizeof($_POST) )
{
  //This is set when all registrations need to be flushed.
  if ( isset($_POST['flush_all']) && $display_common->IsGatewayRunning() )
  {
    $nb_cli = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " -x "; 
    foreach ( GetProfileList($nb_cli) as $sipProfile )
    {
      $cmd = $nb_cli . "\"sofia profile ".$sipProfile." flush_inbound_reg\"";
      exec($cmd, $output);
      unset( $output );
    }
  }

  //This is set when a specific registration need to be flushed.
  if ( isset($_POST['flush_registration']) && $display_common->IsGatewayRunning() )
  {
    $nb_cli = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " -x "; 
    $cmd = $nb_cli . "\"sofia profile ".$_POST['profile']." flush_inbound_reg ".$_POST['user']."\"";
    exec($cmd, $output);
    unset( $output );
  }
}

?><div id='top' style='display:none;'></div><?php
// ************************************************************************************
// BODY 
// ************************************************************************************
// Enable dynamic Div 
$display_common->DynamicDivEnable();

// Auto refresh dynamic Div 
$display_common->DynamicDivAutoRefresh();

// ************************************************************************************
// Port status Dynamic Div
// ************************************************************************************
$display_common->DynamicDivBegin( "SipStatusDiv" );

if ($display_common->IsRenderingNonDynamicDiv() || $display_common->IsDynamicDivRefreshRequest('SipStatusDiv')) {

  if (!$display_common->IsGatewayRunning())
  {
    $display_common->WarningBox( $_SESSION['name'] . " not started\n" );
  }
  else
  {
    // Gateway is running, display status
    $cli = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " -x "; 

    // ************************************************************************************
    // Constants and defines 
    // ************************************************************************************
    define( "COLOR_OK" , 		"#8BB381"); // Kind of Dark Sea Green
    define( "COLOR_WARNING" , 	"#FBB117"); // Kind of orange
    define( "COLOR_ERROR" , 	"#E42217"); // Kind of Firebrick
    define( "COLOR_SIG" , 		"#151B54"); // Kind of Midnight Blue
    define( "COLOR_NA" , 		"#6D7B8D"); // Kind of Light Slate Gray 

    // SIP status mapping
    $SipStatusMap = array(
      'RUNNING (0)'		=> array( 'label' => "RUNNING",	'bkcolor' => COLOR_OK ),
      'DOWN'			=> array( 'label' => "D", 	'bkcolor' => COLOR_ERROR ),
    );

    function ResolveStatusLabel( $in_aStatusMap, $in_szStatus )
    {
      return ( isset( $in_aStatusMap[$in_szStatus] ) ) ? $in_aStatusMap[$in_szStatus]['label']:($in_szStatus);
    }
    function ResolveStatusBkColor( $in_aStatusMap, $in_szStatus )
    {
      return ( isset( $in_aStatusMap[$in_szStatus]['bkcolor'] ) ) ? $in_aStatusMap[$in_szStatus]['bkcolor']:COLOR_NA;
    }
    function ResolveStatusFontColor( $in_aStatusMap, $in_szStatus )
    {
      // For now just white
      return "white";
      //return ( isset( $in_aStatusMap[$in_szStatus]['bkcolor'] ) ) ? $in_aStatusMap[$in_szStatus]['bkcolor']:"#FFFFFF";
    }

    // ************************************************************************************
    // Display SIP  port table
    // ************************************************************************************
    echo "<br/>\n";
    echo "<table class='mytable' border='1' width='100%'>\n";
    echo "	<th class='widget-content-header ui-state-active ui-corner-top' colspan='7' align='left'>\n";
    echo "	 	SIP  Status\n";
    echo "	</th>\n";
    echo "	<tr>\n";
    echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
    echo "		Profile\n";
    echo "	</td>\n";
    echo "	<td align='center' class='ui-state-active mytableheader' width='150px'>\n";
    echo "		Address\n";
    echo "	</td>\n";
    echo "	<td align='center' class='ui-state-active mytableheader' width='60px'>\n";
    echo "		Status\n";
    echo "	</td>\n";
    echo "	<td align='center' class='ui-state-active mytableheader' width='85px' colspan='2'>\n";
    echo "		Inbound\n";
    echo "	</td>\n";
    echo "	<td align='center' class='ui-state-active mytableheader' width='85px' colspan='2'>\n";
    echo "		Outbound\n";
    echo "	</td>\n";
    echo "	<tr>\n";
    // Query SIP profile list
    exec( $cli . "\"sofia xmlstatus\"", $execRc);
    $szXmlSofiaStatus = implode( $execRc );
    unset( $execRc );
    try {
      echo "<!--\n";
      echo $szXmlSofiaStatus;
      echo "-->\n";
      $xmlStatus = new SimpleXMLElement( $szXmlSofiaStatus );
      // Get only the profile elements
      $xmlSipProfiles = $xmlStatus->xpath( "//profile" );
      foreach ( $xmlSipProfiles as $xmlSipProfile )
      {
        echo "<tr>\n";
        echo "	<td align='center' class='ui-state-active'>\n";
        echo 		trim($xmlSipProfile->name);
        echo "	</td>";
        echo "	<td align='center' class='ui-state-active'>\n";
        echo 		trim(substr( $xmlSipProfile->data, strpos( $xmlSipProfile->data, "@" )+1 ));
        echo "	</td>";
        echo "	<td align='center' style='background-color:";
        echo 	ResolveStatusBkColor($SipStatusMap, trim($xmlSipProfile->state)); 
        echo "'>\n";
        echo "		<font color='". ResolveStatusFontColor($SipStatusMap, trim($xmlSipProfile->state)) . "'>";
        echo 	ResolveStatusLabel($SipStatusMap, trim($xmlSipProfile->state)); 
        echo "		</font>";
        echo "	</td>";
        // Query the call stats
        exec( $cli . "\"sofia xmlstatus profile " . $xmlSipProfile->name . "\"", $execRc );
        $szXmlProfileStatus = implode( $execRc );
        unset( $execRc );
        $xmlProfileStatus = new SimpleXMLElement( $szXmlProfileStatus );
        $xmlTmp = $xmlProfileStatus->xpath( "//profile-info" );
        $xmlProfileInfo = $xmlTmp[0];
        $xmlTmp = NULL; 
        // Inbound
        echo "	<td align='center'>\n";
        echo "	<b>\n";
        echo 		trim( $xmlProfileInfo->{'calls-in'} );
        echo "	</b>\n";
        echo "	</td>";
        echo "	<td align='center'>\n";
        echo "	<b>\n";
        echo "		<font color='". COLOR_ERROR . "'>";
        echo 		trim( $xmlProfileInfo->{'failed-calls-in'} );
        echo "		</font>";
        echo "	</b>\n";
        echo "	</td>";
        // Outbound
        echo "	<td align='center'>\n";
        echo "	<b>\n";
        echo 		trim( $xmlProfileInfo->{'calls-out'} );
        echo "	</b>\n";
        echo "	</td>";
        echo "	<td align='center'>\n";
        echo "	<b>\n";
        echo "		<font color='". COLOR_ERROR . "'>";
        echo 		trim( $xmlProfileInfo->{'failed-calls-out'} );
        echo "		</font>";
        echo "	</b>\n";
        echo "	</td>";
        echo "</tr>";
        $xmlProfileStatus = NULL;
        $xmlProfileInfo = NULL;
      }
      $xmlStatus = NULL;
      $xmlSipProfiles = NULL;
    } catch(Exception $e) {};


    // End port table
    echo "<th i align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'>\n";
    echo "</th>\n";
    echo "</table>\n";
    echo "	</br>\n";

    DisplayAllRegistration($cli);

  }
}
$display_common->DynamicDivEnd( "SipStatusDiv" );


if ( $display_common->IsRenderingNonDynamicDiv( ) )
{
	// ************************************************************************************
	// FOOTER
	// ************************************************************************************
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}


function GetProfileList ($in_cli) {

  $profileList = array();
  exec( $in_cli . "\"sofia xmlstatus\"", $execRc);
  $szXmlSofiaStatus = implode( $execRc );
  unset( $execRc );

  $xmlStatus = new SimpleXMLElement( $szXmlSofiaStatus );
  // Get only the profile elements
  $xmlSipProfiles = $xmlStatus->xpath( "//profile" );
  
  foreach ( $xmlSipProfiles as $xmlSipProfile )
  {
    array_push( &$profileList, trim($xmlSipProfile->name) );
  }
  return $profileList;
}


function DisplayAllRegistration ($in_cli) {

  echo "<br/>\n";
  echo "<table class='mytable' border='1' width='100%'>\n";
  echo "	<tr>\n";
  //Display Registrations table header at center and Unregister all button on the right.
  echo "  <form name='flush_all_registration' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
  echo "	<th class='widget-content-header ui-state-active ui-corner-top' colspan='6'>\n";
  //Inner table is use to center Registrations header on the whole table.
  echo "  <table width='100%'>\n";
  echo "    <tr>\n";
  //echo "	  <td align='left'/>\n";
  echo "	  <td align='left'>\n";
  echo "	 	<b>Registrations</b>\n";
  echo "    </td>\n";
  echo "	  <td align='right' width='33%'>\n";
  echo "		<input type='submit' name='flush_all' value='   Unregister all   ' " . $_SESSION['button_class'] . "/>\n"; 
  echo "    </td>\n";
  echo "  </form>\n";
  echo "  </table>\n";
  echo "	</th>\n";
  echo "	</tr>\n";
  echo "	<tr>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		Profile\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		User\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		Contact\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		Address\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		Port\n";
  echo "	</td>\n";
  echo "	<td align='center' class='ui-state-active mytableheader' width='100px'>\n";
  echo "		Control\n";
  echo "	</td>\n";
  echo "  </tr>\n";

  try {
    foreach ( GetProfileList($in_cli) as $sipProfile )
    {
      DisplayProfileRegistration($in_cli, $sipProfile );
    }
  } catch(Exception $e) {};

  // End registrations table
  echo "<th i align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='7'>\n";
  echo "</th>\n";
  echo "</table>\n";
  echo "</br>\n";
}


function DisplayProfileRegistration ( $in_cli, $in_profileName ){

  exec( $in_cli . "\"sofia xmlstatus profile $in_profileName reg\"", $execRc );
  $szXmlProfileStatus = implode( $execRc );
  unset( $execRc );

  $xmlProfileStatus = new SimpleXMLElement( $szXmlProfileStatus );

  //Get only the registration elements
  $xmlProfileRegistrations = $xmlProfileStatus->xpath( "//registration" );
  foreach ( $xmlProfileRegistrations as $xmlProfileRegistration )
  {
    echo "<tr>\n";
		echo "	<td align='center'>\n";
		echo 		$in_profileName;
		echo "	</td>";
		echo "	<td align='center'>\n";
		echo 		trim( $xmlProfileRegistration->{'user'} );
		echo "	</td>";
		echo "	<td align='center'>\n";
		echo 		trim( $xmlProfileRegistration->{'contact'} );
		echo "	</td>";
		echo "	<td align='center'>\n";
		echo 		trim( $xmlProfileRegistration->{'network-ip'} );
		echo "	</td>";
		echo "	<td align='center'>\n";
		echo 		trim( $xmlProfileRegistration->{'network-port'} );
		echo "  </td>";
    //Display button to flush a registration.
		echo "	<td align='center'>\n";
    echo "  <form name='flush_registration".$i++."' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n"; 
    echo "    <input align='center' type='submit' name='flush_registration' value='Unregister' " . $_SESSION['button_class'] . "/>\n";
    echo "    <input type='hidden' name='profile' value='". $in_profileName ."'/>\n";
    echo "    <input type='hidden' name='user' value='". trim( $xmlProfileRegistration->{'user'} ) ."'/>\n";
    echo "  </form>\n";
		echo "  </td>";
    echo "</tr>\n";
  }

}

?>


