<?php
/*
	FusionPBX
	Version: MPL 1.1

	The contents of this file are subject to the Mozilla Public License Version
	1.1 (the "License"); you may not use this file except in compliance with
	the License. You may obtain a copy of the License at
	http://www.mozilla.org/MPL/

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.

	The Original Code is FusionPBX

	The Initial Developer of the Original Code is
	Mark J Crane <markjcrane@fusionpbx.com>
	Portions created by the Initial Developer are Copyright (C) 2008-2010
	the Initial Developer. All Rights Reserved.

	Contributor(s):
	Mark J Crane <markjcrane@fusionpbx.com>
*/
include "root.php";
require "includes/config.php";
require_once "includes/checkauth.php";
if (ifgroup("admin") || ifgroup("superadmin") || ifgroup("member")) {
	//access granted
}
else {
	echo "access denied";
	exit;
}

if (count($_GET)>0) {
	$uuid = $_GET["uuid"];
}

try {
	unset($db);
	//$db = new PDO('sqlite::memory:'); //sqlite 3
	$db = new PDO('sqlite:'.$v_db_dir.'/voicemail_default.db'); //sqlite 3
}
catch (PDOException $error) {
	print "error: " . $error->getMessage() . "<br/>";
	die();
}

if (strlen($uuid)>0) {

	$uuid = $_GET["uuid"];
	$sql = "";
	$sql .= "select * from voicemail_msgs ";
	$sql .= "where uuid = '$uuid' ";
	//echo $sql;
	$prepstatement = $db->prepare(check_sql($sql));
	$prepstatement->execute();
	$result = $prepstatement->fetchAll();
	foreach ($result as &$row) {
		$created_epoch = $row["created_epoch"];
		$read_epoch = $row["read_epoch"];
		$username = $row["username"];
		$domain = $row["domain"];
		$uuid = $row["uuid"];
		$cid_name = $row["cid_name"];
		$cid_number = $row["cid_number"];
		$in_folder = $row["in_folder"];
		$file_path = $row["file_path"];
		$message_len = $row["message_len"];
		$flags = $row["flags"];
		$read_flags = $row["read_flags"];
		break; //limit to 1 row
	}
	unset ($prepstatement);

	if  (file_exists($file_path)) {
		unlink($file_path);
	}

	$sql = "";
	$sql .= "delete from voicemail_msgs ";
	$sql .= "where uuid = '$uuid' ";
	$prepstatement = $db->prepare(check_sql($sql));
	$prepstatement->execute();
	unset($sql);
}

require "includes/config.php";
require_once "includes/header.php";
echo "<meta http-equiv=\"refresh\" content=\"2;url=v_voicemail_msgs.php\">\n";
echo "<div align='center'>\n";
echo "Delete Complete\n";
echo "</div>\n";

require_once "includes/footer.php";
return;

?>

