<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author Santiago Tramoyeres Cuesta <scuesta@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');

class Sng_token_auth extends Safe_CI_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    private function valid($token){
        $module = $this->_the_app->module('rest');
        $apikeys = $module->get_aggregate_objects('apikey');
        $current_session_id = session_id();
        $session_id = null;
        $ret = false;

        $token = base64_decode($token);
        $arToken = explode('{SHA1}',$token);
        if(count($arToken)>1){
            $token = $arToken[1];
            $session_id = $arToken[0];
        }else
            return $ret;

        WebChangeSessionId($session_id);
        $salt = $_SESSION['token_auth_salt'];
        foreach($apikeys as $id => $apikey){
            $key = $apikey->get_data_value('key');
            if(WebIsValidToken($token,$key)){
                $ret = $key;
                break;
            }
        }
        WebChangeSessionId($current_session_id);
        return $ret;
    }

    private function get_user(){
        $module = $this->_the_app->module('system');
        $users = $module->get_aggregate_objects('user');
        foreach($users as $name => $user){
            if(strtolower($user->get_data_value('access'))=='enable' &&
                    strtolower($user->get_data_value('sudoer'))=='enable')
                return $name;
        }
        return 'root';
    }
    
    private function create_salt(){        
        $abc="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@$?!_=-";
        $clen = strlen($abc)-1;
        $length = 32;
        $out = "";
        for($i=0;$i<$length;$i++)
            $out.= $abc[rand(0,$clen)];

        session_start();
        $this->session_set('token_auth_salt',$out);
        session_write_close();

        return $out;
    }

    public function get_salt(){
        $out = $this->create_salt();
        echo $out;
        exit;
    }        
    
    private function get_referer(){
        $referer = null;
        if(isset($_SESSION['referer'])){
            $referer = $_SESSION['referer'];           
            unset($_SESSION['referer']);
        }
        
        return $referer;
    }
    
    private function session_set($key,$val){
        $_SESSION[$key]=$val;
    }

    public function index(){            
        $url='/';
        session_start();
        $referer = $this->get_referer();
        if(preg_match('#(.+?)/\?token=(.+)#',$referer,$match) && ($key=$this->valid($match[2]))){
            $this->session_set('token_auth_key',$key);
            $this->session_set('token_auth_user',$this->get_user());
            $url = $match[1].'/?token='.$match[2];
        }
        session_write_close();
        WebForwardPage($url);
    }
}
