/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/**
 * @file /SAFe/js/safe.js
 */

/**
 * @function safe_disabled
 * @param g (group name)
 * @param v (enable_disable_enum value)
 * @desc allows to disable all fields starting with the end of a field name
 */
function safe_disabled(g, v) {
  if (typeof group[g] !== 'undefined' && typeof group[g]['fields'] !== 'undefined') {
    var fields = group[g]['fields'];
    for(var i=0;i<fields.length;i++) {
       if (v == group[g]['default']['value'] ) {
        if(group[g]['default']['status']=='disable'){
        	$("[name='"+fields[i]+"']").attr('disabled','disabled');
            $("[name='"+fields[i]+"']").addClass('field_disabled');
            //for multi select checkbox
            $("[name='"+fields[i]+"[]']").attr('disabled','disabled');
            $("[name='"+fields[i]+"[]']").addClass('field_disabled');
        }else{
        	$("[name='"+fields[i]+"']").removeAttr('disabled');
            $("[name='"+fields[i]+"']").removeClass('field_disabled');
            $("[name='"+fields[i]+"[]']").removeAttr('disabled');
            $("[name='"+fields[i]+"[]']").removeClass('field_disabled');
        }
      } else {
        if(group[g]['default']['status']=='disable'){
        	$("[name='"+fields[i]+"']").removeAttr('disabled');
            $("[name='"+fields[i]+"']").removeClass('field_disabled');
            $("[name='"+fields[i]+"[]']").removeAttr('disabled');
            $("[name='"+fields[i]+"[]']").removeClass('field_disabled');
        }else{
        	$("[name='"+fields[i]+"']").attr('disabled','disabled');
            $("[name='"+fields[i]+"']").addClass('field_disabled');
            $("[name='"+fields[i]+"[]']").attr('disabled','disabled');
            $("[name='"+fields[i]+"[]']").addClass('field_disabled');
        }
      }
       var field_span = $("[name='"+fields[i]+"']").closest( "span" );
       if(group[g]['default']['display']=='yes'){
       	var hide_class_name = field_span.attr("class");
	        if(hide_class_name == 'field'){
	        	field_span.show();
	        }
       }
       if(group[g]['default']['display']=='no'){
       	var hide_class_name = field_span.attr("class");
	        if(hide_class_name == 'field'){
	        	field_span.hide();
	        }
       }
    }
    if (typeof group[g]['condition'] !== 'undefined') {
  	  var condition = group[g]['condition'];
    	  if(typeof condition[v] !== 'undefined'){
    		  var condition_fileds = condition[v];
    		  for(var k=0;k<condition_fileds.length;k++){
    			  if(condition_fileds[k]['status'] == 'disable'){
	    			  $("[name='"+condition_fileds[k]['field_name']+"']").attr('disabled','disabled');
	    		        $("[name='"+condition_fileds[k]['field_name']+"']").addClass('field_disabled');
	    		  }else{
	    			  $("[name='"+condition_fileds[k]['field_name']+"']").removeAttr('disabled');
	    		        $("[name='"+condition_fileds[k]['field_name']+"']").removeClass('field_disabled');
	    		  }
    			  var field_span = $("[name='"+condition_fileds[k]['field_name']+"']").closest( "span" );
    			  if(condition_fileds[k]['display']=='yes'){
    		        	var hide_class_name = field_span.attr("class");
    			        if(hide_class_name == 'field'){
    			        	field_span.show();
    			        }
    		        }
    			  if(condition_fileds[k]['display']=='no'){
    		        	var hide_class_name = field_span.attr("class");
    			        if(hide_class_name == 'field'){
    			        	field_span.hide();
    			        }
    		        }
    		  }
    		  
    	  }
     }
    for(var i=0;i<fields.length;i++) {
    	var field = $("[name='"+fields[i]+"']");
    	if(field.length != 0 && typeof field.attr('onchange') !== 'undefined' && field.prop('tagName').toLowerCase() =='select'){
    		if(field.is(":visible") && !field.is(":disabled")){
    			field.trigger('change');
    		}else{
    			if(field.is(":disabled")){
    				safe_disabled(fields[i], 'none');
    			}
    		}
    	}
    }
  }
}
function safe_hide(g, v) {
	  if (typeof group[g]['fields']!== 'undefined') {
	    var fields = group[g]['fields'];
	    for(var i=0;i<fields.length;i++) {
	      if (v == 'false') {
	        $("[name='"+fields[i]+"']").attr('disabled','disabled');
	        $("[name='"+fields[i]+"']").addClass('field_disabled');
	        var field_tr = $("[name='"+fields[i]+"']").closest( "tr" );
	        field_tr.hide();
	        var hide_class_name = field_tr.attr("class");
	        if(hide_class_name != ''){
	        	field_tr.attr('class', '');
		        field_tr.attr('tmpclass', hide_class_name);
	        }
	      } else {
	    	$("[name='"+fields[i]+"']").removeAttr('disabled');
  	        $("[name='"+fields[i]+"']").removeClass('field_disabled');
    		var field_tr = $("[name='"+fields[i]+"']").closest( "tr" );
    		field_tr.show();  
    		var hide_class_name = field_tr.attr("tmpclass");
	        field_tr.attr('class', hide_class_name);
	      }
	    }
	    for(var i=0;i<fields.length;i++) {
	    	var field = $("[name='"+fields[i]+"']");
	    	if(typeof field.attr('onchange') !== 'undefined' && field.prop('tagName').toLowerCase() =='select'){
	    		if(field.is(":visible") && !field.is(":disabled")){
	    			field.trigger('change');
	    		}
	    		
	    	}
	    }
	  }
	}
function set_group(group , action ){
	if(action == 'disable'){
		safe_hide(group, 'false');
	}else{
		safe_hide(group, 'true');
	}
}
function safe_condition_disabled(g, v) {
	  if (typeof group_condition[g]!=='undefined') {
		  var condition = group_condition[g];
		  if(typeof condition['default'] !== 'undefined'){
			  for(var i=0;i<condition['groups'].length;i++) {
				  set_group(condition['groups'][i] , condition['default']);
			  }
		  }
		  if(typeof condition['condition'][v] !== 'undefined'){
			  $.each(condition['condition'][v], function(index, value) {
				  set_group(index , value);
			  });
		  }
	  }
	}
/**
 * @function safe_disabled_field_init
 * @param
 * @desc find all fields elements that need to be disabled
 */
function safe_disabled_field_init() {
  	$('form').find('input,select,textarea').each(function(){
      	if (this.tagName.toLowerCase() == 'select') {
          	if (typeof $(this).attr('onchange') !== 'undefined'){
	          	if($(this).is(":visible") && !$(this).is(":disabled")){
	              	$(this).trigger('change');
	          	}
	      	}
      	}
  	});
}

/**
 * @function safe_handle_field_help
 * @param
 * @desc handle contextual help for a form element
 */
function safe_handle_field_help() {
	// if there is at least one help content, build the process to handle it
  if ($('.field_info').size() > 0) {
	$('.field_info').on('click', function(){
	    var content = $(this).find('.tooltip-inner').html();
	    // Field info UI Dialog
	    return $("<div>" + content + "</div>").dialog({
			autoOpen: true,
			position: "center",
			modal: true,
			height: 'auto',
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title:$(this).parent().prev().text(),
			close: function() {
				//destory the dialog
				$(this).dialog("destroy").remove();
			},
			buttons: {
			    "Ok": function() {
			    	$(this).dialog("close");
			        return false;
			     }
			}
	    });
	 });
  
	$('.field_info').tooltip({
	    content : function(){ 
	    	return $(this).find('.tooltip-inner').html();
	    },
	    position: {
		    my: "center top",
		    at: "center bottom+15",
		    using: function( position, feedback ) {
		      $( this ).css( position );
		      $( "<div>" )
		        .addClass( "arrow" )
		        .addClass( feedback.vertical )
		        .addClass( feedback.horizontal )
		        .appendTo( this );
		    }
		  }
	    });
	    $('.field_info').tooltip({
			hide: {
				delay: 250
			}
		});
  }
}

function safe_enable_datepicker(){
  $('.safe_datetime').datetimepicker( {
    dateFormat:'yy-mm-dd'
  });
  $('.safe_date').datepicker({
    dateFormat:'yy-mm-dd'
  });
  $('.safe_time').timepicker({
              step:'5'
          });


}

function safe_toggle_fields(header_id, fields_class, setting){
  if(typeof setting !== 'undefined'){
	  setting = 0; 
  }else{
	  setting = 'slow';
  }
  if($('#'+header_id).hasClass('header_collapse')){
    $('#'+header_id).removeClass('header_collapse');
    $('#'+header_id).addClass('header_expand');
  }else if($('#'+header_id).hasClass('header_expand')){
    $('#'+header_id).removeClass('header_expand');
    $('#'+header_id).addClass('header_collapse');
  }
  $('.'+fields_class).each(function(){
    $(this).fadeToggle(setting);
  });
};


/**
 * @function safe_handle_create_button
 * @param button_obj (button object) 
 * @desc send ajax request pop up a creation dialog
 */
function safe_handle_create_button(button_obj){
	//send a ajax request to generate a creation dialog
	cancel_refresh();
    var create_dialog = function(rs){
			  try{
				  if (rs.result == true ){
					  var ok_name ='Create';
					  if(typeof rs.buttons !== 'undefined'){
						  ok_name = rs.buttons[0].value;
					  }
					  var ok_data = new Object();//{ "delete": "delete"};
					  //get submit button data from confime page
					  if(typeof rs.action_url !== 'undefined'){
					      if(typeof rs.setting !== 'undefined'){
                              setting = rs.setting;
                          }else{
                              setting = false;
                          }
						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data,null ,ok_name,setting)){
						  }else{
							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
						  }
					  }else{
						  if (typeof rs.redirect_url !== 'undefined'){
							  //if redirect url returned no need show confirm dialog
        					  window.location = rs.redirect_url;
        				  }else{
        					  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
        				  }
					  }  
				   }else{
					  var tmp_reason = '';
 					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
 						  if (rs.reason instanceof Array){
 							  tmp_reason = rs.reason.join('<br>');
 						  }else{
 							  tmp_reason = rs.reason;
 						  }
 					  }
 					  if (tmp_reason != ''){
 						  rs.message = rs.message + '<br>' + tmp_reason;
 					  }
					 throw {'title':rs.page_title, 'content':rs.message, 'type': rs.message_type};
				   };
			  }catch(err){
				  safe_message_box(err.title,safe_message_style(err.content,err.type));
			  }
			  
    };
	ui_ajax_running = $.ajax({
		  type: 'POST',
		  url: button_obj.parentNode.action,
		  dataType: 'json',
		  async:false,
		  success:function(rs){
              create_dialog(rs);
			  		  },
		  error:function(xhr){
			  if(xhr.status == '200'){
              var reload = true;
                  if(xhr.statusText=='OK'){
                    var res = xhr.responseText.replace(/<script[^>]+>[\s\S]+<\/script>/g,'').trim();
                    if(res.match(/^\{/) && (res=JSON.parse(res))){
                       if(window.parseURL){ //This is just for Glype
                        for(var key in res){
                          if(typeof res[key] == "string" && res[key].match(/http/)) //just taking car of first level
                            res[key] = window.parseURL(res[key]);
                        }
                       }
                       create_dialog(res);
                       reload=false;
                    }
                  }
                if(reload)
				  location.reload(true);
	
			  }else{
				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			  }
		  }
		});
}

/**
 * @function safe_handle_confirm_button
 * @param button_obj (button object) 
 * @desc handle button with an ajax confirm requst first
 */
function safe_handle_confirm_button(button_obj){
	//send a confirm request
	cancel_refresh();
    var open_dialog = function(rs){
            try{
				  if (rs.result == true ){
					  var ok_data = new Object();//{ "delete": "delete"};
					  //get submit button data from confime page
					  if(typeof rs.action_url !== 'undefined'){
						  var ok_name ='Ok';
      					  if(typeof rs.buttons !== 'undefined'){
      						  ok_name = rs.buttons[0].value;
      					  }
      					  if(typeof rs.setting !== 'undefined'){
      						  setting = rs.setting;
    					  }else{
    						  setting = false;
    					  }
						  if (safe_confirmation_box(rs.page_title,safe_message_style(rs.message,rs.message_type),rs.action_url,'','POST','',ok_data,null,ok_name,setting)){
						  }else{
							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
						  }
					  }else{
						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
					  }  
				   }else{
					   var tmp_reason = '';
	 					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
	 						  if (rs.reason instanceof Array){
	 							  tmp_reason = rs.reason.join('<br>');
	 						  }else{
	 							  tmp_reason = rs.reason;
	 						  }
	 					  }
	 					  if (tmp_reason != ''){
	 						  rs.message = rs.message + '<br>' + tmp_reason;
	 					  }
					   throw {'title':rs.page_title, 'content':rs.message, 'type': rs.message_type};
				   };
			  }catch(err){
				  safe_message_box(err.title,safe_message_style(err.content,err.type));
			  }
    };
	ui_ajax_running = $.ajax({
		  type: 'POST',
		  url: button_obj.parentNode.action,
		  //data : { "confirm": "YES"},
		  dataType: 'json',
		  async:false,
		  success:function(rs){
			open_dialog(rs);  
		  },
		  error:function(xhr){
	                    var reload = true;
			  if(xhr.status == '200'){
                  if(xhr.statusText=='OK'){
                    var res = xhr.responseText.replace(/<script[^>]+>[\s\S]+<\/script>/g,'').trim();
                    if(res.match(/^\{/) && (res=JSON.parse(res))){
                       if(window.parseURL){ //This is just for Glype
                        for(var key in res){
                          if(typeof res[key] == "string" && res[key].match(/http/)) //just taking car of first level
                            res[key] = window.parseURL(res[key]);
                        }
                       }
 
                       open_dialog(res);
                       reload=false;
                    }
                  }
                if(reload)
				  location.reload(true);
		  }else{
				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			  }
		  }
		});
}
/**
 * @function defaultvalue
 * @param arg (argument)
 * @param val (default value)
 * @desc set arg default value
 */
function defaultvalue(arg, val) { 
	return typeof arg !== 'undefined' ? arg : val; 
}

/**
 * @function safe_confirmation_box
 * @param title	(confirm box title)
 * @param content (confirm box content, can use html code)
 * @param url_ok (click ok button url)
 * @param url_cancel (click cancel button url)
 * @param ok_method	(click ok send http requst method)
 * @param cancel_method (click cancel send http requst method)
 * @param ok_data (click ok send http requst with this ok_data)
 * @param cancel_data (click cancel send http requst with this cancel_data)
 * @desc show a confirm dialog box with ok or cancel button
 */
function safe_confirmation_box(title, content, url_ok, url_cancel, ok_method, cancel_method, ok_data, cancel_data, ok_name,setting) {
	
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	url_ok 		= defaultvalue(url_ok, '');
	url_cancel 	= defaultvalue(url_cancel, '');
	ok_method 	= ok_method != 'GET' ? 'POST' : 'GET';
	cancel_method 	= cancel_method != 'POST' ? 'GET' : 'POST';
	ok_data		= defaultvalue(ok_data, null);
	cancel_data = defaultvalue(cancel_data, null);
	ok_name		= defaultvalue(ok_name, 'Ok');
	setting		= defaultvalue(setting, '');
	
	if (title != '' && content != '' && url_ok != '' ){
		return $("<div>" + content + "</div>").dialog({
			//autoOpen: false,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title: title,
			buttons:[ 
				{
					text : ok_name,
					click:function() {
						//show process bar
						if(setting){
							p_title = defaultvalue(setting['title'], title);
							p_sec = defaultvalue(setting['sec'], 30);
							p_msg = defaultvalue(setting['msg'], 'Timeout ...');
							p_label = defaultvalue(setting['label'], 'Ok');
							p_url = defaultvalue(setting['url'], '');
							if(typeof setting.waitbox !== 'undefined'){
							    processing_ui = safe_wait(p_title,setting.waitbox.ui_type,p_sec,p_msg,p_label,setting.waitbox.action_url,setting.waitbox.log_url,setting.waitbox.log_timeout);
							}else{
							    processing_ui = safe_wait(p_title,'spinning_wheel',p_sec,p_msg,p_label,p_url);
							}
						}else{
						    processing_ui = false;
						}
						
						$(this).dialog("close");
						cancel_refresh();
						var timeout = window.setTimeout(function() {
							ui_ajax_running = $.ajax({
			            		  type: ok_method,
			            		  url: url_ok,
			            		  data : ok_data,
			            		  dataType: 'json',
			            		  async:true,
			            		  success:function(rs){
			            			//handle result
			            		      //some cases rest api request,result in data
			            		      if(typeof rs.result === 'undefined'){
			            		          if(typeof rs.data !== 'undefined'){
			            		              rs = rs.data;
			            		          }
			            		      }
			            		      if(typeof setting.callback === 'function'){
			            		          //for restart check
			            		          setting.callback();
			            		          return;
			            		      }
			            			  if(processing_ui) {
			            				  processing_ui.dialog("close");
			            				  clearTimeout(processing_log_timeout_obj);
			            				  clearTimeout(log_timeout_obj);
			            			  }
			            			  if (rs.result == true ){
			            			      //check if have message to display
			            			      if(typeof rs.message !== 'undefined' && rs.message !== null){
			            			          if (typeof rs.redirect_url !== 'undefined' && rs.redirect_url !=''){
			            			              var close_method = {
	                                                      "dialogbeforeclose": function() {
	                                                          window.location = rs.redirect_url;
	                                                       }
	                                                  };
			            			          }else{
			            			              if(rs.reload == true && rs.redirect_url ==''){
			            			                  var close_method = {
	                                                          "dialogbeforeclose": function() {
	                                                             window.location.reload(true);
	                                                           }
	                                                      };
			            			              }else{
			            			                  var close_method = null;
			            			              }
			            			          }
			            			          safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type), close_method);
			            			      }else{
			            			          //return a url and redirect url
	                                          if (typeof rs.redirect_url !== 'undefined'){
	                                              window.location = rs.redirect_url;
	                                          }else{
	                                              safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
	                                          }
			            			      }
			            			  }else{
			            			      //add reason
			            			      var tmp_reason = '';
                                          if(typeof rs.reason !== 'undefined' && rs.reason !== null){
                                              if(typeof rs.reason === 'object'){
                                                  tmp_reason = obj_loop(rs.reason);
                                              }else if(typeof rs.reason === 'string'){
                                                  tmp_reason = rs.reason;
                                              }
                                          }
                                          if (tmp_reason != ''){
                                              rs.message = rs.message + '<br>' + tmp_reason;
                                          }
			            				  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type));
			            			  }
			            		  },
			            		  error:function(xhr){
			            			  processing_ui.dialog("close");
			            			  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			            		  }
			            		});
						}, 200);
		                return false;
		            }
				},
				{
					text : 'Cancel',
					click:function() {
						if (url_cancel != ''){
							//do some thing
						}
						$(this).dialog("close");
		                return false;
		            }
				}
			]
		});
	}else{
		safe_message_box('An error occurred:', safe_message_style("Parameter missing, Open the confirmation box failed",'alert'));
		return false;
	}
}
/**
 * @function safe_security_timer
 * @param sec (Value in second defining maximum time to wait for page to complete - Default is 10sec - 0 disable mechanism)
 * @param msg (Message to display when timeout reached)
 * @param label (Button label for redirection )
 * @param url ( URL to redirect user to after timeout expired when user press the redirect button - default is proper $_SERVER array entry containing base url + port ) 
 * @desc When the timeout fires we must add in the waiting dialog a custom message and a redirect button 
 */
var timeout_dialog;
function safe_security_timer(sec,msg,label,url,wait_dialog){
	sec 	= defaultvalue(sec, 0);
	wait_dialog    = defaultvalue(wait_dialog, null);
	if(sec > 0){
		return setTimeout(function(){ 
		    if(wait_dialog != null){
		        wait_dialog.dialog("close");//close the processing dialog box
		    }
		    timeout_dialog = safe_message_box('Timeout', msg,null,label,function() {if(url!='') {window.location = url;}else{$(this).dialog("close");}});
		    }, sec*1000);
	}
	return false;
}

/**
 * @brief 
 *
 * @return 
 */
var logoutObj = null;
function safe_create_session_timeout(){
    // Timeout box
    $.ajax({
            url:'/SAFe/rest/api/retrieve/application/preferences',
            type: 'GET',
            dataType:'json',
            async:true,
            success:function(response){
                logoutObj = $.timeoutDialog({
                    timeout: response.data.web_session_timeout * 60,
                    countdown: 30,
                    logoutRedirectUrl: logoutUrl
                });
            },
            error:function(){
                logoutObj = $.timeoutDialog({
                    logoutRedirectUrl: logoutUrl
                });
            }
        });
}
var page_is_ready = false;
var log_timeout_obj;
var processing_log = '';
var processing_log_timeout_obj;
function fetchProcessingLog(url,log_timeout_data){
    function onDataReceived(response){
      //check if the data same as last request
      if(processing_log.toString() == response.data.toString()){
          if(timeout_dialog){
              //stop get the log
              clearTimeout(log_timeout_obj);
              return;
          }
      }else{
          //reset timer and update ui
          clearTimeout(processing_log_timeout_obj);
          processing_log_timeout_obj = safe_security_timer(log_timeout_data.sec,log_timeout_data.msg,log_timeout_data.label,log_timeout_data.url,log_timeout_data.wait_dialog);
          processing_log = response.data
          updateProcessingLog(response.data);
      }
      //get log every 5s
      if(!page_is_ready){
          log_timeout_obj = setTimeout(function(){fetchProcessingLog(url,log_timeout_data)}, 10 * 1000);
      }
    }
    $.ajax({
      url:url,
      type: 'GET',
      dataType:'json',
      async:true,
      success:onDataReceived,
      error:function(xhr, textStatus){
              console.log('RX Error:' +  xhr.statusCode() + ' - ' + textStatus);
              //re try if network error
              if(!page_is_ready){
                  log_timeout_obj = setTimeout(function(){fetchProcessingLog(url,log_timeout_data)}, 10 * 1000);
              }
          }
      });
  }
function updateProcessingLog(data){
    // Update log to ui
    if( $("#processing_log_content").length && !timeout_dialog){
        $('#processing_log_content').html(data);
        $('#processing_log_content').animate({
            scrollTop: $('#processing_log_content').get(0).scrollHeight}, 1000);
    }else{
        clearTimeout(log_timeout_obj);
    }
}
/**
 * @function safe_wait
 * @param content (message show in the dialog)
 * @param type (spinning_wheel, or processing_bar ) 
 * @desc show a please wait dialog and block the ui 
 */
function safe_wait(content,type,sec,msg,label,url,log_url){
	content 	= defaultvalue(content, 'Please wait...');
	type 	= defaultvalue(type, 'spinning_wheel');
	sec 	= defaultvalue(sec, 0);
	msg 	= defaultvalue(msg, 'Timeout...');
	label 	= defaultvalue(label, 'Ok');
	url 	= defaultvalue(url, '');
	log_url    = defaultvalue(log_url, '');
	if(type == 'spinning_wheel'){
		var wait_dialog = $('<div><center><br><img src="/templates/base/images/icons/16x16/icon-loading.gif" style="vertical-align:middle;"> &nbsp;Please wait... <br><br><div id="content">' + content + "</div></center></div>").dialog({
		    closeOnEscape: false,
			autoOpen: true,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: false,
			resizable: false,
			dialogClass: 'msgbox',
			open: function( event, ui ) {
				$(this).closest(".ui-dialog").find(".ui-dialog-titlebar:first").hide();
				$(this).closest(".ui-dialog").find(".ui-dialog-content:first").css('overflow', 'hidden'); 
				if(logoutObj != null){
				    logoutObj.pause();
				}
			},
			close: function() {
			    if(logoutObj != null){
			        logoutObj.resume();
			    }
				//destory the dialog
				if(security_timer) clearTimeout (security_timer);
				$(this).dialog("destroy").remove();
			}
		});
		var security_timer = safe_security_timer(sec,msg,label,url,wait_dialog);
		return wait_dialog;
	}else if(type == 'processing_log'){
	    var wait_dialog = $('<div><center><br><img src="/templates/base/images/icons/16x16/icon-loading.gif" style="vertical-align:middle;"> &nbsp;Please wait... <br><br><div id="content">' 
	                        + content 
	                        + '<div style="margin-top: 10px; margin-bottom: 10px;">'
	                        +      '<div id="processing_log_content" style="text-align: left;width:auto;max-width:600px;height: 200px;overflow-x: auto;overflow-y: auto;">'
	                        +      '</div>'
	                        + '</div>'
	                        + "</div></center></div>"
	                            
	    ).dialog({
	        closeOnEscape: false,
            autoOpen: true,
            position: "center",
            modal: true,
            width: 'auto',
            maxHeight: 600,
            maxWidth: 600,
            minWidth: 400,
            draggable: false,
            resizable: false,
            dialogClass: 'msgbox',
            open: function( event, ui ) {
                $(this).closest(".ui-dialog").find(".ui-dialog-titlebar:first").hide();
                $(this).closest(".ui-dialog").find(".ui-dialog-content:first").css('overflow', 'hidden');
                //get the processing_log
                var log_timeout_data = {};
                log_timeout_data.sec = sec;
                log_timeout_data.msg = msg;
                log_timeout_data.label = label;
                log_timeout_data.url = url;
                log_timeout_data.wait_dialog = wait_dialog;
                //wait for the backend script start to clear the logs
                setTimeout(function(){fetchProcessingLog(log_url, log_timeout_data);}, 3000);
            },
            close: function() {
                //destory the dialog
                if(security_timer) clearTimeout (security_timer);
                $(this).dialog("destroy").remove();
                clearTimeout(log_timeout_obj);
            }
        });
	    //process log timeout
	    processing_log_timeout_obj = safe_security_timer(sec,msg,label,url,wait_dialog);
        return wait_dialog;
	}else if(type == 'processing_bar'){
		return $('<div><center><br><img src="/templates/base/images/icons/16x16/icon-loading.gif" style="vertical-align:middle;"> &nbsp;Please wait... <br><br><div id="safe_progress_bar"><span id="percent" style="width: 100%;"></span></div><br><div id="content">' + content + "</div></center></div>").dialog({
		    closeOnEscape: false,
		    autoOpen: true,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: false,
			resizable: false,
			dialogClass: 'msgbox',
			open: function(event, ui) {
				$(this).closest(".ui-dialog").find(".ui-dialog-titlebar:first").hide();
				$(this).closest(".ui-dialog").find(".ui-dialog-content:first").css('overflow', 'hidden'); 
				$("#safe_progress_bar").progressbar({value:false});//init
				safe_progressbar_update($("#safe_progress_bar"),false);
				if(logoutObj != null){
                    logoutObj.pause();
                }
			},
			close: function() {
			    if(logoutObj != null){
                    logoutObj.resume();
                }
				if(security_timer) clearTimeout (security_timer);
				//destory the dialog
				$(this).dialog("destroy").remove();
			},
			buttons:[ {
			    id : 'dialogCancel',
                text : 'Cancel',
                click:function() {
                    if(p > 0 && p < 100){
                        if(ui_ajax_running != null){
                            //stop upload
                            location.reload();
                        }
                    }
                }
			}]
		});
	}else{
		return false;
	}
}
function safe_progressbar_update(bar,value){
	value 	= defaultvalue(value, false);
	bar.progressbar({value:value});
	if(value == false){
		bar.find(".ui-progressbar-value").css('display','block');
		bar.find(".ui-progressbar-value").css('width','100%');
		bar.find(".ui-progressbar-value").css('background-image','url("/SAFe/images/animated-overlay.gif")');
		bar.find(".ui-progressbar-value").css('height','100%');
		bar.find(".ui-progressbar-value").css('opacity','0.25');
	}else{
		bar.find(".ui-progressbar-value").css('display','block');
		bar.find(".ui-progressbar-value").css('width',value +'%');
		bar.find(".ui-progressbar-value").css('background-image','');
		bar.find(".ui-progressbar-value").css('opacity','');
	}
}
function obj_loop(object){
    var collection= '', next, item;
    for(item in object){
        if(object.hasOwnProperty(item)){
            next= object[item];
            if(typeof next == 'object' && next != null){
                collection = collection +   obj_loop(next) ;
            }else{
            	collection = collection + '<li style="list-style-type:none;">'+String(next) + '</li>';
            }
        }
    }
    if(collection != ''){
    	collection = '<ul style="list-style-type:none;  padding-left: 10px; margin: 0px;" >' +  collection + '</ul>';
    }
    return collection;
}
/**
 * @function safe_create_box
 * @param title	(confirm box title)
 * @param content (confirm box content, can use html code)
 * @param url_ok (click ok button url)
 * @param url_cancel (click cancel button url)
 * @param ok_method	(click ok send http requst method)
 * @param cancel_method (click cancel send http requst method)
 * @param ok_data (click ok send http requst with this ok_data)
 * @param cancel_data (click cancel send http requst with this cancel_data)
 * @param ok_name (ok button name)
 * @desc show a confirm dialog box with ok or cancel button
 */
function safe_create_box(title, content, url_ok, url_cancel, ok_method, cancel_method, ok_data, cancel_data,ok_name,setting) {
	
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	url_ok 		= defaultvalue(url_ok, '');
	url_cancel 	= defaultvalue(url_cancel, '');
	ok_method 	= ok_method != 'GET' ? 'POST' : 'GET';
	cancel_method 	= cancel_method != 'POST' ? 'GET' : 'POST';
	ok_data		= defaultvalue(ok_data, null);
	cancel_data = defaultvalue(cancel_data, null);
	ok_name		= defaultvalue(ok_name, 'Create');
	setting     = defaultvalue(setting, null);//wait dialog settings
		
	if (title != '' && content != '' && url_ok != '' ){
		return $("<div>" + content + "</div>").dialog({
			//autoOpen: false,
	    	//position: {my: "center", at: "center", of: window, collision:"fit"},
			position:'center',
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title: title,
			open: function( event, ui ) {
				var forms = $(this).find('form');
				if (forms.length>0){
					//default enter key submit form
					//set submit event to click ok button
					$(forms[0]).submit(function() {
							$(this).parents('.ui-dialog').first().find('.ui-button').not( ".ui-dialog-titlebar-close" ).first().click();
						  return false;
						});
				}
			},
			buttons:[ {
				text : ok_name,
				click:function() {
					var form_type ='';
					//to do url_ok, data 
					var forms = $(this).find('form');
					if (forms.length>0){
						ok_data = $(forms[0]).serialize();
						//check if have a file upload Field
						var files = $(forms[0]).find(':file');
						if (files.length>0){
							form_type='upload_file';
						}
					}else{
						throw {'title':title, 'content':'Form data not found!', 'type':'alert'};
					}
					var old_dialog = $(this);
					
					//ajax submit the form and get the result
					if(form_type=='upload_file'){
						var options = { 
								url:       url_ok,         // override for form's 'action' attribute
								beforeSend: function() {
									old_dialog.dialog("close");//hide the old dialog box
	            					  var close_method = {
	            				            "dialogbeforeclose": function() {
	            				            	old_dialog.dialog("open");//show the old dialog box when close the error message box
	            				             }
	            					  	};
									upload_processing_ui = safe_wait(title,'processing_bar');
									p = 0;
							        //$("#safe_progress_bar .ui-progressbar-value").animate({width: p+"%"},50);
							        //$("#safe_progress_bar").find("#percent").html('0%')
							    },
							    uploadProgress: function(event, position, total, percentComplete) {
							    	if(p == 0){
							    		$("#safe_progress_bar").progressbar({value:0.01});//init
							    		safe_progressbar_update($("#safe_progress_bar"),percentComplete);
							    		p = 1;
							    	}
							    	var last_percent = 0;
							    	var percent_string = $("#safe_progress_bar").find("#percent").text();
							    	if(typeof percent_string !== 'undefined'){
							    	    last_percent = percent_string.replace('%','');
							    	}
							    	if(percentComplete > last_percent){
							    	    $("#safe_progress_bar .ui-progressbar-value").animate({width: percentComplete+"%"},50);
							    	    $("#safe_progress_bar").find("#percent").html(percentComplete + '%')
							    	}
							        if(percentComplete >= 100){
							        	upload_processing_ui.find("#content").html('File uploaded successfully! System processing...');
							        	//disable the cancel button after upload
							        	$("#dialogCancel").button("option", "disabled", true);
							        }
							    },
						        success:       function(rs){
			            			//handle result
			            			  if (rs.result == true ){
			            				  //add successful and return a redirect url
			            				  if (typeof rs.redirect_url !== 'undefined'){
			            					  if(rs.redirect_method=='POST'){
			            						  redirect_by_post(rs.redirect_url,rs.post_data);  
			            					  }else{
			            						  window.location = rs.redirect_url;
			            					  }
			            				  }else{
			            					  safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
			            				  }
			            			  }else{
			            				  //add fail
			            				  if(rs.reload==true){
			            					  //uer input data run_validation fail
			            					  //show the form again with validation error
				            				  ok_data = null;//clear ok_data
				          					  if(typeof rs.action_url !== 'undefined'){
				          						  var ok_name ='Create';
					          					  if(typeof rs.buttons !== 'undefined'){
					          						  ok_name = rs.buttons[0].value;
					          					  }
				          						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data, null,ok_name,setting)){
				          							  old_dialog.dialog("close");//close the old dialog
				          							  old_dialog.dialog( "destroy" ).remove();//distory the old add dialog
				          						  }else{
				          							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
				          						  }
				          					  }else{
				          						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
				          					  }  
			            				  }else{
			            					  
			            					  old_dialog.dialog("close");//hide the old dialog box
			            					  var close_method = {
			            				            "dialogbeforeclose": function() {
			            				            	old_dialog.dialog("open");//show the old dialog box when close the error message box
			            				             }
			            					  	};
			            					  //show other error dialog in a new message box
			            					  var tmp_reason = '';
			            					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
			            						  if(typeof rs.reason === 'object'){
			            							  tmp_reason = obj_loop(rs.reason);
			            						  }else if(typeof rs.reason === 'string'){
			            							  tmp_reason = rs.reason;
			            						  }
			            					  }
			            					  if (tmp_reason != ''){
			            						  rs.message = rs.message + '<br>' + tmp_reason;
			            					  }
			            					  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type),close_method);
			            					 
			            				  }
			            			  }
			            		},  // post-submit callback
			            		error:function(xhr){
			            			if(xhr.status == '200'){
			          				  	location.reload(true);
			          			  	}else{
			          			  		safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			          			  	}
			              		},
			              		complete: function(xhr) {
			              				//status.html(xhr.responseText);
			              				//$("#safe_progress_bar .ui-progressbar-value").animate({width: 100+"%"},100);
			              				upload_processing_ui.dialog("close");
			              		},
						        
						        //async:true,
						        // other available options: 
						         
						        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
						        dataType:  'json'        // 'xml', 'script', or 'json' (expected server response type) 
						        //clearForm: true        // clear all form fields after successful submit 
						        //resetForm: true        // reset the form after successful submit 
						 
						        // $.ajax options can be used here too, for example: 
						        //timeout:   3000 
						    };
						cancel_refresh();
						$(forms[0]).unbind('submit');
						$(forms[0]).submit(function() { 
							ui_ajax_running = $(this).ajaxSubmit(options); 
					        return false; 
					    }); 
						$(forms[0]).submit();
					}else{
						cancel_refresh();
                        var process_response = function(rs){
                            		            			//handle result
		            			  if (rs.result == true && typeof rs.close_dialog == 'undefined' ){
		            				  //add successful and return a redirect url
		            				  if (typeof rs.redirect_url !== 'undefined'){
		            					  if(rs.redirect_method=='POST'){
		            						  redirect_by_post(rs.redirect_url,rs.post_data);  
		            					  }else{
		            						  window.location = rs.redirect_url;
		            					  }
		            				  }else{
		            					  safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
		            				  }
		            			  }else{
		            				  //add fail
		            				  if(!rs.result && rs.reload==true){
		            					  //uer input data run_validation fail
		            					  //show the form again with validation error
			            				  ok_data = null;//clear ok_data
			          					  if(typeof rs.action_url !== 'undefined'){
			          						  var ok_name ='Create';
				          					  if(typeof rs.buttons !== 'undefined'){
				          						  ok_name = rs.buttons[0].value;
				          					  }
			          						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data,null,ok_name,setting)){
			          							  old_dialog.dialog("close");//close the old dialog
			          							  old_dialog.dialog( "destroy" ).remove();//distory the old add dialog
			          						  }else{
			          							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
			          						  }
			          					  }else{
			          						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
			          					  }  
		            				  }else{
		            					  if(typeof rs.close_dialog !== 'undefined' && rs.close_dialog == true){
		            					      old_dialog.dialog("close");//hide the old dialog box
		            					      old_dialog.dialog( "destroy" ).remove();//distory the old add dialog
		            					      if (typeof rs.redirect_url !== 'undefined' && rs.redirect_url != ''){
		            					          var close_method = {
	                                                        "dialogbeforeclose": function() {
	                                                            window.location = rs.redirect_url;
	                                                         }
	                                                    };
		                                      }else{
		                                          var close_method = null;
		                                      }
		            					  }else{
		            					      old_dialog.dialog("close");//hide the old dialog box
	                                          var close_method = {
	                                                "dialogbeforeclose": function() {
	                                                    old_dialog.dialog("open");//show the old dialog box when close the error message box
	                                                 }
	                                            };
		            					  }
		            					  
		            					  //show other error dialog in a new message box
		            					  var tmp_reason = '';
		            					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
		            						  if (rs.reason instanceof Array){
		            							  tmp_reason = rs.reason.join('<br>');
		            						  }else{
		            							  tmp_reason = rs.reason;
		            						  }
		            					  }
		            					  if (tmp_reason != ''){
		            						  rs.message = rs.message + '<br>' + tmp_reason;
		            					  }
		            					  //show other error dialog in a new message box
		            					  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type),close_method);
		            				  }
		            			  }
	
                        };                        
						ui_ajax_running = $.ajax({
		            		  type: ok_method,
		            		  url: url_ok,
		            		  data : ok_data,
		            		  dataType: 'json',
		            		  async:true,
		            		  beforeSend: function() {
                                  old_dialog.dialog("close");//hide the old dialog box
                                  //add wait dialog
                                  if(setting){
                                      p_title = defaultvalue(setting['title'], title);
                                      p_sec = defaultvalue(setting['sec'], 30);
                                      p_msg = defaultvalue(setting['msg'], 'Timeout ...');
                                      p_label = defaultvalue(setting['label'], 'Ok');
                                      p_url = defaultvalue(setting['url'], '');
                                      processing_ui = safe_wait(p_title,'spinning_wheel',p_sec,p_msg,p_label,p_url);
                                  }
                              },
		            		  success:function(rs){
		            		      if(processing_ui) {
                                      processing_ui.dialog("close");
                                  }
                                  process_response(rs);
	            		  },
		            		  error:function(xhr){
		            		      if(processing_ui) {
                                      processing_ui.dialog("close");
                                  }
		            			  if(xhr.status == '200'){
                                       var reload = true;
                                      if(xhr.statusText=='OK'){
                                        var res = xhr.responseText.replace(/<script[^>]+>[\s\S]+<\/script>/g,'').trim();
                                        if(res.match(/^\{/) && (res=JSON.parse(res))){
                                           if(window.parseURL){ //This is just for Glype
                                            for(var key in res){
                                              if(typeof res[key] == "string" && res[key].match(/http/)) //just taking car of first level
                                                res[key] = window.parseURL(res[key]);
                                            }
                                           }
                                           process_response(res);
                                           reload=false;
                                        }
                                      }
                                    if(reload)
                    				  location.reload(true);
	
		            			  }else{
		            				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
		            			  }
		            		  }
		            		});
					}
	                return false;
	            }
			},{
	            	text : "Cancel",
	            	click: function() {
						if (url_cancel != ''){
							//do some thing
						}
						$(this).dialog("close");
		                return false;
		            }
	            }
	          ]
		});
	}else{
		safe_message_box('An error occurred:', safe_message_style("Parameter missing, Open the confirmation box failed.",'alert'));
		return false;
	}
}

/**
 * @function safe_message_style
 * @param content (message content)
 * @param type	(style type normal info message or alert message )
 * @desc add style to dialog content
 */
function safe_message_style(content,type){
	content 	= defaultvalue(content, '');
	type 		= defaultvalue(type, 'info');//alert
	var tmp_string ='';
	 if (content instanceof Array){
         tmp_reason = content.join('<br>');
         content = tmp_reason;
     }
	if(type == 'alert'){
	    tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><i class="fa fa-exclamation-circle fa-fw fa-lg safe_error"></i></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}else if(type == 'notice'){
		tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><i class="fa fa-exclamation-circle fa-fw fa-lg safe_info"></i></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}else{
		tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><i class="fa fa-info-circle fa-fw fa-lg safe_info"></i></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}
	return tmp_string;
}

/**
 * @function safe_message_box
 * @param title	(message  title)
 * @param content (message content)
 * @param buttons (special buttons)
 * @desc show a message box
 */
function safe_message_box(title, content,close_method,btn_name,btn_method){
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	close_method	= defaultvalue(close_method, null);
	btn_name		= defaultvalue(btn_name, 'Ok');
	btn_method	= defaultvalue(btn_method, 
		function() {
			$(this).dialog("close");
			return false;
		}
	);
	return $("<div>" + content + "</div>").dialog({
		//autoOpen: false,
		position: "center",
		modal: true,
		maxHeight: 850,
		maxWidth: 800,
		minWidth: 600,
		draggable: true,
		resizable: false,
		dialogClass: 'msgbox',
		title: title,
		open: function(){
			//Bind an event listener to the dialogbeforeclose event 
			if(close_method!=null){
			    $(this).on( close_method );
			}
		},
		close: function() {
			//destory the dialog
			$(this).dialog("destroy").remove();
		},
		buttons:[ {
			text  : btn_name,
			click : btn_method
		}]
	});
}
(function($){
	if(typeof $.ui.dialog.prototype.oldOpen === 'undefined'){
		var dialogExtensions ={
		        oldOpen: $.ui.dialog.prototype.open,
		        oldClose: $.ui.dialog.prototype.close,
		        open: function(event){
		        	dialog_open = true;
		        	if(this.options.position !== false && this.options.position=='center'){
		        		var window_width = this.window.innerWidth();
		        		var window_height = this.window.innerHeight();
		    			var dialog_width = this.widget().width();
		    			var dialog_height = this.widget().height();
		    			var this_top 	=  this.widget().offset().top;
		    			var this_left 	=  this.widget().offset().left;
		    			if(this_left<(window_width/2-dialog_width/2)) this_left =  window_width/2-dialog_width/2;
		    			//if(this_top<(window_height/2-dialog_height/2)) this_top =  window_height/2-dialog_height/2;
		    			this.widget().offset({ top: this_top, left: this_left});
		        	}
		        	this.oldOpen(event);
		        	//dialog showed in browser
		        	// fix the max and min width value doe not set when dialog open
		        	if(this.options.minWidth !== false && this.widget().width()<this.options.minWidth) this.widget().width(this.options.minWidth);
		        	if(this.options.maxWidth !== false && this.widget().width()>this.options.maxWidth) this.widget().width(this.options.maxWidth);
		        	if(this.options.maxHeight !== false && this.widget().height()>this.options.maxHeight) {
		        		this.widget().height(this.options.maxHeight);
		        		$(this.widget()).find('.ui-dialog-content').first().height(this.options.maxHeight-85);//title and foot bar 85
		        	}
		        },
			close:function(event){
				this.oldClose(event);
				//value sett too fast
				setTimeout(function(){dialog_open = false;},500);
			} 
		};
		$.extend($.ui.dialog.prototype, dialogExtensions);
	}
})(jQuery);

/**
 * @function safe_warn_tooltip
 * @param
 * @desc system warnning messages
 */
function safe_warn_tooltip() {
  if ($('#safe_badge_icon').size() > 0) {
	$('#safe_badge_icon').tooltip({
	    content : function(){ 
	    	return $(this).find('#safe_notification_list').html();
	    },
	    position: {
		    my: "center top",
		    at: "center bottom+10",
		    using: function( position, feedback ) {
		    	$( this ).css( position );
		      $( "<div>" )
		        .addClass( "arrow_red" )
		        .addClass( feedback.vertical )
		        .addClass( feedback.horizontal )
		        .appendTo( this );
		      $(this).css( 'border', '1px solid #800000' );
		      $(this).css( 'background-color', '#FFEEEE' );//D4E6F4
		      $(this).css( 'color', '#cd0a0a' );
		    }
		  }
	    });
	    $('#safe_badge_icon').tooltip({
			hide: {
				delay: 250
			}
		});
  }
}

if(typeof ajax_running_id === 'undefined'){
	var ajax_running_id = 0;
	var ajax_running = null;
	var ui_ajax_running = null;
	var request_queue = new Array();
	var timeout_obj;
	var system_status_timer = null;
}
/**
 * @function cancel_refresh
 * @param
 * @desc stop get system status when ui ajax request
 */
function cancel_refresh(){
	clearTimeout(timeout_obj);
	request_queue.length = 0;
	if(ajax_running != null){
		ajax_running.abort();
		ajax_running = null;
	}
}
/**
 * @function redirect_by_post
 * @param
 * @desc redirect url by post with some post data
 */
function redirect_by_post(url,data){
	if(typeof url !== 'undefined' && url != ''){
		var form = document.createElement("form");
	    form.setAttribute("method", "post");
	    form.setAttribute("action", url);
	    if(typeof data !== 'undefined'){
	    	for(var key in data) 
	        { 
	    		if (data[key].constructor === Array){
	    			for(var subkey in data[key])
	    			{
	    				var hiddenField = document.createElement("input");
			            hiddenField.setAttribute("name", key+'[]');
			            hiddenField.setAttribute("value",data[key][subkey] );
			            hiddenField.setAttribute("type", "checkbox");
			            hiddenField.setAttribute("checked", 'checked');
			            form.appendChild(hiddenField);
	    			}
	    		}else{
	    			var hiddenField = document.createElement("input");
		            hiddenField.setAttribute("name", key);
		            hiddenField.setAttribute("value",data[key] );
		            hiddenField.setAttribute("type", "hidden");
		            form.appendChild(hiddenField);
	    		}
	        	
	            
	        }
	    }
	    document.body.appendChild(form);
	    form.submit();
	}
}
function copy_listbox_data(name,to_box_id)
{
    var data_item = document.getElementById(name);
    var to_box = document.getElementById(to_box_id);
    for (i=data_item.options.length - 1; i>=0; i--){
        //remove old data
        data_item.options[i]=null;
    }
    for (i=to_box.options.length - 1; i>=0; i--)
    {//copy data 
        select_id=to_box.options[i].value;
        select_text=to_box.options[i].text;
        var newRow = new Option(select_text,select_id);
        data_item.options[i]=newRow;
        data_item.options[i].selected = true;
    }
}
function listbox_move(name,type)
{
    var from_box_id = 'tmp_from_listbox_' + name;
    var to_box_id = 'tmp_to_listbox_' + name;
    if(type == 'add'){
        from_box = document.getElementById(from_box_id);
        to_box = document.getElementById(to_box_id);
    }else{
        from_box = document.getElementById(to_box_id);
        to_box = document.getElementById(from_box_id);
    }
    var selected = [];
    for (var i = 0; i < from_box.options.length; i++) {
        if (from_box.options[i].selected) {
            selected.push(from_box.options[i]);
        }
    }
    var select_id='';
    var select_text='';
    var item = null;
    for (i = 0; i < selected.length; i++)
    {
        select_id=selected[i].value;
        select_text=selected[i].text;
        var newRow = new Option(select_text,select_id);
        to_box.options[to_box.length]=newRow;
    }
    for (i = selected.length - 1; i >= 0; i--)
    {
        var index = selected[i].index;
        from_box.options[index]=null;
    }
    copy_listbox_data(name,to_box_id);
}
function listbox_sort(name,direction)
{
    var to_box_id = 'tmp_to_listbox_' + name;
    var listbox = document.getElementById(to_box_id);
    var selected = [];
    var increment = -1;
    if(direction == 'up'){
        increment = -1;
        for (var i = 0; i < listbox.options.length; i++) {
            if (listbox.options[i].selected) {
                selected.push(listbox.options[i]);
            }
        }
    }else{
        increment = 1;
        for (var i = listbox.options.length - 1; i >= 0 ; i--) {
            if (listbox.options[i].selected) {
                selected.push(listbox.options[i]);
            }
        }
    }
    for (i = 0; i < selected.length; i++) {
        var index = selected[i].index;
        if((index + increment) < 0 || (index + increment) > (listbox.options.length-1)) {
            break;
        }
        var temp_text = selected[i].text;
        selected[i].text = listbox.options[index + increment].text;
        listbox.options[index + increment].text = temp_text;

        var temp_value = selected[i].value;
        selected[i].value = listbox.options[index + increment].value;
        listbox.options[index + increment].value = temp_value;

        selected[i].selected = false;
        listbox.options[index + increment].selected = true;
    }
    copy_listbox_data(name,to_box_id);
}
var p = 0;
var upload_processing_ui = null;
var processing_ui = null;

(function($){
	if(system_status_timer === null){
		safe_warn_tooltip();
		//if mouse on the tooltip will not hide
	    $( "[title]" ).bind( "mouseleave", function( event ) {
			event.stopImmediatePropagation();
			var fixed = setTimeout('$("[title]").tooltip().tooltip("close")', 250);
			$(".ui-tooltip").hover(
			    function(){
			    	clearTimeout (fixed);
			    	},
			    function(){
			    		$("[title]").tooltip().tooltip("close");
			    	}
			);
		}).tooltip();
	}
})(jQuery);
var dialog_open = false;

$(window).resize(function () {
	$($('div.modified_configuration')[0]).css('max-height', $(window).height() - 200 + 'px');
});

$(document).ready(function() {
    $('#cfg_manager *:input[type!=hidden]:first').focus();
});
$(document).ready(function() {
	if(typeof _category !== 'undefined'){
		for(var i=0;i<_category.length;i++) {
			safe_toggle_fields('safe_category_header_'+_category[i],'safe_category_'+_category[i], '0');
		}
	}
});


var logoutDialog = null;  
$(function() {
    $.timeoutDialog = function(options) {
        var startTime = new Date().getTime();
        var timeLeft = 0;
        var timerId = null;
        var settings = {
                timeout: 300,
                countdown: 30,
                title : 'Warning!',
                message : 'Due to inactivity, you will be logged out in {} seconds , cancel to restart timer.',
                logoutRedirectUrl: ''
            }    
        $.extend(settings, options);
        var countdownDialog = {
              setTimer: function() {
                  var self = this;
                  var tmpTimeout = (settings.timeout - settings.countdown) * 1000;
                  if(timeLeft > 0){
                      tmpTimeout = timeLeft;//resume from paused 
                  }
                  if(tmpTimeout > 0){
                      timerId = startAjaxTimer(function tmpSetDialog() {
                          self.setDialog();
                      }, tmpTimeout);
                  }else{
                      self.action();
                  }
              },
              clearTimer: function() {
                  clearTimeout(timerId);
                  timerId = null;
              },
              setDialog: function() {
                  var self = this;
                  self.closeDialog();
                  logoutDialog = $('<div><p>' + settings.message.replace("{}",'<span id="countdown">' + settings.countdown + '</span>')  +  '</p></div>').dialog({
                      modal: true,
                      height: 'auto',
                      width: 500,
                      maxHeight: 600,
                      maxWidth: 600,
                      minWidth: 400,
                      zIndex: 10000,
                      closeOnEscape: true,
                      draggable: false,
                      resizable: false,
                      dialogClass: 'msgbox',
                      title: settings.title,
                      close: function( event, ui ) {
                          logoutDialog = null;    
                          self.resetTimer();
                          $(this).dialog("destroy").remove();
                      },
                      buttons :[
                                {
                                    text: 'OK',
                                    click: function() {
                                      self.action();
                                    }
                                },
                                {
                                      text: 'Cancel',
                                      click: function() {
                                          $(this).dialog( "close" );
                                      }
                                  }
                               ]
                  });
                  self.startCountdown();
              },
              closeDialog: function() {
                  if (logoutDialog != null) {
                      logoutDialog.dialog("close");
                      logoutDialog = null;
                  }
              },
              startCountdown: function() {
                  var self = this,
                  counter = settings.countdown;
                  this.countdown = window.setInterval(function() {
                      counter = counter - 1;
                      $("#countdown").html(counter);
                      if (counter <= 0) {
                          window.clearInterval(self.countdown);
                          self.action();
                      }
                  }, 1000);
              },
              resetTimer: function() {
                   var self = this;
                    window.clearInterval(self.countdown);
                    self.setTimer();
              },
              // pause timer
              pause: function() {
                  var now = new Date().getTime();
                  timeLeft = (settings.timeout - settings.countdown) * 1000 - (now - startTime);
                  clearTimeout(timerId);
                  timerId = null;
              },
              // resume paused timer
              resume: function() {
                  var self = this;
                  if (timerId == null){
                      startTime = new Date().getTime();
                      self.setTimer();
                      timeLeft = 0;
                  }
                  
              },
              logout: function() {
                  window.location = settings.logoutRedirectUrl;
              },
              action: function() {
                  //default action logout
                  window.location = settings.logoutRedirectUrl;
              }
        };
        countdownDialog.setTimer();
        return countdownDialog;
    };
  });

function safe_restart(){
    rs = new Object(); 
    rs.page_title = 'Restart';
    rs.message = 'Are you sure you want to restart the system?';
    rs.message_type = 'alert';
    rs.action_url = '/SAFe/rest/api/shutdown/system';
    var ok_data = {
            mode: "reboot"
        };
    ok_name = 'Restart';
    setting = new Object();
    setting['label'] = 'Close';
    setting['msg'] = 'Ooops ! Restart time out...';
    setting['sec'] = 180;
    
    setting['title'] = 'System is restarting...';
    setting['url'] = '?reserved_logout=y';
    setting['callback'] = safeRestartCallback;
    safe_confirmation_box(rs.page_title,safe_message_style(rs.message,rs.message_type),rs.action_url,'','POST','',ok_data,null,ok_name,setting);
}

function safe_check_system_up(){
        $.ajax({
          url:'/SAFe/rest/api/status/system/os',
          type: 'GET',
          dataType:'json',
          async:true,
          timeout: 5000,
          success:function(response){
              //if system is up, go to login page
              $.xhrPool.abortAll();
              window.location = logoutUrl;
          },
          error:function(xhr, textStatus){
              startAjaxTimer(safe_check_system_up, 5 * 1000);
          }
       });
}

function safe_poweroff(){
    rs = new Object(); 
    rs.page_title = 'Power Off';
    rs.message = 'Are you sure you want to shutdown the system?';
    rs.message_type = 'alert';
    rs.action_url = '/SAFe/rest/api/shutdown/system';
    var ok_data = {
            mode: "halt"
        };
    ok_name = 'Power Off';
    setting = new Object();
    setting['label'] = 'Close';
    setting['msg'] = 'Ooops ! Shut down system time out...';
    setting['sec'] = 180;
    
    setting['title'] = 'System is shutting down...';
    setting['url'] = '?reserved_logout=y';
    setting['callback'] = safePoweroffCallback;
    safe_confirmation_box(rs.page_title,safe_message_style(rs.message,rs.message_type),rs.action_url,'','POST','',ok_data,null,ok_name,setting);
}
function safe_check_system_down(){
    $.ajax({
      url:'/SAFe/rest/api/status/system/os',
      type: 'GET',
      dataType:'json',
      async:true,
      timeout: 5000,
      success:function(response){
          //if system is still up try again
          startAjaxTimer(safe_check_system_down, 5 * 1000);
      },
      error:function(xhr, textStatus){
          //close wait dialog 
          if(processing_ui) {
              processing_ui.dialog("close");
          }
          //stop all request
          for (var x in timers) {
              clearTimeout(timers[x]);
          }
          $.xhrPool.abortAll();
          //disable close dialog
          var close_method = {
                  "dialogbeforeclose": function() {
                      return false;
                   }
              };
          safe_message_box('Power Off:', safe_message_style("System is powered off.",'alert'), close_method);
      }
   });
}
function safe_on_save(){
    safe_wait('Saving ...', 'spinning_wheel', 120, 'Timeout...','Ok','/');
    return true;
}
function safeActionConfirm(confirm_obj, waiting_obj){
    safe_confirmation_box(confirm_obj.page_title,safe_message_style(confirm_obj.message,confirm_obj.message_type),confirm_obj.action_url,'',confirm_obj.ok_method,'',confirm_obj.ok_data,null,confirm_obj.ok_name,waiting_obj);
}
function safeRestartCallback(){
    for (var x in timers) {
        clearTimeout(timers[x]);
    }
    //stop all active ajax request
    $.xhrPool.abortAll();
    //delay 60s for system restart
    startAjaxTimer(safe_check_system_up, 60 * 1000);
}
function safePoweroffCallback(){
    for (var x in timers) {
        clearTimeout(timers[x]);
    }
    //stop all active ajax request
    $.xhrPool.abortAll();
    //delay 30s for system shuting down
    startAjaxTimer(safe_check_system_down, 30 * 1000);
}
/**
 * @function safe_add_condition
 * @param
 * @desc handle add condition / action / anti-action button
 */
function safe_add_condition_or_action(event) {
	var elem = $(event.target),
		button_type = $(elem).parent().attr('class'),
		row = $(elem).closest('tr'),
		clone = row.clone(),
		combo = '',
		sel_index = -1;
    alert('hhh');
		switch (button_type) {
			case 'btnAddCondition':
				combo = $(clone.children('td')[1]).children('.condition-row');
				sel_index = $($(row.children('td')[1]).children('.condition-row'))[0].selectedIndex;
			break;
			case 'btnAddAction':
				combo = $(clone.children('td')[1]).children('.action-row');
				sel_index = $($(row.children('td')[1]).children('.action-row'))[0].selectedIndex;
			break;
			case 'btnAddAntiAction':
				combo = $(clone.children('td')[1]).children('.anti-action-row');
				sel_index = $($(row.children('td')[1]).children('.anti-action-row'))[0].selectedIndex;
			break;
		}
	if (combo != '' && sel_index >= 0) {
		$(combo).children('option[selected=selected]').each(function(){ $(this).removeAttr('selected'); });
		$(combo).children('option').eq(sel_index).attr('selected', 'selected');
	}
		window.clone = clone;

	row.after(clone);
	switch (elem.parent().attr('class')) {
		case 'btnAddCondition':
			safe_refresh_condition_or_action('condition');
		break;
		case 'btnAddAction':
			safe_refresh_condition_or_action('action');
		break;
		case 'btnAddAntiAction':
			safe_refresh_condition_or_action('anti-action');
		break;
	}
}
/**
 * @function safe_remove_condition
 * @param
 * @desc handle remove condition / action / anti-action button
 */
function safe_remove_condition_or_action(event) {
	elem = $(event.target).closest('a').attr('class');
	if ($('.' + elem).closest('tr').length == 1) safe_message_box('Operation Failed', 'Minimum of 1 condition is required');
	else {
        // Native object has no function remove in every browser
		$($(event.target).closest('tr')[0]).remove();
		// refresh orders
		switch ($(event.target).parent().attr('class')) {
			case 'btnRemoveCondition':
				safe_refresh_condition_or_action('condition');
			break;
			case 'btnRemoveAction':
				safe_refresh_condition_or_action('action');
			break;
			case 'btnRemoveAntiAction':
				safe_refresh_condition_or_action('anti-action');
			break;
		}
	}
}

function safe_refresh_condition_or_action(type) {
	switch (type) {
		case 'condition':
			$('.condition-row').parent().each(function(index, value) {
				var condition = $(value).children('.condition-row'),
					sel_index = $(condition)[0].selectedIndex,
					html = '';
				$(condition).children('option[selected=selected]').each(function(){ $(this).removeAttr('selected'); });
				$(condition).children('option').eq(sel_index).attr('selected', 'selected');
				html = $(value).html();
				$(value).html(html.replace(/condition\/\d*\//g, 'condition/' + (index+1) + '/'));
			});
		break;
		case 'action':
			$('.action-row').parent().each(function(index, value) {
				var action = $(value).children('.action-row'),
					sel_index = $(action)[0].selectedIndex,
					html = '';
				$(action).children('option[selected=selected]').each(function(){ $(this).removeAttr('selected'); });
				$(action).children('option').eq(sel_index).attr('selected', 'selected');
				html = $(value).html();
				$(value).html(html.replace(/action\/\d*\//g, 'action/' + (index+1) + '/'));
			});
		break;
		case 'anti-action':
			$('.anti-action-row').parent().each(function(index, value) {
				var action = $(value).children('.anti-action-row'),
					sel_index = $(action)[0].selectedIndex,
					html = '';
				$(action).children('option[selected=selected]').each(function(){ $(this).removeAttr('selected'); });
				$(action).children('option').eq(sel_index).attr('selected', 'selected');
				html = $(value).html();
				$(value).html(html.replace(/action\/\d*\//g, 'action/' + (index+1) + '/'));
			});
		break;
	}
}
/**
 * @function safe_reorder_page
 * @param
 * @desc prepares the page for sortable feature on conditions, actions and anti-actions
 */
function safe_reorder_page() {
	var btn = $('.button-reorder-rules');
	if (btn.length == 0) return;
	btn.each(
		function(idx,v) {
			elem = $(v);
			type = $(elem.closest('a')).attr('id');

			switch (type) {
				case "btnReorderCondition":
					$(elem.closest('tr')).children().last().children('.function-buttons-condition').remove();
					$(elem.closest('tr')).children().last().append('<span class="function-buttons-condition">\
					  	<a class="btnAddCondition" onclick="safe_add_condition_or_action(event);" title="Add Condition">&nbsp;<i class="fa fa-plus-circle"></i></a>\
						<a class="btnRemoveCondition" onclick="safe_remove_condition_or_action(event);" title="Remove Condition">&nbsp;<i class="fa fa-times-circle"></i></a>\
				 	</span>');
			 	break;
			 	case "btnReorderAction":
		 			$(elem.closest('tr')).children().last().children('.function-buttons-action').remove();
					$(elem.closest('tr')).children().last().append('<span class="function-buttons-action">\
					  	<a class="btnAddAction" onclick="safe_add_condition_or_action(event);" title="Add Action">&nbsp;<i class="fa fa-plus-circle"></i></a>\
						<a class="btnRemoveAction" onclick="safe_remove_condition_or_action(event);" title="Remove Action">&nbsp;<i class="fa fa-times-circle"></i></a>\
				 	</span>');
			 	break;
			 	case "btnReorderAntiAction":
		 			$(elem.closest('tr')).children().last().children('.function-buttons-anti-action').remove();
					$(elem.closest('tr')).children().last().append('<span class="function-buttons-anti-action">\
					  	<a class="btnAddAntiAction" onclick="safe_add_condition_or_action(event);" title="Add Action">&nbsp;<i class="fa fa-plus-circle"></i></a>\
						<a class="btnRemoveAntiAction" onclick="safe_remove_condition_or_action(event);" title="Remove Action">&nbsp;<i class="fa fa-times-circle"></i></a>\
				 	</span>');
			 	break;
			}
		}
	);

	cloneCondition = $('.btnAddCondition').closest('tr').clone();
	$('.btnAddCondition').closest('tr').remove();

	cloneAction = $('.btnAddAction').closest('tr').clone();
	$('.btnAddAction').closest('tr').remove();

	cloneAntiAction = $('.btnAddAntiAction').closest('tr').clone();
	$('.btnAddAntiAction').closest('tr').remove();

	body = $('.mytablecategoryheader').closest('tbody');

	cloneCond = $(body).children('tr:lt(3)');
	$(body).children('tr:lt(3)').remove();

	cloneAct = $(body).children('tr:lt(1)');
	$(body).children('tr:lt(1)').remove();

	cloneAntiAct = $(body).children('tr:lt(1)');
	$(body).children('tr:lt(1)').remove();

	cloneFoot = $(body).children('tr:lt(1)');
	$(body).children('tr:lt(1)').remove();

	tbl = $(body).parent();
	$(body).remove();
	$(tbl).append('\
	 	<tbody class="sortable-condition-header"></tbody>\
		<tbody class="sortable-condition"></tbody>\
		<tbody class="sortable-action-header"></tbody>\
		<tbody class="sortable-action"></tbody>\
		<tbody class="sortable-anti-action-header"></tbody>\
		<tbody class="sortable-anti-action"></tbody>\
		<tbody class="sortable-footer"></tbody>');

	$('.sortable-condition-header').append(cloneCond);
	$('.sortable-condition').append(cloneCondition);
	$('.sortable-action-header').append(cloneAct);
	$('.sortable-action').append(cloneAction);
	$('.sortable-anti-action-header').append(cloneAntiAct);
	$('.sortable-anti-action').append(cloneAntiAction);
	$('.sortable-footer').append(cloneFoot);

	$( ".sortable-condition" ).sortable({
		stop: function( event, ui) {
			safe_refresh_condition_or_action('condition');
		}
	});

  	$( ".sortable-action" ).sortable({
  		stop: function( event, ui) {
  			safe_refresh_condition_or_action('action');
  		}
  	});

  	$( ".sortable-anti-action" ).sortable({
  		stop: function( event, ui) {
  			safe_refresh_condition_or_action('anti-action');
  		}
  	});
}
