<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Version class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
class Safe_version extends Safe_configurable_object_class
{
    private $_info;
    private $_components = null;
    private $_version_info = null;
    public function __construct($node)
    {
      parent::__construct($node->object_name(), 'version');
      $this->_set_sync_strategy(Safe_serializable_object_class::SYNC_MEM);
    }
    public function configure($node)
    {
        // Get about file
        $config = $node->configuration_manager()->about();
        $about_file = $config['version'];
        // Read config file
        if ($node->read_file($about_file, $about)) {
            // Convert xml to array
            $this->_info = Safe_xml_to_array($about);
        }
        // Build fields list
        foreach($this->info() as $k => $v){
          $this->add_field(strtolower($k), $k, 'text', $v);
          $this->set_field_disabled(strtolower($k));
        }

        parent::configure();
        return true;
    }
    public function info()
    {
        if (!isset($this->_version_info)) {
            // Extract info attributes
            $this->_version_info = $this->_info['@attributes'];
        }
        return $this->_version_info;
    }
    public function components()
    {
        if (!isset($this->_components)) {
            // Retrieve components
            foreach ($this->_info['component'] as $comp) {
                // Create component
                $component = array(
                    'branch' => $comp['@attributes']['branch'],
                    'date' => $comp['commit']['@attributes']['date'],
                    'hash' => $comp['commit']['@attributes']['hash'],
                );
                // Insert in array
                $this->_components[$comp['@attributes']['repo']] = $component;
                unset($component);
            }
        }
        return $this->_components;
    }
}
/* End of file safe_version_class.php */
