<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Safe TABLE lib
 * Generic TABLE lib with CRUD and FORM feature.
 *
 * @author Michel Buczynski
 * @version
 *          
 *          
 */
class Safe_table_class
{
    /**
     *
     * @var array
     */
    public $config = array();
    /**
     *
     * @var MY_Table
     */
    public $table; // CI_Table
    var $heading = array();
    var $data = array();
    var $data_formatter = array();
    var $apply_data_formatter = true;
    var $primary_key = array();
    var $line_button = array(); //Usage $this->line_button[] = array(array('url=>'test','name'=>'test'),array('url'=>'test2','name'=>'test2'));
    var $footer_button = array(); //Usage $this->footer_button = array(array ('url' => 'ntg_statistics/drop_sessions', 'name'=> 'Drop All Sessions'));
    var $footer = ""; // Default footer is blank
    var $form_method = "post"; // Default method is post
    // var $header_button=array();
    /*
     * You can use table without defining a config (for transposing data
     * structure): In Safe_table object; $data      contains a array of array of
     * string ( the actual table that will be show) $heading    contains a array
     * of string of the heading, this can be empty for no heading $primary_key
     * contains a array of string (or number) that will add up to the line
     * button url. this can be empty $line_button   contains a array of button
     * array config (see button() for description of this array), this will add
     * button on each line of the table $footer_button  contains a array of
     * button array config that will be add at the end of the table; After you
     * use generate(); to generate the html for the table.
    */
    var $template = array(
        'table_open' => '', // please don't modify use my_table_open
        // instead
        //Table row height increase option
        'cp_tr_height' => '<tr style="height:20px;">',
        'heading_row_start' => '<tr>',
        'heading_row_end' => '</tr>',
        'heading_cell_start' => '<th class="mytableheader" style="white-space:nowrap;">',
        'heading_cell_end' => '</th>',
        'td_stopped' => '<td class="stopped">',
        'td_started' => '<td class="started">',
        'td_error' => '<td class="error">',
        'row_start' => '<tr class="odd">',
        'row_end' => '</tr>',
        // depending of the table a nowrap attribute may be interesting.
        'cell_start' => '<td style="text-align:left; white-space:nowrap;">',
        'cell_end' => '</td>',
        'row_alt_start' => '<tr class="even">',
        'row_alt_end' => '</tr>',
        'cell_alt_start' => '<td style="text-align:left;">',
        'cell_alt_end' => '</td>',
        'vert_table_row_start' => '<td class="mytablesubheader" style="text-align:right;" width="35%">',
        'vert_table_row_start_no_footer' => '<td class="mytablesubheader ui-corner-bl" style="text-align:right;" width="35%">',
        'table_close' => '', // please don't modify use my_table_close
        // instead
        'my_table_open' => '',
        'my_table_close' => '',
        // theirs following settings are not CodeIgniter Tablle Class
        // related.
        'form_open' => '<span id="%s" style="display: inline-block;%s"><form action="%s" method="%s" enctype="multipart/form-data">',
        'hidden_input' => '<div style="display:none"><input type="hidden" name="%s" value="%s" /></div>',
        'button' => '<input  value="%s" type="submit" class="ui-state-default ui-corner-all">',
        'confirm' => '<input  value="%s" type="button" onclick="safe_handle_confirm_button(this);" class="ui-state-default ui-corner-all" >',
        'create' => '<input  value="%s" type="button" onclick="safe_handle_create_button(this);" class="ui-state-default ui-corner-all" >',
        'form_close' => '</form></span>',
        // footing can be not save number of column
        'footing_table_open' => '</table><div class="mytablelegend">',
        'footing_table_close' => '</div>',
        'footing_row_start' => '',
        'footing_row_end' => '',
        'footing_cell_start' => '',
        'footing_cell_end' => '',
        /* wadam - remove and use div
        'footing_table_open' => '<table width="100%" class="mytable">',
        'footing_row_start' => '<tr>',
        'footing_row_end' => '</tr>',
        'footing_cell_start' => '<td class="mytablelegend"  colspan="%s" align="center">',
        'footing_cell_end' => '</td>',
        'footing_table_close' => '</table>',*/
    );
    protected $_table_title = "";
    /**
     * Sets the table title and passes back to the controller to set in the view
     *
     * @param String $table_title:
     *                              					Contains the table title
     *                              
     * @return String $table_title
     */
    public function set_title($table_title = "")
    {
        $this->_table_title = $table_title;
        return $this->_table_title;
    }
    private $empty_array = array();
    private function _append_html_arguments(&$arguments, $append_arguments)
    {
        $string_arguments = '';
        foreach (array(
            $arguments,
            $append_arguments
        ) as $s) {
            if (!empty($s)) if (is_array($s)) foreach ($s as $k => $v) $string_arguments.= "$k='$v' ";
            else if (is_string($s)) $string_arguments.= "$s ";
        }
        $arguments = $string_arguments;
        return $string_arguments;
    }
    private function _append_class(&$classs, $append_classs)
    {
        $string_classs = '';
        foreach (array(
            $classs,
            $append_classs
        ) as $s) {
            if (!empty($s)) {
                if (is_array($s)) foreach ($s as $k) $string_classs.= "$k ";
                else if (is_string($s)) $string_classs.= "$s ";
            }
        }
        $classs = $string_classs;
        return $string_classs;
    }
    public function set_footer($html)
    {
        $this->footer = $html;
    }
    public function set_form_method($method = 'post')
    {
        $this->form_method = $method;
    }
    /**
     * Generate html of a button
     *
     * @param $button           array 
     *                                  $button['url']: the link of the button
     *                                  $button['label']: the text before button (optional)
     *                                  $button['name']: the text on the button
     *                                  $button['extra_arguements'] : Extra arguements required for the button
     *                                  $button['extra_class'] : Any extra CSS class that would need to be applied to the button
     *                                  $button['type'] : use for confirm button 
     * @param id_and_append_url string
     * @return string           
     */
    public function button($button, $id_and_append_url = null, $extra_arguments = '', $extra_class = '', $show = true)
    {
        if (!empty($button['type']) && isset($this->template[$button['type']]))
        {//special button with confirm
            $template_button = $this->template[$button['type']];
        }else{
            $template_button = $this->template['button'];
        }
        $template_form_open = $this->template['form_open'];
        if (!empty($extra_arguments) || isset($button['extra_arguements'])) {
            $arguments = '';
            if (isset($button['extra_arguements'])) $extra_arguments = $button['extra_arguements'];
            $this->_append_html_arguments($arguments, $extra_arguments);
            $template_button = preg_replace('/(<input\s+)/i', "$1" . $arguments, $template_button);
        }
        if (!empty($extra_class)) {
            $class = '';
            $this->_append_class($class, $extra_class);
            if (preg_match("/class=/i", $template_button)) $template_button = preg_replace('/(class=[\'"])/i', "$1$class", $template_button);
            else $template_button = preg_replace('/(<input\s+)/i', "$1" . $class, $template_button);
        }
        $html = sprintf($template_form_open, $id_and_append_url, ($show ? '' : ' display:none; ') , $button['url'] . '/' . $id_and_append_url, $this->form_method);
        if (!empty($button['label'])) $html.= '<Label>' . $button['label'];
        $html.= sprintf($template_button, htmlentities($button['name']));
        if (!empty($button['label'])) $html.= '</label>';
        $html.= $this->template['form_close'];
        return $html;
    }
    public function __construct()
    {
        $CI = & get_instance();
        $CI->load->library('Table');
        $this->table = & $CI->table;
        $this->table->set_template($this->template);
    }
    public function set_template()
    {
        $this->table->set_template($this->template);
    }
    private function convert_heading()
    {
        if (!empty($this->config)) {
            $this->heading = array();
            foreach ($this->config as $c) $this->heading[] = $c['label'];
        }
    }
    private function generate_heading()
    {
        $this->convert_heading();
        if (!is_array($this->heading) || empty($this->heading)){
            return $this->empty_array;
        }
        if (count($this->line_button) > 0){
            // add a colunm for line button
            if (isset($this->heading_button)){
                $this->heading[] = $this->heading_button;
            }else{
                $this->heading[] = '';
            }
        }
        return $this->heading;
    }
    private function _append_style(&$style, $append_style)
    {
        $string_style = '';
        foreach (array(
            $style,
            $append_style
        ) as $s) {
            if (is_array($s)) foreach ($s as $k => $v) $string_style.= "$k:$v; ";
            else if (is_string($s)) $string_style.= " $s";
        }
        return $style = $string_style;
    }
    public function _get_data_cell_with_config(&$cell, $data, $cell_config, $pk = 0, $colunm_name = 0)
    {
        if (!is_array($data)) $cell_data = $data;
        else $cell_data = (isset($data[$cell_config['path']]) ? $data[$cell_config['path']] : '');
        $cell['data'] = '';
        switch ($cell_config['type']) {
        case 'boolean':
        case '!boolean':
            if (isset($cell_config['type_data'])) $type_data = explode('|', $cell_config['type_data']);
            else $type_data = array(
                '',
                'X'
            );
            if ($cell_config['type'] == '!boolean') list($type_data[1], $type_data[0]) = array(
                $type_data[0],
                $type_data[1]
            );
            if (isset($cell_config['type_style'])) {
                $type_style = explode('|', $cell_config['type_style']);
                if ($cell_config['type'] == '!boolean') $type_style = (empty($cell_data) ? $type_style[1] : $type_style[0]);
                else $type_style = (empty($cell_data) ? $type_style[0] : $type_style[1]);
                $this->_append_style($cell['style'], $type_style);
                // TODO: id
                
            }
            $cell['data'] = (empty($cell_data) ? $type_data[0] : $type_data[1]);
            break;

        default:
            $cell['data'] = $cell_data;
        }
    }
    private function _get_config_by_field($field)
    {
        foreach ($this->config as $column_config) {
            if (isset($column_config['field']) && $column_config['field'] == $field) return $column_config;
        }
        return $this->empty_array;
    }
    private function _get_data_by_path($data_line, $path, $line_name = '')
    {
        if ($path == '/' or empty($path)) return $line_name;
        return (isset($data_line[$path]) ? $data_line[$path] : false);
    }
    private function _get_data_by_field($data_line, $field, $line_name = '')
    {
        $conf = $this->_get_config_by_field($field);
        $path = $conf['path'];
        return $this->_get_data_by_path($data_line, $path, $line_name);
    }
    /**
     * @param mixed      $line_data
     * @param string|int $line_root
     * @param boolean    $only_line
     * @param string|int $pk       
     * @throws Exception 
     * @return multitype:
     */
    public function &convert_data_line($line_data, $line_root = '', $only_line = true, $line_num = 0)
    {
        // if (! empty ( $this->config )) {
        if ($only_line) {
            $this->data = array();
            $this->primary_key = array();
        }
        $table_line = array();
        if (empty($this->config)) throw new Exception("No config in Safe_table please provide a config or run create_config()");
        // Get the real primary key if it set or take the line number
        $pk = $line_num;
        foreach ($this->config as $column_config) if (isset($column_config['primary_key']) && $column_config['primary_key']) if (empty($cell_config['path']) || $cell_config['path'] == '/') $pk = $line_root;
        else {
            $pk = (isset($line_data[$cell_config['path']]) ? $line_data[$cell_config['path']] : '');
        }
        $this->primary_key[] = $pk;
        foreach ($this->config as $column_config) {
            $cell = array();
            $cell['id'] = $pk . '--' . $column_config['field'];
            if (isset($column_config['style'])) $this->_append_style($cell['style'], $column_config['style']);
            if ($column_config['path'] == '/') {
                $this->_get_data_cell_with_config($cell, $line_root, $column_config, $pk, $column_config['field']);
            } else {
                $this->_get_data_cell_with_config($cell, $line_data, $column_config, $pk, $column_config['field']);
            }
            unset($column_config['field']);
            unset($column_config['path']);
            unset($column_config['label']);
            unset($column_config['type']);
            unset($column_config['type_data']);
            unset($column_config['type_style']);
            unset($column_config['primary_key']);
            unset($column_config['id']);
            unset($column_config['style']);
            foreach ($column_config as $k => $v) $cell[$k] = $v;
            $table_line[] = $cell;
            //$i++;
            
        }
        if (count($this->line_button) > 0) {
            $html0 = "";
            foreach ($this->line_button as $button) {
                $extra_argument = "";
                $extra_class = "";
                $show = true;
                if (isset($button['show']) || isset($button['hide'])) {
                    $show = (isset($button['show']) ? true : false);
                    $field = (isset($button['show']) ? $button['show'] : $button['hide']);
                    if (!$this->_get_data_by_field($line_data, $field)) $show = !$show;
                }
                if (isset($button['class'])) $this->_append_class($extra_class, $button['class']);
                $temp_button = $button;
                unset($temp_button['url']);
                unset($temp_button['label']);
                unset($temp_button['name']);
                unset($temp_button['show']);
                unset($temp_button['hide']);
                unset($temp_button['class']);
                $this->_append_html_arguments($extra_argument, $temp_button);
                $html0.= $this->button($button, $pk, $extra_argument, $extra_class, $show);
            }
            $table_line[] = $html0;
        }
        $this->data[] = $table_line;
        return $this->data;
    }
    public function &convert_data($data)
    {
        // TODO: if no data put a empty cell
        try {
            $this->data = array();
            $this->primary_key = array();
            if (!empty($data)) {
                $i = 0;
                foreach ($data as $k => $v) {
                    $this->convert_data_line($v, $k, false, $i);
                    $i++;
                }
            } else {
                throw new Exception('Empty $data');
            }
        }
        catch(Exception $e) {
            safe_add_error(__FUNCTION__ . ": ERROR :" . $e->getMessage() , true);
            return $this->empty_array;
        }
        return $this->data;
    }
    public function generate_data()
    {
        $data = array(
            'heading' => $this->heading,
            'row' => array(
                'data' => $this->data,
                'key' => $this->primary_key,
                'button' => $this->line_button,
            ),
            'footer' => array(
                'button' => $this->footer_button,
                'data' => $this->footer,
            ),
        );

        return $data;
    }
    protected function _data_formatter_none($data)
    {
        return $data;

    }
    protected function _data_formatter_pre($data, $recurse=false)
    {
        $html = '';
        if(!$recurse){
            $html = '<pre>';
        }
        if(is_array($data)){
            foreach($data as $d){
                if(is_array($d)){
                    $html .= $this->_data_formatter_pre($d, true);
                }else{
                    $html .= $data.PHP_EOL;
                }
            }
        }else{
            $html .= htmlentities($data);
        }

        if(!$recurse){
            $html .= '</pre>';
        }
        return $html;
    }
    protected function _data_formatter_list($data, $style='none', $recurse=false)
    {
        $padding = ($recurse)?'':' padding: 0px; margin: 0px;';
        $html = '<ul style="list-style-type:'.$style.'; '.$padding.';">';
        foreach($data as $d){
            if(is_array($d)){
                $html .= $this->_data_formatter_list($d, $style, true);
            }else{
                $html .= '<li>';
                $html .= htmlentities($d);
                $html .='</li>';
            }
        }
        $html .= '</ul>';
        return $html;
    }
    public function generate(&$raw_data = null)
    {
        $html = "";
        $array_html = "";
        $skip = false;
        if (empty($this->template['table_open']) && !empty($this->template['my_table_open'])){
            $html.= $this->template['my_table_open'];
        }
        $heading = $this->generate_heading();
        if (!empty($heading)){
            $this->table->set_heading($heading);
        }
        $i = 0;
        if ($this->data) {
            //$this->line_button is an array of arrays which contain buttons per line.
            foreach ($this->data as $l) {
                // XSS filter on all data but buttons
                if($this->apply_data_formatter){
                    $filtered_l = array();
                    $j = 0;
                    foreach($l as $v){
                        // Use data + style... format ?
                        $tmp_v = null;
                        if($v['data']){
                            $tmp_v = $v;
                            $v = $tmp_v['data'];
                        }
                        $filtered_v = '';
                        // Check is data_style associated with this entry?
                        if($this->data_formatter[$j]){
                            $_formatter = '_data_formatter_'.$this->data_formatter[$j];
                            if(method_exists($this, $_formatter)){
                                $filtered_v = call_user_func(array($this, $_formatter),$v);
                            }else{
                                $filtered_v = $this->_data_formatter_pre($v);
                            }
                        }elseif(is_array($v)){
                            $filtered_v = $this->_data_formatter_list($v);
                        }else{
                            $filtered_v = htmlentities($v);
                        }
                        $j++;
                        // Put back in data + style ... format
                        if($tmp_v){
                            $tmp_v['data'] = $filtered_v;
                            $filtered_v = $tmp_v;
                        }
                        $filtered_l[] = $filtered_v;
                    }
                    $l = $filtered_l;
                }
                // proceed with buttons
                if (!empty($this->line_button) && count($this->line_button[$i]) > 0) {
                    $html0 = "";
                    $html0.= "<div id='buttons" . $i . "' style='float:right;'>";
                    foreach ($this->line_button[$i] as $button) {
                        if (isset($button['extra_arguements']) && isset($button['extra_class'])){
                            $html0.= $this->button($button, (!empty($this->primary_key[$i]) ? $this->primary_key[$i] : '') , $button['extra_arguements'], $button['extra_class']);
                        }elseif (isset($button['extra_arguements'])){
                            $html0.= $this->button($button, (!empty($this->primary_key[$i]) ? $this->primary_key[$i] : '') , $button['extra_arguements'], '');
                        }elseif (isset($button['extra_class'])){
                            $html0.= $this->button($button, (!empty($this->primary_key[$i]) ? $this->primary_key[$i] : '') , '', $button['extra_class']);
                        }else{
                            $html0.= $this->button($button, (!empty($this->primary_key[$i]) ? $this->primary_key[$i] : ''));
                        }
                    }
                    $html0.= "</div>";
                    $l[] = $html0;
                }
                if (is_array($l) && count($l[0]) > 2) {
                    $array_html = '<pre style="white-space: pre-wrap;white-space: -moz-pre-wrap;white-space: -pre-wrap;white-space: -o-pre-wrap;word-wrap: break-word;">';
                    foreach ($l[0] as $value){
                        $array_html.= $value . "<br />";
                    }
                    $array_html.= '</pre>';
                    $this->table->add_row($array_html);
                } else{
                    $this->table->add_row($l);
                }
                $i++;
            }
        }else{
            $this->table->add_row(
                array(
                    'data' => 'No '. $this->_table_title,
                    'colspan' => '100%',
                    'style' => 'text-align: center; font-weight: normal; font-style: italic;'
                )
                );
        }
        if(null !== $raw_data){
            $raw_data = $this->table->rows;
        }
        $html.= $this->table->generate();
        if (empty($this->template['table_close']) && !empty($this->template['my_table_close'])) $html.= $this->template['my_table_close'];
        if (count($this->footer_button)) {
            if (count($this->footer_button) > 1) $html.= $this->generate_multiple_button_footing_table($this->footer_button);
            else {
                foreach ($this->footer_button as $button) {
                    $html.= $this->generate_footing_table($this->button($button));
                }
            }
        } elseif (isset($this->footer)) {
            $html.= $this->generate_footing_table($this->footer);
        }
        return $html;
    }
    public function &get_line(&$data, $pk)
    {
        if (!empty($this->config)) {
            foreach ($this->config as $c) {
                if (isset($c['primary_key']) && $c['primary_key']) if ($c['path'] == '/') $path = '';
                else $path = $c['path'];
            }
            foreach ($data as $k => $v) {
                if ($path == '') {
                    if ($k == $pk) {
                        return $data[$k];
                    }
                } elseif ($v[$path] == $pk) return $data[$k];
            }
        }
        return $this->empty_array;
    }
    public function delete_line(&$data, $pk)
    {
        // TODO: return tue if delete
        if (!empty($this->config)) {
            foreach ($this->config as $c) {
                if (isset($c['primary_key']) && $c['primary_key']) if ($c['path'] == '/') $path = '';
                else $path = $c['path'];
            }
            foreach ($data as $k => $v) {
                if ($path == '') {
                    if ($k == $pk) {
                        unset($data[$k]);
                        return;
                    }
                } elseif ($v[$path] == $pk) {
                    unset($data[$k]);
                    return;
                }
            }
        }
        // TODO: delete line if no config
        
    }
    public function generate_vertical_line_table($pk_label, $pk, $line)
    {
        extract($this->template);
        //$html = $table_open . $row_start . $heading_cell_start;
        $html = $table_open . $row_start;
        //$html .= htmlentities ( $pk_label );
        //$html .= $heading_cell_end . $heading_cell_start;
        //$html .= htmlentities ( $pk );
        //$html .= $heading_cell_end . $heading_row_end;
        foreach ($line as $k => $v) {
            //echo "Key = $k, value = $v<br />";
            $html.= $row_start . $vert_table_row_start;
            //$html .= $row_start . $cell_start;
            $html.= htmlentities($k);
            $html.= $cell_end . $cell_start;
            if (is_array($v)) {
                foreach ($v as $value) $html.= htmlentities($value) . '<br />';
            } elseif (!is_array($v)) {
                if (preg_match("'\binput\b'", $v)) $html.= $v;
                elseif (preg_match("'\bfont\b'", $v)) $html.= $v;
                else $html.= htmlentities($v);
            }
            $html.= $cell_end . $row_end;
        }
        $html.= $row_start;
        // Figure out if footer follows
        $table_footer = "";
        if (count($this->footer_button) > 0) {
            if (count($this->footer_button) > 1) $table_footer.= $this->generate_multiple_button_footing_table($this->footer_button);
            else {
                foreach ($this->footer_button as $button) {
                    $table_footer.= $this->generate_footing_table($this->button($button));
                }
            }
        } else if (isset($this->footer)) {
            $table_footer.= $this->generate_footing_table($this->footer);
        }
        if(empty($table_footer)) {
            $html.= $vert_table_row_start_no_footer;
        } else {
            $html.= $vert_table_row_start;
        }
        $html.= htmlentities('');
        $html.= $cell_end . $cell_start;
        $i = 0;
        if (!is_array($this->primary_key)) {
            $key[] = '';
            $this->primary_key = $key;
        }
        if (!empty($this->line_button) && count($this->line_button[$i]) > 0) {
            foreach ($this->line_button as $temp_button){
                foreach ($temp_button as $button) {
                    if (!empty($this->primary_key[$i])) {
                        $pk = $this->primary_key[$i];
                    }else{
                        $pk = '';
                    }
                    //echo "pk= " .$pk . "<br />";
                    //(!empty($this->primary_key [$i])?$this->primary_key [$i]:'')
                    if (isset($button['extra_arguements']) && isset($button['extra_class'])){
                        $html.= $this->button($button, $pk, $button['extra_arguements'], $button['extra_class']);
                    } elseif (isset($button['extra_arguements'])) {
                        $html.= $this->button($button, $pk, $button['extra_arguements'], '');
                    } elseif (isset($button['extra_class'])) {
                        $html.= $this->button($button, $pk, '', $button['extra_class']);
                    } else {
                        $html.= $this->button($button, $pk);
                    }
                    $i++;
                }
            }
        }
        $html.= $cell_end . $row_end;
        $html.= $table_close;
        $html.= $table_footer;
        if (empty($this->template['table_close']) && !empty($this->template['my_table_close'])) $html.= $this->template['my_table_close'];
        return $html;
    }
    public function generate_footing_table($content, $use_htmlentities = false)
    {
        if(empty($content))
            return "";
        if (!is_array($content)) {
            $content = array(
                $content
            );
        }
        extract($this->template);
        $html = $footing_table_open . $footing_row_start;
        $html.= $footing_cell_start;
        foreach ($content as $v) {
            if ($use_htmlentities) $html.= htmlentities($v);
            else $html.= $v;
        }
        $html.= $footing_cell_end;
        $html.= $footing_row_end . $footing_table_close;
        return $html;
    }
    public function generate_multiple_button_footing_table($content, $use_htmlentities = false)
    {
        extract($this->template);
        $html = $footing_table_open . $footing_row_start;
        $html.= $footing_cell_start;
        foreach ($content as $v) {
            if ($use_htmlentities) $html.= htmlentities($v);
            else $html.= $this->button($v);
        }
        $html.= $footing_cell_end;
        $html.= $footing_row_end . $footing_table_close;
        return $html;
    }
}
/* End of file safe_table_class.php */
