#!/usr/bin/env python

# Copyright (C) 2014  Sangoma Technologies Corp.
# All Rights Reserved.
#
# Author(s):
# Leonardo Lang <lang@sangoma.com>

import os
import re
import fileinput
import sys

CFGFILE = '/etc/sysconfig/snmpd'
TMPFILE = CFGFILE + '.new'

RE_LINE = re.compile('^([#] )?OPTIONS=["]([^"]+)["]')
RE_ARGS = re.compile('[ ]?((([^-]|([-][^L]))+)|([-]L([^ ]|[ ][^-])+))')
RE_SLOG = re.compile('L[ ]?[Ss]')

GRP_ARGLST = 2

GRP_ANYARG = 1
GRP_LOGARG = 5

SYSLOG_ARG = '-LS 0-4 d'

try:
    rdfd = open(CFGFILE)
    wrfd = open(TMPFILE, 'w')

    sys.stdout.write('processing %s for log statements\n' % CFGFILE)
    sys.stdout.flush()

    for line in rdfd.readlines():
        m1 = RE_LINE.match(line.strip())

        if m1 is None:
            wrfd.write(line)
            sys.stdout.write('keeping as-is: %s\n' % line.strip())
            continue

        arglist = []
        currpos = 0
        arglogs = False

        while len(m1.group(GRP_ARGLST)) <> currpos:
            argstr = m1.group(GRP_ARGLST)[currpos:]

            sys.stdout.write('checking "%s"...\n' % argstr)
            sys.stdout.flush()
            m2 = RE_ARGS.search(argstr)

            if m2 is None:
                raise Exception('unable to run match on argument "%s"' % argstr)
                break

            if m2.group(GRP_LOGARG) is not None:
                if RE_SLOG.search(m2.group(GRP_LOGARG)) is not None:
                    if m2.group(GRP_LOGARG) <> SYSLOG_ARG:
                        sys.stdout.write('replacing syslog argument: "%s" with "%s"\n' % (m2.group(GRP_LOGARG), SYSLOG_ARG))
                    else:
                        sys.stdout.write('syslog argument already set to "%s"\n' % m2.group(GRP_LOGARG))

                    sys.stdout.flush()

                    arglist.append(SYSLOG_ARG)
                else:
                    sys.stdout.write('keeping log argument as-is: "%s"\n' % m2.group(GRP_LOGARG))
                    arglist.append(m2.group(GRP_LOGARG))

                currpos += m2.end(GRP_LOGARG)
                continue

            if m2.group(GRP_ANYARG) is not None:
                sys.stdout.write('found argument: "%s"\n' % m2.group(GRP_ANYARG))
                arglist.append(m2.group(GRP_ANYARG))
                currpos += m2.end(GRP_ANYARG)

        wrfd.write('OPTIONS="%s"\n' % (' '.join(arglist)))

    rdfd.close()
    wrfd.close()

    try:
        os.rename(TMPFILE, CFGFILE)
        sys.stdout.write('processing done!\n')
        sys.stdout.flush()

    except OSError, e:
        sys.stderr.write('unable to move %s to %s: %s' % (TMPFILE, CFGFILE, str(e)))


except Exception, e:
    sys.stderr.write('unable to process %s: %s' % (CFGFILE, str(e)))
    sys.exit(1)

sys.exit(0)
