# !bin/sh
# Author: Jean-Philippe Boily, jr. eng.
# Date: 13/06/2011
# Description: 
#
# Add to /etc/sudoers file the folders where webconfig process needs to be
# granted read/write privileges.
#
# Parameters:
# $1 - product name
# $2 - product's sudoers configuration file
#
# Return codes:
# 0 - configuration completed
# 1 - sudoers file is missing
# 2 - application sudoers configuration file is missing
# 3 - unable to complete configuration
sudoersTmpFile=/tmp/sudoers.new
appSudoersConf=$2
webconfigAccessStr="webconfig ALL=NOPASSWD: "

echo "Adding $1 rights to sudoers file."

# /etc/sudoers.tmp file exists
if [ -f "/etc/sudoers.tmp" ]; then
  echo "sudoers file is locked! (/etc/sudoers.tmp)"
  exit 1
fi

# Lock sudoers by creating the /etc/sudoers.tmp file
touch /etc/sudoers.tmp

# Create a sudoers tmp file
if [ -f "$sudoersTmpFile" ]; then
  echo "Overwritting file $sudoersTmpFile"
fi

cp /etc/sudoers /tmp/sudoers.new

# application sudoers.conf file exists
if [ ! -f "$2" ]; then
  echo "Unable to find $1 sudoers configuration file $2"
  exit 2
fi

# Loop through appSudoersConf and add an entry for each of the files if they are
# not in sudoersFile."
while read line
do
  if [ ! `expr substr "$line" 1 1` == "#" ] ; then
    isLineInBackupFile=$(grep -m1 -F "$webconfigAccessStr$line" < $sudoersTmpFile)
    if [ ${#isLineInBackupFile} == 0 ]; then
      echo $webconfigAccessStr$line >> $sudoersTmpFile
    fi
  fi
done < $appSudoersConf

# Validate new sudoers file uisng visudo
visudo -c -f $sudoersTmpFile
if [ ! "$?" -eq "0" ]; then
  echo "New sudoers file $sudoersTmpFile is invalid"
  exit 3
fi

cp $sudoersTmpFile /etc/sudoers
rm /etc/sudoers.tmp

