<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/**
 * coding: utf-8: *
 */
/*
 * Copyright (C) 2012 Sangoma Technologies Corp. All Rights Reserved. Author(s)
 * your name <your_name@sangoma.com> This code is Sangoma Technologies
 * Confidential Property. Use of and access to this code is covered by a
 * previously executed non-disclosure agreement between Sangoma Technologies and
 * the Recipient. This code is being supplied for evaluation purposes only and
 * is not to be used for any other purpose.
 */
/**
 * FS Distributor Config wrapper page
 * 
 * @author Kent <khong@sangoma.com>
 *        
 */
if (! defined ( 'BASEPATH' ))
    exit ( 'No direct script access allowed' );
require_once ('application/helpers/safe_helper.php');
safe_require_controller ( 'sng', 'config_manager' );
class Fs_certificate_config_manager extends Sng_config_manager {
    public function __construct() {
        parent::__construct ();
    }
    public function index() {
        return $this->modify ( 'certificate' );
    }
    /**
     * Displays ca certificate information
     * 
     * @param string $cfg_obj
     *            Certificate name to display
     */
    public function view($module_name, $obj_type, $obj_name) {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name ( $module_name );
        // Get config object
        $cfg_obj = $module->config ();
        $description = $module->description ();
        // Prepare redirect urls
        if ($module->has_aggregate_objects ()) {
            $redirect_url = '/modify/' . $module_name;
        }
        
        // gets aggregated object based on the url. If editing aggregated
        // object, set cfg_obj to the aggregated object configuration
        if ($obj_type && $obj_name) {
            $aggr_obj = $module->get_aggregate_objects ( $obj_type );
            $cfg_obj = $aggr_obj [$obj_name];
            $description = $module->description () . ' - ' . $module->aggregate_object_name ( $obj_type ) . ' - ' . $obj_name;
            if ($cfg_obj) {
                if ($cfg_obj->has_aggregate_objects ()) {
                    $redirect_url = '/modify/' . $module_name . '/' . $obj_type . '/' . $obj_name;
                }
                $module = $cfg_obj;
                // Same mechanism if editing a sub object
                if ($sub_type && $sub_name) {
                    $description = $module->aggregate_object_name ( $sub_type ) . ' ' . $sub_name;
                    $aggr_obj = $module->get_aggregate_objects ( $sub_type );
                    $cfg_obj = $aggr_obj [$sub_name];
                }
            }
        }
        
        // Set the basic data
        $data ['page_title'] = $description . ' Configuration';
        $data ['page_summary'] = 'This page allows managing ' . $description . ' Configuration.';
        $data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        
        // Prepare table structure
        $data ['table_size'] = '100%';
        
        $table = new Safe_crud_table_class ();
        
        // Prepare heading
        $table->set_headings ( array (
                'Certificate Name' 
        ) );
        $table->set_controller_url ( base_url ( $this->router->fetch_class () ) );
        
        // Re-create certificate to run openssl command on it
        $retCode = "";
        if ($cfg_obj) {
            $cfg_obj_data = $cfg_obj->get_data_values ( false );
            $data ['table_title'] = $table->set_title ( $description . '-' . $cfg_obj->name() );
            $table_line = array (
                    'Name' => $cfg_obj_data ["name"],
                    'Subject' => $cfg_obj_data ["subject"],
                    'Issuer' => $cfg_obj_data ['issuer'],
                    'Expires' => $cfg_obj_data ['expires'],
                    '' => $table->create_button ( false, 'Back', $button_css_class = '', '' ) 
            );
        } else {
            $data ['table_title'] = $table->set_title ( $description );
            $table_line = array (
                    'Error' => $description . ' obj not found!',
                    '' => $table->create_button ( false, 'Back', $button_css_class = '', '' ) 
            );
        }
        // Generate table HTML code
        $data ['table'] = $table->generate_vertical_line_table ( '', $obj_name, $table_line );
        $this->load->view ( "safe_header", $data );
        $this->load->view ( "safe_table", $data );
        unset ( $table );
        
        if ($cfg_obj) {
            $table = new Safe_crud_table_class ();
            // Prepare heading
            safe_sudo_exec ( 'touch /tmp/file.pem' );
            Safe_sudo_exec ( '/bin/chown webconfig /tmp/file.pem' );
            safe_sudo_exec ( '/bin/chmod 655 /tmp/file.pem' );
            file_put_contents ( '/tmp/file.pem', base64_decode ( $cfg_obj_data ['certificate-file-contents'] ) );
            $pem = safe_sudo_exec ( '/usr/bin/openssl x509 -in /tmp/file.pem', '-noout -text', $retCode );
            @unlink ( '/tmp/file.pem' );
            $data ['table_title'] = $table->set_title ( 'PEM Contents' );
            $table->set_headings ( array (
                    '' 
            ) );
            $table->add_row ( array (
                    $pem 
            ), '', '', '' );
            $data ['table'] = $table->generate_table ();
            $this->load->view ( "safe_table", $data );
        }
        $this->load->view ( "safe_footer", $data );
    }
}
