<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/**
 * FS Call Admission Control Base Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'ipaddr_cac_condition');
safe_module_require_class('fs', 'user_cac_condition');
class Fs_cac_sip_profile_param_class extends Safe_configurable_object_class
{
    public $_sip_profile_profiles;
    public $_the_product;
    public $_the_app;
    public $_parent_name = null;
    public $_parent_cac_profile = null;
    public function __construct($name = null, $parent_cac_profile = null)
    {
        if($name != null){
            if($parent_cac_profile != null){
                $this->_parent_name = $parent_cac_profile->name();
                $this->_parent_cac_profile = $parent_cac_profile;
            }
            parent::__construct('',$name);
        }
    }
    public function configure($profile)
    {
        $this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all sip_profile Profiles
        $this->_cac_rules = $this->_the_app->cac_rules(); //Holds all cac_rules
        if($this->_parent_name == null){
            $this->_parent_name = $profile->name();
            $this->_parent_cac_profile = $profile;
        }
        $cac_profile = $this->_parent_cac_profile;
        $def_name = array();
        $names = array();
        $config = $cac_profile->get_data_values();
        //Set sip profiles
        if (isset($this->_sip_profiles)) {
            foreach ($this->_sip_profiles as $profile) {
                if (isset($profile)) {
                    $names[$profile->name()] = $profile->name();
                }
            }
        }
        foreach ($config['sip-profiles'] as $sip_profile) {
            foreach ($this->_sip_profiles as $profile) {
                if (isset($profile)) {
                    if (trim(strtolower($profile->name())) == trim(strtolower($sip_profile))) $def_name[$profile->name()] = $profile->name();
                }
            }
        }
        $this->add_multiple_field('sip-profiles', '', 'checkbox', $def_name, $names);
        $this->set_field_rules('sip-profiles', 'callback_check_sip_profiles['. implode(',',$names) .']');
    }

    public function get_data_value($field){
        if($field == 'name'){
            return $this->name();
        }else{
            return null;
        }
    }
    public function set_data_values($data){
        if($this->_parent_cac_profile){
            $temp = $this->_parent_cac_profile->get_data_values();
            parent::set_data_values($data);
            if (isset($data['sip-profiles'])) {
                foreach ($data['sip-profiles'] as $sip_profile) {
                    if(in_array(trim($sip_profile),$temp['sip-profiles'])){
                        continue;
                    }else{
                        $temp['sip-profiles'][] = trim($sip_profile);
                    }
                }
            }
            $this->_parent_cac_profile->set_data_values($temp);
            return true;
        }else{
            return false;
        }
    }
    public function synch(){
        return;
    }
    public function save(){
        if($this->_parent_cac_profile){
            return $this->_parent_cac_profile->save();
        }else{
            return false;
        }
    }
    public function dispose(){
        if($this->_parent_cac_profile){
            $cac = $this->_parent_cac_profile;
            $profile = $cac->get_data_values();
            $temp['sip-profiles'] = array();
            for ($a = 0; $a < count($profile['sip-profiles']); $a++) {
                if ($profile['sip-profiles'][$a] != $this->name()) $temp['sip-profiles'][] = $profile['sip-profiles'][$a];
            }
            $cac->set_data_values($temp);
            return $cac->save();
        }else{
            return false;
        }
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = array("SIP Profile" => $this->name());
        return array('data' => $table_line);
    }
    public function validate($data, &$output){
        unset($data['profile-name']);
        unset($_POST['profile-name']);
        return parent::validate($data, $output);
    }
    public function check_sip_profiles($field_name, $sip_profile_list = null){
        if($sip_profile_list &&  0 != strlen($sip_profile_list)){
            $sip_profiles = explode(',',$sip_profile_list);
            $new_sip_profiles = parent::get_data_value('sip-profiles',false);
            foreach($new_sip_profiles as $new_sip_profile){
                if(trim($new_sip_profile)!=''  && !in_array(trim($new_sip_profile),$sip_profiles))
                {
                    return array('check_sip_profiles' => 'Unable to bind the sip profile: '.$new_sip_profile);
                }
            }
            return true;
        }
    }
}
class Fs_cac_rule_class extends Safe_configurable_object_class
{
    private $_sip_profiles;
    private $_conditions;
    /**
     * @brief 
     *
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *
     * @return 
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief 
     *
     * @return 
     */
    public function configure()
    {
        $this->add_field('description', 'Description', 'text', '',60);
        //Adds hidden record in db to hold sip-profiles
        $def_name = array();
        $names = array();
        $config = $this->get_data_values();
        //Set sip profiles
        $sip_profiles = $this->_node->software()->application()->sip_profiles();
        if (isset($sip_profiles)) {
            foreach ($sip_profiles as $profile) {
                if (isset($profile)) {
                    $names[$profile->name()] = $profile->name();
                }
            }
        }
        if($config['sip-profiles']){
            foreach ($config['sip-profiles'] as $sip_profile) {
                foreach ($sip_profiles as $profile) {
                    if (isset($profile)) {
                        if (trim(strtolower($profile->name())) == trim(strtolower($sip_profile))) $def_name[$profile->name()] = $profile->name();
                    }
                }
            } 
        }
        
        $this->add_multiple_field('sip-profiles', 'SIP profiles', 'checkbox', $def_name, $names);
        
        // Register objects
        $this->register_aggregate_object('ipaddr', 
            array(
                'name' => 'IP Address Condition',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/ipaddr',
                'autoname' => true,
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a CAC IP Address Condition',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a CAC IP Address Condition',
                        'request' => 'POST',
                        ),
                    ),
            )
        );
        $this->register_aggregate_object('user', 
            array(
                'name' => 'User Condition',
                'dynamic' => true,
                'autoname' => true,
                'base_path' => $this->object_name() . '/user',
                'methods' => array(
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create a CAC User Condition',
                        'request' => 'POST',
                        ),
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a CAC User Condition',
                        'request' => 'GET',
                        ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => 'Update a CAC User Condition',
                        'request' => 'POST',
                        ),
                    'delete' => array(
                        'name' => 'Delete',
                        'description' => 'Delete a CAC User Condition',
                        'request' => 'POST',
                        ),
                    ),
            )
        );
        
        /*
        $this->register_aggregate_object('sip_profile',
                array(
                        'name' => 'SIP Profile',
                        'base_path' => $this->object_name() . '/sip_profile', // need to verify path
                        'dynamic' => true,
                        'controller' => array(
                                'config_manager' => array(
                                        'summary_buttons' => 'Delete[Unbind]:confirm',
                                        'allow_create_button' => 'Add[Bind]'
                                ),
                        ),
                        'autoname' => true,
                        'popup_add_form' => true,
                        'methods' => array(
                                'create' => array(
                                        'name' => 'Create',
                                        'description' => 'Bind a sip_profile',
                                        'request' => 'POST',
                                ),
                                'retrieve' => array(
                                        'name' => 'Retrieve',
                                        'description' => 'Retrieve a binded sip_profile',
                                        'request' => 'GET',
                                ),
                                'update' => array(
                                        'name' => 'Update',
                                        'description' => 'Update a binded sip_profile',
                                        'request' => 'POST',
                                ),
                                'delete' => array(
                                        'name' => 'Delete',
                                        'description' => 'Delete a binded sip_profile',
                                        'request' => 'POST',
                                ),
                        ),
                )
        );
        */

        return parent::configure();
    }

    public function get_aggregate_objects($type, $all=false){
        if($type == 'sip_profile'){
            $sip_profiles = $this->get_data_value('sip-profiles');
            $sip_profile_objs = array();
            if($sip_profiles){
                foreach($sip_profiles as $sip_profile_item){
                    $sip_profile_objs[$sip_profile_item] = new Fs_cac_sip_profile_param_class($sip_profile_item, $this);
                    $sip_profile_objs[$sip_profile_item]->configure($this->name());
                }
            }
            return $sip_profile_objs;
        }else{
            $definition = $this->get_aggregate_object_definition($type);
            if($definition['base_path']) {
                $objects = Safe_object_serializer_class::get_serializer()->find_objects($definition['base_path']);
                foreach ($objects as $k => $v) {
                    $obj = new $v['class']($this->node(), $definition['base_path'], $k);
                    $obj->configure();
                    $obj->synch();
                    $objects[$k] = $obj;
                }
                if($all){
                    $deleted = Safe_object_serializer_class::get_serializer()->find_deleted_objects($definition['base_path']);
                    foreach ($deleted as $k => $v) {
                        $obj = new $v['class']($this->node(), $definition['base_path'], $k);
                        $obj->configure();
                        $obj->unserialize();
                        $objects[$k] = $obj;
                    }
                }
                return $objects;
            }
            return null;
        }
    }
    /**
     * @brief 
     *
     * @return 
     */
    public function profile_binding()
    {
        return $this->get_data_value('sip-profiles', false);
    }
    /**
     * Pulls CAC conditions based on rule name and rule type
     *
     * @return array $_conditions
     *               							Array of conditions based on rule type and rule name
     */
    public function conditions($obj_type=null)
    {
        $conditions = array();
        if($obj_type) {
            $conditions = $this->get_aggregate_objects($obj_type);
        } else {
            $objs_def = $this->get_aggregate_object_definition();

            foreach($objs_def as $obj_type => $obj_def) {
                $tmp = $this->get_aggregate_objects($obj_type);
                if($tmp) {
                    $conditions = array_merge($conditions, $tmp);
                }
            }
        }

        return $conditions;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_ipaddr($name, $data=null, &$output = null) {
        $condition = new Fs_ipaddr_cac_condition_class($this->node(), $this->object_name() . '/ipaddr', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_ipaddr($name, $data=null, &$output = null) {
        $conditions = $this->conditions('ipaddr');
        return $conditions[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_ipaddr($name, $data=null, &$output = null) {
        $ipaddr = $this->api_retrieve_ipaddr($name);
        if($ipaddr) {
            if ($ipaddr->validate($data,$output)) {
                if (true == $ipaddr->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_ipaddr($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_ipaddr($name);
        if($condition) {
            if($condition->can_dispose($output)) {
                return $condition->dispose();
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_create_user($name, $data=null, &$output = null) {
        $condition = new Fs_user_cac_condition_class($this->node(), $this->object_name() . '/user', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_retrieve_user($name, $data=null, &$output = null) {
        $conditions = $this->conditions('user');
        return $conditions[$name];
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_update_user($name, $data=null, &$output = null) {
        $user = $this->api_retrieve_user($name);
        if($user) {
            if ($user->validate($data,$output)) {
                if (true == $user->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief 
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return 
     */
    public function api_delete_user($name, $data=null, &$output = null) {
        $condition = $this->api_retrieve_user($name);
        if($condition) {
            if($condition->can_dispose($output)) {
                return $condition->dispose();
            }
        }
        return false;
    }
    public function sip_profiles()
    {
        return $this->get_aggregate_objects('sip_profile');
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_sip_profile($name, $data=null) {
        $sip_profile = new Fs_cac_sip_profile_param_class($name, $this);
        $sip_profile->configure($this->name());
        if($data) {
            $sip_profile->set_data_values($data);
        }
        return $sip_profile;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_sip_profile($name, $data=null) {
        $sip_profiles = $this->sip_profiles();
        return $sip_profiles[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_sip_profile($name, $data=null, &$output = null) {
        $sip_profiles = $this->sip_profiles();
        if($sip_profiles[$name]) {
            if($sip_profiles[$name]->can_dispose($output)) {
                return $sip_profiles[$name]->dispose();
            }
        }
        return false;
    }
    //re define the add form for popup dialog
    public function new_fields(&$config_manager, $type)
    {
        if($type == 'sip_profile'){
            $name = Safe_object_serializer_class::build_unique_name($type);
            //add new sip_profile
            
            $config_manager->add_field('profile-name', 'Profile Name', 'hidden', $name, 50);
            $sip_profile_obj = new Fs_cac_sip_profile_param_class($name, $this);
            $sip_profile_obj->configure($this);
            $sip_profile_cfg = $sip_profile_obj->get_data();
            $def_name = array();
            $value_names = array();
            if(is_array($sip_profile_cfg['sip-profiles']['default'])){
                $def_name = array();
                foreach($sip_profile_cfg['sip-profiles']['default'] as $tmp_def){
                    $def_name[$tmp_def] = $tmp_def;
                }
            }
            if(is_array($sip_profile_cfg['sip-profiles']['value'])){
                $value_names = array();
                foreach($sip_profile_cfg['sip-profiles']['value'] as $tmp_val){
                    $value_names[$tmp_val] = $tmp_val;
                }
            }
            $config_manager->add_multiple_field('sip-profiles', '', $sip_profile_cfg['sip-profiles']['type'],$def_name ,$value_names);
            //pass by the edit form, save directly
            $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
        }else{
            parent::new_fields($config_manager, $type);
            $condition_number = count($this->get_aggregate_objects($type))+1;
            $new_name = ucfirst($type) . $condition_number;
            $config_manager->add_field('profile-name', 'New Rule Name', 'string', $new_name, 50);
        }
    }
    public function summary($type = 'horizontal' , $long = false){
        $settings = array();
        $table_line = array("Name" => $this->name());
        if($type == 'horizontal'){
            if(trim($this->get_data_value('description', false)) != ''){
                $table_line['Description'] = $this->get_data_value('description', false);
            }else{
                $table_line['Description'] = '';
            }
            $table_line['SIP Profiles'] = implode('<br>',$this->get_data_value('sip-profiles',false));
        }else{
            if(trim($this->get_data_value('description', false)) != ''){
                $table_line['Description'] = $this->get_data_value('description', false);
            }else{
                $table_line['Description'] = $this->description();
            }
            $table_line['SIP Profiles'] = $this->get_data_value('sip-profiles',false);
        }
        
        
        
        return array('data' => $table_line, 'settings' => $settings);
    }
    public function validate($data, &$output){
        unset($data['profile-name']);
        unset($_POST['profile-name']);
        if(!isset($data['sip-profiles'])){
            $data['sip-profiles'] = array();
        }else{
            foreach ($data['sip-profiles'] as $sip_profile) {
                $temp['sip-profiles'][] = trim($sip_profile);
            }
            unset($data['sip-profiles']);
            $data['sip-profiles'] = $temp['sip-profiles'];
        }
        return parent::validate($data, $output);
    }
}
?>
