# !bin/sh
#
# Author: Jean-Philippe Boily, jr. eng.
# Date: 15/06/2011
# Description:
#
# Install all the available updates for the installed version of the product.
# 
# Parameters:
# $1 - Yum configuration file path
# $2 - Product name
# $3 - repo type (base|patches|upgrades)
#
# Return code:
# 0 - No error
# 1 - update cmd failed
#
# Copyright: Sangoma Technologies Corp. 2011

yumConfPath=$1
prodName=$2
repoType=$3

sudo yum -y -c $yumConfPath --enablerepo=$prodName-$repoType update

rc=$?

if [ "$rc" -eq 1 ]; then
  echo "Failed to install software updates"
  exit 1
fi


