<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SAFe CI Controller Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_product_class');
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Safe_CI_Controller extends CI_Controller
{
    public $_the_product = null;
    public $_the_app = null;
    public $_services = null;
    public $_cfg_mgr = null;
    public function __construct()
    {
        //Need to authenticate before constructing the parent
        $this->authenticate();
        parent::__construct();
        //Global Variables used in most controllers. Can be overrided in controller classes
        $this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_services = $this->_the_product->local_node()->software()->services();
        $this->_cfg_mgr = $this->_the_product->local_node()->configuration_manager();
    }
    /**
     * @brief Proceed to authentication
     *
     * @return none
     */
    protected function authenticate()
    {
        safe_authenticate();
    }
}
?>
