# !bin/sh
#
# Author: Jean-Philippe Boily, jr. eng.
# Date: 09/06/2011
# Description:
#
# This script will extract a tarball package for a new license that needs to be
# applied to Netborder SS7 to VoIP Media Gateway and install the license files
# if they are valid.
#
# Parameters:
# $1 - New License Package file
# $2 - Current license file path
# $3 - Public key
#
# Return code:
# 0 - No error
# 1 - Could not extract license files
# 2 - License file is invalid
# 3 - Failed to copy license files
# 4 - Failed to remove extracted files
# 5 - Failed to create tmp dir
#
# Copyright: Sangoma Technologies Corp. 2011

tmpDir=/tmp/license_update

# Create temp extraction directory
if [ ! -d "$tmpDir" ]; then
  mkdir -p $tmpDir
  
  if [ ! $? == 0 ]; then
    exit 5
  fi
fi

# Extract license package to tmpDir
tar -xzf $1 -C $tmpDir

if [ ! $? == 0 ]; then
  echo "Unable to extract $1 to directory $tmpDir"
  exit 1
fi

/usr/local/sng/scripts/verify-license.sh $tmpDir/license.txt $3

if [ ! $? == 0 ]; then
  exit 2 
fi

sudo cp $tmpDir/license.txt $2
sudo cp $tmpDir/license.txt.sig $2.sig

if [ ! $? == 0 ]; then
  exit 3 
fi

rm -rf $tmpDir

if [ ! $? == 0 ]; then
  echo "Unable to remove $tmpDir"
  exit 4
fi

# Update the product
product="`sudo /usr/local/sng/scripts/product-brand.sh $2`"
sudo /usr/local/sng/scripts/update-product.sh "$product"

