#!/usr/bin/env python
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
"""
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
"""

import sys
import subprocess
import re
import xml.dom.minidom as xml

# Global
# We assume fs_cli is in /usr/local/sng/bin directory
sng_fscli = '/usr/local/sng/bin/fs_cli'

def os_execute(args, filter_rc=False):
    try:
        p = subprocess.Popen(args, 
                stdout=subprocess.PIPE,
                stderr=subprocess.STDOUT)
        output = p.communicate()[0].split('\n'); 
        if filter_rc:
            error = None
        else:
            error = p.returncode
    except:
        error = 'Exception'
        output = list() 
        pass

    return (error, output)


def execute_cmd(cmd):
    args = [sng_fscli, '-x', cmd]
    error, output = os_execute(args, True)
    # Iterate output
    for line in output:
        #print 'Check line:', line
        # check for error
        match = re.match(r'.*ERR', line)
        if match:
            error=line
            break

    return (error, output)

def xml_to_dict(node, dict=None):
    if not dict:
        dict = {} 

    def _merge_entries(name, dict, entry):
        # Check key doesn't exist yet
        if name in dict:
            # Convert to list and append
            if not isinstance(dict[name], list):
                l = [dict[name]]
                del dict[name]
                dict[name] = l
            dict[name].append(entry)
        else:
            dict.update({name:entry})

        return dict

    if isinstance(node, xml.Node):
        if node.nodeType == node.TEXT_NODE:
            return {node.parentNode.nodeName: node.data}

        for n in node.childNodes:
            name = n.nodeName
            if len(n.childNodes)>1:
                _merge_entries(name, dict, xml_to_dict(n))
            else:
                dict.update(xml_to_dict(n))

    else:
        for n in node:
            name = n.nodeName
            _merge_entries(name, dict, xml_to_dict(n))

    return dict

