<?php

///////////////////////////////////////////////////////////////////////////////
//
// Copyright 2007 Point Clark Networks.
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
///////////////////////////////////////////////////////////////////////////////

require_once("../../gui/Webconfig.inc.php");
// Error description array
$errors = array(
  // Client Request Errors
  400 => "Bad Request",
  401 => "Authorization Required",
  402 => "Payment Required (not used yet)",
  403 => "Forbidden",
  404 => "Not Found",
  405 => "Method Not Allowed",
  406 => "Not Acceptable (encoding)",
  407 => "Proxy Authentication Required",
  408 => "Request Timed Out",
  409 => "Conflicting Request",
  410 => "Gone",
  411 => "Content Length Required",
  412 => "Precondition Failed",
  413 => "Request Entity Too Long",
  414 => "Request URI Too Long",
  415 => "Unsupported Media Type",
  // Server Errors
  500 => "Internal Server Error",
  501 => "Not Implemented",
  502 => "Bad Gateway",
  503 => "Service Unavailable",
  504 => "Gateway Timeout",
  505 => "HTTP Version Not Supported",
);

// Default error
$error = 404;
$error_msg = "Unknown";
// get error from get error.php?code=404
if (isset($_GET) && isset($_GET['code']))
  $error = $_GET['code'];

// Error look up
if(isset($errors[$error]))
  $error_msg = $errors[$error];

WebHeader('', "splash");

WebDialogWarning( $error . " - " . $error_msg );

WebFooter("splash");

///////////////////////////////////////////////////////////////////////////////
// F U N C T I O N S
///////////////////////////////////////////////////////////////////////////////


// vim: syntax=php ts=4
?>
