<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Base class for routing rule
 * @author: William Adam
 */
class Fs_basic_dialplan_rule_class   extends Safe_configurable_object_class
{
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief
     *         
     * @return
     */
    public function description()
    {
        $desc = $this->get_data_value('global/description', false);
        if($desc){
            return $desc;
        }
        return parent::description();
    }
    public function summary($type = 'horizontal' , $long = false)
    {
        if($type == 'horizontal'){
            $settings = $this->get_data_values_exploded();
            $summary  = $settings['global']['summary'];
            $summary_string = '';
            foreach($summary as $tmp_item){
                if(is_array($tmp_item) && $tmp_item != null){
                    foreach($tmp_item as $key => $sub_tmp_item){
                        $tmp_item[$key] = $sub_tmp_item;
                    }
                    $summary_string .= PHP_EOL.'('.implode(',', $tmp_item) .')'.PHP_EOL;
                }else{
                    $summary_string .= wordwrap($tmp_item,100,PHP_EOL). ' ';
                }
            }
            return array(
                    'data' => array(
                        '#' => array(
                            'data' => $settings['global']['rank'],
                            'style' => 'width:30px',
                        ),
                        'Description' => array(
                            'data' => $summary,
                            'style' => 'width:780px',
                            'class' => 'ellipsis',
                        ),
                    ),
                    );
        }else{
            return parent::summary($type, false, 3);
        }
        
    }
    public function rule_summary_array($key, $v, $v_raw)
    {
        //in sub class
        return '';
    }
    public function rule_summary($settings_raw)
    {
        $rule_array = array();
        $rule_summary['type'] = 'Condition';
        $condition_summary = '';
        $rule_settings = $this->get_data_values_exploded();
        $rule_array[] = $rule_settings['condition']['matching'];
        unset($rule_settings['condition']['matching']);
        unset($rule_settings['condition']['break']);
        $rule_settings_raw = $this->get_data_values_exploded(false);
        
        foreach($rule_settings['condition'] as $key => $v){
            if($rule_settings_raw['condition'][$key]['type'] != '__none__'){
                $rule_array[]  = $this->rule_summary_array($key, $v, $rule_settings_raw['condition'][$key]);
            }
        }
        if($rule_array){
            $condition_summary = implode(',', $rule_array);
        }
        if(strlen($condition_summary)){
            $rule_summary['data'] = '('.$condition_summary.')';
        }else{
            $rule_summary['data'] = '';
        }
        return $rule_summary;
    }
    
    public function create_summary()
    {
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        // Build up a description of this rule
        $settings = $this->get_data_values_exploded();
        $settings_raw = $this->get_data_values_exploded(false);
        $break = $settings['condition']['break'];
        unset($settings['condition']['break']);
        
        $rule_summary = $module->rule_summary($this);
        
        $action_array = array() ;
        $anti_action_array = array();
        $action_array = $module->action_summary($this, 'action');
        $anti_action_array = $module->action_summary($this, 'anti-action');
        
        // Check need to add parameter to action
        if($action_array){
            $match_string = 'MATCH';
            $then_string = ' THEN';
        }else{
            $match_string = 'NOT MATCH';
            $then_string = '';
        }
        if($anti_action_array){
            if($match_string == 'MATCH' ){
                $else_string = 'ELSE';
            }else{
                $else_string = ' THEN';
            }
        }else{
            $else_string = '';
        }
        if($settings['condition']['matching'] == 'always'){
             
        }
        $all_summary = array();
        if($settings_raw['condition']['matching'] == 'always'){
            $all_summary[] = 'Always ';
            $anti_action_array = array();
            $else_string = '';
        }else{
            $all_summary[] = 'IF ' . $match_string . ' ' . $rule_summary['type'] . $rule_summary['data'] . $then_string;
        }
        $all_summary[] = $action_array;
        if($else_string){
            $all_summary[] = $else_string;
            $all_summary[] = $anti_action_array;
        }
        $all_summary[] = 'AND '. $break;
        return $all_summary;
    }
    public function configure_condition()
    {
        // Find out 1st condition field to 
        
    }
    protected function _type_str(){
        return 'Regular Expression';
    }
    public function configure()
    {
        // Common condition part
        $this->add_field('global/description', 'Description', 'text', '', 90);
        $this->set_field_category('global/description', 'Condition');
        $this->add_field('global/rank', 'Rank', 'text', '', 5);
        $this->composite_layout('global/description', array('global/rank'));
        $this->set_field_rules('global/rank','integer|greater_or_equal[0]');
        $this->add_field('global/summary', 'Summary', 'hidden', '', 90);
        
        
        // Delegate Action configuration to module
        // Extract module name from object name
        $path = $this->object_name();
        $parts = explode('/', $path);
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $module->configure_rule($this);
        $module->configure_action($this,'action');
        $module->configure_action($this,'anti-action');
        $all_group = $this->get_group();
        $always_group = array();
        foreach($all_group  as $key => $group_item){
            if($key == 'always' || $key == 'anti-action/always'){
                $always_group = array_merge($always_group,$group_item['fields']);
            }
       }
       //merge two group
       $this->create_group('new_always',
               $always_group,
               array('default' => array( 'value' => 'always', 'status' => 'disable'),
                       'condition' => array()
               ));
       $this->conditional_control('condition/matching', 'new_always');
       return parent::configure();
    }
    public function pre_validate(&$obj , &$data){
        $tmp['global/summary'] = $obj->create_summary();
        $obj->set_data_values($tmp);
    }
    public function validate($data, &$out_message = null){
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        // Update data in object
        $this->set_data_values($data);
        $data = $this->get_data_values(false);
        $error_message = $module->pre_validate($this , $data);
        $parent_obj = $this->node()->software()->application()->find_obj_by_path(dirname($path));
        if(isset($data['global/rank']) && $data['global/rank'] == ''){
            $data['global/rank'] = $parent_obj->get_max_rule_rank();
        }else{
            if(!isset($data['global/rank']) && $this->get_data_value('global/rank',false) == ''){
                $data['global/rank'] = $parent_obj->get_max_rule_rank();
            }
        }
        $validate_result = parent::validate($data, $out_message);
        if($error_message){
            foreach($error_message as $key => $message){
                $this->set_form_error($key, $message);
                $out_message[$key] = $message;
            }
            $validate_result = false;    
        }
        return $validate_result;
    }
    public function check_actions(){
        $data = $this->get_data_values_exploded(false);
        $have_action = false;
        $action_types = array('action','anti-action');
        foreach($action_types as $action_type){
            if(isset($data[$action_type])){
                foreach($data[$action_type] as $key => $value ){
                    if($data[$action_type][$key]['type'] != '__none__'){
                        $have_action = true;
                        break;
                    }
                }    
            }
            if($have_action) break;
        }
        if(!$have_action){
            return array('check_actions' => 'No action defined.');
        }
        return true;
    }
    public function get_condition(&$attributes, &$elements)
    {
        $condition = array();
        $data = $this->get_data_values_exploded(false); 
        $elements = null;
        $summary = $this->summary();
        $condition = array(
                'type'     => $data['global']['type'],
                'rank'     => $data['global']['rank'],
                'summary'  => $summary['data']['Description'],
                'break'    => $data['condition']['break'],
                );
        $attributes['break'] = $condition['break'];
        
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $module->get_condition($this , $attributes , $elements);
        return $condition;
    }
    public function get_rule_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        if(!$module) return false;
        $rule_usage = $module->get_rule_object_usage($this, $src_module_name, $obj_type, $obj_name, $sub_type, $sub_name);
        if($rule_usage){
            return $rule_usage;
        }else{
            return $module->get_action_object_usage($this, $src_module_name, $obj_type, $obj_name, $sub_type, $sub_name);
        }
    }
    public function get_action($params, &$elements)
    {
        //fields in action class
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $action = array();
        $on_match_type = array('action', 'anti-action');
        foreach($on_match_type as $on_match){
            $action_params = $module->get_action_params($this, $on_match);
            foreach($action_params as $action_item){
                $action[] = array(
                        $on_match => $action_item
                );
            }
        }
        return $action;
    }
    public function save()
    {
        $result = parent::save();
        if($this->is_modified()){
            $path = $this->object_name();
            $obj = $this->node()->software()->application()->find_obj_by_path(dirname(dirname($path)));
            if($obj){
                $obj->save();
            }
        }
        return $result;
    }
    public function dispose()
    {
        $this_obj_name = $this->object_name();
        $obj = $this->node()->software()->application()->find_obj_by_path(dirname(dirname($this_obj_name)));
        $result =  parent::dispose();
        if($result){
            if($obj){
                $obj->save();
            }
        }
        return $result;
    }
}

class Fs_basic_dialplan_rule_regex_class extends Fs_basic_dialplan_rule_class 
{
    protected $_max_regex = 5;
    protected function _sip_fields_enums(){
        $module = $this->_node->software()->application()->find_module_by_name( 'sip' );
        return $module->sip_fields_enums(array('invite_header'), false);
    }
    public function configure_condition()
    {
        $matching_values = array(
                'all' => 'All',
                'any' => 'Any',
                'xor' => 'Only One',
                'always' => 'Always',
            );
        $this->add_enum_field('condition/matching', 'Matching', 'dropdown', 'all', $matching_values);
        $this->add_enum_field('condition/break', 'Stop Policy', 'dropdown', 'never',
                array(
                        'on-true' => 'Stop On Success',
                        'on-false' => 'Stop On Failure',
                        'always' => 'Stop',
                        'never' => 'Continue',
                )
        );
        $this->composite_layout('condition/matching', array('condition/break'));
        // gather SIP fields enums
        $sip_enums = $this->_sip_fields_enums();
        // Add all catergory to field type
        $enum_list = array();
        foreach($sip_enums as $k => $v){
            $enum_list[$k] = $v['label'];
        }
        $enum_list = safe_create_enum_list($enum_list, ADD_NONE_ALWAYS, true, '( Please Select One )');
        $always_group = array();
        $always_condition_data = array();
        // Add regex fields
        for($i=1; $i<=$this->_max_regex; $i++){
            $this->add_enum_field('condition'.'/'.$i.'/type', 'Condition', 'dropdown', '__none__', $enum_list);
            $this->set_field_attributes('condition'.'/'.$i.'/type', array('style' => 'width:157px;'));
            if($i == 1){
                $this->set_field_rules('condition'.'/'.$i.'/type', 'required[condition/matching,not_in,always]|required[,in,__none__]');
            }
            $always_group[] = 'condition'.'/'.$i.'/type';
            
            $condition_data = array();
            foreach($sip_enums as $k => $v){
            $name_label = 'Name';
                $value_label = 'Expression';
                if(isset($v['name_label'])) $name_label = $v['name_label'];
                if(isset($v['value_label'])) $value_label = $v['value_label'];
                // Is this another enumeration ?
                if(isset($v['enum'])){
                    $this->add_enum_field('condition'.'/'.$i.'/'.$k.'/name', $name_label, 'dropdown', '', $v['enum']);
                    $this->set_field_attributes('condition'.'/'.$i.'/'.$k.'/name', array('style' => 'width:190px;', 
                                                                                         'label_style' => 'width:60px;', 
                                                                                         'composite_style' => 'display: none;' ));
                    $this->set_field_rules('condition'.'/'.$i.'/'.$k.'/name', 'required[,in,__selectone__]');
                }
                // A pattern fields ?
                if(isset($v['pattern'])){
                    $this->add_field('condition'.'/'.$i.'/'.$k.'/name', $name_label, 'text', '', 30);
                    $this->set_field_attributes('condition'.'/'.$i.'/'.$k.'/name', array('style' => 'width:186px;', 
                                                                                         'label_style' => 'width:60px;', 
                                                                                         'composite_style' => 'display: none;'));
                    $this->set_field_rules('condition'.'/'.$i.'/'.$k.'/name', 'required');
                }
                if(isset($v['value'])){
                    if(isset($v['value']['enum'])){
                        $this->add_enum_field('condition'.'/'.$i.'/'.$k.'/value', $value_label, 'dropdown', '', $v['value']['enum']);
                        $this->set_field_attributes('condition'.'/'.$i.'/'.$k.'/value', array('style' => 'width:210px;', 
                                                                                              'label_style' => 'width:65px;', 
                                                                                              'composite_style' => 'display: none;'));
                        $this->set_field_rules('condition'.'/'.$i.'/'.$k.'/value', 'required[,in,__selectone__]');
                    }
                }else{
                    // Add regex value field
                    $this->add_field('condition'.'/'.$i.'/'.$k.'/value', $value_label, 'text', '', 40);
                    $this->set_field_attributes('condition'.'/'.$i.'/'.$k.'/value', array('style' => 'width:206px;', 
                                                                                          'label_style' => 'width:65px;', 
                                                                                          'composite_style' => 'display: none;'));
                    $this->set_field_rules('condition'.'/'.$i.'/'.$k.'/value', 'required');
                }
                // Build condition array
                // Display value
                $condition_data[$k][] =
                    array('field_name' =>'condition'.'/'.$i.'/'.$k.'/value', 'status' => 'enable', 'display' => 'yes');
                // Display field select
                $condition_data[$k][] =
                    array('field_name' =>'condition'.'/'.$i.'/'.$k.'/name', 'status' => 'enable', 'display' => 'yes');
                // Hide all other
                $enum_keys = array_keys($sip_enums);
                foreach($enum_keys as $group_key){
                    if($group_key == $k)
                        continue;
                    $condition_data[$k][] =
                        array('field_name' =>'condition'.'/'.$i.'/'.$group_key.'/name', 'status' => 'disable', 'display' => 'no');
                    $condition_data[$k][] =
                        array('field_name' =>'condition'.'/'.$i.'/'.$group_key.'/value', 'status' => 'disable', 'display' => 'no');
                }
            }
            // Populate the '__none__' group
            $enum_keys = array_keys($sip_enums);
            $group = array();
            foreach($enum_keys as $group_key){
                $condition_data['__none__'][] =
                    array('field_name' =>'condition'.'/'.$i.'/'.$group_key.'/name', 'status' => 'disable', 'display' => 'no');
                $condition_data['__none__'][] =
                    array('field_name' =>'condition'.'/'.$i.'/'.$group_key.'/value', 'status' => 'disable', 'display' => 'no');
                $group[] = 'condition'.'/'.$i.'/'.$group_key.'/name';
                $group[] = 'condition'.'/'.$i.'/'.$group_key.'/value';
            }
            $this->create_group(
                'condition'.'/'.$i.'/type', 
                $group,
                array('default' => array( 'value' => '', 'status' => 'enable'),
                'condition' => $condition_data
                ));
            $this->conditional_control('condition'.'/'.$i.'/type', 'condition'.'/'.$i.'/type');
            $this->composite_layout('condition'.'/'.$i.'/type', $group);
        }
        $this->create_group('always', 
                   $always_group,
                    array('default' => array( 'value' => 'always', 'status' => 'disable'),
                    'condition' => $always_condition_data
                ));
        //$this->conditional_control('condition/matching', 'always');
        return parent::configure_condition();
    }

    public function get_condition(&$attributes , &$elements ){
        // gather SIP fields enums
        $sip_enums = $this->_sip_fields_enums();
        // Get data
        $data = $this->get_data_values_exploded(false);
        if($data['condition']['matching'] != 'always'){
            $attributes['regex'] = $data['condition']['matching'];
        }else{
            return;
        }
        // Loop around regex fields
        for($i=1; $i<=$this->_max_regex; $i++){
            $type = $data['condition'][$i]['type'];
            switch($type){
                case 'domain':
                    $elements[]['regex'] = array(
                            'field' => '${'.$data['condition'][$i][$type]['name'].'}',
                            'expression' => '^'.$data['condition'][$i][$type]['value'].'$'
                    );
                    break;
                case 'user':
                    if($data['condition'][$i][$type]['name'] == 'sip_from_user'){
                        $field = '${user_exists(id ${sip_from_user} ${sip_from_host})}';
                    }else{
                        $field = '${user_exists(id ${sip_to_user} ${sip_to_host})}';
                    }
                    $elements[]['regex'] = array(
                        'field' => $field,
                        'expression' => '^true$'
                    );
                    break;
                case 'auth':
                    $elements[]['regex'] = array(
                        'field' => '${sip_authorized}',
                        'expression' => '^true$'
                    );
                    break;
                case 'from_trunk':
                    $elements[]['regex'] = array(
                        'field' => '${sip_trunk_name}',
                        'expression' => '^'.$data['condition'][$i][$type]['name'].'$'
                    );
                    break;
                default:
                    if(isset($data['condition'][$i][$type])){
                        // Get field values
                        $values = $data['condition'][$i][$type];
                        // Check if pattern in enum def
                        if(isset($sip_enums[$type]['pattern'])){
                            $values['name'] = str_replace('xxx', $values['name'], $sip_enums[$type]['pattern']);
                        }
                        $elements[]['regex'] = array(
                                'field' => $values['name'] ,
                                'expression' => $values['value'],
                        );
                    }
                    break;
            }
        }
    }

    public function pre_validate(&$obj, &$data){
        $sip_enums = $this->_sip_fields_enums();
        $sub_field_names = array_keys($sip_enums);
        for($i=1; $i<=$this->_max_regex; $i++){
            $field_name = 'condition'.'/'.$i.'/type';
            foreach($sub_field_names as $tmp){
                if(!preg_match('/^'.$tmp.'/', $data[$field_name])){
                    unset($obj->_fields['condition'.'/'.$i.'/'.$tmp.'/name']);
                    unset($obj->_fields['condition'.'/'.$i.'/'.$tmp.'/value']);
                    unset($data['condition'.'/'.$i.'/'.$tmp.'/name']);
                    unset($data['condition'.'/'.$i.'/'.$tmp.'/value']);
                }
            }
        }
        $fields = $this->get_data(true);
        if(isset($data['condition/matching']) && $data['condition/matching'] == 'always'){
            foreach($fields as $key => $tmp_data){
                $pieces = explode("/", $key);
                if($pieces[0] == 'condition' && $pieces[1]!='matching' && $pieces[1]!= 'break' ){
                    unset($obj->_fields[$key]);
                    unset($data[$key]);
                }
            }
        }
        $tmp_data['global/summary'] = $obj->create_summary();
        $obj->set_data_values($tmp_data);
    }
    
    public function rule_summary_array($key, $v, $v_raw)
    {
        $condition_summary = '';
        if(strlen($v_raw['type']) && $v_raw['type'] != '__none__'){
            if(strlen($v[$v_raw['type']]['name'])){
                $condition_summary .= $v['type'] .'['.$v[$v_raw['type']]['name'] . ']';
                if(strlen($v[$v_raw['type']]['value'])){
                    $condition_summary .= ' = '.$v[$v_raw['type']]['value'];
                }   
            }else{
                $condition_summary .= $v['type'];
            }
        }
        return $condition_summary;
    }
    
    public function get_rule_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        $data = $this->get_data_values_exploded(false);
        for($i=1; $i<=$this->_max_regex; $i++){
            $type = $data['condition'][$i]['type'];
            switch($type){
                case 'domain':
                    if ($data['condition'][$i][$type]['value'] == $obj_name && $src_module_name == 'directory' && $obj_type == 'domain') {
                        return true;
                    }
                    break;
                case 'to_trunk':
                    if ($data['condition'][$i][$type]['name'] == $obj_name && $src_module_name == 'sip' && $obj_type == 'trunk') {
                        return true;
                    }
                    break;
            }
        }
        return false;
    }
    
}
class Fs_basic_dialplan_rule_regex_routing_class extends Fs_basic_dialplan_rule_regex_class
{
    protected function _sip_fields_enums(){
        $module = $this->_node->software()->application()->find_module_by_name( 'sip' );
        return $module->sip_fields_enums(array('invite_header'), false);
    }
}
class Fs_basic_dialplan_rule_unconditional_class extends Fs_basic_dialplan_rule_class 
{
    public function configure_condition(){
    }
    public function get_condition(&$attributes){
        $attributes = array();
    }
    public function pre_validate(&$obj , &$data){
        $tmp_field['global/on_match'] = 'action';
        $tmp_field['condition/break'] = 'never';
        $tmp_field['global/summary'] = $obj->create_summary();
        $obj->set_data_values($tmp_field);
    }
    public function rule_summary($settings_raw)
    {
        return 'Always';
    }
}

class Fs_basic_dialplan_rule_default_class extends Fs_basic_dialplan_rule_class 
{
    protected function _type_str(){
        return 'Default Rule';
    }
    public function get_condition(&$attributes){
        $condition = array(
                'type'     => 'default',
                'rank'     => 'MAX', // alway at the last one
                'summary'  =>  $this->_type_str(),
                'break'    => 'always',
        );
        $attributes['break'] = $condition['break'];
        
        return  $condition;
    }
    public function get_action($params, &$elements)
    {
        //default actions
        $action_type = 'action';
        $action = array(
            0 => array(
                        'action' => array('application' => 'log', 
                                         'data' => 'warning Default Rule - Responding '.$params['default-response'],
                                         ),
                        ),
            1 => array(
                        'action' => array('application' => 'info'),
                        ),
            2 => array(
                        'action' => array('application' => 'respond', 
                                          'data' => $params['default-response'], 
                                         ),
                        )
        );
        return $action;
    }
}
class Fs_basic_dialplan_rule_trace_class extends Fs_basic_dialplan_rule_class 
{
    protected function _type_str(){
        return 'Trace Rule';
    }
    public function get_condition(&$attributes){
        $condition = array(
                'type'     => 'trace',
                'rank'     => '-1', // alway at the first one
                'summary'  => $this->_type_str(),
                'break'    => 'never',
        );
        $attributes['break'] = $condition['break'];
        return  $condition;
    }
    public function get_action($params, &$elements)
    {
        //trace actions
        $action_type = 'action';
        $action = array(
                0 => array(
                        'action' => array('application' => 'export', data => 'nolocal:inherit_session_loglevel=true'),
                ),
                1 => array(
                        'action' => array('application' => 'session_loglevel', data => 'debug'),
                ),
                2 => array(
                        'action' => array('application' => 'info'),
                )
        );
        return $action;
    }
}
class Fs_basic_dialplan_routing_rule_class extends Fs_basic_dialplan_rule_class
{
    protected function _sip_fields_enums(){
        $module = $this->_node->software()->application()->find_module_by_name( 'sip' );
        return $module->sip_fields_enums();
    }
}
class Fs_basic_dialplan_hmr_rule_class extends Fs_basic_dialplan_rule_class
{
}
?>
