#!/bin/bash
# Proceed with rpm update (yum)

UPDATE_DIR=$1
UPDATE_WORKING=$2

# Check if we are updating an ISO install or a binary install
if rpm -q app-sng-release; then
  RPM_EXCLUDE='-x app-sng-binary'
fi
if rpm -q app-sng-binary; then
  RPM_EXCLUDE='-x app-sng-release'
fi

yum -c ${UPDATE_DIR}/conf/yum.conf --enablerepo=update update -y ${RPM_EXCLUDE} | tee ${UPDATE_WORKING_DIR}/`basename $0`.log
RC=${PIPESTATUS[0]}
exit $RC

