#!/usr/bin/env python2.7
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
"""
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
"""

class Object(object):
    @property
    def name(self):
        return self._name

    @property
    def description(self):
        return self._description

    def __init__(self, parent, name, description=None):
        self._children = {}
        self._parent = parent
        self._name = name
        self._configuration = None 
        if description:
            self._description = description
        else:
            self._description = self._name

    @property
    def children(self):
        return self._children

    def _add_child(self, child):
        self._children[child.name] = child

    def _remove_child(self, name):
        if name in self._children:
          del self._children[name]

    def _get_child(self, name):
        if name in self._children:
          return self._children[name]
        else:
          return None

    def _clear_children(self):
        self._children.clear()

    def list(self):
        return self._children.keys()

    def delegate(self, request, method, path=None, params=None):
        if path:
            _path = self._name + '/' + path
        else:
            _path = self._name
        return self._parent.delegate(request, method, _path, params)

