<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC SIP Trunk Class
 *
 * author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'gateway');
class Nsc_sip_trunk_class extends Fs_gateway_class
{
    private $_the_app;
    private $_carrier_profiles = array();
    private $_sip_profiles = array();
    private $_media_profiles = array();
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($node, $parent_name, $name, $node);
        $this->_the_app = $this->_node->software()->application();
    }
    public function configure()
    {
        parent::configure();
        $this->configure_session_routing();
        $this->configure_cac();
        $this->configure_lcr();
        $this->configure_db();
        return true;
    }

    public function configure_general()
    {
        // Configure parent object
        parent::configure_general();
        $def_name = "";
        //Create SIP Profile Drop Down
        $sip = array();
        $this->sip_profiles();
        if (isset($this->_sip_profiles)) {
            foreach ($this->_sip_profiles as $name => $profile) {
                if (isset($profile)) {
                    if (!sizeof($name)) $def_name = $name;
                    $sip[$name] = $name;
                }
            }
        }
        $this->add_enum_field('sip_profile', 'SIP Profile', 'dropdown', $def_name, $sip);
        $this->set_field_help('sip_profile', 'The SIP Profile this SIP trunk will be associated to.');

        // Media section
        $media_module = $this->_the_app->find_module_by_name('media');
        $media = $media_module->object_enum('profile', ADD_NONE_ALWAYS, true, '( SIP Profile Default )');
        $def_name = '__none__';
        
        $this->add_enum_field('inbound-media-profile', 'Inbound Media Profile', 'dropdown', $def_name, $media);
        $this->set_field_help('inbound-media-profile', 'Media profile that will be used on all incoming calls.');
        $this->add_enum_field('outbound-media-profile', 'Outbound Media Profile', 'dropdown', $def_name, $media);
        $this->set_field_help('outbound-media-profile', 'Media profile that will be used on all outgoing calls.');
    }

    protected function configure_session_routing()
    {
        //Add dialplans drop downs
        $routing_module = $this->_the_app->find_module_by_name('routing');
        $dialplans = $routing_module->object_enum('dialplans', ADD_NONE_ALWAYS, true, '( SIP Profile Default )');
        
        $this->add_enum_field('call-routing', 'Routing Plan', 'dropdown', '__none__', $dialplans);
        $this->set_field_help('call-routing', 'Use a specific routing plan for this SIP Trunk.');

        // Header Manipulation
        $hmr_module = $this->_the_app->find_module_by_name('hmr');
        $hmrs = $hmr_module->object_enum('dialplans', ADD_NONE_ALWAYS, true, '( SIP Profile Default )');

        $this->add_enum_field('ingress', 'Ingress ', 'dropdown', '__none__', $hmrs);
        $this->set_field_help('ingress', 'Use a specific ingress Header Manipultion plan for this SIP Trunk.');
        $this->add_enum_field('egress', 'Egress  ', 'dropdown', '__none__', $hmrs);
        $this->set_field_help('egress', 'Use a specific egress Header Manipultion plan for this SIP Trunk.');

        // Set categories
        $this->set_field_category('call-routing', 'Routing & Header Manipulation');
    }

    public function configure_cac()
    {
        // Call Admission Control Section
        $this->add_field('max-sessions', 'Max Sessions', 'string', '', 10);
        $this->set_field_rules('max-sessions', 'greater_than[0]|less_than[65536]|is_natural');
        $this->set_field_help('max-sessions', 'Maximum allowed concurrent sessions');

        $this->add_field('session-rate-limit', 'Session Rate Limit', 'string', '', 10);
        $this->set_field_rules('session-rate-limit', 'greater_than[0]|less_than[65536]|is_natural');
        $this->set_field_help('session-rate-limit', 'Maximum number of sessions per period of time configured in \'Session Rate Period\'');

        $this->add_field('session-rate-period', 'Session Rate Period', 'string', '', 10);
        $this->set_field_rules('session-rate-period', 'required[session-rate-limit]|greater_than[0]|less_than[65536]|is_natural');
        $this->set_field_help('session-rate-period', 'Period of time in seconds to enforce the rate limit specified in \'Session Rate Limit\'');

        // Set categories
        $this->set_field_category('max-sessions', 'Call Admission Control');
    }
    public function configure_lcr()
    {
        //Create carrier drop down
        /*
        $carrier = array();
        $carrier['none'] = "-- None --";
        $this->carrier_profiles();
        if (isset($this->_carrier_profiles)) {
            foreach ($this->_carrier_profiles as $name => $profile) {
                if (isset($profile)) {
                    $carrier[$name] = $name;
                }
            }
        }*/
        // LCR section
        //$this->add_enum_field('carrier_name', 'LCR Carrier', 'dropdown', 'none', $carrier);
        //$this->set_field_help('carrier_name', array( 
        //    'Select a carrier to use for Least Cost Routing.',
        //    'Selecting None disables LCR.'));
        

        // Set categories
        //$this->set_field_category('carrier_name', 'LCR');
    }
    public function configure_db()
    {
        $this->add_field('db-cfg/hostname', 'Database Hostname', 'hidden', 'localhost', 50); //HOSTNAME set to localhost
        $this->add_field('db-cfg/username', 'Database Username', 'hidden', 'root', 25); //USERNAME set to root
        $this->add_field('db-cfg/password', 'Database Password', 'hidden', '', 50); //PASSWORD set to ""
        $this->add_field('db-cfg/port', 'Database Port', 'hidden', '3306', 10); //PORT set to 3306
        $this->add_field('db-cfg/database', 'Database', 'hidden', 'freeswitch'); //DATABASE set to NSC. Hidden Field
        $this->add_field('db-cfg/dbdriver', 'dbdriver', 'hidden', 'mysql'); //DBDRIVER set to mysql. Hidden field
        $this->add_field('db-cfg/dbprefix', 'dbprefix', 'hidden', ''); //DBPREFIX set to "". Hidden field
        $this->add_field('db-cfg/pconnect', 'pconnect', 'hidden', 'false'); //PCONNECT set to false. Hidden field
        $this->add_field('db-cfg/db_debug', 'db_debug', 'hidden', 'true'); //DB_DEBUG set to true. Hidden field
        $this->add_field('db-cfg/cache_on', 'cache_on', 'hidden', 'false'); //CACHE_ON set to false. Hidden field
        $this->add_field('db-cfg/cachedir', 'cachedir', 'hidden', ''); //CACHEDIR set to "". Hidden field
        $this->add_field('db-cfg/char_set', 'char_set', 'hidden', 'utf8'); //CHAR_SET set to UTF8. Hidden field
        $this->add_field('db-cfg/dbcollat', 'dbcollat', 'hidden', 'utf8_general_ci'); //DBCOLLAT set to utf8_general_ci. Hidden field
        $this->add_field('db-cfg/active-record', 'active-record', 'hidden', 'true'); //ACTIVE-RECORD set to true. Hidden field
    }

    public function prepare_edit()
    {
        // Check if system is running and object as been serialized
        if (Safe_service_class::STATUS_RUNNING == $this->_the_app->status()) {
            if(Safe_object_serializer_class::OBJ_STATUS_NEW != $this->status()) {
                // Prevent binding edition
                $this->set_field_disabled('sip_profile', true);
                // Adjust help so user knows why :)
                $this->set_field_help('sip_profile',
                    array(
                        '<font color="red">Association cannot be changed while system is running.</font>',
                        '',
                        'The SIP Profile this SIP trunk will be associated to.',
                    )
                    );
            }
        }
        parent::prepare_edit();
    }
    /**
     * Pulls out all carrier profiles from db
     */
    public function carrier_profiles()
    {
        $this->_carrier_profiles = $this->_the_app->carrier_profiles();
    }
    public function sip_profiles()
    {
        $this->_sip_profiles = $this->_the_app->sip_profiles();
    }
    private function _media_profiles()
    {
        $this->_media_profiles = $this->_the_app->media_profiles();
    }
    /**
     * @brief Check if media profile is used by the SIP trunk
     *           
     * @param[in out] $media_profile
     *           
     * @return true if used
     */
    public function media_check($media_profile)
    {
        $prof_data = $this->get_data_values(false);
        return ($prof_data['outbound-media-profile'] == $media_profile || $prof_data['inbound-media-profile'] == $media_profile) ? true : false;
    }
    /**
     * @brief Check carrier used by trunk
     *
     * @param[in out] $carrier_profile
     *
     * @return true if carrier is used 
     */
    public function carrier_check($carrier_profile){
        $prof_data = $this->get_data_values(false);
        return ($prof_data['carrier_name'] == $carrier_profile) ? true : false;
    }
    public function sip_profile_check($sip_profile){
        $prof_data = $this->get_data_values(false);
        return ($prof_data['sip_profile'] == $sip_profile) ? true : false;
    }
    
    
}
?>
