<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/**
 * SNG misc debug facilities
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/REST_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Sng_rest extends REST_Controller
{
    /**
     * @brief 
     *
     * @return 
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Parse PUT
     */
    protected function _parse_put()
    {
        // put method only used  for upload file
        $this->request->body = '';
    }
    protected $_supported_formats = array(
            'xml' => 'application/xml',
            'json' => 'application/json',
            'jsonp' => 'application/javascript',
            'serialized' => 'application/vnd.php.serialized',
            'php' => 'text/plain',
            'html' => 'text/html',
            'bin' => 'multipart/form-data', // add for post upload bin file
            'csv' => 'application/csv'
    );
    /**
     * @brief api_post
     *
     * @param[in out] $method_name
     * @param[in out] $module_name
     * @param[in out] $obj_type
     * @param[in out] $obj_name
     * @param[in out] $child_obj_type
     * @param[in out] $child_obj_name
     *
     * @return
     */
    public function api_post($method_name,$module_name, $obj_type=null, $obj_name=null, $child_obj_type=null, $child_obj_name=null)
    {
        $this->check_allowed();
        //Content-Type: application/json 
        $post = $this->post();
        return $this->_action('POST',$post,$method_name,$module_name, $obj_type, $obj_name, $child_obj_type, $child_obj_name);
    }
    /**
     * @brief api_get
     *
     * @param[in out] $method_name
     * @param[in out] $module_name
     * @param[in out] $obj_type
     * @param[in out] $obj_name
     * @param[in out] $child_obj_type
     * @param[in out] $child_obj_name
     *
     * @return
     */
    public function api_get($method_name,$module_name, $obj_type=null, $obj_name=null, $child_obj_type=null, $child_obj_name=null)
    {
        $this->check_allowed();
        $get = $this->get();
        return $this->_action('GET',$get,$method_name,$module_name, $obj_type, $obj_name, $child_obj_type, $child_obj_name);
    }
    /**
     * @brief api_get
     *
     * @param[in out] $method_name
     * @param[in out] $module_name
     * @param[in out] $obj_type
     * @param[in out] $obj_name
     * @param[in out] $child_obj_type
     * @param[in out] $child_obj_name
     *
     * @return
     */
    public function api_put($method_name,$module_name, $obj_type=null, $obj_name=null, $child_obj_type=null, $child_obj_name=null)
    {
        $this->check_allowed();
        $put = $this->put();
        return $this->_action('PUT',$put,$method_name,$module_name, $obj_type, $obj_name, $child_obj_type, $child_obj_name);
    }
    /**
     * @brief action
     *
     * @param[in out] $type
     * @param[in out] $data
     * @param[in out] $method_name
     * @param[in out] $module_name
     * @param[in out] $obj_type
     * @param[in out] $obj_name
     * @param[in out] $child_obj_type
     * @param[in out] $child_obj_name
     *
     * @return
     */
    private function _action($type, $data, $method_name, $module_name, $obj_type=null, $obj_name=null, $child_obj_type=null, $child_obj_name=null)
    {
        $response_data = array("status" => false,"error" => "Not Found");
        $response = 404;
        $response_data['method'] = $method_name;
        $response_data['module'] = $module_name;
        try{
            if($obj_type){
                $response_data['type'] = $obj_type;
                if($obj_name){
                    $response_data['name'] = $obj_name;
                }
            }
            $module = $this->_the_app->find_module_by_name($module_name);
            if($module){
                //sub obj
                if($child_obj_type) {
                    $response_data['child_type'] = $child_obj_type;
                    if($child_obj_name){
                        $response_data['child_name'] = $child_obj_name;
                    }
                    //get this obj
                    $sub_obj = call_user_func(array($module, 'api_retrieve_'.$obj_type), $obj_name,$data,&$output);
                    if($sub_obj){
                        $module = $sub_obj;
                        $obj_type = $child_obj_type;
                        $obj_name = $child_obj_name;
                    }else{
                        $error = 'Not Found';
                        throw new Exception($error,404);
                    }
                }
                // Get object type definition
                $obj_type_def = $module->get_aggregate_object_definition($obj_type);
                // Check if get_data_settings exists - $module can be a simple 
                // object see above when checking for child_obj
                if(method_exists($module, "get_data_settings")) {
                    $obj_data_def = $module->get_data_settings();
                }
                if(method_exists($module, "get_action_settings")) {
                    $obj_action_def = $module->get_action_settings();
                }
                if(isset($obj_type_def["methods"][$method_name])) {
                    if($obj_type_def["methods"][$method_name]['request']!=$type) {
                        $error = 'Method Not Allowed';
                        throw new Exception($error,405);
                    }
                    $method_def = $obj_type_def["methods"][$method_name];
                    $crud_method = array('create', 'retrieve', 'update' , 'delete');
                    $real_method_name = 'api_'.$method_name.'_'.$obj_type;
                    $output = array();
                    if(method_exists($module,$real_method_name)){
                        // All CRUD methods gonna work on object
                        $obj = call_user_func(array($module, 'api_retrieve_'.$obj_type), $obj_name,$data,&$output);
                        if (in_array($method_name,$crud_method)){
                            switch ($method_name) {
                                case 'create':
                                    if($obj) {
                                        $error = 'Conflict';
                                        throw new Exception($error,409);
                                    }else{
                                        if($module->can_create_aggregate_object($obj_type, $obj_name, $output)){
                                            $new_obj = call_user_func(array($module, $real_method_name), $obj_name,$data,&$output);
                                            if($new_obj){
                                                if(true == $new_obj->validate($data, &$output)){
                                                    if(true == $new_obj->save()){
                                                        $result = true;
                                                    }else{
                                                        $error = 'Internal Error';
                                                        throw new Exception($error,500);
                                                    }
                                                }else{
                                                    $result = false;
                                                }
                                            }else{
                                                $error = 'Internal Error';
                                                throw new Exception($error,500);
                                            }    
                                        }else{
                                            $result = false;
                                        }
                                    }
                                    break;
                                case 'retrieve':
                                    if(is_object($obj)) {
                                        $result = $obj->get_data_values(false,false);
                                    }elseif(is_array($obj)){
                                        //'configurable' => false obj return array not obj
                                        $result = $obj;
                                    }
                                    break;
                                case 'update':
                                    if(is_object($obj)) {
                                        $obj->prepare_edit();
                                    }
                                case 'delete':
                                    if(is_object($obj)) {
                                        $result = call_user_func(array($module, $real_method_name), $obj_name,$data,&$output);
                                    }
                                    break;
                            }                            
                        }else{
                            $result = call_user_func(array($module, $real_method_name), $obj_name,$data,&$output);
                        }
                        if($result === true || $result === false){
                            $response_data['status'] = $result;
                            $response = ($result===true)?200:400;
                            if($response == 200){
                                unset($response_data['error']);
                                if(!empty($output)){
                                    $response_data['data'] = $output;
                                }
                            }else{
                                $response_data['error']  = $output;
                            }
                        }else if(is_subclass_of($result, 'Safe_object_class')) {
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $result->get_data_values(false);
                            // Does this object has childs ?
                            $childs_def = $result->get_aggregate_object_definition();
                            foreach($childs_def as $child_type => $child_def) {
                                $child_objs = $result->get_aggregate_objects($child_type);
                                foreach($child_objs as $child_name => $child) {
                                    $response_data['data'][$child_type][$child_name] = $child->get_data_values(false);
                                }
                            }
                            $response = 200;
                        }else if(is_array($result)) {
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $result;
                            $response = 200;
                        }
                    }else{
                        $error = 'Not Implemented';
                        throw new Exception($error,501);
                    }
                }elseif(isset($obj_data_def[$obj_type]['methods'][$method_name])){
                    //check if have data setting
                    if($obj_data_def[$obj_type]["methods"][$method_name]['request']!=$type) {
                        $error = 'Method Not Allowed';
                        throw new Exception($error,405);
                    }
                    $real_method_name = 'api_'.$method_name.'_'.$obj_type;
                    $output = array();
                    if(method_exists($module,$real_method_name)){
                        $result = call_user_func(array($module, $real_method_name), $obj_name,$data,&$output);
                        if($result === true || $result === false){
                            $response_data['status'] = $result;
                            $response = ($result===true)?200:400;
                            if($result === false){
                                if($output != null){
                                    $response_data['error'] = $output;
                                }else{
                                    //for delete file
                                    $error = 'Not Found';
                                    throw new Exception($error,404);
                                }
                            }else{
                                $response_data['data']  = $output;
                                $response_data['error'] = '';
                            }
                        }else if(is_array($result)) {
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $result;
                            $response = 200;
                        }else if($output != null){
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $output;
                            $response = 200;
                        }
                    }else{
                        $error = 'Not Implemented';
                        throw new Exception($error,501);
                    }
                }elseif(isset($obj_action_def[$method_name])){
                    //check if have action setting
                    if($obj_action_def[$method_name]['request']!=$type) {
                        $error = 'Method Not Allowed';
                        throw new Exception($error,405);
                    }
                    $real_method_name = 'api_'.$method_name.'_action';
                    $output = array();
                    if(method_exists($module,$real_method_name)){
                        $result = call_user_func(array($module, $real_method_name), $data, &$output);
                        if($result === true || $result === false){
                            $response_data['status'] = $result;
                            $response = ($result===true)?200:400;
                            if($result === false){
                                if($output != null){
                                    $response_data['error'] = $output;
                                }else{
                                    $error = 'Not Found';
                                    throw new Exception($error,404);
                                }
                            }else{
                                $response_data['data']  = $output;
                                $response_data['error'] = '';
                            }
                        }else if(is_array($result)) {
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $result;
                            $response = 200;
                        }else if($output != null){
                            $response_data['status'] = true;
                            $response_data['error'] = '';
                            $response_data['data'] = $output;
                            $response = 200;
                        }
                    }else{
                        $error = 'Not Implemented';
                        throw new Exception($error,501);
                    }
                }else if('list' == $method_name) {
                    $has_obj = false;
                    $has_data = false;
                    // Enumerate resource
                    $agg_objs = $module->has_aggregate_objects();
                    if($agg_objs && isset($agg_objs[$obj_type])){
                        //pass pagination/limit and pagination/offset in $data
                        $objs = $module->get_aggregate_objects_keys($obj_type, false, $data);
                        //check if support pagination
                        if($agg_objs[$obj_type]['pagination']){
                            $response_data['count'] = count($objs['data']);
                            $response_data['data'] = array_keys($objs['data']);
                            $response_data['pagination/total'] = $objs['total'];
                            $response_data['pagination/limit'] = $objs['limit'];
                            $response_data['pagination/offset'] = $objs['offset'];
                            $response_data['pagination'] = true;
                        }else{
                            $response_data['count'] = count($objs);
                            $response_data['data'] = $objs;
                        }
                        $has_obj = true;
                    }
                    //check if have data to list
                    if(method_exists($module, "get_data_settings")) {
                        $data_cfg = $module->get_data_settings();
                        if($data_cfg && isset($data_cfg[$obj_type])){
                            try{
                                $data_files = $module->get_data_files($obj_type);
                                $response_data['count'] = count($data_files);
                                $response_data['data'] = array_keys($data_files);
                                $has_data = true;
                            }catch (Exception $e){
                                $error = 'Not Found';
                                throw new Exception($error,404);
                            }
                        }
                    }
                    if(!$has_obj && !$has_data){
                        throw new Exception($error,404);
                    }else{
                        $response_data['status'] = true;
                        $response_data['error'] = '';
                        $response = 200;
                    }
                }else{
                    $error = 'Not Found';
                    throw new Exception($error,404);
                }
                //
            }else{
                $error = 'Not Found';
                throw new Exception($error,404);
            }
        }catch(Exception $e){
            $response_data['status'] = false;
            $response_data['error'] = $e->getMessage();
            $response_data['data'] = '';
            $response = $e->getCode();
        }
        if(!$response_data['error']){
            unset($response_data['error']);
        }
        // Get some additional info for debug
        if(file_exists("/usr/local/sng/conf/sng_dev_env")){
            $response_data['debug']['mem']['usage'] = memory_get_usage();
            $response_data['debug']['mem']['peak'] = memory_get_peak_usage();
        }
        $this->response($response_data, $response);
    }

    /**
     * @brief Overload authenticate from Safe_CI_Controller
     *         
     * @return
     */
    protected function authenticate()
    {
        // Grant access in any cases
    }
    protected function _check_whitelist_auth()
    {
        // Allow local access
        if($_SERVER['SERVER_ADDR'] == $_SERVER['REMOTE_ADDR']){
            return;
        }
        // Check on a Sangoma dev environment
        if(file_exists("/usr/local/sng/conf/sng_dev_env")){
            return;
        }
        // Check if module enabled
        $rest = $this->_the_app->find_module_by_name('rest');
        // Enabled
        if(!$rest->is_enabled()) {
            $this->response('Forbidden', 403);
        }
        // Check IP white list
        if(!$rest->check_ip_whitelist($this->input->ip_address()) ) {
            $this->response(array(
                'status' => false,
                'error' => 'Not authorized'
            ) , 401);
        }
    }
    protected function _detect_api_key()
    {
        // Allow local access
        if($_SERVER['SERVER_ADDR'] == $_SERVER['REMOTE_ADDR']){
            return true;
        }
        // Check on a Sangoma dev environment
        if(file_exists("/usr/local/sng/conf/sng_dev_env")){
            return;
        }
        // Check if module enabled
        $rest = $this->_the_app->find_module_by_name('rest');
        if(!$rest->is_api_key_enabled()) {
            return true;
        }
        // Get the api key name variable set in the rest config file
        $api_key_variable = config_item('rest_key_name');
        // Work out the name of the SERVER entry based on config
        $key_name = 'HTTP_' . strtoupper(str_replace('-', '_', $api_key_variable));
        $this->rest->key = null;
        $this->rest->level = null;
        $this->rest->user_id = null;
        $this->rest->ignore_limits = true;
        // Find the key from server or arguments
        if (($key = isset($this->_args[$api_key_variable]) ? $this->_args[$api_key_variable] : $this->input->server($key_name))) {
            if (!($api_key = $rest->check_api_key($key))) {
                return false;
            }else{
                $this->client = true;
                $this->rest->key = $api_key->get_data_value("key");
                $this->rest->user_id = $api_key->name();
                return $this->client;
            }
        }
        // No key has been sent
        return false;
    }
    protected function check_allowed()
    {
    }
    /**
     * @brief REST Configuration interface
     *
     * @param[in out] $module_name
     * @param[in out] $method_name
     * @param[in out] $obj_type
     * @param[in out] $child_obj_type
     *
     * @return
     */
    public function config_get($module_name=null, $obj_type=null, $method_name=null, $child_obj_type=null)
    {
        $this->check_allowed();
        $response_data = array();
        $response = 404;
    
        $software = $this->_the_product->local_node()->software();
        $modules = array();
        // Check if we want all
        if(!$module_name) {
            $modules = $software->application()->modules();
            $modules = array_merge($modules, $software->services());
            $modules['hardware'] = $software->application()->find_module_by_name('hardware');
        } else {
            $mod = $software->application()->find_module_by_name($module_name);
            if($mod) {
                $modules[$module_name] = $mod;
            }
        }
        foreach($modules as $mod_name => $module) {
            $agg_objs = $module->has_aggregate_objects(true);
            foreach($agg_objs as $obj_type => $obj_def) {
                if($obj_def['configurable'] === false) continue;
                if($obj_def['pseudo']){
                    continue;
                }
                $objs = $module->get_aggregate_objects($obj_type);
                if(!is_array($objs)){
                    if(is_subclass_of($objs, 'Safe_object_class')){
                        $response_data[$mod_name][$obj_type] = $objs->get_data_values(false);
                    }
                }else{
                    foreach($objs as $obj_name => $obj){
                        if(is_subclass_of($obj, 'Safe_object_class')){
                            $response_data[$mod_name][$obj_type][$obj_name] = $obj->get_data_values(false);
                            // Check this one has sub object
                            $agg_child_objs = $obj->has_aggregate_objects(true);
                            foreach($agg_child_objs as $sub_type => $sub_def){
                                if($sub_def['configurable'] === false) continue;
                                if($sub_def['pseudo']){
                                    continue;
                                }
                                $sub_objs = $obj->get_aggregate_objects($sub_type);
                                foreach($sub_objs as $sub_name => $sub_obj){
                                    $response_data[$mod_name][$obj_type][$obj_name][$sub_type][$sub_name] = $sub_obj->get_data_values(false);
                                }
                            }
                        }else if(is_array($obj)){
                            $response_data[$mod_name][$obj_type][$obj_name] = $obj;
                        }
                    }
                }
            }
            if($cfg_obj = $module->config()){
                $response_data[$mod_name]['configuration'] = $cfg_obj->get_data_values(false);
            }
        }
        if($response_data)
            $response = 200;
        $this->response($response_data, $response);
    }

    /**
        * @brief REST documentation interface
        *
        * @param[in out] $module_name
        * @param[in out] $obj_type
        * @param[in out] $method_name
        * @param[in out] $child_obj_type
        *
        * @return 
     */
    public function doc_get($module_name=null, $obj_type=null, $method_name=null, $child_obj_type=null)
    {
        $this->check_allowed();
        $response_data = array();
        $response = 404;
    
        $software = $this->_the_product->local_node()->software();
        $modules = array();
        // Check if we want all
        if(!$module_name) {
            $modules = $software->application()->modules();
            $modules = array_merge($modules, $software->services());
            $modules['hardware'] = $software->application()->find_module_by_name('hardware');
        } else {
            $mod = $software->application()->find_module_by_name($module_name);
            if($mod) {
                $modules[$module_name] = $mod;
            }
        }
    
        foreach($modules as $mod_name => $module) {
            if($obj_type) {
                $agg_objs[$obj_type] = $module->get_aggregate_object_definition($obj_type);
            } else {
                $agg_objs = $module->has_aggregate_objects(true);
            }
            foreach($agg_objs as $obj_name => $obj_def) {
                if($obj_def['pseudo']){
                    continue;
                }
                if($obj_def['singleton'] === true || isset($obj_def['methods']['list']) || $obj_def['list'] === false){
                }else{
                    $obj_def['methods']['list'] = array(
                            'name' => 'List',
                            'description' => array( 'List '. $obj_name .'.' ),
                            'request' => 'GET',
                    );
                }
                // Filter out method not allowed (ie. no request set)
                foreach($obj_def['methods'] as $method_name => $method_def){
                    if(empty($method_def['request'])){
                        unset($obj_def['methods'][$method_name]);
                    }
                }
                if($obj_def['methods']) {
                    if(!$response_data[$mod_name]['name']){
                        $response_data[$mod_name]['name'] = $module->description();
                        $response_data[$mod_name]['description'] = $module->documentation();
                    }
                    $response_data[$mod_name]['object'][$obj_name] = $obj_def;
                    //display method parameters
                    foreach($obj_def['methods'] as $method_name => $method_def){
                        $param = $module->get_aggregate_object_method_params($obj_name,$method_name);
                        if($param !== false){
                            $response_data[$mod_name]['object'][$obj_name]['methods'][$method_name]['class'] = $param->get_data(false);
                        }
                    }
                    // Create one object to display parameters
                    $obj = $module->create_aggregate_object($obj_name);
                    if($obj) {
                        $response_data[$mod_name]['object'][$obj_name]['class'] = $obj->get_data(false);
                        // Include childs ?
                        if($obj_def['has_child']) {
                            $agg_child_objs = $obj->get_aggregate_object_definition();
                            foreach($agg_child_objs as $obj_child_name => $obj_child_def) {
                                if($obj_child_def['pseudo']){
                                    continue;
                                }
                                if($obj_child_def['singleton'] === true || isset($obj_child_def['methods']['list']) || $obj_child_def['list'] === false){
                                }else{
                                    $obj_child_def['methods']['list'] = array(
                                            'name' => 'List',
                                            'description' => array( 'List '. $obj_child_name .'.' ),
                                            'request' => 'GET',
                                    );
                                }
                                if($obj_child_def['methods']) {
                                    $response_data[$mod_name]['object'][$obj_name]['object'][$obj_child_name] = $obj_child_def;
                                    $child_obj = $obj->create_aggregate_object($obj_child_name);
                                    if($child_obj) {
                                        $response_data[$mod_name]['object'][$obj_name]['object'][$obj_child_name]['class'] = $child_obj->get_data(false);
                                    }
                                    //display method parameters
                                    foreach($obj_child_def['methods'] as $method_name => $method_def){
                                        $param = $obj->get_aggregate_object_method_params($obj_child_name,$method_name);
                                        if($param !== false){
                                            $response_data[$mod_name]['object'][$obj_name]['object'][$obj_child_name]['methods'][$method_name]['class'] = $param->get_data(false);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            //data objs
            $data_objs = $module->get_data_settings();
            foreach($data_objs as $data_obj_name => $data_obj_def) {
                if($obj_type && $obj_type != $data_obj_name) {
                    continue;
                }
                //add list method
                if(isset($data_obj_def['methods']['list']) || $data_obj_def['list'] === false){
                }else{
                    $data_obj_def['methods']['list'] = array(
                            'name' => 'List',
                            'description' => array( 'List '. $data_obj_name .'.' ),
                            'request' => 'GET',
                    );
                }
                foreach($data_obj_def as $key => $value){
                    if(!in_array($key, array('description','methods','singleton'))){
                        unset($data_obj_def[$key]);
                    }
                }
                // Filter out method not allowed (ie. no request set)
                foreach($data_obj_def['methods'] as $method_name => $method_def){
                    if(empty($method_def['request'])){
                        unset($data_obj_def['methods'][$method_name]);
                    }
                }
                if($data_obj_def['methods']) {
                    //if no methods not need show for rest api doc  
                    if(!$response_data[$mod_name]['name']){
                        $response_data[$mod_name]['name'] = $module->description();
                        $response_data[$mod_name]['description'] = $module->documentation();
                    }
                    if(!$response_data[$mod_name]['object'][$data_obj_name]){
                        //no same name aggregate_object 
                        $response_data[$mod_name]['object'][$data_obj_name] = $data_obj_def;
                    }else{
                        //have same name aggregate_object
                        if(!$response_data[$mod_name]['object'][$data_obj_name]['methods']){
                            $response_data[$mod_name]['object'][$data_obj_name]['methods'] = $data_obj_def['methods'];
                        }else{
                            $response_data[$mod_name]['object'][$data_obj_name]['methods'] = array_merge($response_data[$mod_name]['object'][$data_obj_name]['methods'], $data_obj_def['methods']);
                        }
                    }
                    //display method parameters
                    foreach($data_obj_def['methods'] as $method_name => $method_def){
                        $param = $module->get_aggregate_object_method_params($data_obj_name,$method_name);
                        if($param !== false){
                            $response_data[$mod_name]['object'][$data_obj_name]['methods'][$method_name]['class'] = $param->get_data(false);
                        }
                    }
                }
            }
            //module actions
            $mod_action_setting = $module->get_action_settings();
            if($mod_action_setting){
                foreach($mod_action_setting as $action_name => $action_cfg) {
                    // Filter out method  no request set
                    if(!isset($action_cfg['request'])){
                        continue;
                    }
                    if($action_cfg['param']){
                        $tmp_param = $action_cfg['param']->get_data(false);
                        unset($action_cfg['param'] );
                        $action_cfg['param'] = $tmp_param;
                    }
                    $response_data[$mod_name]['methods'][$action_name] = $action_cfg;
                }
            }
        }
        if($response_data)
            $response = 200;
        $this->response($response_data, $response);
    }
}
/* End of file sng_rest.php */
