<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Network Config wrapper page
 * @author William Adam <william.adam@sangoma.com>
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');


class Sng_data_collector extends Safe_CI_Controller
{
    private $_httpd = null;
    private $_auditor = null;
    private $_monitor = null;
    private $_audit_points = array();
    private $_notifier = null;
    private $_notify_cfg = null;

    public function __construct()
    {
        parent::__construct();
        $this->_auditor = $this->_the_app->find_module_by_name('auditor');
        $this->_monitor = $this->_the_app->find_module_by_name('monitor');
        $this->_notifier = $this->_the_app->find_module_by_name('notifier');
    }
    protected function authenticate()
    {
        // Only allows local access
        if($_SERVER['SERVER_ADDR'] != $_SERVER['REMOTE_ADDR']){
            header('HTTP/1.0 401 Unauthorized');
            header('HTTP/1.1 401 Unauthorized');
            exit();
        }
    }
    public function monit()
    {
        $data = file_get_contents("php://input");
        // Process collected data
        $result = $this->_auditor->collector($data);

        if($result){
            // Handle events
            foreach($result['events'] as $level => $events_cat){
                $this->_notifier->notify($level, $events_cat);
                $this->_monitor->add_events($level, $events_cat);
            }
            // Handle status
            foreach($result['status'] as $status){
                $this->_monitor->update_status($status);
            }
        }
    }
    /**
        * @brief Send report
        *
        * @param[in out] $type = [hourly|daily]
        *
        * @return 
     */
    public function report($type=null)
    {
        // Check report to generate
        switch($type){
        case 'hourly':
            $range = 1;
            break;
        case 'daily':
            $range = 24;
            break;
        default:
            $this->output->set_status_header(400);
            return;
        }
        // Gather events
        $events = $this->_monitor->events_list(null, null, $range);
        if($events){
            // Ask notifier to send appropriate report
            $this->_notifier->report($type, $events);
        }
    }
    /**
     * @brief Perfom Monitoring cleanup
     *
     * @return 
     */
    public function cleanup()
    {
        $this->_monitor->cleanup();
    }
}
