<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Dialplan Module Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'dialplan');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'advanced_dialplan');
safe_module_require_class('fs', 'basic_dialplan');
safe_module_require_class('fs', 'basic_dialplan_action');
class Fs_dialplan_module_class extends Fs_module_class
{
    private $_dialplans = array();
    protected $_desc_str;
    public function __construct($fs_app, $module_name="routing")
    {
        parent::__construct($fs_app, $module_name);
        $this->_desc_str = 'Call Routing';
    }
    public function configure()
    {
        // Set the module description
        $this->set_description($this->_desc_str);
        // Register objects
        $this->register_aggregate_object('basic',
            array(
                'name' => 'Basic '.$this->_desc_str,
                'dynamic' => true,
                'base_path' => $this->object_name().'/basic',
                'controller_url' => '/SAFe/fs_routing_config',
                'has_child' => true,
                'methods' => array(
                        'create' => array(
                                'name' => 'Create',
                                'description' => 'Create a '.$this->_desc_str,
                                'request' => 'POST',
                        ),
                        'retrieve' => array(
                                'name' => 'Retrieve',
                                'description' => 'Retrieve a '.$this->_desc_str,
                                'request' => 'GET',
                        ),
                        'update' => array(
                                'name' => 'Update',
                                'description' => 'Update a '.$this->_desc_str,
                                'request' => 'POST',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a '.$this->_desc_str,
                                'request' => 'POST',
                        ),
                ),
            )
        );
        $this->register_aggregate_object('advanced',
            array(
                'name' => 'Advanced '.$this->_desc_str,
                'dynamic' => true,
                'base_path' => $this->object_name().'/advanced',
                'controller_url' => '/SAFe/fs_routing_config',
                'methods' => array(
                        'create' => array(
                                'name' => 'Create',
                                'description' => 'Create a '.$s->_desc_str,
                                'request' => 'POST',
                        ),
                        'retrieve' => array(
                                'name' => 'Retrieve',
                                'description' => 'Retrieve a '.$this->_desc_str,
                                'request' => 'GET',
                        ),
                        'update' => array(
                                'name' => 'Update',
                                'description' => 'Update a '.$this->_desc_str,
                                'request' => 'POST',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a '.$this->_desc_str,
                                'request' => 'POST',
                        ),
                ),
            )
        );
        return parent::configure();
    }
    public function checklist(&$list)
    {
        if (!$this->dialplans()){
            $list[] = array(
                'module' => 'routing',
                'obj_type' => 'basic',
                'description' => 'Not defined',
            );
        }
    }
    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }

    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    private function _generate_config(&$config_manager)
    {
        // Delete all user dialplans
        $directory = "dialplan/user";
        $conf_dir = $this->node()->configuration_manager()->directory('configuration');
        $file_list = $this->node()->os()->search_files($conf_dir.'/'.$directory.'/'.$this->name().'*.xml');
        foreach($file_list as $file){
            $config_manager->add_config(new Safe_configuration_class($file, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        }
        // Create user dialplans
        foreach ($this->dialplans() as $dialplan) {
            if (!$this->_write_user_dialplan($config_manager, $dialplan)) return false;
        }
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        return parent::post_write_config();
    }
    protected function _write_advanced_dialplan($data, $dialplan)
    {
        $xml_str = '<include>'.PHP_EOL.'<context name="'.$this->name().'.' . $dialplan->name() . '">'.PHP_EOL;
        $xml_str.= $data['data'];
        $xml_str.= '</context>'.PHP_EOL.'</include>'.PHP_EOL;
        return $xml_str;
    }
    protected function _write_basic_default (&$xml_writer)
    {
    }
    /**
     * @brief Write user dialplan
     *           
     * @param[in out] $config_manager
     * @param[in out] $dialplan
     *           
     * @return
     */
    private function _write_user_dialplan(&$config_manager, $dialplan)
    {
        //Create core dialplan file for the sip profile
        $data = $dialplan->get_data_values(false);
        if ("advanced" == $dialplan->type()) {
            $xml_str = $this->_write_advanced_dialplan($data , $dialplan);
            $xml_obj = simplexml_load_string($xml_str);
            $xmlstr = $xml_obj->asXml();
            $file = "dialplan/user/".$this->name()."." . $dialplan->name() . ".xml";
            $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        }elseif("basic" == $dialplan->type()){
            $file = "dialplan/user/".$this->name()."." . $dialplan->name() . ".xml";
            $xml_writer = new XMLWriter();
            $xml_writer->openMemory();
            $xml_writer->setIndent(true);
            $xml_writer->startDocument('1.0', 'UTF8');
            $xml_writer->startElement("include");
                $xml_writer->writeComment('Description: '.str_replace('--','',$dialplan->description()));
                $xml_writer->writeComment('Name       : ' . $dialplan->name());
                $xml_writer->writeComment('File       : ' . $file);
                $xml_writer->startElement("context");
                $xml_writer->writeAttribute('name', $this->name().'.' . $dialplan->name());
                   $xml_writer->startElement("extension");
                   $xml_writer->writeAttribute('name', 'default');

                        $this->write_user_rule($dialplan, &$xml_writer);
                        $dialplan->clear_cache();
                        
                   $this->_write_basic_default($xml_writer);
                   $xml_writer->endElement();//extension
                $xml_writer->endElement();//context
            $xml_writer->fullendElement();//include
            $xml_writer->endDocument();
            $xmlstr = $xml_writer->outputMemory(true);
            $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        }
        return true;
    }
    
    public function write_user_rule($dialplan, &$xml_writer)
    {
        $rules = $dialplan->trace_rules();
        $tmp_rules = $dialplan->rules(true);
        $rules = array_merge($rules , $tmp_rules);
        foreach($rules as $rule){
            $attributes = array();
            $elements = array();
            $condition = $rule->get_condition($attributes, $elements);
            if($condition){
                $xml_writer->writeComment('Description : '.str_replace('--','',$rule->description()));
                $xml_writer->writeComment('Name        : '.$rule->name());
                $xml_writer->writeComment('Rank        : '.str_replace('--','',$condition['rank']));
                $xml_writer->startElement('condition');//condition
                foreach($attributes as $condition_key => $condition_data){
                    $xml_writer->writeAttribute($condition_key, $condition_data);
                }
                if($elements){
                    foreach($elements as $element){
                        $key = key($element);
                        $xml_writer->startElement($key);//regx
                        foreach($element[$key] as $e_key => $e_data){
                            $xml_writer->writeAttribute($e_key, $e_data);
                        }
                        $xml_writer->endElement();//regx
                    }
                }
                $params['default-response'] = $dialplan->get_default_response();
                $elem = array();
                $actions = $rule->get_action($params, $elem);
                foreach($actions as  $action){
                    $key = key($action);
                    //check if have raw_format
                    $cdata = array();
                    if(isset($action[$key]['raw_format'])){
                        $raw_format =  array();
                        if(is_array($action[$key]['raw_format'])){
                            $raw_format = $action[$key]['raw_format'];
                        }else{
                            $raw_format[] = $action[$key]['raw_format'];
                        }
                        foreach($raw_format as $tmp_item){
                            if(isset($action[$key][$tmp_item])){
                                $cdata[$tmp_item] = $action[$key][$tmp_item];
                                unset($action[$key][$tmp_item]);
                            }
                        }
                        unset($action[$key]['raw_format']);
                    }
                    $xml_writer->startElement($key);//action
                    foreach($action[$key] as $a_sub_key => $a_sub_data){
                        $xml_writer->writeAttribute($a_sub_key, $a_sub_data);
                    }
                    if($cdata != null){
                        foreach($cdata as $cdata_key => $cdata_value){
                            if($cdata_key == '__custom__'){
                                $xml_writer->writeCData($cdata_value);
                            }else{
                                $xml_writer->writeCData($cdata_key . '=' . $cdata_value);
                            }
                        }
                    }
                    $xml_writer->endElement();//action
                }
                $xml_writer->endElement();//condition
            }
        }
    }
    public function can_create_aggregate_object($type, $name, &$reason="")
    {
        // Default implementation - Check object name exists (but check in
        // merged dialplans)
        $objs = $this->dialplans();
        if($objs[$name]){
            $reason = "Already exists";
            return false;
        }
        return parent::can_create_aggregate_object($type, $name, $reason);
    }
    /**
     * Returns all the dialplans
     */
    public function dialplans($type=null)
    {
        if($type){
            $this->_dialplans = $this->get_aggregate_objects($type);
        }else{
            // Get all type of dialplan
            $this->_dialplans = array();
            $def = $this->get_aggregate_object_definition();
            foreach($def as $obj_type => $obj_def){
                $this->_dialplans = array_merge($this->_dialplans, $this->get_aggregate_objects($obj_type));
            }
        }
        return $this->_dialplans;
    }

    protected function _create_basic_dialplan($name)
    {
        return new Fs_basic_dialplan_routing_class($this->node() , $this->object_name().'/basic', $name);
    }
    protected function _create_advanced_dialplan($name)
    {
        return new Fs_advanced_dialplan_class($this->node() , $this->object_name().'/advanced', $name);
    }
    /**
     * @brief Create a dialplan object
     *           
     * @param[in out] $name : dialplan name
     * @param[in out] $type : advanced or basic
     *           
     * @return true on success
     */
    public function create_dialplan($name, $type = "advanced",$save=true)
    {
        $obj = null;
        switch ($type) {
        case "advanced":
            $obj = $this->_create_advanced_dialplan($name);
            break;

        case "basic":
            $obj = $this->_create_basic_dialplan($name);
            break;
        }
        // Succeed to create dialplan ?
        if ($obj) {
            if ($save)
            {
                $obj->configure();
                $obj->synch();
                return true;
            }else
            {
                return $obj;
            }
            
        }
        return false;
    }
    
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_create_advanced($name, $data=null, &$output = null) {
        $dialplan = $this->_create_advanced_dialplan($name);
        $dialplan->configure();
        if($data) {
            $dialplan->set_data_values($data);
        }
        return $dialplan;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_retrieve_advanced($name, $data=null, &$output = null) {
        $dialplans = $this->get_aggregate_objects('advanced');
        return $dialplans[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_update_advanced($name, $data = null, &$output = null){
        $dialplan = $this->api_retrieve_advanced($name);
        if($dialplan) {
            if ($dialplan->validate($data,$output)) {
                if (true == $dialplan->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_delete_advanced($name, $data=null, &$output = null) {
        $dialplan = $this->api_retrieve_advanced($name);
        if($dialplan) {
            if($dialplan->can_dispose($output)) {
                return $dialplan->dispose();
            }
        }
        return false;
    }

    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_create_basic($name, $data=null, &$output = null) {
        $dialplan = $this->_create_basic_dialplan($name);
        $dialplan->configure();
        if($data) {
            $dialplan->set_data_values($data);
        }
        return $dialplan;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_retrieve_basic($name, $data=null, &$output = null) {
        $dialplans = $this->get_aggregate_objects('basic');
        return $dialplans[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_update_basic($name, $data = null, &$output = null){
        $dialplan = $this->api_retrieve_basic($name);
        if($dialplan) {
            if ($dialplan->validate($data,$output)) {
                if (true == $dialplan->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    //check diaplan is modify or not, regenerate sip profile too
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_delete_basic($name, $data=null, &$output = null) {
        $dialplan = $this->api_retrieve_basic($name);
        if($dialplan) {
            if($dialplan->can_dispose($output)) {
                 $rules = $dialplan->rules();
                 if ($rules != null) {
                    foreach ($rules as $rule) $rule->dispose();
                 }
                return $dialplan->dispose();
            }
        }
        return false;
    }
    public function get_templates($type)
    {
        $conf_dir = $this->node()->configuration_manager()->directory('configuration');
        $file_list = $this->node()->os()->search_files($conf_dir.'/custom/dialplan/templates/*.xml');
        return $file_list;
    }
    public function new_fields(&$config_manager, $type)
    {
        $obj_def = $this->get_aggregate_object_definition($type);
        if(!$obj_def){
            error_log("WARNING - ".$this->name()." Unknown object type ${type}");
            return;
        }
        if('advanced' === $type){
            $name = Safe_object_serializer_class::build_unique_name($type);
            $config_manager->add_field('profile-name', $this->_desc_str .' Name', 'string', $name, 50);
            $config_manager->set_field_rules('profile-name', 'required|alpha_dash');
            $config_manager->add_field('dialplan_type',$this->_desc_str .' Type','hidden','advanced');
            // Check if we ever have some custom dialplan
            $file_list = $this->get_templates($type);
            // Create enum list of existing templates
            $dialplans = $this->dialplans('advanced');
            if($file_list || $dialplans) {
                $template_list['__none__'] = "(None)";
                foreach($file_list as $k){
                    $template_list['templates/'.basename($k)] = 'templates/'.basename($k);
                }
                // Add user dialplans
                foreach($dialplans as $k=>$v) {
                    $template_list['users/'.$v->name()] = $k;
                }
                $config_manager->add_enum_field('src', 'Copy From', 'dropdown', '__none__', $template_list);
            }
            $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
        }else{
            $obj_def = $this->get_aggregate_object_definition($type);
            $label = 'New ' . $obj_def['name'];
            $number = count($this->get_aggregate_objects($type))+1;
            $new_name = ucfirst($type) . $number;
            $config_manager->add_field('profile-name', $label, 'string', $new_name, 50);
            $config_manager->set_field_rules('profile-name', 'required|alpha_dash');
            $config_manager->add_field('dialplan_type',$this->_desc_str .' Type','hidden','basic');
            $dialplans = $this->object_enum('basic', ADD_NONE_NEVER);
            if($dialplans){
                $config_manager->add_enum_field('src', 'Copy From', 'dropdown', '__none__', safe_create_enum_list($dialplans, ADD_NONE_ALWAYS, true));
            }
        }
    }
    /**
     * @brief Populate allowed rule type for basic dialplan
     *
     * @return 
     */
    public function _rule_types()
    {
        return array(
            //'domain' =>'Known Domain',
            //'user' =>'Known User',
            //'auth' =>'Authorized User',
            //'from_trunk' =>'From SIP Trunk',
            //'to_trunk' =>'To SIP Trunk',
            'regex_routing' =>'Regular Expression',
            //'unconditional' =>'Always',
            );

    }
    protected function _action_types()
    {
        return array(
                'rule' => 'Rule Action',
        );
    }

    public function configure_rule($obj)
    {
        // Add possible rule to the dialplan obj
        // Condition section
        // Loop around rule and create the field conditional group per rule type
        $conditional_group = array();
        $condition = array();
        $groups = array();
        foreach($this->_rule_types() as $rule_name => $str){
            // Create rule class
            $rule_class = 'Fs_basic_dialplan_rule_'.$rule_name.'_class';
            // rule object are not meant to be serialized, they live in rule
            // object as conditional field rule
            $rule_obj = new $rule_class($this->node(), '/temp', 'dummy');
            if($rule_obj){
                // Configure rule
                $rule_obj->configure_condition();
                // Extract configuration for conditional group
                $conditional_group[$rule_name] = $rule_obj->get_data();
                foreach ($conditional_group[$rule_name] as $new_field){
                    $obj->_fields[$new_field['field']] = $new_field;
                }
                $rule_group[$rule_name] = $rule_obj->get_group();
                foreach($rule_group[$rule_name]  as $key => $group_item){
                    $obj->create_group($key, $group_item['fields'], $group_item);
                    $obj->conditional_control($key, $key);
                }
            }
        }
    }
    public function configure_action($obj , $on_match = 'action')
    {
        // Add possible action to the rule obj
        $conditional_group = array();
        $condition = array();
        $groups = array();
        foreach($this->_action_types() as $action_name => $str){
            // Create action class
            $action_class = 'Fs_basic_dialplan_action_'.$action_name.'_class';
            // Action object are not meant to be serialized, they live in rule 
            // object as conditional field rule
            $action_obj = new $action_class($this->node(), '/temp', 'dummy');
            if($action_obj){
                $action_obj->_on_match = $on_match;
                // Configure action
                $action_obj->configure();
                // Extract configuration for conditional group
                $conditional_group[$action_name] = $action_obj->get_data();
                foreach ($conditional_group[$action_name] as $new_field){
                    $obj->_fields[$new_field['field']] = $new_field;
                }
                // set group  
                $action_group[$action_name] = $action_obj->get_group();
                
                foreach($action_group[$action_name]  as $key => $group_item){
                    $obj->create_group($key, $group_item['fields'], $group_item);
                    $obj->conditional_control($key, $key);
                }
            }
        }
        $category_name  = array(
                'action' => 'Actions to perform if condition matches',
                'anti-action' => 'Actions to perform if condition doesn’t match'
                );
        
        $obj->set_field_category($on_match .'/1/type', $category_name[$on_match]);
    }
    
    public function get_condition($obj, &$attributes, &$elements)
    {
        //$obj is a rule obj
        $rule_name = key($this->_rule_types());
        $rule_class = 'Fs_basic_dialplan_rule_'.$rule_name.'_class';
        $rule_obj = new $rule_class($this->node(), '/temp', 'dummy');
        if($rule_obj){
            $rule_obj->configure_condition();
            $data = $obj->get_data_values(false);
            $obj_data = array();
            //pick all rule filed data and set to rule obj
            foreach($data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == 'condition'){
                    $obj_data[$key] = $value;
                }
            }
            $rule_obj->set_data_values($obj_data);
            return $rule_obj->get_condition($attributes, $elements);
        }
    }
    public function get_rule_object_usage($obj, $src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        //$obj is a rule obj
        $rule_name = key($this->_rule_types());
        $rule_class = 'Fs_basic_dialplan_rule_'.$rule_name.'_class';
        $rule_obj = new $rule_class($this->node(), '/temp', 'dummy');
        if($rule_obj){
            $rule_obj->configure_condition();
            $data = $obj->get_data_values(false);
            $obj_data = array();
            //pick all rule filed data and set to rule obj
            foreach($data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == 'condition'){
                    $obj_data[$key] = $value;
                }
            }
            $rule_obj->set_data_values($obj_data);
            return $rule_obj->get_rule_object_usage($src_module_name, $obj_type, $obj_name, $sub_type, $sub_name);
        }
    }
    public function rule_summary($obj)
    {
        //$obj is a rule obj
        $rule_name = key($this->_rule_types());
        $rule_class = 'Fs_basic_dialplan_rule_'.$rule_name.'_class';
        $rule_obj = new $rule_class($this->node(), '/temp', 'dummy');
        if($rule_obj){
            $rule_obj->configure_condition();
            $data = $obj->get_data_values(false);
            $obj_data = array();
            //pick all rule filed data and set to rule obj
            foreach($data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == 'condition'){
                    $obj_data[$key] = $value;
                }
            }
            $rule_obj->set_data_values($obj_data);
            return $rule_obj->rule_summary($obj->get_data_values_exploded(false));
        }
    }
    public function pre_validate(&$obj , &$data)
    {
        //$obj is a rule obj
        //remove no used field base on rule type
        $rule_name = key($this->_rule_types());
        $rule_class = 'Fs_basic_dialplan_rule_'.$rule_name.'_class';
        $rule_obj = new $rule_class($this->node(), '/temp', 'dummy');
        if($rule_obj){
            $rule_obj->configure_condition();
            $obj_data = $obj->get_data_values(false);
            $rule_data = array();
            //pick all rule filed data and set to rule obj
            foreach($obj_data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == 'condition'){
                    $rule_data[$key] = $value;
                }
            }
            $rule_obj->set_data_values($rule_data);
            $rule_obj->pre_validate($obj , $data);
        }
        $obj_data = $obj->get_data_values(false);
        $error_message = array();
        //remove no used action field
        $on_match_types = array('action','anti-action');
        foreach($on_match_types as $on_match){
            $action_name = key($this->_action_types());
            $action_class = 'Fs_basic_dialplan_action_'.$action_name.'_class';
            $action_obj = new $action_class($this->node(), '/temp', 'dummy');
            if($action_obj){
                $action_obj->_on_match = $on_match;
                $action_obj->configure();
                $action_data = array();
                //pick all action filed data and set to action obj
                foreach($data as $key => $value){
                    $pieces = explode("/", $key);
                    if($pieces[0] == $on_match){
                        $action_data[$key] = $value;
                    }
                }
                $action_obj->set_data_values($action_data);
                $error_message = array_merge($error_message, $action_obj->pre_validate($obj , $data));
            }
            unset($action_obj);
        }
        return $error_message;
    }
    public function get_action_params($obj, $on_match = 'action')
    {
        //$obj is a action obj
        $action_name = key($this->_action_types());
        $action_class = 'Fs_basic_dialplan_action_'.$action_name.'_class';
        $action_obj = new $action_class($this->node(), '/temp', 'dummy');
        if($action_obj){
            $action_obj->_on_match = $on_match;
            $action_obj->configure();
            $data = $obj->get_data_values(false);
            $obj_data = array();
            //pick all action filed data and set to action obj
            foreach($data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == $on_match){
                    $obj_data[$key] = $value;
                }
            }
            $action_obj->set_data_values($obj_data);
            return $action_obj->get_action_params();
        }
    }
    public function action_summary($obj , $on_match = 'action')
    {
        //$obj is a action obj
        $action_name = key($this->_action_types());
        $action_class = 'Fs_basic_dialplan_action_'.$action_name.'_class';
        $action_obj = new $action_class($this->node(), '/temp', 'dummy');
        if($action_obj){
            $action_obj->_on_match = $on_match;
            $action_obj->configure();
            $data = $obj->get_data_values(false);
            $obj_data = array();
            //pick all action filed data and set to rule obj
            foreach($data as $key => $value){
                $pieces = explode("/", $key);
                if($pieces[0] == $on_match){
                    $obj_data[$key] = $value;
                }
            }
            $action_obj->set_data_values($obj_data);
            return $action_obj->action_summary();
        }
    }
    public function get_action_object_usage($obj, $src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null)
    {
        //$obj is a action obj
        $data = $obj->get_data_values(false);
        $on_match_types = array('action','anti-action');
        foreach($on_match_types as $on_match){
            $action_name = key($this->_action_types());
            $action_class = 'Fs_basic_dialplan_action_'.$action_name.'_class';
            $action_obj = new $action_class($this->node(), '/temp', 'dummy');
            if($action_obj){
                $action_obj->_on_match = $on_match;
                $action_obj->configure();
                $obj_data = array();
                //pick all action filed data and set to action obj
                foreach($data as $key => $value){
                    $pieces = explode("/", $key);
                    if($pieces[0] == $on_match){
                        $obj_data[$key] = $value;
                    }
                }
                $action_obj->set_data_values($obj_data);
                $tmp_usage = $action_obj->get_action_object_usage($src_module_name, $obj_type, $obj_name, $sub_type, $sub_name);
                if($tmp_usage) return $tmp_usage;
            }
        }
        return false;
    }
    public function get_object_enum($type)
    {
        if($type == 'dialplans'){
            return array_merge(parent::get_object_enum('basic') , parent::get_object_enum('advanced'));
        }else{
            return parent::get_object_enum($type);
        }
    }
    public function check_object_usage($src_module_name, $obj_type, $obj_name, $sub_type = null, $sub_name = null) 
    {
        // check usages ?
        $usages = array();
        $basics = $this->dialplans('basic');
        foreach ( $basics as $basic ) {
            foreach ( $basic->rules() as $rule ) {
                if ($rule->get_rule_object_usage($src_module_name, $obj_type, $obj_name, $sub_type, $sub_name)) {
                    $usages[] = array (
                            'name' => $this->name(),
                            'obj_type' => 'basic',
                            'obj_name' => $basic->name(),
                            'sub_type' => 'rule',
                            'sub_name' => $rule->name()
                    );
                    break;
                }
            }
            $basic->clear_cache();
        }
        return $usages;
    }
}
?>
