<?php
/*
 * FS Sangoma Media Server module class
 */
require_once('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs','application');
safe_module_require_class('sng','transcoding_config');

class Fs_sngms_module_class extends Fs_module_class  {
  public $_config = null;
  public $_config_test = 'hello';
  /**
    * @brief
    *
    * @param[in out] $fs_app
    *
    * @return
   */
  public function __construct($fs_app) {
    parent::__construct($fs_app, "sngms");

  }

  /**
    * @brief
    *
    * @return
   */
  public function configure(){
    // Set the module description
    $this->set_description("Media Server");
    $cfg = new Sng_transcoding_config_class($this->fs_app()->node());
    $cfg->configure();
    $cfg->synch();
    // Attach config to module
    $this->set_config($cfg, '/SAFe/fs_sngms_config');

    return parent::configure();
  }
  
  /**
    * @brief Is module enabled
    *
    * @param[in out] $mod_name
    *
    * @return 
   */
  public function is_enabled($mod_name = "") {
    // Check if transcoding enabled ?
    $cfg = $this->config();
    if($cfg->is_enabled()){
      // force load module sngms
      // force noload for TDM
      if ($mod_name=="mod_sangoma_media_server.so"){
        return 'load';
      }
      if ($mod_name=="CORE_PCM_MODULE"){
        return 'noload';
      }

      return 'skip';
    }
    return ($mod_name=="mod_sangoma_media_server.so")?'skip':'load';
  }
  /**
   * Returns whether the module is a critical module
   * @return boolean
   */
  public function is_critical($mod_name="") {
  	return ($mod_name=="mod_sangoma_media_server.so")?TRUE:FALSE;
  }
  /**
   * @brief Return FS module name
    *
    * @return string
   */
  public function get_fs_module_name() {
		//two module for Media server
    $mod = array(
      'mod_sangoma_media_server.so',
      'CORE_PCM_MODULE', 
      'mod_spandsp.so',
      'mod_ilbc.so',
      'mod_g729.so',
      'mod_g723_1.so',
      'mod_siren.so',
      'mod_h26x.so',
    );	
		return $mod;
  }

  /**
    * @brief
    *
    * @param[in out] $config_manager
    *
    * @return
   */
  public function generate_config(&$config_manager){
    return parent::generate_config($config_manager);
  }

  /*
   * Return usage statistics
   */
  public function term_sessions(&$result)
  {
  	$output = array();
  	if ($this->eslapi_execute('hupall','',$output))
  	{
  		return true;
  	}
  	return false;
  }
  
  //Drops all active sessions
  public function service_request(&$result, $mac, $service_type)
  {
  	$cmd = 'sngms_control service ' . $service_type . ' mac ' . $mac;
  	if ($this->eslapi_execute($cmd,'',$result))
  	{
  		return true;
  	}
  	return false;
  } 
  
  //Returns usage statistics
  public function stats_usage(&$stats, $summary=false){
    $output = array();
    $cmd = 'sngms_stats_xml usage';
    if (!$summary)
      $cmd = $cmd.' all';
       
    if($this->eslapi_execute($cmd, "", $output) ) 
    {
      $stats = Safe_xml_to_array($output);
      if (!$summary) {
        // Check if module array is created correctly
        // When only 1 module is returned, conversion from XML to array
        // can't figure out this is and arry. Ending up in:
        // [modules]
        //   [module]
        //     [stats]
        //
        // Instead of
        // [modules]
        //   [module]
        //     [0] <-- Missing info
        //       [stats]
        //
        if (isset($stats['usage'])
          && isset($stats['usage']['modules'])
          && isset($stats['usage']['modules']['module'])
          && !is_indexed_array($stats['usage']['modules']['module']))
        {
          $tmp = $stats['usage']['modules']['module'];
          unset($stats['usage']['modules']['module']);
          $stats['usage']['modules']['module'] = array(
            '0' => $tmp);
        }
      }
      return true;
    }
    return false;
  }

  //Returns duration statistics
  public function stats_duration(&$stats,$summary=false){
    $output = array();
    $cmd = 'sngms_stats_xml duration';
    if (!$summary)
    	$cmd = $cmd.' all';
    
    
    if($this->eslapi_execute($cmd,"",$output) ) 
    {
      $stats = Safe_xml_to_array($output);
      if (!$summary) {
        // Check if module array is created correctly
        // When only 1 module is returned, conversion from XML to array
        // can't figure out this is and arry. Ending up in:
        // [modules]
        //   [module]
        //     [stats]
        //
        // Instead of
        // [modules]
        //   [module]
        //     [0] <-- Missing info
        //       [stats]
        //
        if (isset($stats['duration'])
          && isset($stats['duration']['modules'])
          && isset($stats['duration']['modules']['module'])
          && !is_indexed_array($stats['duration']['modules']['module']))
        {
          $tmp = $stats['duration']['modules']['module'];
          unset($stats['duration']['modules']['module']);
          $stats['duration']['modules']['module'] = array(
            '0' => $tmp);
        }
      }
      return true;
    }
    return false;
  }
  
  public function api_update_configuration($obj_name=null, $params=null, &$output=null)
  {
      $this->_the_product = Safe_get_product();
      $cfg = $this->api_retrieve_configuration();
      
      unset($params['scan']);
      if ($params['enable_media_interface'] == 'false') {
          if($cfg->validate($params, $output)) {
              return $cfg->save();
          }
      }else{
          $this->_hardware     = $this->_the_product->local_node()->hardware();
          $this->_transcoding_if      = $this->_hardware->adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER);
          $this->_ethernet_if         = $this->_hardware->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
          if($params['enable_media_interface'] || !empty($this->_transcoding_if)){
              $cfg->set_data_values($params);
              if($cfg->validate($params, $output)) {
                  $cfg->set_data_values(array('enable_media_interface' => 'true'));
                  $cfg->save();
                  $param = $cfg->get_data_values(false);
                   foreach ($this->_transcoding_if as $if) {
                       $if->delete_media_info();
                   }
                   unset($if);
                   foreach ($this->_ethernet_if as $if) {
                       $if->delete_media_info();
                   }
                   unset($if);
                   $param_copy = $param;
                   // Check if external ip defined
                   if (isset($param_copy['ext_ip_address']) && !strlen($param_copy['ext_ip_address'])) unset($param_copy['ext_ip_address']);
                   // Detect interfaces
                   $detected_modules = 0;
                   //Create an array of ip addresses to validate
                   $a = 0;
                   if (!empty($this->_ethernet_if)) {
                       foreach ($this->_ethernet_if as $if) {
                           $ip_list[$a] = $if->ip_address();
                           $a++;
                       }
                   }
                   unset($if);
                   if (!empty($this->_transcoding_if)) {
                       foreach ($this->_transcoding_if as $if) {
                           $ip_list[$a] = $if->ip_address();
                           $a++;
                       }
                   }
                   unset($if);
                   // Build up list of interfaces to run detection on
                   $if_list = array();
                   if (!empty($param['interfaces'])) {
                     foreach ($param['interfaces'] as $interface) {
                       if (isset($this->_transcoding_if[$interface])){
                         $if_list[$interface] = $this->_transcoding_if[$interface];
                       }elseif (isset($this->_ethernet_if[$interface])){
                         $if_list[$interface] = $this->_ethernet_if[$interface];
                       }
                     }
                   }else{
                     // internal adapters
                     $if_list = $this->_transcoding_if;
                   }
                   // Run detection
                   foreach($if_list as $if_name => $if){
                     if ('true' != $param['individual-ip']) {
                       // Copy back original parameter for aggregate mode
                       $upd_begin = $param['udp_begin']; 
                       $param = $param_copy;
                       // Update IP and gw address
                       $ip_addr = $if->ip_address();
                       increment_ip($ip_addr);
                       $param['ip_address'] = $ip_addr;
                       $param['mask'] = $if->mask();
                       $param['gateway'] = $if->ip_address();
                       $param['udp_begin'] = $upd_begin; 
                       $param['udp_end'] = $param['udp_begin'] + 3999;
                     }
                     $detected_modules+= $if->detect_modules($param, $ip_list);
                   }

                   if (!$detected_modules) {
                     $output['notif_error'] = "Media Interface detection failed.";
                   }
                   return true;
              }
          }
      }
      return false;
  }
  public function checklist(&$list)
  {
    // HW transcoding enabled ?
    $cfg = $this->config();
    if('true' == $cfg->media_check()){
      $adapters = $this->node()->hardware()->adapters();
      $has_modules = false;
      // Check each adapters
      foreach($adapters as $adapter){
        // Has modules ?
        if($adapter->modules()){
          $has_modules = true;
          // Is version up to date ?
          if(!$adapter->check_modules_version()){
            $list[] = array(
              'module' => $this->name(),
              'obj_type' => 'configuration',
              'description' => 'Firmware version out of date on interface '.$adapter->name(),
            );
          }
        }
      }
      if(!$has_modules){
        $list[] = array(
          'module' => $this->name(),
          'obj_type' => 'configuration',
          'description' => 'No Transcoding Modules',
        );
      }
    }
  }
}

/* End of file fs_sngms_module_class.php */
