<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
 */
/**
 * FS LCR Module Class
 * @author William Adam
 */

require_once('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs','application');
safe_module_require_class('fs','lcr_carrier');

/**
 * @brief FS LCR module class
 */
class Fs_lcr_module_class extends Fs_module_class {

    protected $_obj_base_path = '';

    /**
     * @brief Array of configured domains
     */
    private $_carriers = array();

    /**
     * @brief Constructor
     *
     * @param[in out] $fs_app
     *
     * @return 
     */
    public function __construct($fs_app) {
        parent::__construct($fs_app, "lcr");
        $this->_obj_base_path = $this->path().'/lcr';
    }

    /**
     * @brief Directory module configuration
     *
     * @return 
     */
    public function configure() {
        // Set the module description
        $this->set_description("Least Cost Routing");
        
        // Register objects
        $this->register_aggregate_object('carrier',
            array(
                'name' => 'Carrier',
                'dynamic' => true,
                'base_path' => $this->_obj_base_path.'/carrier',
                'has_child' => true,
                'methods' => array(
                        'create' => array(
                                'name' => 'Create',
                                'description' => 'Create a carrier',
                                'request' => 'POST',
                        ),
                        'retrieve' => array(
                                'name' => 'Retrieve',
                                'description' => 'Retrieve a carrier',
                                'request' => 'GET',
                        ),
                        'update' => array(
                                'name' => 'Update',
                                'description' => 'Update a carrier',
                                'request' => 'POST',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a carrier',
                                'request' => 'POST',
                        ),
                ),
            )
        );

        return parent::configure();
    }
    /*
    public function get_data_settings()
    {
        $data = array(
                    'ratefile' => array(
                            'description' => 'Carrier Rate file',
                            'filesystem' => true,
                            'singleton' => true,
                            'pattern' =>  safe_verify_tmp() . '/tmp_rate_file.csv',
                            'file_ext' => 'csv',
                            'global_capabilities_no_data' => array(
                                    'upload'
                            ) ,
                            'methods' => array(
                                    'upload' => array(
                                            'name' => 'Upload',
                                            'description' => array( 'Upload Rate file.' ),
                                            'request' => 'POST',
                                    )
                            ),
                            'list' => false
                    )
                );
        return $data;
    }
     */
    /**
     * @brief Return existing carrier
     *
     * @return 
     */
    public function carriers(){
        $this->_carriers = $this->get_aggregate_objects('carrier');
        return $this->_carriers;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return 
     */
    public function post_write_config()
    {
        // Reload configuration
        if(!$this->fs_app()->reloadxml()) return false;
        return parent::post_write_config();
    }

    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }

    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    /**
     * @brief 
     *
     * @param[in out] $config_manager
     *
     * @return 
     */
    private function _generate_config(&$config_manager)
    {
        // Ensure the lcr table is autoincrement
        $db = $this->db($value['data']);
        $db->connect();
        $db->query('ALTER TABLE lcr MODIFY COLUMN id INT(11) auto_increment;');
        $db->disconnect();
        // Cleanup
        //Handle deleted Carrier Profile
        $deleted_carrier = Safe_object_serializer_class::get_serializer()->find_deleted_objects(
            $this->_obj_base_path.'/carrier');
        foreach ($deleted_carrier as $carrier_profile => $value) {
            unset($data);
            $db = $this->db($value['data']);
            //get carrier id from carriers table
            $db->connect();
            $pk = array(
                    'carrier_name' => $carrier_profile
            );
            $result = $db->select('carriers', $pk);
            $db->disconnect();
            if (!empty($result)) {
                unset($tmp_data);
                $tmp_data['db_class'] = $db;
                foreach ($result as $row) {
                    $tmp_data['primary_key'] = array(
                            'carrier_id'
                    );
                    $tmp_data['data']['carrier_id'] = $row->id;
                    //delete from carrier_gateway
                    $config_manager->add_config(new Safe_configuration_class('carrier_gateway', 
                            $tmp_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
                    //delete from lcr
                    $config_manager->add_config(new Safe_configuration_class('lcr', 
                            $tmp_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
                    //delete from carriers
                    unset($tmp_data['data']);
                    $tmp_data['primary_key'] = array(
                            'id'
                    );
                    $tmp_data['data']['id'] = $row->id;
                    $config_manager->add_config(new Safe_configuration_class('carriers', 
                            $tmp_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
                }
            }
        }
        // Write carriers
        foreach($this->carriers() as $profile) {
            // Delete all rates as they are now stored in the carrier object, so 
            // we have no clue what is new, up to date nor deleted.
            $tmp_data['db_class'] = $this->db($profile);
            $tmp_data['primary_key'] = array(
                    'carrier_id'
            );
            $tmp_data['data']['carrier_id'] = $profile->id();
            //delete from lcr
            $config_manager->add_config(new Safe_configuration_class('lcr', 
                    $tmp_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
            if (!$this->_write_carrier($config_manager, $profile)) { 
                return false;
            }
        }

        return true;
    }
    private function _write_carrier(&$config_manager, $profile)
    {
        //build data array
        unset($data);
        $db = $this->db($profile);
        $data['db_class'] = $db;
        $data['data'] = $profile->get_data_values(false);
        unset($data['data']['rates']);
        $binding_name = $data['data']['binding_name'];
        unset($data['data']['binding_name']);
        $data['data']['carrier_name'] = $profile->name();
        $data['data']['id'] = $profile->id();
        foreach ($data['data'] as $k => $v) {
            if (preg_match('"\bdb-cfg\b"', $k)) {
                unset($data['data'][$k]);
            }
        }
        //Determine whether to update or insert a rule
        $status = $profile->status();
        if ($status == Safe_object_serializer_class::OBJ_STATUS_MODIFIED) {
            $data['primary_key'] = array(
                'id'
            );
            $config_manager->add_config(new Safe_configuration_class('carriers', 
                    $data, Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_SQL));
        } elseif ($status == Safe_object_serializer_class::OBJ_STATUS_NEW) {
            $config_manager->add_config(new Safe_configuration_class('carriers', 
                    $data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
        }
        
        if($status == Safe_object_serializer_class::OBJ_STATUS_MODIFIED || 
                $status == Safe_object_serializer_class::OBJ_STATUS_NEW){
            //handle carrier_gateway table
            unset($tmp_data);
            $tmp_data['db_class'] = $db;
            $tmp_data['primary_key'] = array(
                    'carrier_id'
            );
            //make sure  only one carrier bind to one sip trunk
            $tmp_data['data']['carrier_id'] = $data['data']['id'];
            $config_manager->add_config(new Safe_configuration_class('carrier_gateway', 
                    $tmp_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
            //add record to table 'carrier_gateway'
            if($binding_name != 'none' ){
                $obj = $this->fs_app()->find_obj_by_path($binding_name);
                if($obj){
                    $new_data['data']['prefix'] = $obj->get_prefix_string();
                    $key_id = $obj->id();
                }
                $del_data['db_class'] = $db;
                //delete record with id = $key_id make sure only one carrier bind to one sip trunk or list 
                $del_data['primary_key'] = array(
                    'id'
                );
                $del_data['data']['id'] = $key_id;
                $config_manager->add_config(new Safe_configuration_class('carrier_gateway', 
                        $del_data, Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_SQL));
            
                //add new record
                $new_data['db_class'] = $db;
                $new_data['data']['id'] = $key_id;
                $new_data['data']['enabled'] = 1;
                $new_data['data']['carrier_id'] = $data['data']['id'];
                
                $config_manager->add_config(new Safe_configuration_class('carrier_gateway', 
                        $new_data, Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_SQL));
            }
        }
        
        //Serialize Carrier Rates
        $rates= $profile->get_aggregate_objects('rate');
        unset($data['data']);
        $data['db_class'] = $db;
        $data['data'] = array();
        foreach($rates as $rate){

            if($rate->is_enabled()){
                // Ask rate to populate load_INFILE 
                $rate->create_load_infile($data['data'], $profile, $keys);

                // create config task
                $config_manager->add_config(new Safe_configuration_class('lcr', 
                        $data, Safe_configuration_class::CFG_LOAD, Safe_configuration_class::CFG_SQL));
            }
        }

        return true;
    }
    
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_carrier($name, $data=null) {
        $carrier = new Fs_lcr_carrier_class($this->node(), $this->_obj_base_path.'/carrier', $name);
        $carrier->configure();
        if($data) {
            $carrier->set_data_values($data);
        }
        return $carrier;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_carrier($name, $data=null) {
        $carriers = $this->carriers();
        return $carriers[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_carrier($name, $data=null, &$output = null) {
        $carrier = $this->api_retrieve_carrier($name);
        if($carrier) {
            if ($carrier->validate($data,$output)) {
                if (true == $carrier->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_carrier($name, $data=null) {
        $carriers = $this->carriers();
        if($carriers[$name]) {
            if($carriers[$name]->can_dispose()) {
                foreach ($carriers[$name]->has_aggregate_objects(false, true) as $_type => $_definition){
                    if('rate' !== $_type && $_definition['configurable']){
                        foreach ($carriers[$name]->get_aggregate_objects($_type) as $sub_obj_name => $sub_object) {
                            $sub_object->dispose();
                        }    
                    }
                }
                return $carriers[$name]->dispose();
            }
        }
        return false;
    }
    public function check_object_usage($src_module_name, $obj_type, $obj_name, $sub_typ=null, $sub_name=null)
    {
        // check usages ?
        $usages = array();
        $carriers = $this->carriers();
        foreach($carriers as $carrier){
            $data = $carrier->get_data_value('binding_name',false);
            if($data == 'none'){
                continue;
            }else{
                list($module,$type,$name) =  explode ('/',$data);
                if($module == $src_module_name && $type==$obj_type && $name == $obj_name){
                    $usages[] = array('name' => $this->name(), 'obj_type' =>'carrier', 'obj_name' => $carrier->name());
                }
            }
        }
        return $usages;
    }
}
?>
