$.fn.dataTableExt.sErrMode = 'throw';
$.fn.dataTableExt.oPagination.four_button = {
    "fnInit": function ( oSettings, nPaging, fnCallbackDraw )
    {
        // Create new navigation controls
        nFirst = document.createElement('button');
        nFirst.setAttribute('class', 'ui-button ui-widget ui-button-icon-only css_left page-first');
        nFirstSpan = document.createElement('span');
        nFirstSpan.setAttribute('class', 'ui-icon ui-icon-seek-first');
        nFirst.appendChild(nFirstSpan);

        nPrevious = document.createElement('button');
        nPrevious.setAttribute('class', 'ui-button ui-widget ui-button-icon-only css_left page-prev');
        nPreviousSpan = document.createElement('span');
        nPreviousSpan.setAttribute('class', 'ui-icon ui-icon-seek-prev');
        nPrevious.appendChild(nPreviousSpan);

        nNext = document.createElement('button');
        nNext.setAttribute('class', 'ui-button ui-widget ui-button-icon-only css_left page-next');
        nNextSpan = document.createElement('span');
        nNextSpan.setAttribute('class', 'ui-icon ui-icon-seek-next');
        nNext.appendChild(nNextSpan);

        nLast = document.createElement('button');
        nLast.setAttribute('class', 'ui-button ui-widget ui-button-icon-only css_left page-last');
        nLastSpan = document.createElement('span');
        nLastSpan.setAttribute('class', 'ui-icon ui-icon-seek-end');
        nLast.appendChild(nLastSpan);
        // Create page list
        nPages = document.createElement('select');
        nPages.setAttribute('class', 'page-list');
        // For sure we gonna have at least one page :)
        nOption = document.createElement('option');
        nOption.text = "1";
        nOption.value = "1";
        nPages.appendChild(nOption);
        // Add the onchange function
        $(nPages).change(function (e) {
            var iNewStart = oSettings._iDisplayLength * (this.value - 1);
            oSettings._iDisplayStart = iNewStart;
            fnCallbackDraw(oSettings);
        });

        // Add pagination controls to navigation div
        nPaging.appendChild(nFirst);
        nPaging.appendChild(nPrevious);
        nPaging.appendChild(nPages);
        nPaging.appendChild(nNext);
        nPaging.appendChild(nLast);
        $(nFirst).click( function () {
            oSettings.oApi._fnPageChange( oSettings, "first" );
            fnCallbackDraw( oSettings );
        } );
        $(nPrevious).click( function () {
            oSettings.oApi._fnPageChange( oSettings, "previous" );
            fnCallbackDraw( oSettings );
        } );
        $(nNext).click( function () {
            oSettings.oApi._fnPageChange( oSettings, "next" );
            fnCallbackDraw( oSettings );
        } );
        $(nLast).click( function () {
            oSettings.oApi._fnPageChange( oSettings, "last" );
            fnCallbackDraw( oSettings );
        } );
    },
    "fnUpdate": function ( oSettings, fnCallbackDraw )
    {
        //console.log('in Update');
        if (!oSettings.aanFeatures.p) {
            return;
        }
        // Compute number of pages based on display lenght and total records
        var iPages = Math.ceil(oSettings.fnRecordsDisplay() / oSettings._iDisplayLength);
        var iCurrentPage = Math.ceil(oSettings._iDisplayStart / oSettings._iDisplayLength) + 1;
        var oPager = oSettings.aanFeatures.p;
        //console.log('Table total ' + oSettings.fnRecordsTotal() );
        //console.log('Table display ' + oSettings.fnRecordsDisplay() );
        //console.log('display lenght ' + oSettings._iDisplayLength );
        //console.log('Pages ' + iPages);
        //console.log('Page ' + iCurrentPage);

        // Populate page list
        nPages = $('.page-list', oPager);
        nPages.empty();
        for(var i=1; i <= iPages; i++){
            nOption = document.createElement('option');
            nOption.text = i.toString();
            nOption.value = i.toString();
            if(i == iCurrentPage){
                nOption.selected = true;
            }
            nPages.append(nOption);
        }
        // Enable/Disable navigation buttons based on current page and number of pages
        if(iPages > 1){
            // Enable all
            $('[class*="page-"]', oPager).attr('disabled', false);
        }else{
            // Disable all
            $('[class*="page-"]', oPager).attr('disabled', true);

        }
    }
};
/*
* l - Length changing
* f - Filtering input
* t - The table!
* i - Information
* p - Pagination
* r - pRocessing
 */

$(document).ready(function(){
    $('.safe_datatable table').each(function(){
        try{
          $(this).dataTable(
              {
                  "bJQueryUI": true,
                  "sPaginationType": "four_button",
                  "sDom": '<"top"<"css_left"f><"css_left"l><"css_left"i><"css_right"p>><"css_clear"t><"bottom"><"clear">',
                  "bRetrieve": true, 
                  "bDestroy": true,
                  "aaSorting": [],
                  "oLanguage": {
                      "sSearch": "",
                      "sLengthMenu": "_MENU_"
                              }
              }
          );
        }catch(err){
        }
    });
    // Change search div to add icon
    $('.dataTables_filter label:first-child').each(function() {
        $('input', this).addClass('ui-corner-all');
        nSearch = document.createElement('div');
        nSearch.setAttribute('class', 'ui-icon ui-icon-search css_left');
        nSearch.setAttribute('style', 'margin-top: 2px;');
        $(this).prepend(nSearch);
    });
    // Remove sort icon from all table column header that don't have caption 
    // (ie. button column)
    $('.DataTables_sort_wrapper').filter(function(){
        return $(this).text() == "";
      }).children('.DataTables_sort_icon').remove()
});

var safe_datatable_fetch_params = {};

function safeDatatableUpdate(params){
  if(params.hasOwnProperty('data')){
    var oTable = $('#' + params.async.id + '.safe_datatable table').dataTable();
    oTable.fnAddData(params.data, false);
    oTable.fnDraw(false);
  }
  safeDatatableFetch(params.async);
}

function safeDatatableFetch(params){
  params = params || {};

  // Store fetch parameters
  safe_datatable_fetch_params[params.id] = params;
  // Is fetch completed ?
  if(params.offset + params.count < params.total){
    var missing = params.total - (params.offset+params.count);

    params.offset += params.count;
    $.ajax({
      contentType: 'application/json',
      url:params.url,
      type: 'POST',
      dataType:'json',
      data: JSON.stringify(params),
      async:true,
      success:safeDatatableUpdate,
      error:(function (xhr, textStatus, thrownError){
              console.log('RX Error:' +  xhr.status + ' - ' + textStatus);
              console.log(thrownError);
        })
      }); 
  }
}

