<?php
/*
 * License class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
class Safe_license extends Safe_configurable_object_class
{
    // Default is no license
    private $_status = false;
    /*
     * License type
    */
    const NOT_INSTALLED = 'Not Installed';
    const INVALID = 'Invalid';
    const FULL = 'Installed';
    const DEMO = 'Demo';
    const TIME_BOMB = 'timebomb';
    private $_type = Safe_license::INVALID;
    private $_info;
    public function __construct($node)
    {
      parent::__construct($node->object_name(), 'license');
      $this->_set_sync_strategy(Safe_serializable_object_class::SYNC_MEM);
    }
    public function configure($node)
    {
        // Get about file
        $config = $node->configuration_manager()->license();
        $file = $config['file'];
        // TODO(wadam) - need to validate license against key
        // Read license file (as array)
        if ($node->read_file($file, $content, 'r', true)) {
            // convert to proper array
            foreach ($content as $line) {
                $line = trim($line);
                if (strlen($line)) {
                    // License format is
                    // KEY=VALUE
                    $kv = explode("=", $line);
                    // Check we have enough info
                    if (isset($kv[0]) && isset($kv[1])) {
                        // Add as key/value in array
                        $this->_info[$kv[0]] = $kv[1];
                    }
                    unset($kv);
                }
            }
            $this->_status = true;
            $this->_type = Safe_license::FULL;
        } else {
            $this->_status = false;
            $this->_type = Safe_license::NOT_INSTALLED;
        }
        // Build fields list
        //$this->add_field('status', 'Status', 'text', $this->_type);
        //$this->set_field_disabled('status');
        foreach($this->_info as $k => $v){
          $this->add_field(strtolower($k), $k, 'text', $v);
          $this->set_field_disabled(strtolower($k));
        }
        $tmp_data = $this->get_data_values();
        if (!empty($tmp_data)) {
            // Auto synch
            $this->synch();
        }else{
            $this->dispose();
        }
        return parent::configure();
    }
    public function info($key = null)
    {
        if (isset($key)) return (isset($this->_info[$key])) ? $this->_info[$key] : "";
        return $this->_info;
    }
    public function status(&$type = null)
    {
        if (isset($type)) $type = $this->_type;
        return $this->_status;
    }
    public function describe()
    {
        $describe['Status'] = $this->_type;
        $describe = array_merge($describe, $this->get_data_values_with_field_desc());
        return $describe;
    }
}
/* End of file safe_license_class.php */
