#!/usr/bin/env python
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab
"""
* Copyright (C) 2011   Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* William Adam <william.adam@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.
"""



#Include this directory to  python sys.path
import paths


import sys
import os
import xml.dom.minidom as minidom
from optparse import OptionParser


class sngProductTool(object):
    prodDef = None

    def __init__(self, definition):
        super(sngProductTool, self).__init__()
        self.prodDef = minidom.parse(definition)

    def _create_file_menu_entry(self, path, position, category, subcategory, properties):
      print position + ' - ' + category + ' > ' + subcategory + ' > ' + \
          properties['name']
      menu = open(path+'/'+position+'.en_US', 'w+');
      menu.write(category+'|')
      menu.write(subcategory+'|')
      menu.write(properties['name']+'|')
      menu.write(properties['url']+'|')
      menu.write(properties['type']+'|')
      menu.write(position)
      menu.write('\n')
      menu.close()


    def do_menu(self, output):
        # Locate menu entry in definition
        menuDef = self.prodDef.getElementsByTagName('menu')[0]

        print 'Creating menu entries'
        print '---------------------'

        # Loop around categories
        categoryDef = menuDef.getElementsByTagName('category')
        category_level = 1
        for cat in categoryDef:
          category_name = cat.getAttribute('name')
          subcat_entries = {}
          # Loop around sub categories
          subcategoryDef = cat.getElementsByTagName('subcategory')
          subcategory_level = 1
          for subcat in subcategoryDef:
            subcategory_name = subcat.getAttribute('name')
            entries = {}
            entriesDef = subcat.getElementsByTagName('entry')
            entry_level = 1
            # Loop around entries
            for entry in entriesDef:
              entry_properties = {}
              # Create one entry per attribute
              for (k,v) in entry.attributes.items():
                entry_properties[k] = v

              position = str(category_level) + \
                str(subcategory_level) + \
                str(entry_level).zfill(2)

              self._create_file_menu_entry(output, 
                  position,
                  category_name,
                  subcategory_name,
                  entry_properties )

              # next entry
              entry_level+=1

            # next subcategory
            subcategory_level+=1

          # next category
          category_level+=1


def main():
    #Parse the options
    optParser = OptionParser()
    optParser.add_option('-d', '--definition', action='store', type='string',
                        dest='definition', metavar='DEFINITION',
                        help="Product definition file.")
    optParser.add_option('-a', '--action', action='store', type='choice',
                        dest='action', metavar='ACTION',
                        choices=['menu', 'info'],
                        help="Action to perform.")

    optParser.add_option('-o', '--output', action='store', type='string',
                        dest='output', metavar='OUTPUT',
                        help="Output directory.")

    (options, args) = optParser.parse_args()

    # Check for mandatory arguments
    if not options.action or not options.definition or not options.output:
        sys.exit('Missing mandatory arguments')

    prodTool = sngProductTool(options.definition)

    # Locate action to run
    action = getattr(prodTool, 'do_'+options.action)
    if not action:
        sys.exit('Invalid action '+options.action)

    # Do it
    print 'Action:     ' + options.action 
    print 'Output:     ' + options.output
    print 'Definition: ' + options.definition
    action(options.output)



if __name__ == '__main__':
  main()
