<?php

///////////////////////////////////////////////////////////////////////////////
//
// Copyright 2010 ClearFoundation.
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
///////////////////////////////////////////////////////////////////////////////

require_once("../../gui/Webconfig.inc.php");
require_once("../../gui/Charts.inc.php");
require_once("../../api/File.class.php");
require_once("../../api/ShellExec.class.php");
require_once(GlobalGetLanguageTemplate(__FILE__));
require_once("../include/SngProduct.class.php");

///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////
$productName = "";
$licenseConfFilePath = "/usr/local/sng/conf/prod-def.xml";
$licenseFilePath = "";
$licensePubKeyPath = "";
$licenseUpdateScriptPath = "/usr/local/sng/scripts/update-license.sh";

///////////////////////////////////////////////////////////////////////////////
//
// Main
//
///////////////////////////////////////////////////////////////////////////////

// Set the product name according to the parameter "product" given in the 
// request
if( isset($_REQUEST['product']) ) {
  registerProduct($_REQUEST['product']);
}

$productName = getProductName();

WebAuthenticate();
WebHeader(WEB_LANG_PAGE_TITLE);
WebDialogIntro(WEB_LANG_PAGE_TITLE, "/images/icon-license.png", WEB_LANG_PAGE_INTRO);

/*if( $productName == "" ) {
  WebDialogWarning("Product Name was not registered properly");
  exit();
}*/

if( !getLicenseInfo($licenseConfFilePath, $productName, $licenseFilePath, $licensePubKeyPath) ) {
  exit();
}

// Handle Upload
if (isset($_POST['Upload'])) {
  handleUpload($licenseUpdateScriptPath, $licenseFilePath, $licensePubKeyPath);
}

// Current License info table
$trial_array = DisplayLicenseFile($licenseFilePath);

// Upload new license form
DisplayLicenseUpgrade($productName);

//Display Notification if there is a timed license in play
if ($trial_array['timed_trial']) {
  DisplayLicesneNotif($trial_array);
}

WebFooter();

///////////////////////////////////////////////////////////////////////////////
// F U N C T I O N S
///////////////////////////////////////////////////////////////////////////////

function handleUpload($in_licenseUpdateScriptPath, $in_licenseFilePath, $in_licensePubKeyPath) {
  if( !isset($_FILES["archive"]["tmp_name"]) || 0==strlen($_FILES["archive"]["tmp_name"])) {
    WebDialogWarning('No file selected.');
    return false;
  }
  if( validateFileExtension($_FILES["archive"]["type"]) == "true" ) {
    if (isset($_FILES["archive"]) && !$_FILES["archive"]["error"] && is_uploaded_file($_FILES["archive"]["tmp_name"])) {
      try {
        $file = new File($_FILES["archive"]["tmp_name"]);
        $file->MoveTo("/tmp/" .$_FILES["archive"]["name"]);
        $shell = new ShellExec();
        $rc = $shell->Execute($in_licenseUpdateScriptPath, $file->GetFilename(). " " . $in_licenseFilePath . " " . $in_licensePubKeyPath, true); 
        if( $rc == 0 ) {
          $file->Delete();
          WebDialogInfo(WEB_LANG_LICENSE_UPDATE_SUCCEED);
        } else {
          WebDialogWarning(WEB_LANG_LICENSE_UPDATE_FAILED . " " . $shell->GetLastOutputLine());
        }
      } catch (Exception $e) {
        WebDialogWarning($e->GetMessage());
      }
    }
  } else {
    WebDialogWarning(WEB_LANG_LICENSE_EXT_WARN . " (". $_FILES['archive']['type']. ")");
  }
}

// Looks in $in_licenseConfFilePath file for $in_productName and retrieve its 
// information
function getLicenseInfo($in_licenseConfFilePath, $in_productName, &$out_licenseFilePath, &$out_licensePubKeyPath)
{

  $xml = parseProdDefXML($in_licenseConfFilePath);

  if( !getProductValue($xml, $in_productName, "license", $out_licenseFilePath) ) {
    WebDialogWarning("Unable to find license file value.");
    return false;
  }

  if( !getProductValue($xml, $in_productName, "pubkey", $out_licensePubKeyPath) ) {
    WebDialogWarning("Unable to find license public key value.");
    return false;
  }

  return true;
}

function validateFileExtension($file_type = "" ) {
  $file_type = str_replace('"', '', $file_type);
  if( $file_type == "application/x-gzip" ||
      $file_type == "application/x-zip-compressed" ||
      $file_type == "application/x-gzip-compressed" ||
      $file_type == "application/x-compressed-tar" ||
      $file_type == "application/x-compressed" ||
      $file_type == "application/gzip" ||
      $file_type == "application/octet-stream" )
  {
    return "true";
  }

  return "false";
}

function DisplayLicenseFile($in_licenseFilePath) {
  $licenseFile = fopen($in_licenseFilePath, "r");

  if( $licenseFile == "" ) {
    WebDialogWarning("Unable to open license file!");
    fclose($licenseFile);
    return;
  }

  WebTableOpen(WEB_LANG_SS7_LICENSE_INFO);

  $licenseArray = array();

  while( !feof($licenseFile) ) {
    $line = fgets($licenseFile);
    array_push($licenseArray, explode( "=", $line));
  }

  fclose($licenseFile);
  $trial_array = array();


  foreach( $licenseArray as $key_value ) {
    echo "<tr>";
    echo "<td class='mytablesubheader'>";

    if (preg_match("'\bTIME_TRIAL_BEGIN\b'",$key_value[0])) {
       echo "TRIAL START";
    }
    elseif (preg_match("'\bTIME_TRIAL_END\b'", $key_value[0])) {
       echo "TRIAL END";
    }
    else {    
      echo $key_value[0];
    }
    echo "</td>";
    echo "<td>";
    echo $key_value[1];
    echo "</td>";
    echo "</tr>";

    if (preg_match("'\bTIME_TRIAL_BEGIN\b'",$key_value[0]))
    {
      $trial_array['timed_trial'] = TRUE;
      $trial_array['time_start'] = $key_value[1];
    }
    if (preg_match("'\bTIME_TRIAL_END\b'", $key_value[0]))
    {
      $trial_array['time_end'] = $key_value[1];
    }
  }

  WebTableClose();

  return $trial_array;
}

function DisplayLicenseUpgrade($in_product) {
  WebFormOpen($_SERVER['PHP_SELF'] . "?product=" . $in_product);
  WebTableOpen(WEB_LANG_SS7_LICENSE_UPDATE);
  echo "
    <tr>
      <td align='center'>
        <input type='file' name='archive' size='40' /> &#160;" .
        WebButton("Upload", "Upload", WEBCONFIG_ICON_UPDATE) . "
      </td>
    </tr>
  ";
  WebTableClose();
  WebFormClose();

}

//Displays notification if the timed license exists and is expired
function DisplayLicesneNotif($trial_array)
{
  //Determine if License has expired or not
  $current_time = date("Y/m/d H:i");
  $cur_linux_time = strtotime($current_time);
  $temp_end_time = $trial_array['time_end'];
  $end_time = trim($temp_end_time);
  $end_linux_time = strtotime($end_time);
  
  if ($cur_linux_time > $end_linux_time)
  {
    $expired = TRUE;
  }

  if ($expired)
  {
    echo '<br />';
    require_once '/usr/local/nsg/nginx/html/php/display_class.php';
    $notif = new NotificationBox( 'Error', NotificationBox::Error );
    $notif->add("Trial License","Trial License Expired. Please contact <a href='mailto:sales@sangoma.com'>sales@sangoma.com</a>" );
    echo $notif->getHtml();
    echo "<br />";
    unset($notif);
  }

}
?>
