<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS LCR Rate Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_lcr_rate_record_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    
    public function configure()
    {
        $this->add_field('digits', 'Digits to match', 'string', '', 50);
        $this->set_field_rules('digits', 'required|min_length[1]|max_length[30]');
        $this->set_field_help('digits', 'The entered numbers will be matched with the dialed number to determine which route to use.');
        $this->add_field('rate', 'Least Cost Routing Rate', 'string', '', 50);
        $this->set_field_rules('rate', 'required|decimal');
        $this->set_field_help('rate', 'The rate indicates the relative cost of the using this carrier.');
        $this->add_field('lead_strip', 'Strip Leading Digits', 'string', '', 50);
        $this->set_field_rules('lead_strip', 'greater_than[0]|less_than[29]');
        $this->set_field_help('lead_strip', 'Number of digits to strip off the front off the dialed number.');
        $this->add_field('trail_strip', 'Strip Trailing Digits', 'string', '', 50);
        $this->set_field_rules('trail_strip', 'greater_than[0]|less_than[29]');
        $this->set_field_help('trail_strip', 'Number of digits to strip off the trailing portion of the dialed number.');
        $this->add_field('prefix', 'Prefix', 'string', '', 50);
        $this->set_field_rules('prefix', 'alpha_dash');
        $this->set_field_help('prefix', 'Prefix to add in front of the dialed number.');
        $this->add_field('suffix', 'Suffix', 'string', '', 50);
        $this->set_field_rules('suffix', 'alpha_dash');
        $this->set_field_help('suffix', 'Suffix to add after the dialed number.');
        $this->add_field('date_start', 'Start Date', 'date', '', 20);
        $this->set_field_rules('date_start', 'valid_date');
        $this->set_field_help('date_start', 'Date when the carrier rate will become active. Must be entered in YYYY-MM-DD format.');
        $this->add_field('date_end', 'End Date', 'date', '', 20);
        $this->set_field_rules('date_end', 'valid_date|date_greater_than[today]|date_greater_than[date_start]');
        $this->set_field_help('date_end', 'Date when the carrier rate will end. Must be entered in YYYY-MM-DD format.');
        return parent::configure();
    }
    public function description()
    {
        $cfg = $this->get_data_values(false);
        return 'Digits=' . $cfg['digits'] . ' Rate=' . $cfg['rate'];
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = parent::summary($type , $long);
        array_shift($table_line['data']);
        return $table_line;
    }
    
}
class Fs_lcr_rate_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }

    public function configure()
    {
        $this->add_enum_field('enabled', 'Enabled', 'dropdown', 'true', $this->enable_disable_enum());
        $this->add_field('description', 'Description', 'string', '', 100);
        $this->add_field('file_name', 'File Name', 'string', '', 50);
        $this->set_field_readonly('file_name');
        $this->add_field('count', 'Rate Count', 'integer', '', 50);
        $this->set_field_readonly('count');
        return parent::configure();
    }
    public function is_enabled(){
        $enabled = $this->get_data_value('enabled', false);
        return ('true' == $enabled);
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = parent::summary($type , $long, 5);
        array_shift($table_line['data']);
        return $table_line;
    }
    private function _validate_csv($file, &$line, &$error_messages = null){
        $error_messages = array();
        $rc = true;
        ini_set('auto_detect_line_endings',TRUE);
        $handle = fopen($file,'r');
        if ($handle) {
            $csv_data = array();
            $line = 0;
            $tmp_new_obj = new Fs_lcr_rate_record_class($this->node(), $this->path(), 'tmp');
            $tmp_new_obj->configure();
            $keys = $tmp_new_obj->get_data_keys();
            $header_checked = false;
            
            while ( ($csv_data= fgetcsv($handle) ) !== FALSE ) {
                // check header
                if(!$header_checked){
                    // keys must be indentical
                    if($keys != $csv_data){
                        $error_messages[]= array(
                                'message' => "line [" . $line ."] ",
                                'reason' =>  'Invalid CSV header, must be: '.implode(',', $keys)
                        );
                        $rc = false;
                        break;
                    }else{
                        $header_checked = true;
                        continue;
                    }
                }
                // rate record, validate
                $name = 'rate_'.$line;
                $obj_data = array_combine($keys,$csv_data);
                $tmp_new_obj->set_data_values($obj_data);
                $ouput_msg = array();
                if(!$tmp_new_obj->validate($obj_data, $ouput_msg)){
                    $error_messages[]= array(
                            'message' => "line [" . $line ."] ",
                            'reason' =>  $ouput_msg
                    );
                    $rc = false;
                }
                $line++;
            }
            fclose($handle);
        }else{
            $error_messages[]= array(
                    'message' => "Fail to open ".$file,
            );
            $rc = false;
        }
        ini_set('auto_detect_line_endings',FALSE);
        return $rc;
    }
    public function validate($data, &$out_message = null){
        // Check if file content is provided
        if(isset($data['base64_encode_contents'])){
            $conf = $this->node()->configuration_manager()->directory('configuration');
            $conf = $conf . '/ui-store/'.$this->path();
            $this->node()->mkdir($conf);
            // Store on disk
            $_rates = base64_decode($data['base64_encode_contents']);
            unset($data['base64_encode_contents']);
            file_put_contents($conf.'/'.$this->name(), $_rates);
            $count = 0;
            if(!$this->_validate_csv($conf.'/'.$this->name(), $count, $out_message)){
                @unlink($conf.'/'.$this->name());
                error_log(print_r($out_message, true));
                return false;
            }
            $data['count'] = $count;
        }

        $this->set_data_values($data);
        error_log(print_r($data, true));
        return parent::validate($data, $out_message);
    }
    public function download(){
        $name = $this->get_data_value('file_name', false);
        $conf = $this->node()->configuration_manager()->directory('configuration');
        $conf = $conf . '/ui-store/'.$this->path();
        safe_download($conf.'/'.$this->name(), null, $name, 'text/csv');
    }
    public function dispose(){
        $conf = $this->node()->configuration_manager()->directory('configuration');
        $conf = $conf . '/ui-store/'.$this->path();
        @unlink($conf.'/'.$this->name());
        return parent::dispose();
    }
    public function create_load_infile(&$data, $carrier, &$keys){
        $conf = $this->node()->configuration_manager()->directory('configuration');
        $conf = $conf . '/ui-store/'.$this->path();
        $file = $conf . '/' . $this->name();
        // Create a temp file
        $tmpfname = tempnam("/tmp", $carrier->name());
        $data['file_name'] = $tmpfname;
        chmod($tmpfname, 0644);

        ini_set('auto_detect_line_endings',TRUE);
        $handle = fopen($file,'r');
        if ($handle) {
            $csv_data = array();
            $rate = new Fs_lcr_rate_record_class($this->node(), $this->path(), 'tmp');
            $rate->configure();
            $keys = $rate->get_data_keys();
            $header_skipped = false;
            $keys_in_data = false;
            
            while ( ($csv_data= fgetcsv($handle) ) !== FALSE ) {
                // check header
                if(!$header_skipped){
                    $header_skipped = true;
                    continue;
                }
                // rate record, validate
                $obj_data = array_combine($keys,$csv_data);
                $rate->set_data_values($obj_data);
                $rec = array();
                foreach ($rate->get_data_values(false) as $k => $v) {
                    switch ($k) {
                    case 'date_start':
                        if (!strlen(trim($v))){
                            $rec[$k] = '1970-01-01 00:00:00';
                        }
                        break;

                    case 'date_end':
                        if (!strlen(trim($v))){
                            $rec[$k] = '2030-12-31 00:00:00';
                        }
                        break;
                    default:
                        $rec[$k] = $v;
                        break;
                    }
                }
                $rec['lcr_profile'] = $this->name();
                $rec['carrier_id'] = $carrier->id();
                if(!$keys_in_data){
                    $data['keys'] = array_keys($rec);
                    $keys_in_data = true;
                }

                // Create a csv line
                $line = implode(",", array_values($rec));
                if(strlen(trim($line))) {
                    file_put_contents($tmpfname, $line. PHP_EOL, FILE_APPEND);
                }
            }
            fclose($handle);
        }
        ini_set('auto_detect_line_endings',FALSE);
    }
}
?>
