<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/* 
 * Dashboard
 *
 * Parameters:
 *     $system     = System data series 
 *                    ['cpu'] => CPU data series (pie)
 *                    ['memory'] => Memory data series (pie)
 *                    ['events'] => Events/hours data series (bar with 
 *                    info/warning/critical)
 *     $services   = Array of services data series
 *                   For each services
 *                     ['cpu'] => CPU data series (vertical bar)
 *                     ['memory'] => Memory data series (vertical bar)
 *                     ['events'] => Count of events for this service (just 
 *                     number)
 *     $curren_date = Current datetime in string format
 *     $hour_range = Hour range
*/
?>
<!--[if lte IE 8]><script language="javascript" type="text/javascript" src="../../excanvas.min.js"></script><![endif]-->
<style>
    .ui-progressbar {
        position: relative;
        height: 15px;
    }
    .progress-label {
        position: absolute;
        left: 50%;
        top: 1px;
        font-weight: bold;
        text-shadow: 1px 1px 0 #fff;
    }
    .disabled{
        opacity: 0.4;
        filter: alpha(opacity=40); /* msie */
    }
    .enabled{
        opacity: 1;
        filter: alpha(opacity=100); /* msie */
    }
    .service_status {
        text-align: center;
        font-weight: bold;
    }
    .service_stopped {
        color: #FFFAFA;
        background-color: #E42217;
    }
    .service_running {
        color: #FFFAFA;
        background-color: #8BB381;
    }
    .service_error, .service_unrecognized{
        color: #FFFAFA;
        background-color: #E56717;
    }


    
</style>
<script type="text/javascript">

$(function() {

    function bytesToSize(bytes) {
        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
        if (bytes == 0) return 'N/A';
        var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
        if (i == 0) return bytes + ' ' + sizes[i]; 
        return (bytes / Math.pow(1024, i)).toFixed(1) + ' ' + sizes[i];
    };

    var services = <?php echo $services;?>;

    // Create initial layout
    var tableBody = $('#sng_service_stats_table');
    var i=0;

    $.each(services, function(index, entry){
        tableBody.append( 
            "<tr id='service_" + index + "_row' class='" + (0==((i++)%2)?"even":"odd") + "'>" +
            "<td id='service_" + index + "_name'>" + entry.description + "</td>" +
            "<td id='service_" + index + "_status' class='service_status service_"+entry.status_text.toLowerCase()+"'>" + entry.status_text + "</td>" +
            "<td>" +
            "    <div id='bar_cpu_" + index + "'>" +
            "    <div id='bar_label_cpu_" + index + "' class='progress-label'/>" +
            "    </div>" +
            "</td>" +
            "<td>" +
            "    <div id='bar_memory_" + index + "'>" +
            "    <div id='bar_label_memory_" + index + "' class='progress-label'/>" +
            "    </div>" +
            "<td id='service_" +index + "_report' style='text-align:center;'>" +
            " <a href='<?php echo $controller_uri;?>/events/" + index + "' id='service_" +index + "_report_count'>" +
            " </a>" + 
            " </div>" +
            "</td>" +
            /*
            "<td>" +
            " <img src='/SAFe/images/silk/chart_line.png'/> " +
            "</td>" +
            "<td>" +
            " <img src='/SAFe/images/silk/cog.png'/> " +
            "</td>" +
            */

            "</tr>");

    });

    function renderServiceStats(services){
        $.each(services, function(index, entry){
            // Display CPU
            if(entry.hasOwnProperty('cpu')){
                $("#bar_cpu_" + index).progressbar({
                    value: entry.cpu.percent
                });
                $("#bar_label_cpu_" + index).text(entry.cpu.percent + " %");
                $("#bar_cpu_" + index).progressbar("enable");
            }else{
                $("#bar_cpu_" + index).progressbar({
                    value: 0
                });
                $("#bar_label_cpu_" + index).text("N/A");
                $("#bar_cpu_" + index).progressbar("disable");
            }
            // Out of limit
            $("#bar_cpu_" + index).find(".ui-progressbar-value").css({"background":'#FA9696'});
            // In limit
            $("#bar_cpu_" + index).find(".ui-progressbar-value").css({"background":'#FFC266'});
            $("#bar_cpu_" + index).find(".ui-progressbar-value").css({"background":'#80B2FF'});

            // Display Memory
            if(entry.hasOwnProperty('mem') && '' != entry.mem.percent){
                $("#bar_memory_" + index).progressbar({
                    value: entry.mem.percent
                });
                $("#bar_label_memory_" + index).text(bytesToSize(entry.mem.kb*1024));
                $("#bar_memory_" + index).progressbar("enable");
            }else{
                $("#bar_memory_" + index).progressbar({
                    value: 0
                });
                $("#bar_label_memory_" + index).text("N/A");
                $("#bar_memory_" + index).progressbar("disable");
            }
            // Out of limit
            $("#bar_memory_" + index).find(".ui-progressbar-value").css({"background":'#FA9696'});
            // In limit
            $("#bar_memory_" + index).find(".ui-progressbar-value").css({"background":'#FFC266'});
            $("#bar_memory_" + index).find(".ui-progressbar-value").css({"background":'#80B2FF'});
            // Check events
            var totalEvents = 0;
            var eventsSummary = '';
            try{
            $.each(entry.events, function(k, v){
                totalEvents = totalEvents + parseInt(v);
            });
            }catch(exc){
            }
            if(totalEvents > 0){
                $("#service_" + index + "_report_count").text(totalEvents);
            }else{
                $("#service_" + index + "_report_count").text('-');
            }
            $("#service_" + index + "_status").removeClass();
            $("#service_" + index + "_status").addClass('service_status service_' + entry.status_text.toLowerCase());
            $("#service_" + index + "_status").text(entry.status_text);
        });
    }

    renderServiceStats(services);
    function fetchDataService(){
        function onDataReceived(data){
            renderServiceStats(data);
        }
        $.ajax({
            url:"/SAFe/sng_dashboard/service_stats_json",
                type: "GET",
                dataType:"json",
                success:onDataReceived
        });
        setTimeout(fetchDataService, 20 * 1000);
    }
    setTimeout(fetchDataService, 20 * 1000);


});
</script>


<?php echo safe_webtabletitleopen("Services", '100%', 'sng_service_stats') ?>
  <thead>
    <th class="mytableheader" style="text-align: center;"></th>
    <th class="mytableheader" style="text-align: center;">Status</th>
    <th class="mytableheader" style="text-align: center;" width="25%">CPU</th>
    <th class="mytableheader" style="text-align: center;" width="25%">Memory</th>
    <th class="mytableheader" style="text-align: center;">Events</th>
<!--
    <th class="mytableheader" style="text-align: center;"></th>
    <th class="mytableheader" style="text-align: center;"></th>
-->
</thead>
<tbody id="sng_service_stats_table">
<?php foreach($services as $service):?>
<tr class='<?php echo (($i++)%2)?'odd':'even';?>'>
    <td style="text-wrap:none; white-space:nowrap;">
<!--
        <img src="/SAFe/images/silk/<?php echo $service['icon'];?>.png"/>
-->
    </td>
    <td style="text-wrap:none; white-space:nowrap;">
        <?php echo $service['name'];?>
    </td>
    <td width="30%">
        <div id="bar_cpu_<?php echo $service['module'];?>">
        <div id="bar_label_cpu_<?php echo $service['module'];?>" class="progress-label"/>
        </div>
    </td>
    <td width="30%">
      <div id="bar_memory_<?php echo $service['module'];?>">
        <div id="bar_label_memory_<?php echo $service['module'];?>" class="progress-label"/>
        </div>
    </td>
    <td align="center">
        <a href="<?php echo $controller_uri;?>/events/<?php echo $service['module'];?>/info">
            <?php echo (isset($service['events']['info']))?$service['events']['info']:"-";?>
        </a>
    </td>
    <td align="center">
        <a href="<?php echo $controller_uri;?>/events/<?php echo $service['module'];?>/error">
            <?php echo (isset($service['events']['error']))?$service['events']['error']:"-";?>
        </a>
    </td>
    <td align="center">
        <a href="<?php echo $controller_uri;?>/events/<?php echo $service['module'];?>/critical">
            <?php echo (isset($service['events']['critical']))?$service['events']['critical']:"-";?>
        </a>
    </td>
  </tr>
<?php endforeach; ?>
</tbody>
<?php echo safe_webtableclose() ?>
