<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * William Adam <wadam@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * SNG RAID module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_module_class');
safe_require_class('safe_auditor_class');

class Sng_raid_change_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        // Contact fields
        return parent::configure();
    }
    public function summary($type = 'horizontal' , $long = false, $min=3)
    {
        return parent::summary($type, $long, 20);
    }
}
class Sng_raid_array_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        // Contact fields
        return parent::configure();
    }
    public function summary($type = 'horizontal' , $long = false, $min=3)
    {
        if('vertical' == $type){
            return parent::summary($type, $long, 20);
        }else{
            $result =  array('Name' => $this->name());
            $result['State'] = $this->get_data_value('state');
            $result['Progress'] = $this->get_data_value('progress');
            return array( 'data' => $result);
        }
    }
}

/******************************************************************************
 *   RAID Module
 ******************************************************************************/
class Sng_raid_module_class extends Safe_module_class
{
    public function __construct($app)
    {
        parent::__construct($app->node(), "raid");
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("RAID");
        // Register objects
        $this->register_aggregate_object('change', 
            array(
                'name' => 'Change',
                // No base path as not stored in DB + avoid Safe_object doing 
                // magic
                'base_path' => false, // $this->object_name().'/array',
                'readonly' => true,  // do not allow delete, add...
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a User',
                        'request' => 'GET'
                        ),
                    'recover' => array(
                        'name' => 'Recover',
                        'description' => 'Retrieve a User',
                        'request' => 'GET'
                        ),
                    ),
               )
            );
        /*
        $this->register_aggregate_object('array', 
            array(
                'name' => 'Array',
                // No base path as not stored in DB + avoid Safe_object doing 
                // magic
                'base_path' => false, // $this->object_name().'/array',
                'readonly' => true,  // do not allow delete, add...
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve a RAID Array',
                        'request' => 'GET'
                        ),
                    ),
               )
            );
         */
        return parent::configure();
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    private $_changes = array();
    private function _build_change_objects()
    {
        $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-raid-tool --changes '.$name.' --commit', $cmd_output, true, true);
        $cmd_output = implode('', $cmd_output);
        // Flush _arrays
        $_changes = array();
        // 1/ Issue sng-raid-tool --changes
        // 2/ Process output
        $xml_status = simplexml_load_string(trim($cmd_output));
        if($xml_status){
            // Search for array
            $change_query = $xml_status->xpath("//changes/change");
            foreach($change_query as $c){
                $type = trim((string)$c[type]);
                if(!$type){
                    continue;
                }
                $devices_query = $c->xpath("./device");
                if($devices_query){
                    foreach($devices_query as $d){
                        // Dynamically creates parameters
                        $name = trim((string)$d[name]);
                        if(!$name){
                            continue;
                        }
                        $obj = new Sng_raid_change_config_class($this->node(), $this->aggregate_object_base_path('change'), $name);

                        $obj->add_field('type', ucfirst('type'), 'string', trim($type));
                        foreach($d->children() as $child_name => $child_data){
                            // Add all text attributes
                            if(!$child_data->children()){
                                $obj->add_field($child_name, ucfirst($child_name), 'string', trim($child_data), '50');
                            }
                        }
                        // store array
                        if($_changes[$name]){
                            error_log('WARNING - Duplicate RAID change for device '.$name);
                        }
                        $_changes[$name] = $obj;
                    }
                }
                $state_query = $c->xpath("./progress");
                if($state_query){
                    $progress = trim(trim($state_query[0]));
                    $obj->add_field('progress', 'Progress', 'progress', $progress);
                }
            }
            ksort($_changes);
        }else if (false === $xml_status){
            error_log('WARNING - Fail to parse RAID changes');
        }

        $this->_changes = $_changes;

        return $this->_changes;
    }

    private $_arrays = array();
    private function _build_array_objects()
    {
        return $this->_arrays();
        $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-raid-tool --status', $cmd_output, true, true);
        $cmd_output = implode('', $cmd_output);
        // Flush _arrays
        $_arrays = array();
        // 1/ Issue sng-raid-tool --status
        // 2/ Process output
        $xml_status = simplexml_load_string(trim($cmd_output));
        if($xml_status){
            // Search for array
            $array_query = $xml_status->xpath("//arrays/array");
            foreach($array_query as $a){
                $name = trim((string)$a[name]);
                if(!$name){
                    continue;
                }
                $obj = new Sng_raid_array_config_class($this->node(), $this->aggregate_object_base_path('array'), $name);
                // Dynamically creates parameters
                foreach($a->children() as $child_name => $child_data){
                    // Add all text attributes
                    if(!$child_data->children()){
                        $obj->add_field($child_name, ucfirst($child_name), 'string', trim($child_data), '50');
                    }
                }
                // Check if a <progress> element exists
                $progress = 'N/A';
                $state_query = $a->xpath("./*/progress");
                if($state_query){
                    $progress = trim(trim($state_query[0]));
                }
                $obj->add_field('progress', 'Progress', 'progress', $progress);
                // store array
                $_arrays[$name] = $obj;
            }
            ksort($_arrays);
        }else if(false === $xml_status){
            error_log('WARNING - Fail to parse RAID status');
        }

        $this->_arrays = $_arrays;

        return $this->_arrays;
    }
    public function api_retrieve_status($name=null, $data=null, &$output = null) {
        $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-raid-details', $cmd_output, true, true);
        $cmd_output = implode(PHP_EOL, $cmd_output);
        return $cmd_output;
    }

    public function api_retrieve_array($name=null, $data=null, &$output = null) {
        $_objs = $this->_build_array_objects();

        if($name){
            return $_objs[$name];
        }else{
            return $_objs;
        }
    }
    public function api_retrieve_change($name=null, $data=null, &$output = null) {
        $_objs = $this->_build_change_objects();

        if($name){
            return $_objs[$name];
        }else{
            return $_objs;
        }
    }
    public function api_recover_change($name=null, $data=null, &$output = null)
    {
        $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-raid-tool --recover auto --commit', $output, true, true);
        return $rc;
    }
}
/* End of file sng_update_module_class.php */
