#!/usr/bin/env python
# vim: tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab

"""
* Copyright (C) 2012  Sangoma Technologies Corp.
* All Rights Reserved.
*
* Author(s)
* Johnny <jma@sangoma.com>
*
* This code is Sangoma Technologies Confidential Property.
* Use of and access to this code is covered by a previously executed
* non-disclosure agreement between Sangoma Technologies and the Recipient.
* This code is being supplied for evaluation purposes only and is not to be
* used for any other purpose.

"""

import sys
import os
from xml.dom.minidom import parse


def getText(nodelist):

    rc = []
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc.append(node.data)

    return ''.join(rc)


def handleTok(tokenlist):

    texts = ""
    for token in tokenlist:
        texts += " " + getText(token.childNodes)

    return texts


class ProdDef:

    def __init__(self):

        self._datasource = open("/usr/local/sng/conf/prod-def.xml")
        self._dom = parse(self._datasource)

    def get_base_dir(self):

        base = self._dom.getElementsByTagName("base")
        text = handleTok(base)

        return text.strip()


