<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS RADIUS VSAS Configuration Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'radius_module');
class Fs_radius_vsas_config_class extends Safe_configurable_object_class
{
    private $_vsas = array();
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('vendor-id', 'VSA Vendor ID', 'string', '', '', 10);
        $this->set_field_rules('vendor-id', 'required|greater_than[-1]|less_than[16777215]');
        $this->set_field_help('vendor-id', 'RADIUS vendor ID required for VSA. Example: 0 is default, 9 is for Cisco');
        $this->add_field('vsa-id', 'VSA ID', 'string', '', 10);
        $this->set_field_rules('vsa-id', 'required|greater_than[-1]|less_than[65535]');
        $this->set_field_help('vsa-id', "VSA ID within this vendor's scope in this vendor specified attribute.");
        $this->add_enum_field('vsa-value-type', 'VSA Value Type', 'dropdown', '0', array(
            '0' => 'Direct String Input',
            '1' => 'Channel Variable'
        ));
        $this->set_field_help('vsa-value-type', "The VSA value type that will be used in the RADIUS message.");
        $this->add_field('vsa-value', 'VSA Value', 'string', '', 60);
        $this->set_field_rules('vsa-value', 'required|alpha-dash');
        $this->set_field_help('vsa-value', 'The VSA value which is based on the VSA value chosen. If the you chose Direct String Input, the VSA value entered in this text box will be forwarded directly to the RADIUS server.' . ' If you chose Channel Variable, the value inputted in the VSA Value field will be the variable used in the RADIUS message.');
        $this->add_enum_field('radius-message', 'VSA in RADIUS Message', 'dropdown', '', array(
            'in' => 'Request',
            'out' => 'Response'
        ));
        $this->set_field_help('radius-message', 'Decision on whether this VSA is used as an input RADIUS request or an output RADIUS response.');
        return parent::configure();
    }
    public function description()
    {
        $cfg = $this->get_data_values(false);
        return "Vendor=" . $cfg['vendor-id'] . " ID=" . $cfg['vsa-id'];
    }
}
?>
