<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS CA Certificate Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_module_require_class('fs', 'application');
class Fs_certificate_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('name', 'Name', 'text', '', 60);
        $this->add_field('issuer', 'Issuer', 'text', '', 60);
        $this->add_field('subject', 'Subject', 'text', '', 60);
        $this->add_field('expires', 'Expires', 'text', '', 60);
        //$this->add_upload_field('certificate', 'CA Certificate', 'upload', '', 30);
        //$this->set_field_help('certificate', 'CA Certificate that will be used. Must be a valid PEM file.');
        $this->add_field('certificate-file-contents', 'file-contents', 'base64', '');
        $this->add_field('certificate-file-name', 'file', 'text', '');
        return parent::configure();
    }
    public function validate($data, &$output)
    {
        if(isset($data['base64_encode_contents'])){
            $data['certificate-file-contents'] = $data['base64_encode_contents'];
            unset($data['base64_encode_contents']);
        }
        $ssl = openssl_x509_parse(base64_decode($data['certificate-file-contents']));

        if(isset($ssl['issuer']))
            if(isset($ssl['issuer']['CN']))
                $data['issuer'] = $ssl['issuer']['CN'];
        if(isset($ssl['subject']))
            if(isset($ssl['subject']['CN']))
                $data['subject'] = $ssl['subject']['CN'];
        if(isset($ssl['validTo_time_t']))
            $data['expires'] = date("Y-m-d H:i:s", $ssl['validTo_time_t']);

        $data['name'] = $this->name();

        $data['certificate-file-name'] = $this->name();
        $ext = pathinfo($data['certificate-file-name'], PATHINFO_EXTENSION);
        if('pem' != $ext){
            $data['certificate-file-name'] = $this->name().'.pem';
        }
        $this->set_data_values($data);
        //return parent::validate($data, $output);
        return true;
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = parent::summary($type , $long);
        $table_line['data'][$this->get_data_label('expires')] = $this->get_data_value('expires', true);
        return $table_line;
    }
}
class Fs_ca_certificate_config_class extends Fs_certificate_config_class
{
    public function can_dispose(&$reason)
    {
        $usages = $this->node()->software()->application()->check_object_usage('certificate','ca', $this->name());
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
}
class Fs_server_certificate_config_class extends Fs_certificate_config_class
{
    public function can_dispose(&$reason)
    {
        $usages = $this->node()->software()->application()->check_object_usage('certificate','server', $this->name());
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
}
?>
