#!/bin/bash
# arguments (all optional): 
#    -p <product short name>
#    -n <product long name>
#    -v <product version (no dot no space, use _)>
#    -s <server address ip:port>
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

echo 'Bootstrapping safepy'
mkdir -p $DIR/data/product_release
$DIR/setup.sh
# Try to get local server listen address
SERVER_ADDR='127.0.0.1:81'

if [ -f /usr/webconfig/conf/httpd.d/server_local.conf ]; then
  SERVER_ADDR=`cat /usr/webconfig/conf/httpd.d/server_local.conf | awk '/Listen/ {print $2;}'`
fi
# Default settings
_NAME="Sangoma"
_VERSION="release"
_PRODUCT="product"

# Some arguments ?
while getopts "p:v:n:s:" OPTION
do
  case $OPTION in
    p)
      _PRODUCT=$OPTARG
      ;;
    v)
      _VERSION=$OPTARG
      ;;
    n)
      _NAME=$OPTARG
      ;;
    s)
      SERVER_ADDR=$OPTARG
      ;;
  esac
done

echo "Server: ${SERVER_ADDR}"
echo "Product: ${_PRODUCT}"
echo "Version: ${_VERSION}"
mkdir -p $DIR/data/${_PRODUCT}_${_VERSION}

$DIR/tools/scripts/safe_doc.sh http://${SERVER_ADDR} > $DIR/data/${_PRODUCT}_${_VERSION}/safepy_def.json
RC=$?
if [ $RC -eq 0 ]; then
  $DIR/bin/safepy_builder --name="${_NAME}" --version="${_VERSION}" --product="${_PRODUCT}"
  RC=$?
fi

if [ $RC -eq 0 ]; then
  $DIR/setup.sh
fi

exit $RC
