<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC SIP Profile Class
 *
 * @author Shaunt Libarian
 *         
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'sip_profile');
safe_module_require_class('fs', 'sip_request_limit_config');
class Nsc_sip_domain_profile_param_class extends Safe_configurable_object_class
{
    public $_domain_profiles;
    public $_the_product;
    public $_the_app;
    public $_parent_name = null;
    public $_parent_sip_profile = null;
    public function __construct($name = null, $parent_sip_profile = null)
    {
        if($name != null){
            if($parent_sip_profile != null){
                $this->_parent_name = $parent_sip_profile->name();
                $this->_parent_sip_profile = $parent_sip_profile;
            }
            parent::__construct('',$name);
        }
    }
    public function configure($profile)
    {
        $this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_domain_profiles = $this->_the_app->domain_profiles(); //Holds all Domain Profiles
        if($this->_parent_name == null){
            $this->_parent_name = $profile;
            $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all SIP Profiles
            $sip_profile = $this->_sip_profiles[$profile];
            $this->_parent_sip_profile = $sip_profile;
        }else{
            $sip_profile = $this->_parent_sip_profile;
        }
        $def_name = array();
        $names = array();
        $config = $sip_profile->get_data_values();
        //Set sip profiles
        if (isset($this->_domain_profiles)) {
            foreach ($this->_domain_profiles as $profile) {
                if (isset($profile)) {
                    $names[$profile->name()] = $profile->name();
                }
            }
        }
        foreach ($config['domains'] as $sip_domain) {
            foreach ($this->_domain_profiles as $profile) {
                if (isset($profile)) {
                    if (trim(strtolower($profile->name())) == trim(strtolower($sip_domain))) $def_name[$profile->name()] = $profile->name();
                }
            }
        }
        $this->add_multiple_field('domains', '', 'checkbox', $def_name, $names);
        $this->set_field_rules('domains', 'callback_check_domains['. implode(',',$names) .']');
    }
    
    public function get_data_value($field){
        if($field == 'name'){
            return $this->name();
        }else{
            return null;
        }        
    }
    public function set_data_values($data){
        if($this->_parent_sip_profile){
            $temp = $this->_parent_sip_profile->get_data_values();
            parent::set_data_values($data);
            if (isset($data['domains'])) {
                foreach ($data['domains'] as $domain) {
                    if(in_array(trim($domain),$temp['domains'])){
                        continue;
                    }else{
                        $temp['domains'][] = trim($domain);
                    }
                }
            }
            $this->_parent_sip_profile->set_data_values($temp);
            return true;
        }else{
            return false;
        }
    }
     public function synch(){
         return;
     }
    public function save(){
        if($this->_parent_sip_profile){
            return $this->_parent_sip_profile->save();
        }else{
            return false;
        }
    }
    public function dispose(){
        if($this->_parent_sip_profile){
            $sip = $this->_parent_sip_profile;
            $profile = $sip->get_data_values();
            $temp['domains'] = array();
            for ($a = 0; $a < count($profile['domains']); $a++) {
                if ($profile['domains'][$a] != $this->name()) $temp['domains'][] = $profile['domains'][$a];
            }
            $sip->set_data_values($temp);
            return $sip->save();
        }else{
            return false;
        } 
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = array("Domain" => $this->name());
        return array('data' => $table_line);
    }
    public function validate($data, &$output){
        unset($data['profile-name']);
        unset($_POST['profile-name']);
        return parent::validate($data, $output);
    }
    public function check_domains($field_name, $domain_list = null){
        if($domain_list &&  0 != strlen($domain_list)){
            $domains = explode(',',$domain_list);
            $new_domains = parent::get_data_value('domains',false);
            foreach($new_domains as $new_domain){
                if(trim($new_domain)!=''  && !in_array(trim($new_domain),$domains))
                {
                    return array('check_domains' => 'Unable to bind the domain: '.$new_domain);
                }
            }
            return true;
        }
    }
}
class Nsc_sip_profile_class extends Fs_sip_profile_class
{
    private $_media_profiles = array();
    private $_domain_profiles = array();
    private $_the_app = "";
    private $_limits = array();
    private $_cac_rules = array();
    private $_dialplans = array();
    private $_gateways = array();
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($node, $parent_name, $name);

        $this->_the_app = $this->_node->software()->application();
    }
    /**
     * @brief
     *         
     * @return
     */
    protected function configure_general()
    {
        parent::configure_general();
        // Override user agent default
        $this->set_field_default('user-agent-string', 'NetBorder Session Controller');
        $this->_media_profiles();
        $media = array();
        $def_name = "";
        //Add media profile drop downs
        if (isset($this->_media_profiles)) {
            foreach ($this->_media_profiles as $name => $profile) {
                if (isset($profile)) {
                    if (!sizeof($name)) $def_name = $name;
                    $media[$name] = $name;
                }
            }
        }
        $this->add_enum_field('inbound-bypass-media', 'Inbound Bypass Media', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('inbound-bypass-media', 'Disable SDP parsing and bypass the SDP offer/answer payloads for incoming calls (<font color="red">This disables transcoding</font>)');
        $this->add_enum_field('inbound-media-profile', 'Inbound Media Profile', 'dropdown', $def_name, $media);
        $this->set_field_help('inbound-media-profile', 'Media profile that will be used on all incoming calls.');
        $this->add_enum_field('outbound-media-profile', 'Outbound Media Profile', 'dropdown', $def_name, $media);
        $this->set_field_help('outbound-media-profile', 'Media profile that will be used on all outgoing calls.');

        $this->add_enum_field('sip-trace', 'SIP Trace', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('sip-trace','Enable or Disable SIP messages tracing.');

    }

    protected function configure_interoperability()
    {
        parent::configure_interoperability();
        $this->add_enum_field('lync-interop', 'Lync Interoperability', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('lync-interop','Enable or Disable settings for Lync interoperability.');
    }
    protected function configure_authentication()
    {
        // Add authentication params
        $this->add_enum_field('auth-calls', 'Authenticate Calls', 'dropdown', 'true', $this->enable_disable_enum());
        $this->set_field_help('auth-calls', 'Enable or Disable authentication on all incoming calls.');
        $this->add_enum_field('accept-blind-auth', 'Accept Blind Authentication', 'dropdown', 'false', array(
            'true' => 'Enable',
            'false' => 'Disable'
        ));
        $this->set_field_help('accept-blind-auth', '<font color="red">Warning: If set to enable, all authentication requests will be granted without checking.</font>');
        $this->add_enum_field('auth-all-packets', 'Authenticate Requests', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('auth-all-packets', 'Enable or Disable authentication on all incoming requests.');
        
        // Add Authentication category
        $this->set_field_category('auth-calls','Authentication');
    }
    protected function configure_qos()
    {
        //TOS Values
        $this->add_field('sip-tos-value', 'SIP TOS Value', 'string', '', 10);
        $this->set_field_rules('sip-tos-value', 'greater_than[-1]|less_than[256]');
        $this->set_field_help('sip-tos-value', 'DiffServ integer value (0-255) for the signaling packets (this is the old TOS IP header value). You can use this to set TOS values as well.');
        $this->add_field('rtp-tos-value', 'RTP TOS Value', 'string', '', 10);
        $this->set_field_rules('rtp-tos-value', 'greater_than[-1]|less_than[256]');
        $this->set_field_help('rtp-tos-value', 'DiffServ integer value (0-255) for the RTP packets (this is the old TOS IP header value). You can use this to set TOS values as well.');
        
        // Add QoS category
        $this->set_field_category('sip-tos-value','QoS');
    }

    protected function configure_load_limits()
    {
        $this->add_enum_field('enable-load-limit', 'Enable Load Limiting', 'dropdown', 'true', $this->enable_disable_enum());
        $this->set_field_help('enable-load-limit', 'Enable or Disable Load Limiting on this SIP Profile');
        $this->add_field('max-sessions', 'Max Concurrent Sessions', 'string', '', '20');
        $this->set_field_rules('max-sessions', "greater_than[0]|less_than[10000]|is_numeric");
        $this->set_field_help('max-sessions', 'Maximum number of concurrent sessions that will be accepted in this profile. Unlimited if not specified.');
        $this->add_field('load-limit-high-threshold', 'CPU High Threshold', 'string', '90', '20');
        $this->set_field_rules('load-limit-high-threshold', "required[enable-load-limit]|greater_than[0]|less_than[100]|is_numeric");
        $this->set_field_help('load-limit-high-threshold', 'CPU usage percentage amount that NSC will start rejecting calls.');
        $this->add_field('load-limit-low-threshold', 'CPU Low Threshold', 'string', 80, 20);
        $this->set_field_rules('load-limit-low-threshold', "required[enable-load-limit]|greater_than[0]|less_than[100]|is_numeric");
        $this->set_field_help('load-limit-low-threshold', 'CPU usage percentage amount that NSC will resume accepting calls. It is recommended this be 90% of the high threshold');
        $this->add_field('load-limit-reject-cause', 'Reject Response Code', 'string', 503, 20);
        $this->set_field_rules('load-limit-reject-cause', "required[enable-load-limit]|sip_fail_response_code");
        $this->set_field_help('load-limit-reject-cause', 'Reject calls based on the SIP Response.');
        $this->add_field('load-limit-cause-string', 'Reject Message', 'string', 'Service Unavailable', 60);
        $this->set_field_help('load-limit-cause-string', 'required[enable-load-limit]|max_length[39]|alpha');
        $this->set_field_help('load-limit-cause-string', 'Reject calls based on the string provided.');
        // Add Conditional Control for global/http
        // 1. create the group control 'http'
        $this->create_group('load-limit', array(
            'max-sessions',
            'load-limit-high-threshold',
            'load-limit-low-threshold',
            'load-limit-reject-cause',
            'load-limit-cause-string'
        ));
        // 2. tell the field 'global/http' which existing group it can control (http)
        $this->conditional_control('enable-load-limit', 'load-limit');
        // Add Load Limits category
        $this->set_field_category('enable-load-limit', 'Load Limits');
    }
    protected function configure_session_routing()
    {
        $dialplans = array();
        $module_routing = $this->_node->software()->application()->find_module_by_name('routing');
        $dialplans = $module_routing->object_enum('dialplans', ADD_NONE_IF_EMPTY, false);
        $this->add_enum_field('call-routing', 'Routing Plan', 'dropdown', '', $dialplans);
        $this->set_field_rules('call-routing', 'required[,in,__selectone__]');
                
        $this->set_field_help('call-routing', 'XML routing plan for all incoming calls received in this SIP profile.');
        
        $this->add_enum_field('manual-redirect', 'Manual Redirect Routing', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('manual-redirect',
            array('If enabled, all SIP 30X responses (Redirect Responses) will cause a new routing request to your dialplan.',
                  'If disabled, the SBC will try to follow the Redirect request as-is automatically',
                  '',
                  'The routing plan used is determined by the contents of the channel variable "sip_redirect_context"',
                  ));

        $this->add_enum_field('full-id-in-dialplan', 'Always Use Full Identification', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('full-id-in-dialplan', 'Always use user@domain format when routing the call.');

        // Add Session routingcategory
        $this->set_field_category('call-routing', 'Session Routing');
        
        //hmr drop downs
        $module_hmr = $this->_node->software()->application()->find_module_by_name('hmr');
        $hmrs = $module_hmr->object_enum('dialplans', ADD_NONE_ALWAYS, true);
        $this->add_enum_field('ingress', 'Ingress ', 'dropdown', '__none__', $hmrs);
        $this->add_enum_field('egress', 'Egress  ', 'dropdown', '__none__', $hmrs);
        
        // Add Session routingcategory
        $this->set_field_category('ingress', 'Header Manipulation');
    }
    protected function configure_nat()
    {
        // Eventually we'll allow the user to add their own ACLs
        $acl_list = array();
        $acl_list[''] = '(None)';
        $acl_list['nat.auto'] = 'RFC1918';
        $this->add_enum_field('apply-nat-acl', 'NAT ACL', 'dropdown', '', $acl_list);
        $this->set_field_help('apply-nat-acl', 'Apply a given network ACL to the host IP of the Contact: header in SIP requests to determine if a host is behind NAT');

        $this->add_enum_field('nat-options-ping', 'Ping NAT Registrations', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('nat-options-ping',
            array('Send OPTIONS ping requests to NATed registrations.',
                  'This helps to keep firewall pinholes open even when the registration refresh timer is long'));

        $force_rport_options = array();
        $force_rport_options['false'] = 'Enable'; /* This leaves RFC3581 support enabled per spec */
        $force_rport_options['disabled'] = 'Disable'; /* This turns-off completely RFC3581 support */
        $force_rport_options['true'] = 'Force Always'; /* This forces RFC3581 support even if the client does not request it */
        $force_rport_options['safe'] = 'Auto Force'; /* This forces RFC3581 only for certain problematic user agents,
                                                  and still honors RFC3581 for clients that support it  */
        $force_rport_options['client-only'] = 'Client Only'; /* This enables RFC3581 for outbound requests only */
        $force_rport_options['server-only'] = 'Server Only'; /* This enables RFC3581 for inbound requests only */
        $this->add_enum_field('NDLB-force-rport',
            'Symmetric Response Routing',
            'dropdown', 'false', $force_rport_options);
        $this->set_field_help('NDLB-force-rport',
            array(
                'Controls RFC3581 (Symmetric Response Routing) behavior',
                '',
                'If \'Enable\' is selected, RFC3581 will be followed according to the specification',
                'Selecting any of the other options is only advisable when this SIP profile will be used to connect',
                'with user agents that are known to have issues with RFC3581 or lack support for it (ie: Polycom)',
                'and they are known to be behind some sort of firewall or NAT device (ie remote employees)',
                '',
                'If \'Disable\' is selected, RFC3581 support will be completely disabled',
                'Outbound requests will not contain the Via rport parameter and responses will be routed back',
                'to the port specified in the topmost Via header of the request even if the rport Via parameter',
                'was specified in the request by the client (this helps with devices that have problems processing or',
                'ignoring the Via rport parameter or when you want to disable the RFC3581 behavior even if',
                'a client requests it or a server supports it)',
                '',
                'If \'Force Always\' is selected, RFC3581 support will be always forced even if client does not request it',
                'Outbound requests will contain the Via rport parameter and UDP responses',
                'will be routed back to the network source port of the client even when no Via rport parameter was',
                'specified in the request by the client. This effectively forces RFC3581 behavior even if not requested',
                'This is non-RFC compliant but helps with devices behind NAT that do not implement RFC3581 but still',
                'need the SBC to provide that functionality to route responses through NAT or firewall devices',
                '<font color="red">* This option may break communications if used when requests come through a SIP proxy',
                'or user agents that are not behind a firewall or NAT device</font>',
                '',
                'If \'Auto Force\' is selected, RFC3581 support will be forced on particular user agents known to be problematic',
                'This option is equivalent to \'Force\' except that it will force it only for inbound requests with a User-Agent',
                'header such as Polycom or other known problematic user agents without RFC3581 support',
                '<font color="red">* This option may break communications if used when requests come through a SIP proxy</font>',
                '',
                'If \'Client Only\' is selected, RFC3581 behavior is followed only for outbound requests',
                'Outbound requests will contain the Via rport parameter and responses will still be routed',
                'back to the port specified in the topmost Via header of the request (non-RFC3581 behavior)',
                'even if the rport Via parameter was specified in the request by the client',
                'This is non-RFC complaint but helps with clients that have issues/bugs with their RFC3581',
                'This effecitvely disabling RFC3581 for inbound requests only',
                '',
                'If \'Server Only\' is selected, RFC3581 behavior is followed only for inbound requests',
                'Outbound requests will not contain the Via rport parameter but responses will be routed',
                'back to the network source port when the client specifies the Via rport parameter in their request',
                'This is effectively disabling RFC3581 for outbound requests only',
            )
        );


        // In order to look consistent to the user, I'd rather cause a bit confusion in the code
        // note how the option for the user is enabled/disabled but in the code is inverted, we're actually
        // enabling or disabling the disable :)
        // by default we set it to true because we want to disable rtp auto-adjust, but to the user appears as 'Disable'
        $this->add_enum_field('disable-rtp-auto-adjust', 'RTP Auto Adjust', 'dropdown', 'true', array(
            'true' => 'Disable',
            'false' => 'Enable'
        ));
        $this->set_field_help('disable-rtp-auto-adjust', array(
            'This option enables the RTP auto-adjust feature used to detect RTP streams coming from hosts behind NAT.',
            '',
            'Note that when media interfaces are enabled, an incoming RTP stream is required before outgoing RTP is sent.',
        ));
        $this->add_enum_field('aggressive-nat-detection', 'Aggressive NAT Detection', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('aggressive-nat-detection', array(
            'This option enables aggressive NAT detection by examining the Via headers of requests',
            '',
            'It will determine if a given device is behind NAT if the network IP/Port from which the request was received differs from the IP/Port combination in the SIP Via: header.',
            '',
            'It also will determine if a given device is behind NAT if the Via: header contains the \'received\' parameter, regardless of what it contains.',
        ));
        // Add NAT category
        $this->set_field_category('apply-nat-acl', 'NAT Traversal');
    }
    
    public function configure()
    {
        parent::configure();
        // General authentication
        $this->configure_authentication();
        // General qos
        $this->configure_qos();
        $this->configure_nat();
        $this->configure_load_limits();
        $this->configure_session_routing();
        //Adds hidden record in db to hold domains
        $this->add_field('domains', 'domains', 'private', array());
        
        // Register objects
        $this->register_aggregate_object('domain',
                array(
                        'name' => 'Domain',
                        'base_path' => false, // need to verify path
                        'dynamic' => true,
                        'pseudo'  => true,  
                        /* Add some extra infos for config_manager create object */
                        'controller' => array(
                                'config_manager' => array(
                                        'summary_buttons' => 'Delete[Unbind]:confirm',
                                        'allow_create_button' => 'Add[Bind]'
                                ),
                        ),
                        'autoname' => true,
                        'popup_add_form' => true,
                        'methods' => array(
                                'create' => array(
                                        'name' => 'Create',
                                        'description' => 'Create a domain',
                                        'request' => 'POST',
                                ),
                                'retrieve' => array(
                                        'name' => 'Retrieve',
                                        'description' => 'Retrieve a domain',
                                        'request' => 'GET',
                                ),
                                'update' => array(
                                        'name' => 'Update',
                                        'description' => 'Update a domain',
                                        'request' => 'POST',
                                ),
                                'delete' => array(
                                        'name' => 'Delete',
                                        'description' => 'Delete a domain',
                                        'request' => 'POST',
                                ),
                        ),
                )
        );
       
        
        $this->register_aggregate_object('limit',
                array(
                        'name' => 'Limits',
                        'base_path' => $this->object_name() . '/limits', // need to verify path
                        'dynamic' => true,
                        'autoname' => true,
                        'methods' => array(
                                'create' => array(
                                        'name' => 'Create',
                                        'description' => 'Create a limit',
                                        'request' => 'POST',
                                ),
                                'retrieve' => array(
                                        'name' => 'Retrieve',
                                        'description' => 'Retrieve a limit',
                                        'request' => 'GET',
                                ),
                                'update' => array(
                                        'name' => 'Update',
                                        'description' => 'Update a limit',
                                        'request' => 'POST',
                                ),
                                'delete' => array(
                                        'name' => 'Delete',
                                        'description' => 'Delete a limit',
                                        'request' => 'POST',
                                )
                        )
                )
        );
    }
    /**
     * Pulls all media profiles to populate form
     */
    private function _media_profiles()
    {
        $this->_media_profiles = $this->_the_app->media_profiles();
    }
    private function _cac_rules()
    {
        $this->_cac_rules = $this->_the_app->cac_rules();
        return $this->_cac_rules;
    }
    private function _dialplans()
    {
        $this->_dialplans = $this->_the_app->dialplans();
        return $this->_dialplans;
    }
    private function _hmrs()
    {
        $module = $this->_node->software()->application()->find_module_by_name('hmr');
        $this->_hmrs = $module->dialplans();
        return $this->_hmrs;
    }
    private function _domains()
    {
        $this->_domains = $this->_the_app->domain_profiles();
        return $this->_domains;
    }
    private function _gateways()
    {
        $this->_gateways = $this->_the_app->sip_trunks();
        return $this->_gateways;
    }
    /**
     * Pull all SIP Limits created
     */
    public function request_limits()
    {
        $limits = Safe_object_serializer_class::get_serializer()->find_objects($this->object_name() . '/limits');
        foreach ($limits as $k => $v) {
            $v = new Fs_sip_request_limit_config_class($this->_node, $this->object_name() . '/limits', $k);
            $v->configure();
            $v->synch();
            $this->_limits[$k] = $v;
        }
        return $this->_limits;
    }
    /**
     * @brief Check if media profile is used by the SIP profile
     *           
     * @param[in out] $media_profile
     *           
     * @return true if used
     */
    public function media_check($media_profile)
    {
        $prof_data = $this->get_data_values(false);
        return ($prof_data['outbound-media-profile'] == $media_profile || $prof_data['inbound-media-profile'] == $media_profile) ? true : false;
    }
    /**
     * @brief Check if domain profile is used by the SIP profile
     *           
     * @param[in out] $domain_profile
     *           
     * @return true if used
     */
    public function domain_check($domain_profile)
    {
        $prof_data = $this->get_data_values();
        //Check to make sure a domain is not in the sip profile
        foreach ($prof_data['domains'] as $domain) {
            //echo "Domain = $domain & Profile = $domain_profile<br />";
            if ($domain == $domain_profile) {
                return true;
            }
        }
        return false;
    }
    public function validate($data, &$output){
        $domains = array_keys($this->_domains());
        if(isset($data['domains']) && is_array($data['domains']) ){
            foreach($data['domains'] as $item){
                if(in_array($item, $domains)){
                    continue;
                }else{
                    $output = 'Unknown domain : ' .$item ;
                    return false;
                }
            }                        
        }
        return parent::validate($data, $output);
    }
    /**
     * Check to see if the sip profile can be deleted
     * @see Safe_serializable_object_class::can_dispose()
     *         
     * @return boolean
     */
    public function can_dispose(&$reason)
    {
        $usages = $this->node()->software()->application()->check_object_usage('sip','profile', $this->name());
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $usages = array_merge($usages, $module->check_object_usage('sip', 'profile', $this->name()));
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        return parent::can_dispose($reason);
    }
    
    public function limits()
    {
        return $this->get_aggregate_objects('limit');
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_limit($name, $data=null) {
        $condition = new Fs_sip_request_limit_config_class($this->node(), $this->object_name() . '/limits', $name);
        $condition->configure();
        if($data) {
            $condition->set_data_values($data);
        }
        return $condition;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_limit($name, $data=null) {
        $limits = $this->limits();
        return $limits[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_limit($name, $data=null, &$output = null) {
        $limit = $this->api_retrieve_limit($name);
        if($limit) {
            if ($limit->validate($data,$output)) {
                if (true == $limit->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_limit($name, $data=null, &$output = null) {
        $limits = $this->limits();
        if($limits[$name]) {
            if($limits[$name]->can_dispose($output)) {
                return $limits[$name]->dispose();
            }
        }
        return false;
    }
    public function domains()
    {
        $domains = $this->get_data_value('domains');
        $domain_objs = array();
        if($domains){
            foreach($domains as $domain_item){
                $domain_objs[$domain_item] = new Nsc_sip_domain_profile_param_class($domain_item, $this);
                $domain_objs[$domain_item]->configure($this->name());
            }
        }
        return $domain_objs;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_domain($name, $data=null) {
        $domain = new Nsc_sip_domain_profile_param_class($name, $this);
        $domain->configure($this->name());
        if($data) {
            $domain->set_data_values($data);
        }
        return $domain;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_domain($name, $data=null) {
        $domains = $this->domains();
        if($name){
            return $domains[$name];
        }else{
            return $domains;
        }
        
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_domain($name, $data=null, &$output = null) {
        $domains = $this->domains();
        if($domains[$name]) {
            if($domains[$name]->can_dispose($output)) {
                return $domains[$name]->dispose();
            }
        }
        return false;
    }
    //re define the add form for popup dialog
    public function new_fields(&$config_manager, $type)
    {
        if($type == 'domain'){
            $name = Safe_object_serializer_class::build_unique_name($type);
            //add new domain
            $config_manager->add_field('profile-name', 'Profile Name', 'hidden', $name, 50);
            $domain_obj = new Nsc_sip_domain_profile_param_class($name, $this);
            $domain_obj->configure($this->name());
            $domain_cfg = $domain_obj->get_data();
            $def_name = array();
            $value_names = array();
            if(is_array($domain_cfg['domains']['default'])){
                $def_name = array();
                foreach($domain_cfg['domains']['default'] as $tmp_def){
                    $def_name[$tmp_def] = $tmp_def;
                }
            }
            if(is_array($domain_cfg['domains']['value']) && $domain_cfg['domains']['value'] != null){
                $value_names = array();
                foreach($domain_cfg['domains']['value'] as $tmp_val){
                    $value_names[$tmp_val] = $tmp_val;
                }
            }else{
                $config_manager->error = true;
                $config_manager->error_message = "No domain defined!";
            }
            $config_manager->add_multiple_field('domains', '', $domain_cfg['domains']['type'],$def_name ,$value_names);
            $config_manager->set_field_rules('domains','callback_check_domain');
            //pass by the edit form, save directly
            $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
        }else{
            parent::new_fields($config_manager, $type);
        }
    }
    public function check_domain($field ,$param, $postdata)
    {
        if(!is_array($postdata) || $postdata == null){
            $error['check_domain'] = ' No domain selected.';
            return $error;
        }
        return true;
    }
}
?>
