<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Advanced Dialplan Class
 * @author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'basic_dialplan_rule');

// Include all rules we know about
safe_module_require_class('fs', 'basic_dialplan_rule');

class Fs_basic_dialplan_class extends Safe_configurable_object_class
{
    private $_module;
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
        // Extract module name from object name
        $path = $this->object_name();
        $parts = explode('/', $path);
        $this->_module = $this->node()->software()->application()->find_module_by_path($path);
    }
    public function configure()
    {
        $this->add_field('description', 'Description', 'text', '', 50);
        $this->add_enum_field('trace-call', 'Trace Call', 'dropdown', 'false', $this->enable_disable_enum());
        // Register objects
        $this->register_aggregate_object('rule',
            array(
                'name' => 'Rule',
                'dynamic' => true,
                'base_path' => $this->object_name().'/rule',
                'autoname' => true,
                'methods' => array(
                        'create' => array(
                                'name' => 'Create',
                                'description' => 'Create a Rule',
                                'request' => 'POST',
                        ),
                        'retrieve' => array(
                                'name' => 'Retrieve',
                                'description' => 'Retrieve a Rule',
                                'request' => 'GET',
                        ),
                        'update' => array(
                                'name' => 'Update',
                                'description' => 'Update a Rule',
                                'request' => 'POST',
                        ),
                        'delete' => array(
                                'name' => 'Delete',
                                'description' => 'Delete a Rule',
                                'request' => 'POST',
                        ),
                ),
            )
        );
        return parent::configure();
    }
    protected function _default_rules()
    {
        return array();
    }
    public function trace_rules()
    {
        $trace_rules = array();
        if($this->get_data_value('trace-call' , false) == 'true'){
            $data['rule/type'] = 'trace';
            //crate a temp default rule name
             $obj = $this->api_create_rule(MD5(microtime()),$data);
             $trace_rules[$obj->name()] = $obj;
        }
        return $trace_rules;
        
    }
    
    public function get_aggregate_objects($type, $all=false){
        $obj_list = parent::get_aggregate_objects($type, $all);
        if($type == 'rule'){
            //order $_rules
            $rule_rank = array();
            if($obj_list){
                foreach($obj_list as $key => $rule){
                    $rule_rank[$key] = $rule->get_data_value('global/rank', false);
                }
                asort($rule_rank , SORT_NUMERIC);
                $tmp_rules = array();
                foreach($rule_rank as $key => $rule_rank){
                    $tmp_rules[$key] = $obj_list[$key];
                }
                $obj_list = $tmp_rules;
            }
        }
        return $obj_list;
    }
    
    public function get_max_rule_rank(){
        $_rules =  $this->get_aggregate_objects('rule');
        $max_rank = 10;
        if($_rules){
            $_tmp_rule = array_pop($_rules);
            $max_rank = $_tmp_rule->get_data_value('global/rank', false) + 10;
        }
        return $max_rank;
    }
    
    public function rules($internal = false)
    {
        $_rules = $this->get_aggregate_objects('rule');
        if($internal){
            $default_rules = $this->_default_rules();
            if($default_rules){
                $_rules = array_merge($_rules , $default_rules);
            }
        }
        return $_rules;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_create_rule($name, $data=null) {
        // data MUST be supplied to create a rule and 'global/type' parameter 
        // contains rule type to create
        $rule = null;
        if($data){
            $type = $data['rule/type'];
            $rule = $this->create_aggregate_object($type, $name);
            $rule->set_data_values($data);
        }
        return $rule;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_retrieve_rule($name, $data=null) {
        $rules = $this->rules();
        return $rules[$name];
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_update_rule($name, $data=null, &$output = null) {
        $rules = $this->rules();
        if($rules[$name]) {
            if ($rules[$name]->validate($data,$output)) {
                if (true == $rules[$name]->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     *
     * @return
     */
    public function api_delete_rule($name, $data=null, &$output = null) {
        $rules = $this->rules();
        if($rules[$name]) {
            if($rules[$name]->can_dispose($output)) {
                return $rules[$name]->dispose();
            }
        }
        return false;
    }
    
    /**
     * Returns dialplan type
     * @return string
     */
    public function type()
    {
        return 'basic';
    }
    public function description()
    {
        $desc = $this->get_data_value('description', false);
        if($desc){
            return $desc;
        }
        return parent::description();
    }

    /**
     * @brief Overload create obj create proper rule type
     *
     * @param[in out] $type
     * @param[in out] $name
     *
     * @return 
     */
     public function create_aggregate_object($type, $name='default')
     {
         if($type == 'default' || $type == 'trace'){
             // Object class name
             $class = 'Fs_basic_dialplan_rule_'.$type.'_class';
        }else{
            $class = 'Fs_basic_dialplan_routing_rule_class';
        }
        $obj = new $class($this->node() , $this->object_name().'/rule', $name);
        if($obj){
            // Configure rule - general and condition
            $obj->configure();
        }
        return $obj;
     }
     public function get_default_response()
     {
         return '';
     }
    public function save()
    {
        $result = parent::save();
        if($this->is_modified() || $this->is_configuration_modified()){
            //send dialplan modification event out
            $receivers = $this->node()->software()->application()->check_object_modified($this->_module->name(),'basic', $this->name());
        }
        return $result;
    }
    public function can_dispose(&$reason = null)
    {
        //check if this list binded to sip profile
        $usages = $this->node()->software()->application()->check_object_usage($this->_module->name(),'basic', $this->name());
        //check_object_usage does not inclue slef module 
        $path = $this->object_name();
        $module = $this->node()->software()->application()->find_module_by_path($path);
        $usages = array_merge($usages , $module->check_object_usage('routing', 'basic', $this->name()));
        if($usages){
            $reason['msg'] = "  {$this->name()} is used by ";
            $reason['obj'] = $usages;
            return false;
        }
        
        return parent::can_dispose($reason);
    }
}

class Fs_basic_dialplan_routing_class extends Fs_basic_dialplan_class
{
    public function configure()
    {
        parent::configure();
        $this->add_field('default-response', 'Default Response', 'text', '404');
    }
    protected function _default_rules()
    {
        $default_rules = array();
        $data['rule/type'] = 'default';
        //crate a temp default rule name
        $obj = $this->api_create_rule(MD5(microtime()),$data);
        $default_rules[$obj->name()] = $obj;
        return $default_rules;
    }
    public function get_default_response()
    {
        return $this->get_data_value('default-response' , false);
    }
}
class Fs_basic_dialplan_hmr_class extends Fs_basic_dialplan_class
{
    public function create_aggregate_object($type, $name='default')
    {
        if($type == 'default' || $type == 'trace'){
            // Object class name
            $class = 'Fs_basic_dialplan_rule_'.$type.'_class';
        }else{
            $class = 'Fs_basic_dialplan_hmr_rule_class';
        }
        $obj = new $class($this->node() , $this->object_name().'/rule', $name);
        if($obj){
            // Configure rule - general and condition
            $obj->configure();
        }
        return $obj;
    }
}
?>
