<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Safe_editor controller
 *
 * @author Michel Buczynski
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_product_class');
class Safe_editor extends CI_Controller
{
    private $_the_product;
    private $_configuration_path;
    private $_node;
    public function __construct()
    {
        parent::__construct();
        $this->_the_product = Safe_get_product();
        $this->_node = $this->_the_product->local_node();
        $this->_configuration_path = $this->_node->configuration_manager()->directory('configuration');
    }
    public function load()
    {
        safe_authenticate();
        $fn = $this->input->post('fn');
        // Only allow configuration path files
        $buffer = '';
        if (strlen($fn) >= strlen($this->_configuration_path) && !substr_compare(dirname($fn) , $this->_configuration_path, 0, strlen($this->_configuration_path))) {
            $this->_node->read_file($fn, $buffer);
        } else {
            error_log('Trying to load a file not in configuration folder:' . $fn);
        }
        // Always return something
        echo base64_encode($buffer);
    }
    public function save()
    {
        safe_authenticate();
        $fn = $this->input->post('fn');
        $buffer = base64_decode($this->input->post('data'));
        // Only allow configuration path files
        if (!substr_compare(dirname($fn) , $this->_configuration_path, 0, strlen($this->_configuration_path))) {
            $this->_node->write_file($fn, $buffer);
        } else {
            error_log('Trying to load a file not in configuration folder:' . $fn);
        }
    }
}
/* End of file safe_edito.php */
