#!/bin/bash
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

echo 'Bootstrapping safepy'
mkdir -p $DIR/data/product_release
$DIR/setup.sh
# Try to get local server listen address
SERVER_ADDR='127.0.0.1:81'

if [ -f /usr/webconfig/conf/httpd.d/server_local.conf ]; then
  SERVER_ADDR=`cat /usr/webconfig/conf/httpd.d/server_local.conf | awk '/Listen/ {print $2;}'`
fi

$DIR/tools/scripts/safe_doc.sh http://${SERVER_ADDR} > $DIR/data/product_release/safepy_def.json
RC=$?
if [ $RC -eq 0 ]; then
  $DIR/bin/safepy_builder --name="Sangoma" --version="release" --product="product"
  RC=$?
fi

if [ $RC -eq 0 ]; then
  $DIR/setup.sh
fi

exit $RC
